/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jmx.support;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class DefaultMBeanRegistration
implements MBeanRegistration {
    private static Logger LOGGER = LoggerFactory.createLogger(DefaultMBeanRegistration.class);
    private MBeanServer mBeanServerFromPreRegister;
    private ObjectName name;
    private boolean usePlatformMBeanServer = true;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mBeanServerFromPreRegister = server;
        if (name == null) {
            name = this.createObjectName();
        }
        this.name = name;
        return name;
    }

    protected abstract ObjectName createObjectName() throws Exception;

    public void init() {
        this.doInit();
        if (this.usePlatformMBeanServer) {
            this.register();
        }
    }

    protected void register() {
        try {
            ObjectName objectName = this.createObjectName();
            this.registerWithExceptions(this, objectName);
        }
        catch (Exception e) {
            LOGGER.logError("Failed to register with MBeanServer", (Throwable)e);
        }
    }

    protected abstract void doInit();

    protected MBeanServer getMBeanServer() {
        MBeanServer ret = null;
        ret = this.usePlatformMBeanServer ? ManagementFactory.getPlatformMBeanServer() : this.mBeanServerFromPreRegister;
        return ret;
    }

    protected void unregister() {
        try {
            this.unregisterWithExceptions(this.name);
        }
        catch (Exception e) {
            LOGGER.logWarning("Failed to unregister" + this.name, (Throwable)e);
        }
    }

    private void unregisterWithExceptions(ObjectName objectName) throws MBeanRegistrationException, InstanceNotFoundException {
        if (this.isRegistered()) {
            MBeanServer server = this.getMBeanServer();
            server.unregisterMBean(objectName);
            this.mBeanServerFromPreRegister = null;
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    protected void register(String objectNameAsString, Object jmxBean) {
        try {
            ObjectName objectName = this.convertToObjectName(objectNameAsString);
            this.registerWithExceptions(jmxBean, objectName);
        }
        catch (Exception e) {
            LOGGER.logError("Failed to register " + objectNameAsString, (Throwable)e);
        }
    }

    private void registerWithExceptions(Object jmxBean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanServer server = this.getMBeanServer();
        if (server != null) {
            server.registerMBean(jmxBean, objectName);
            this.name = objectName;
        }
    }

    protected void unregister(String objectNameAsString) {
        try {
            ObjectName objectName = this.convertToObjectName(objectNameAsString);
            this.unregisterWithExceptions(objectName);
        }
        catch (Exception e) {
            LOGGER.logWarning("Failed to unregister " + objectNameAsString, (Throwable)e);
        }
    }

    protected ObjectName convertToObjectName(String objectNameAsString) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(objectNameAsString);
    }

    public void setAutoRegisterWithPlatformMBeanServerOnInit(boolean value) {
        this.usePlatformMBeanServer = value;
    }

    public boolean getAutoRegisterWithPlatformMBeanServerOnInit() {
        return this.usePlatformMBeanServer;
    }

    public boolean isRegistered() {
        boolean ret = false;
        MBeanServer server = this.getMBeanServer();
        ObjectName objectName = this.getObjectName();
        if (server != null && objectName != null) {
            ret = server.isRegistered(objectName);
        }
        return ret;
    }
}

