/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.util.stax.XMLStreamIOException;

class TextFromElementReader
extends Reader {
    private final XMLStreamReader stream;
    private final boolean allowNonTextChildren;
    private boolean endOfStream;
    private int skipDepth;
    private int sourceStart = -1;

    TextFromElementReader(XMLStreamReader stream, boolean allowNonTextChildren) {
        this.stream = stream;
        this.allowNonTextChildren = allowNonTextChildren;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int read = 0;
        try {
            while (true) {
                if (this.sourceStart == -1) {
                    block8: while (true) {
                        int type = this.stream.next();
                        switch (type) {
                            case 4: 
                            case 12: {
                                if (this.skipDepth != 0) continue block8;
                                this.sourceStart = 0;
                                break block8;
                            }
                            case 1: {
                                if (this.allowNonTextChildren) {
                                    ++this.skipDepth;
                                    continue block8;
                                }
                                throw new IOException("Unexpected START_ELEMENT event");
                            }
                            case 2: {
                                if (this.skipDepth == 0) {
                                    this.endOfStream = true;
                                    return read == 0 ? -1 : read;
                                }
                                --this.skipDepth;
                            }
                            default: {
                                continue block8;
                            }
                        }
                        break;
                    }
                }
                int c = this.stream.getTextCharacters(this.sourceStart, cbuf, off, len);
                this.sourceStart += c;
                off += c;
                read += c;
                if ((len -= c) <= 0) break;
                this.sourceStart = -1;
            }
            return read;
        }
        catch (XMLStreamException ex) {
            throw new XMLStreamIOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

