/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.axiom.ext.io.StreamCopyException;

public final class IOUtils {
    private IOUtils() {
    }

    public static long copy(InputStream in, OutputStream out, long length) throws StreamCopyException {
        if (out instanceof ReadFromSupport) {
            return ((ReadFromSupport)((Object)out)).readFrom(in, length);
        }
        byte[] buffer = new byte[4096];
        long read = 0L;
        long toRead = length == -1L ? Long.MAX_VALUE : length;
        while (toRead > 0L) {
            int c;
            try {
                c = in.read(buffer, 0, (int)Math.min(toRead, (long)buffer.length));
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (c == -1) break;
            try {
                out.write(buffer, 0, c);
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
            read += (long)c;
            toRead -= (long)c;
        }
        return read;
    }
}

