/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.base64;

import java.io.IOException;
import java.io.Writer;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;

public class Base64EncodingWriterOutputStream
extends AbstractBase64EncodingOutputStream {
    private final Writer writer;
    private final char[] buffer;
    private int len;

    public Base64EncodingWriterOutputStream(Writer writer, int bufferSize, boolean ignoreFlush) {
        super(ignoreFlush);
        this.writer = writer;
        this.buffer = new char[bufferSize];
    }

    public Base64EncodingWriterOutputStream(Writer writer, int bufferSize) {
        this(writer, bufferSize, false);
    }

    public Base64EncodingWriterOutputStream(Writer writer) {
        this(writer, 4096, false);
    }

    @Override
    protected void doWrite(byte[] b) throws IOException {
        if (this.buffer.length - this.len < 4) {
            this.flushBuffer();
        }
        int i = 0;
        while (i < 4) {
            this.buffer[this.len++] = (char)(b[i] & 0xFF);
            ++i;
        }
    }

    @Override
    protected void flushBuffer() throws IOException {
        this.writer.write(this.buffer, 0, this.len);
        this.len = 0;
    }

    @Override
    protected void doFlush() throws IOException {
        this.writer.flush();
    }

    @Override
    protected void doClose() throws IOException {
        this.writer.close();
    }
}

