/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXWriterConfiguration;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;
import org.apache.axiom.util.stax.wrapper.ImmutableXMLInputFactory;
import org.apache.axiom.util.stax.wrapper.ImmutableXMLOutputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXUtils {
    private static final Log log = LogFactory.getLog(StAXUtils.class);
    private static final Map<StAXParserConfiguration, XMLInputFactory> inputFactoryMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<StAXWriterConfiguration, XMLOutputFactory> outputFactoryMap = Collections.synchronizedMap(new WeakHashMap());

    public static XMLInputFactory getXMLInputFactory() {
        return StAXUtils.getXMLInputFactory(null);
    }

    public static XMLInputFactory getXMLInputFactory(boolean factoryPerClassLoaderPolicy) {
        return StAXUtils.getXMLInputFactory(null, factoryPerClassLoaderPolicy);
    }

    public static XMLInputFactory getXMLInputFactory(StAXParserConfiguration configuration, boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            throw new UnsupportedOperationException();
        }
        return StAXUtils.getXMLInputFactory(configuration);
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in, encoding);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, InputStream in, String encoding) throws XMLStreamException {
        XMLStreamReader reader = StAXUtils.getXMLInputFactory(configuration).createXMLStreamReader(in, encoding);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
        }
        return reader;
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, InputStream in) throws XMLStreamException {
        XMLStreamReader reader = StAXUtils.getXMLInputFactory(configuration).createXMLStreamReader(in);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
        }
        return reader;
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, String systemId, InputStream in) throws XMLStreamException {
        XMLStreamReader reader = StAXUtils.getXMLInputFactory(configuration).createXMLStreamReader(systemId, in);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
        }
        return reader;
    }

    public static XMLStreamReader createXMLStreamReader(Reader in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, Reader in) throws XMLStreamException {
        XMLStreamReader reader = StAXUtils.getXMLInputFactory(configuration).createXMLStreamReader(in);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
        }
        return reader;
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return StAXUtils.getXMLOutputFactory(null);
    }

    public static XMLOutputFactory getXMLOutputFactory(boolean factoryPerClassLoaderPolicy) {
        return StAXUtils.getXMLOutputFactory(null, factoryPerClassLoaderPolicy);
    }

    public static XMLOutputFactory getXMLOutputFactory(StAXWriterConfiguration configuration, boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            throw new UnsupportedOperationException();
        }
        return StAXUtils.getXMLOutputFactory(configuration);
    }

    public static void setFactoryPerClassLoader(boolean value) {
        if (value) {
            throw new UnsupportedOperationException();
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return StAXUtils.createXMLStreamWriter(null, out);
    }

    public static XMLStreamWriter createXMLStreamWriter(StAXWriterConfiguration configuration, OutputStream out) throws XMLStreamException {
        XMLStreamWriter writer = StAXUtils.getXMLOutputFactory(configuration).createXMLStreamWriter(out, "utf-8");
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
        }
        return writer;
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) throws XMLStreamException {
        return StAXUtils.createXMLStreamWriter(null, out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(StAXWriterConfiguration configuration, OutputStream out, String encoding) throws XMLStreamException {
        XMLStreamWriter writer = StAXUtils.getXMLOutputFactory(configuration).createXMLStreamWriter(out, encoding);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
        }
        return writer;
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer out) throws XMLStreamException {
        return StAXUtils.createXMLStreamWriter(null, out);
    }

    public static XMLStreamWriter createXMLStreamWriter(StAXWriterConfiguration configuration, Writer out) throws XMLStreamException {
        XMLStreamWriter writer = StAXUtils.getXMLOutputFactory(configuration).createXMLStreamWriter(out);
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
        }
        return writer;
    }

    static Map<String, Object> loadFactoryProperties(ClassLoader cl, String name) {
        InputStream in = cl.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            Properties rawProps = new Properties();
            HashMap<String, Object> props = new HashMap<String, Object>();
            rawProps.load(in);
            for (Map.Entry<Object, Object> entry : rawProps.entrySet()) {
                Object value;
                String strValue = (String)entry.getValue();
                if (strValue.equals("true")) {
                    value = Boolean.TRUE;
                } else if (strValue.equals("false")) {
                    value = Boolean.FALSE;
                } else {
                    try {
                        value = Integer.valueOf(strValue);
                    }
                    catch (NumberFormatException ex) {
                        value = strValue;
                    }
                }
                props.put((String)entry.getKey(), value);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded factory properties from " + name + ": " + props));
            }
            HashMap<String, Object> hashMap = props;
            return hashMap;
        }
        catch (IOException ex) {
            log.error((Object)("Failed to read " + name), (Throwable)ex);
            return null;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static XMLInputFactory newXMLInputFactory(final ClassLoader classLoader, final StAXParserConfiguration configuration) {
        return AccessController.doPrivileged(new PrivilegedAction<XMLInputFactory>(){

            @Override
            public XMLInputFactory run() {
                ClassLoader savedClassLoader;
                if (classLoader == null) {
                    savedClassLoader = null;
                } else {
                    savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                try {
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                    Map<String, Object> props = StAXUtils.loadFactoryProperties(classLoader, "XMLInputFactory.properties");
                    if (props != null) {
                        for (Map.Entry<String, Object> entry : props.entrySet()) {
                            factory.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    StAXDialect dialect = StAXDialectDetector.getDialect(factory);
                    if (configuration != null) {
                        factory = configuration.configure(factory, dialect);
                    }
                    ImmutableXMLInputFactory immutableXMLInputFactory = new ImmutableXMLInputFactory(dialect.normalize(dialect.makeThreadSafe(factory)));
                    return immutableXMLInputFactory;
                }
                finally {
                    if (savedClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
            }
        });
    }

    public static XMLInputFactory getXMLInputFactory(StAXParserConfiguration configuration) {
        XMLInputFactory f;
        if (configuration == null) {
            configuration = StAXParserConfiguration.DEFAULT;
        }
        if ((f = inputFactoryMap.get(configuration)) == null) {
            f = StAXUtils.newXMLInputFactory(StAXUtils.class.getClassLoader(), configuration);
            inputFactoryMap.put(configuration, f);
            if (log.isDebugEnabled() && f != null) {
                log.debug((Object)("Created singleton XMLInputFactory " + f.getClass() + " with configuration " + configuration));
            }
        }
        return f;
    }

    private static XMLOutputFactory newXMLOutputFactory(final ClassLoader classLoader, final StAXWriterConfiguration configuration) {
        return AccessController.doPrivileged(new PrivilegedAction<XMLOutputFactory>(){

            @Override
            public XMLOutputFactory run() {
                ClassLoader savedClassLoader;
                if (classLoader == null) {
                    savedClassLoader = null;
                } else {
                    savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                try {
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
                    Map<String, Object> props = StAXUtils.loadFactoryProperties(classLoader, "XMLOutputFactory.properties");
                    if (props != null) {
                        for (Map.Entry<String, Object> entry : props.entrySet()) {
                            factory.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    StAXDialect dialect = StAXDialectDetector.getDialect(factory);
                    if (configuration != null) {
                        factory = configuration.configure(factory, dialect);
                    }
                    ImmutableXMLOutputFactory immutableXMLOutputFactory = new ImmutableXMLOutputFactory(dialect.normalize(dialect.makeThreadSafe(factory)));
                    return immutableXMLOutputFactory;
                }
                finally {
                    if (savedClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
            }
        });
    }

    public static XMLOutputFactory getXMLOutputFactory(StAXWriterConfiguration configuration) {
        XMLOutputFactory f;
        if (configuration == null) {
            configuration = StAXWriterConfiguration.DEFAULT;
        }
        if ((f = outputFactoryMap.get(configuration)) == null) {
            f = StAXUtils.newXMLOutputFactory(StAXUtils.class.getClassLoader(), configuration);
            outputFactoryMap.put(configuration, f);
            if (log.isDebugEnabled() && f != null) {
                log.debug((Object)("Created singleton XMLOutputFactory " + f.getClass() + " with configuration " + configuration));
            }
        }
        return f;
    }
}

