/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.List;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MultipartBodyWriter;
import org.apache.axiom.om.OMOutputFormat;

public class OMMultipartWriter {
    private final OMOutputFormat format;
    private final MultipartBodyWriter writer;
    private final boolean useCTEBase64;
    private final String rootPartContentType;

    public OMMultipartWriter(OutputStream out, OMOutputFormat format) {
        this.format = format;
        this.writer = new MultipartBodyWriter(out, format.getMimeBoundary());
        this.useCTEBase64 = format != null && Boolean.TRUE.equals(format.getProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments"));
        String soapContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
        this.rootPartContentType = format.isOptimized() ? "application/xop+xml; charset=" + format.getCharSetEncoding() + "; type=\"" + soapContentType + "\"" : String.valueOf(soapContentType) + "; charset=" + format.getCharSetEncoding();
    }

    private static boolean isTextual(String contentType) {
        try {
            return new ContentType(contentType).isTextual();
        }
        catch (ParseException ex) {
            return false;
        }
    }

    private String getContentTransferEncoding(String contentType) {
        if (this.useCTEBase64 && !OMMultipartWriter.isTextual(contentType)) {
            return "base64";
        }
        return "binary";
    }

    public String getRootPartContentType() {
        return this.rootPartContentType;
    }

    public OutputStream writeRootPart() throws IOException {
        return this.writer.writePart(this.rootPartContentType, "binary", this.format.getRootContentId(), null);
    }

    public OutputStream writePart(String contentType, String contentID) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(contentType), contentID, null);
    }

    public OutputStream writePart(String contentType, String contentID, List<Header> extraHeaders) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(contentType), contentID, extraHeaders);
    }

    public void writePart(DataHandler dataHandler, String contentID, List<Header> extraHeaders) throws IOException {
        String contentTransferEncoding = null;
        if (dataHandler instanceof ConfigurableDataHandler) {
            contentTransferEncoding = ((ConfigurableDataHandler)dataHandler).getTransferEncoding();
        }
        if (contentTransferEncoding == null) {
            contentTransferEncoding = this.getContentTransferEncoding(dataHandler.getContentType());
        }
        this.writer.writePart(dataHandler, contentTransferEncoding, contentID, extraHeaders);
    }

    public void writePart(DataHandler dataHandler, String contentID) throws IOException {
        this.writePart(dataHandler, contentID, null);
    }

    public void complete() throws IOException {
        this.writer.complete();
    }
}

