/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds.custombuilder;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.ds.BlobOMDataSource;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;

public final class BlobOMDataSourceCustomBuilder
implements CustomBuilder {
    private final WritableBlobFactory<?> blobFactory;
    private final String encoding;

    public BlobOMDataSourceCustomBuilder(WritableBlobFactory<?> blobFactory, String encoding) {
        this.blobFactory = blobFactory;
        this.encoding = encoding;
    }

    @Override
    public OMDataSource create(OMElement element) throws OMException {
        try {
            Object blob = this.blobFactory.createBlob();
            try (OutputStream out = blob.getOutputStream();){
                element.serializeAndConsume(out);
            }
            return new BlobOMDataSource((Blob)blob, this.encoding);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
        catch (IOException ex) {
            throw new OMException(ex);
        }
    }
}

