/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import org.apache.axiom.mime.ContentTypeTokenizer;

public final class MediaType {
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_SOAP_XML = new MediaType("application", "soap+xml");
    public static final MediaType APPLICATION_XOP_XML = new MediaType("application", "xop+xml");
    public static final MediaType MULTIPART_RELATED = new MediaType("multipart", "related");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    private final String primaryType;
    private final String subType;

    public MediaType(String primaryType, String subType) {
        this.primaryType = primaryType;
        this.subType = subType;
    }

    public MediaType(String type) throws ParseException {
        ContentTypeTokenizer tokenizer = new ContentTypeTokenizer(type);
        this.primaryType = tokenizer.requireToken();
        tokenizer.require('/');
        this.subType = tokenizer.requireToken();
        tokenizer.requireEndOfString();
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean hasPrimaryType(String type) {
        return this.primaryType.equalsIgnoreCase(type);
    }

    public boolean hasSubType(String type) {
        return this.subType.equalsIgnoreCase(type);
    }

    public boolean isXML() {
        return this.equals(TEXT_XML) || this.hasPrimaryType("application") && (this.hasSubType("xml") || this.subType.length() > 4 && this.subType.substring(this.subType.length() - 4).equalsIgnoreCase("+xml"));
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        int l = this.primaryType.length();
        while (i < l) {
            hash = 31 * hash + Character.toLowerCase(this.primaryType.charAt(i));
            ++i;
        }
        hash *= 31;
        i = 0;
        l = this.subType.length();
        while (i < l) {
            hash = 31 * hash + Character.toLowerCase(this.subType.charAt(i));
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaType) {
            MediaType other = (MediaType)obj;
            return this.primaryType.equalsIgnoreCase(other.primaryType) && this.subType.equalsIgnoreCase(other.subType);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.primaryType) + "/" + this.subType;
    }
}

