/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.axiom.locator.Feature;
import org.apache.axiom.locator.Implementation;
import org.apache.axiom.locator.ImplementationFactory;
import org.apache.axiom.locator.OSGiLoader;
import org.apache.axiom.locator.PriorityBasedOMMetaFactoryLocator;
import org.apache.axiom.locator.RegisteredImplementation;
import org.apache.axiom.om.OMMetaFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTrackerCustomizer;

final class OSGiOMMetaFactoryLocator
extends PriorityBasedOMMetaFactoryLocator
implements BundleTrackerCustomizer<List<RegisteredImplementation>> {
    private final BundleContext apiBundleContext;
    private final List<Implementation> implementations = new ArrayList<Implementation>();

    OSGiOMMetaFactoryLocator(BundleContext apiBundleContext) {
        this.apiBundleContext = apiBundleContext;
    }

    @Override
    public synchronized OMMetaFactory getOMMetaFactory(String feature) {
        return super.getOMMetaFactory(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegisteredImplementation> addingBundle(Bundle bundle, BundleEvent event) {
        URL descriptorUrl = bundle.getEntry("META-INF/axiom.xml");
        if (descriptorUrl != null) {
            List<Implementation> discoveredImplementations = ImplementationFactory.parseDescriptor(new OSGiLoader(bundle), descriptorUrl);
            ArrayList<RegisteredImplementation> registeredImplementations = new ArrayList<RegisteredImplementation>(discoveredImplementations.size());
            OSGiOMMetaFactoryLocator oSGiOMMetaFactoryLocator = this;
            synchronized (oSGiOMMetaFactoryLocator) {
                this.implementations.addAll(discoveredImplementations);
                this.loadImplementations(this.implementations);
            }
            for (Implementation implementation : discoveredImplementations) {
                ArrayList registrations = new ArrayList();
                ArrayList references = new ArrayList();
                Feature[] featureArray = implementation.getFeatures();
                int n = featureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Feature feature = featureArray[n2];
                    ArrayList<String> clazzes = new ArrayList<String>();
                    clazzes.add(OMMetaFactory.class.getName());
                    Class<?>[] classArray = feature.getExtensionInterfaces();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> extensionInterface = classArray[n4];
                        clazzes.add(extensionInterface.getName());
                        ++n4;
                    }
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    properties.put("implementationName", implementation.getName());
                    properties.put("feature", feature.getName());
                    properties.put("service.ranking", feature.getPriority());
                    ServiceRegistration registration = bundle.getBundleContext().registerService(clazzes.toArray(new String[clazzes.size()]), (Object)implementation.getMetaFactory(), properties);
                    registrations.add(registration);
                    ServiceReference reference = registration.getReference();
                    references.add(reference);
                    this.apiBundleContext.getService(reference);
                    ++n2;
                }
                registeredImplementations.add(new RegisteredImplementation(implementation, registrations, references));
            }
            return registeredImplementations;
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<RegisteredImplementation> object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedBundle(Bundle bundle, BundleEvent event, List<RegisteredImplementation> object) {
        for (RegisteredImplementation registeredImplementation : object) {
            for (ServiceReference<?> serviceReference : registeredImplementation.getReferences()) {
                this.apiBundleContext.ungetService(serviceReference);
            }
            for (ServiceRegistration serviceRegistration : registeredImplementation.getRegistrations()) {
                serviceRegistration.unregister();
            }
            OSGiOMMetaFactoryLocator oSGiOMMetaFactoryLocator = this;
            synchronized (oSGiOMMetaFactoryLocator) {
                this.implementations.remove(registeredImplementation.getImplementation());
            }
        }
        OSGiOMMetaFactoryLocator oSGiOMMetaFactoryLocator = this;
        synchronized (oSGiOMMetaFactoryLocator) {
            this.loadImplementations(this.implementations);
        }
    }
}

