/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.blob.State;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.util.io.IOUtils;

final class OverflowableBlobImpl
implements OverflowableBlob {
    final int chunkSize;
    final WritableBlobFactory<?> overflowBlobFactory;
    byte[][] chunks;
    int chunkIndex;
    int chunkOffset;
    WritableBlob overflowBlob;
    State state = State.NEW;
    OutputStream overflowOutputStream;

    OverflowableBlobImpl(int numberOfChunks, int chunkSize, WritableBlobFactory<?> overflowBlobFactory) {
        this.chunkSize = chunkSize;
        this.overflowBlobFactory = overflowBlobFactory;
        this.chunks = new byte[numberOfChunks][];
    }

    byte[] getCurrentChunk() {
        if (this.chunkOffset == 0) {
            byte[] chunk = new byte[this.chunkSize];
            this.chunks[this.chunkIndex] = chunk;
            return chunk;
        }
        return this.chunks[this.chunkIndex];
    }

    void switchToOverflowBlob() throws IOException {
        this.overflowBlob = this.overflowBlobFactory.createBlob();
        this.overflowOutputStream = this.overflowBlob.getOutputStream();
        int i = 0;
        while (i < this.chunkIndex) {
            this.overflowOutputStream.write(this.chunks[i]);
            ++i;
        }
        if (this.chunkOffset > 0) {
            this.overflowOutputStream.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
        }
        this.chunks = null;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.state != State.NEW) {
            throw new IllegalStateException();
        }
        this.state = State.UNCOMMITTED;
        return new OutputStreamImpl();
    }

    long readFrom(InputStream in, long length, boolean commit) throws StreamCopyException {
        if (this.state == State.COMMITTED) {
            throw new IllegalStateException();
        }
        long read = 0L;
        long toRead = length == -1L ? Long.MAX_VALUE : length;
        while (toRead > 0L) {
            int c;
            if (this.overflowOutputStream != null) {
                read += IOUtils.copy(in, this.overflowOutputStream, toRead);
                break;
            }
            if (this.chunkIndex == this.chunks.length) {
                try {
                    this.switchToOverflowBlob();
                    continue;
                }
                catch (IOException ex) {
                    throw new StreamCopyException(2, ex);
                }
            }
            try {
                int len = this.chunkSize - this.chunkOffset;
                if ((long)len > toRead) {
                    len = (int)toRead;
                }
                c = in.read(this.getCurrentChunk(), this.chunkOffset, len);
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (c == -1) break;
            read += (long)c;
            toRead -= (long)c;
            this.chunkOffset += c;
            if (this.chunkOffset != this.chunkSize) continue;
            ++this.chunkIndex;
            this.chunkOffset = 0;
        }
        if (commit && this.overflowOutputStream != null) {
            try {
                this.overflowOutputStream.close();
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
        this.state = commit ? State.COMMITTED : State.UNCOMMITTED;
        return read;
    }

    @Override
    public long readFrom(InputStream in) throws StreamCopyException {
        if (this.state != State.NEW) {
            throw new IllegalStateException();
        }
        return this.readFrom(in, -1L, true);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            return this.overflowBlob.getInputStream();
        }
        return new InputStreamImpl();
    }

    @Override
    public void writeTo(OutputStream out) throws StreamCopyException {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            this.overflowBlob.writeTo(out);
        } else {
            try {
                int i = 0;
                while (i < this.chunkIndex) {
                    out.write(this.chunks[i]);
                    ++i;
                }
                if (this.chunkOffset > 0) {
                    out.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
                }
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
    }

    @Override
    public long getSize() {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            return this.overflowBlob.getSize();
        }
        return this.chunkIndex * this.chunkSize + this.chunkOffset;
    }

    @Override
    public void release() throws IOException {
        if (this.overflowBlob != null) {
            this.overflowBlob.release();
            this.overflowBlob = null;
        }
        this.state = State.RELEASED;
    }

    @Override
    public WritableBlob getOverflowBlob() {
        return this.overflowBlob;
    }

    class InputStreamImpl
    extends InputStream {
        private int currentChunkIndex;
        private int currentChunkOffset;
        private int markChunkIndex;
        private int markChunkOffset;

        InputStreamImpl() {
        }

        @Override
        public int available() throws IOException {
            return (OverflowableBlobImpl.this.chunkIndex - this.currentChunkIndex) * OverflowableBlobImpl.this.chunkSize + OverflowableBlobImpl.this.chunkOffset - this.currentChunkOffset;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int read = 0;
            while (len > 0 && (this.currentChunkIndex != OverflowableBlobImpl.this.chunkIndex || this.currentChunkOffset != OverflowableBlobImpl.this.chunkOffset)) {
                int c = this.currentChunkIndex == OverflowableBlobImpl.this.chunkIndex ? Math.min(len, OverflowableBlobImpl.this.chunkOffset - this.currentChunkOffset) : Math.min(len, OverflowableBlobImpl.this.chunkSize - this.currentChunkOffset);
                System.arraycopy(OverflowableBlobImpl.this.chunks[this.currentChunkIndex], this.currentChunkOffset, b, off, c);
                len -= c;
                off += c;
                this.currentChunkOffset += c;
                read += c;
                if (this.currentChunkOffset != OverflowableBlobImpl.this.chunkSize) continue;
                ++this.currentChunkIndex;
                this.currentChunkOffset = 0;
            }
            if (read == 0) {
                return -1;
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b) == -1 ? -1 : b[0] & 0xFF;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            this.markChunkIndex = this.currentChunkIndex;
            this.markChunkOffset = this.currentChunkOffset;
        }

        @Override
        public void reset() throws IOException {
            this.currentChunkIndex = this.markChunkIndex;
            this.currentChunkOffset = this.markChunkOffset;
        }

        @Override
        public long skip(long n) throws IOException {
            int available = this.available();
            int c = n < (long)available ? (int)n : available;
            int newOffset = this.currentChunkOffset + c;
            int chunkDelta = newOffset / OverflowableBlobImpl.this.chunkSize;
            this.currentChunkIndex += chunkDelta;
            this.currentChunkOffset = newOffset - chunkDelta * OverflowableBlobImpl.this.chunkSize;
            return c;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class OutputStreamImpl
    extends OutputStream
    implements ReadFromSupport {
        OutputStreamImpl() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            block3: {
                block2: {
                    if (OverflowableBlobImpl.this.state != State.UNCOMMITTED) {
                        throw new IllegalStateException();
                    }
                    if (OverflowableBlobImpl.this.overflowOutputStream == null) break block2;
                    OverflowableBlobImpl.this.overflowOutputStream.write(b, off, len);
                    break block3;
                }
                if (len <= (OverflowableBlobImpl.this.chunks.length - OverflowableBlobImpl.this.chunkIndex) * OverflowableBlobImpl.this.chunkSize - OverflowableBlobImpl.this.chunkOffset) ** GOTO lbl20
                OverflowableBlobImpl.this.switchToOverflowBlob();
                OverflowableBlobImpl.this.overflowOutputStream.write(b, off, len);
                break block3;
lbl-1000:
                // 1 sources

                {
                    chunk = OverflowableBlobImpl.this.getCurrentChunk();
                    c = Math.min(len, OverflowableBlobImpl.this.chunkSize - OverflowableBlobImpl.this.chunkOffset);
                    System.arraycopy(b, off, chunk, OverflowableBlobImpl.this.chunkOffset, c);
                    len -= c;
                    off += c;
                    OverflowableBlobImpl.this.chunkOffset += c;
                    if (OverflowableBlobImpl.this.chunkOffset != OverflowableBlobImpl.this.chunkSize) continue;
                    ++OverflowableBlobImpl.this.chunkIndex;
                    OverflowableBlobImpl.this.chunkOffset = 0;
lbl20:
                    // 3 sources

                    ** while (len > 0)
                }
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void close() throws IOException {
            if (OverflowableBlobImpl.this.overflowOutputStream != null) {
                OverflowableBlobImpl.this.overflowOutputStream.close();
            }
            OverflowableBlobImpl.this.state = State.COMMITTED;
        }

        @Override
        public long readFrom(InputStream in, long length) throws StreamCopyException {
            return OverflowableBlobImpl.this.readFrom(in, length, false);
        }
    }
}

