/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.blob.MemoryBlobChunk;
import org.apache.axiom.blob.MemoryBlobImpl;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.ext.io.StreamCopyException;

final class MemoryBlobOutputStreamImpl
extends MemoryBlobOutputStream {
    private final MemoryBlobImpl blob;
    private MemoryBlobChunk chunk;

    MemoryBlobOutputStreamImpl(MemoryBlobImpl blob, MemoryBlobChunk firstChunk) {
        this.blob = blob;
        this.chunk = firstChunk;
    }

    private void updateChunk() {
        if (this.chunk.size == this.chunk.buffer.length) {
            this.chunk = this.chunk.allocateNextChunk();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        int total = 0;
        while (total < len) {
            this.updateChunk();
            int c = Math.min(len - total, this.chunk.buffer.length - this.chunk.size);
            System.arraycopy(b, off, this.chunk.buffer, this.chunk.size, c);
            this.chunk.size += c;
            total += c;
            off += c;
        }
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) {
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        this.updateChunk();
        this.chunk.buffer[this.chunk.size++] = (byte)b;
    }

    @Override
    public long readFrom(InputStream in, long length) throws StreamCopyException {
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        long read = 0L;
        long toRead = length == -1L ? Long.MAX_VALUE : length;
        while (toRead > 0L) {
            int c;
            this.updateChunk();
            try {
                c = in.read(this.chunk.buffer, this.chunk.size, (int)Math.min(toRead, (long)(this.chunk.buffer.length - this.chunk.size)));
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (c == -1) break;
            this.chunk.size += c;
            read += (long)c;
            toRead -= (long)c;
        }
        return read;
    }

    @Override
    public void close() {
        this.blob.commit();
        this.chunk = null;
    }
}

