/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.shared.common.error.StandardException;

public class GenericPrivilegeInfo
extends PrivilegeInfo {
    private PrivilegedSQLObject _tupleDescriptor;
    private String _privilege;
    private boolean _restrict;

    public GenericPrivilegeInfo(PrivilegedSQLObject tupleDescriptor, String privilege, boolean restrict) {
        this._tupleDescriptor = tupleDescriptor;
        this._privilege = privilege;
        this._restrict = restrict;
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean grant, List grantees) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String currentUser = lcc.getCurrentUserId(activation);
        TransactionController tc = lcc.getTransactionExecute();
        SchemaDescriptor sd = this._tupleDescriptor.getSchemaDescriptor();
        UUID objectID = this._tupleDescriptor.getUUID();
        String objectTypeName = this._tupleDescriptor.getObjectTypeName();
        this.checkOwnership(currentUser, this._tupleDescriptor, sd, dd);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        PermDescriptor permDesc = ddg.newPermDescriptor(null, objectTypeName, objectID, this._privilege, currentUser, null, false);
        dd.startWriting(lcc);
        Iterator itr = grantees.iterator();
        while (itr.hasNext()) {
            boolean privileges_revoked = false;
            String grantee = (String)itr.next();
            if (dd.addRemovePermissionsDescriptor(grant, permDesc, grantee, tc)) {
                privileges_revoked = true;
                int invalidationType = this._restrict ? 45 : 44;
                dd.getDependencyManager().invalidateFor(permDesc, invalidationType, lcc);
                dd.getDependencyManager().invalidateFor(this._tupleDescriptor, invalidationType, lcc);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, grant, privileges_revoked, grantee);
        }
    }
}

