/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.launcher.client.LaunchRequest;
import com.sas.launcher.client.LauncherClient;
import com.sas.launcher.client.LauncherClientAuthenticationException;
import com.sas.launcher.client.LauncherClientDisconnectedException;
import com.sas.launcher.client.OperatingSystem;
import com.sas.launcher.client.Password;
import com.sas.launcher.client.Process;
import com.sas.launcher.client.ProcessState;
import com.sas.launcher.client.Product;
import com.sas.launcher.client.ProductInfoRequest;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.model.SchedulerException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASJFSLauncherClient {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(SASJFSLauncherClient.class);
    private static final Logger LOGGER = LogManager.getLogger(SASJFScheduler.class);
    private static int SETINTLICENSE = 1616;
    private LauncherClient _launcherClient = LauncherClient.create();
    private String _host;
    private Integer _port;
    private int _bufSize;
    private boolean _sslEnabled;
    private static String userCommandLine = " -user %s ";
    private static String keyCommandLine = " -key %s ";
    private static String ssl = " -ssl";

    public SASJFSLauncherClient(String host, Integer port, int bufSize, boolean sslEnabled) {
        this._host = host;
        this._port = port;
        this._bufSize = bufSize;
        this._sslEnabled = sslEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getServerAuthentication(String username, SealedString password) throws SchedulerException {
        boolean isLicensedConnection = false;
        Password pw = Password.create((String)(password != null ? String.valueOf(password.getCharacters()) : ""));
        try {
            this._launcherClient.connect(this._host, this._port, Boolean.valueOf(this._sslEnabled), username, pw);
        }
        catch (LauncherClientAuthenticationException cause) {
            LOGGER.error(cause.getMessage());
            return false;
        }
        catch (RuntimeException rte) {
            LOGGER.error(rte.getMessage());
            return false;
        }
        if (this._launcherClient != null) {
            if (this.verifyLicense()) {
                return true;
            }
            this.closeServerAuthentication();
            isLicensedConnection = false;
            SchedulerException ex = new SchedulerException(m_bundle.getString("SASJFSLauncherClient.InvalidLicense.txt"), SASJFSLauncherClient.class, "SASJFSLauncherClient.InvalidLicense.txt", null);
            throw ex;
        }
        LOGGER.error("Unable to create Launcher connection.");
        return isLicensedConnection;
    }

    public boolean closeServerAuthentication() {
        try {
            this._launcherClient.disconnect();
            return true;
        }
        catch (RuntimeException cause) {
            LOGGER.error(cause.getMessage());
            return false;
        }
    }

    private boolean verifyLicense() throws SchedulerException {
        ProductInfoRequest productInfoRequest = ProductInfoRequest.create((Integer)SETINTLICENSE);
        Product product = null;
        try {
            product = this._launcherClient.productInfo(productInfoRequest);
        }
        catch (LauncherClientDisconnectedException e) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("SASJFSLauncherClient.Disconnected.txt"), SASJFSLauncherClient.class, "SASJFSLauncherClient.Disconnected.txt", null);
            throw ex;
        }
        return product.isLicensed();
    }

    public boolean updateKey(String command, String user, SealedString password) {
        boolean updated = false;
        try {
            OperatingSystem operatingSystem = this._launcherClient.getServerOperatingSystem();
            if (!operatingSystem.isWindows().booleanValue()) {
                return true;
            }
            command = command + String.format(userCommandLine, user);
            command = command + String.format(keyCommandLine, password != null ? String.valueOf(password.getCharacters()) : null);
            if (this._sslEnabled) {
                command = command + ssl;
            }
            updated = this.sendToLauncherNoPolling(command) != null;
        }
        catch (LauncherClientDisconnectedException e) {
            LOGGER.error(e.getMessage());
        }
        return updated;
    }

    public boolean scheduleFlow(String command, String user, SealedString password) {
        try {
            OperatingSystem operatingSystem = this._launcherClient.getServerOperatingSystem();
            if (operatingSystem.isWindows().booleanValue()) {
                command = command + String.format(userCommandLine, user);
                command = command + String.format(keyCommandLine, password != null ? String.valueOf(password.getCharacters()) : null);
            }
        }
        catch (LauncherClientDisconnectedException e) {
            LOGGER.error(e.getMessage());
        }
        return this.sendToLauncher(command).compareTo((Enum)ProcessState.COMPLETED) == 0;
    }

    public int rescheduleFlow(String command, String user, SealedString password) {
        int rc = 2;
        try {
            OperatingSystem operatingSystem = this._launcherClient.getServerOperatingSystem();
            if (operatingSystem.isWindows().booleanValue()) {
                command = command + String.format(userCommandLine, user);
                command = command + String.format(keyCommandLine, password != null ? String.valueOf(password.getCharacters()) : null);
            }
        }
        catch (LauncherClientDisconnectedException e) {
            LOGGER.error(e.getMessage());
        }
        ProcessState ps = this.sendToLauncher(command);
        if (ps.compareTo((Enum)ProcessState.COMPLETED) == 0) {
            rc = 0;
        }
        return rc;
    }

    public boolean unschedule(String command) {
        return this.sendToLauncher(command).compareTo((Enum)ProcessState.COMPLETED) == 0;
    }

    public boolean execute(String command) {
        return this.sendToLauncherNoPolling(command) != null;
    }

    public ProcessState sendToLauncher(String command) {
        LaunchRequest launchRequest = LaunchRequest.builder().command(command).build();
        Process process = null;
        try {
            process = this._launcherClient.launch(launchRequest);
            while (!process.hasTerminated().booleanValue()) {
                process = this._launcherClient.status(process);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LOGGER.info("Process state: " + process.getState());
            }
            LOGGER.info("Has terminated, process state: " + process.getState());
        }
        catch (LauncherClientDisconnectedException e) {
            LOGGER.error(e.getMessage());
        }
        return process != null ? process.getState() : ProcessState.SERVER_ERROR;
    }

    public Process sendToLauncherNoPolling(String command) {
        LaunchRequest launchRequest = LaunchRequest.builder().command(command).build();
        Process process = null;
        try {
            process = this._launcherClient.launch(launchRequest);
        }
        catch (LauncherClientDisconnectedException e) {
            LOGGER.error(e.getMessage());
        }
        return process;
    }
}

