/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(File file, int maxChars) throws Exception {
        StringBuffer fileData = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String s;
            while ((s = br.readLine()) != null) {
                fileData.append(s);
                fileData.append('\n');
                if (maxChars <= 0 || fileData.length() < maxChars) continue;
            }
            String string = fileData.toString();
            return string;
        }
    }

    public static List<File> findAllFiles(File root) {
        File[] allFiles;
        ArrayList<File> result = new ArrayList<File>();
        if (root == null) {
            return result;
        }
        if (!root.exists()) {
            return result;
        }
        for (File file : allFiles = root.listFiles()) {
            if (file.isDirectory()) {
                List<File> subDirResults = FileUtilities.findAllFiles(file);
                result.addAll(subDirResults);
                continue;
            }
            result.add(file);
        }
        return result;
    }

    public static void deleteDirAndContents(File rootDir) {
        if (rootDir == null) {
            return;
        }
        if (!rootDir.exists()) {
            return;
        }
        File[] allFiles = rootDir.listFiles();
        if (allFiles == null) {
            return;
        }
        for (File file : allFiles) {
            if (file.isDirectory()) {
                FileUtilities.deleteDirAndContents(file);
                continue;
            }
            FileUtilities.deleteFileSafely(file);
        }
        FileUtilities.deleteFileSafely(rootDir);
    }

    private static void deleteFileSafely(File file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeLineToFile(File target, String data) throws Exception {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(target));
            writer.write(data);
            writer.newLine();
        }
    }
}

