/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FileStatInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileEventChecker {
    FileEventInfo m_event;
    FileStatInfo m_previous;
    FileStatInfo m_current;

    public FileEventChecker(FileEventInfo event, FileStatInfo previous, FileStatInfo current) {
        this.m_event = event;
        this.m_previous = previous;
        this.m_current = current;
    }

    public boolean isTrue() {
        boolean rc = false;
        int operator = this.m_event.getOperator();
        long value = this.m_event.getValue();
        block0 : switch (this.m_event.getEventType()) {
            case 0: {
                if (value == 0L) {
                    rc = this.m_current.doesFileExist();
                    break;
                }
                rc = !this.m_current.doesFileExist();
                break;
            }
            case 2: {
                if (this.m_current.doesFileExist() && !this.m_previous.doesFileExist()) {
                    rc = true;
                    break;
                }
                rc = false;
                break;
            }
            case 3: {
                long difference = System.currentTimeMillis() - this.m_current.getFileModifiedDataBinding();
                long remainder = difference % 60000L;
                long age = (difference - remainder) / 60000L;
                switch (operator) {
                    case 21: {
                        rc = age == value;
                        break;
                    }
                    case 23: {
                        rc = age > value;
                        break;
                    }
                    case 24: {
                        rc = age >= value;
                        break;
                    }
                    case 25: {
                        rc = age < value;
                        break;
                    }
                    case 26: {
                        rc = age <= value;
                        break;
                    }
                    case 22: {
                        rc = age != value;
                    }
                }
                break;
            }
            case 1: {
                long size = this.m_current.getFileSizeDataBinding();
                switch (operator) {
                    case 21: {
                        rc = size == value;
                        break block0;
                    }
                    case 23: {
                        rc = size > value;
                        break block0;
                    }
                    case 24: {
                        rc = size >= value;
                        break block0;
                    }
                    case 25: {
                        rc = size < value;
                        break block0;
                    }
                    case 26: {
                        rc = size <= value;
                        break block0;
                    }
                    case 22: {
                        rc = size != value;
                    }
                }
            }
        }
        return rc;
    }

    public boolean updateStat(Map<String, FileStatInfo> latest) {
        Set<String> files = latest.keySet();
        for (String filename : files) {
            if (!filename.equals(this.m_event.getFileName())) continue;
            this.m_previous = this.m_current;
            this.m_current = latest.get(filename);
            return true;
        }
        return false;
    }

    public static List<FileEventInfo> getExternalFileEventTriggers(TriggerEventInfo trigger) {
        ArrayList<FileEventInfo> list;
        block4: {
            List<AbstractEventInfo>[] lists;
            block5: {
                list = new ArrayList<FileEventInfo>();
                AbstractEventInfo event = trigger.getEvent();
                if (event instanceof FileEventInfo) {
                    list.add((FileEventInfo)event);
                    return list;
                }
                if (event instanceof TimeEventInfo) {
                    return null;
                }
                if (!(event instanceof GroupingEventInfo)) break block4;
                GroupingEventInfo gate = (GroupingEventInfo)event;
                lists = FileEventChecker.parseTriggerTypes(gate);
                if (gate.getEventType() != 1) break block5;
                List<AbstractEventInfo> file = lists[0];
                for (FileEventInfo fileEventInfo : file) {
                    list.add(fileEventInfo);
                }
                break block4;
            }
            List<AbstractEventInfo> file = lists[0];
            List<AbstractEventInfo> time = lists[1];
            if (!time.isEmpty()) break block4;
            for (FileEventInfo fileEventInfo : file) {
                list.add(fileEventInfo);
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<FileEventInfo> getInternalFileEventTriggers(TriggerEventInfo trigger) {
        ArrayList<FileEventInfo> list = new ArrayList<FileEventInfo>();
        AbstractEventInfo event = trigger.getEvent();
        if (!(event instanceof GroupingEventInfo)) return null;
        GroupingEventInfo gate = (GroupingEventInfo)event;
        List<AbstractEventInfo>[] lists = FileEventChecker.parseTriggerTypes(gate);
        if (gate.getEventType() != 0) return null;
        List<AbstractEventInfo> file = lists[0];
        List<AbstractEventInfo> time = lists[1];
        if (time.isEmpty()) return list;
        for (FileEventInfo fileEventInfo : file) {
            list.add(fileEventInfo);
        }
        return list;
    }

    private static List<AbstractEventInfo>[] parseTriggerTypes(GroupingEventInfo gate) {
        List[] list = new ArrayList[2];
        ArrayList<AbstractEventInfo> file = new ArrayList<AbstractEventInfo>();
        ArrayList<AbstractEventInfo> time = new ArrayList<AbstractEventInfo>();
        list[0] = file;
        list[1] = time;
        List triggers = gate.getDependencies2();
        int numTriggers = triggers.size();
        for (int x = 0; x < numTriggers; ++x) {
            AbstractEventInfo t = (AbstractEventInfo)triggers.get(x);
            if (t instanceof TimeEventInfo) {
                time.add(t);
                continue;
            }
            if (!(t instanceof FileEventInfo)) continue;
            file.add(t);
        }
        return list;
    }
}

