/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.ssl.client;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.FileStreamFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLObjectFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLObjectUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketFactoryBuilder {
    public static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private final SSLObjectFactory sslObjectFactory = new SSLObjectFactory();
    private final SSLObjectUtils sslObjectUtils = new SSLObjectUtils();
    private final FileStreamFactory fileStreamFactory = new FileStreamFactory();

    public Instance getInstance() {
        return new Instance();
    }

    public class Instance {
        private String sslProtocol = "TLSv1.2";
        private String sslTrustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        private String sslTrustStoreType = KeyStore.getDefaultType();
        private String sslTrustStorePath = null;
        private SealedString sslTrustStorePassword = null;

        private Instance() {
        }

        public Instance sslProtocol(String sslProtocol) {
            this.sslProtocol = sslProtocol;
            return this;
        }

        public Instance sslTrustManagerAlgorithm(String sslTrustManagerAlgorithm) {
            this.sslTrustManagerAlgorithm = sslTrustManagerAlgorithm;
            return this;
        }

        public Instance sslTrustStoreType(String sslTrustStoreType) {
            this.sslTrustStoreType = sslTrustStoreType;
            return this;
        }

        public Instance sslTrustStorePath(String sslTrustStorePath) {
            this.sslTrustStorePath = sslTrustStorePath;
            return this;
        }

        @Deprecated
        public Instance sslTrustStorePassword(String sslTrustStorePassword) {
            return this.sslTrustStorePassword(sslTrustStorePassword != null ? new SealedString(sslTrustStorePassword) : null);
        }

        public Instance sslTrustStorePassword(SealedString sslTrustStorePassword) {
            this.sslTrustStorePassword = sslTrustStorePassword;
            return this;
        }

        public SSLSocketFactory build() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException {
            SSLContext sslContext = SSLSocketFactoryBuilder.this.sslObjectFactory.getSSLContext(this.sslProtocol);
            TrustManagerFactory trustManagerFactory = SSLSocketFactoryBuilder.this.sslObjectFactory.getTrustManagerFactory(this.sslTrustManagerAlgorithm);
            KeyStore trustStore = SSLSocketFactoryBuilder.this.sslObjectFactory.getKeyStore(this.sslTrustStoreType);
            if (this.sslTrustStorePath != null) {
                FileInputStream fileInputStream = SSLSocketFactoryBuilder.this.fileStreamFactory.getInputStream(this.sslTrustStorePath);
                SSLSocketFactoryBuilder.this.sslObjectUtils.keyStoreLoad(trustStore, (InputStream)fileInputStream, this.sslTrustStorePassword);
                fileInputStream.close();
            }
            SSLSocketFactoryBuilder.this.sslObjectUtils.trustFactoryManagerInit(trustManagerFactory, trustStore);
            SSLSocketFactoryBuilder.this.sslObjectUtils.sslContextInit(sslContext, SSLSocketFactoryBuilder.this.sslObjectUtils.getTrustManagerFactoryTrustManagers(trustManagerFactory));
            return SSLSocketFactoryBuilder.this.sslObjectUtils.getSSLContextSocketFactory(sslContext);
        }
    }
}

