/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.ssl.client;

import com.sas.net.crypto.SealedString;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SSLObjectUtils {
    SSLObjectUtils() {
    }

    public void trustFactoryManagerInit(TrustManagerFactory trustManagerFactory, KeyStore keyStore) throws KeyStoreException {
        trustManagerFactory.init(keyStore);
    }

    public void keyFactoryManagerInit(KeyManagerFactory keyManagerFactory, KeyStore keyStore, String password) throws KeyStoreException {
        this.keyFactoryManagerInit(keyManagerFactory, keyStore, password != null ? new SealedString(password) : null);
    }

    public void keyFactoryManagerInit(KeyManagerFactory keyManagerFactory, KeyStore keyStore, SealedString password) throws KeyStoreException {
        try {
            keyManagerFactory.init(keyStore, password != null ? password.getCharacters() : null);
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void sslContextInit(SSLContext sslContext, TrustManager[] trustManagers) throws KeyManagementException {
        sslContext.init(null, trustManagers, null);
    }

    public void sslContextInit(SSLContext sslContext, KeyManager[] keyManagers) throws KeyManagementException {
        sslContext.init(keyManagers, null, null);
    }

    public TrustManager[] getTrustManagerFactoryTrustManagers(TrustManagerFactory trustManagerFactory) {
        return trustManagerFactory.getTrustManagers();
    }

    public KeyManager[] getKeyManagerFactoryKeyManagers(KeyManagerFactory keyManagerFactory) {
        return keyManagerFactory.getKeyManagers();
    }

    public SSLSocketFactory getSSLContextSocketFactory(SSLContext sslContext) {
        return sslContext.getSocketFactory();
    }

    public SSLServerSocketFactory getSSLServerContextSocketFactory(SSLContext sslContext) {
        return sslContext.getServerSocketFactory();
    }

    public void keyStoreLoad(KeyStore keyStore, InputStream inputStream, String password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreLoad(keyStore, inputStream, password != null ? new SealedString(password) : null);
    }

    public void keyStoreLoad(KeyStore keyStore, InputStream inputStream, SealedString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        keyStore.load(inputStream, password != null ? password.getCharacters() : null);
    }
}

