/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sas.grid.representations.Job;
import com.sas.grid.representations.Queue;
import com.sas.grid.representations.Queues;
import com.sas.grid.representations.ResourceNames;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.AbstractBaseService;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.IBaseService;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.RestCall;
import com.sas.scheduler.api.servers.sasjfs.sgmg.AuthenticationException;
import com.sas.util.BASE64;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GridService
extends AbstractBaseService
implements IBaseService {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    private static final String _gridJobPostCmdJsonTemplate = "{ \"version\": {{ver_num}}, \"request\": {\"cmd\": \"{{command}}\", \"name\": \"{{name}}\"}}";
    private static final String _gridJobPostCmdJsonTemplatewithQueue = "{ \"version\": {{ver_num}}, \"request\": {\"cmd\": \"{{command}}\", \"name\": \"{{name}}\", \"queue\": \"{{queue}}\"}}";
    private static String _gridProcessesUrl;
    private static String getQueuesUrl;
    private static String getResourcesUrl;
    private static final List<String> _statusCompleteList;

    public GridService(String restAPIPath) {
        super(restAPIPath);
        _gridProcessesUrl = this._baseUrl + "/sasgrid/api/jobs";
    }

    public Job launchProcess(String processJson, PasswordAuthentication authToken, ExecutionItem executionItem) throws IOException, SasPasswordEncodingException, AuthenticationException {
        Job job = null;
        HashMap<String, String> requestProps = new HashMap<String, String>();
        if (authToken != null) {
            String pa = authToken.getUserName() + ":" + new String(authToken.getPassword()).replace("\"", "");
            String authPass = BASE64.encode((byte[])pa.getBytes("UTF-8"));
            requestProps.put("Authorization", String.format("Basic %s", authPass));
        }
        requestProps.put("Accept", "application/vnd.sas.sasgrid.job;version=1;charset=utf-8");
        URL restEndpoint = new URL(_gridProcessesUrl);
        String contentType = "application/vnd.sas.sasgrid.job.request;version=1;charset=utf-8";
        String requestBody = processJson;
        LOGGER.debug("Grid requestBody: " + requestBody);
        RestCall rc = new RestCall(restEndpoint, "POST", requestProps, requestBody, contentType, SASJFSProperties.getReadTimeOut(), SASJFSProperties.getConnTimeOut());
        String gridResponse = rc.response;
        if (gridResponse != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                job = (Job)mapper.readValue(gridResponse, Job.class);
            }
            catch (JsonParseException e) {
                LOGGER.error("Unable to parse json returned from grid to Job Object: " + gridResponse);
            }
            catch (JsonMappingException e) {
                LOGGER.error("Unable to parse json returned from grid to Job Object: " + gridResponse);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create Job Object from grid response: " + gridResponse);
            }
        } else {
            LOGGER.error("Grid response is null for grid on: " + restEndpoint + " grid body: " + requestBody);
        }
        return job;
    }

    public Job getJobStatus(String procStatusUrl, PasswordAuthentication authToken, int readTimeOut, int connTimeOut) throws UnsupportedEncodingException, MalformedURLException, AuthenticationException {
        Job job = null;
        HashMap<String, String> requestProps = new HashMap<String, String>();
        if (authToken != null) {
            String pa = authToken.getUserName() + ":" + new String(authToken.getPassword()).replace("\"", "");
            String authPass = BASE64.encode((byte[])pa.getBytes("UTF-8"));
            requestProps.put("Authorization", String.format("Basic %s", authPass));
        }
        String jsonString = "";
        requestProps.put("Accept", "application/vnd.sas.sasgrid.job;version=1;charset=utf-8");
        URL restEndpoint = new URL(procStatusUrl);
        String contentType = "application/vnd.sas.sasgrid.job.request;version=1;charset=utf-8";
        RestCall rc = new RestCall(restEndpoint, "GET", requestProps, null, contentType, readTimeOut, connTimeOut);
        jsonString = rc.response;
        if (jsonString == null) {
            System.err.println("Attempt to get job on grid resulted in null object being returned.");
        }
        if (jsonString != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                job = (Job)mapper.readValue(jsonString, Job.class);
            }
            catch (JsonParseException e) {
                LOGGER.error("Unable to parse json returned from grid status request for: " + procStatusUrl + " with Job Object: " + jsonString);
            }
            catch (JsonMappingException e) {
                LOGGER.error("Unable to parse json returned from grid status request for: " + procStatusUrl + " with Job Object: " + jsonString);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create Job Object from grid response for: " + procStatusUrl + " with Job Object: " + jsonString);
            }
        } else {
            LOGGER.error("Grid response is null for process get grid on: " + restEndpoint);
        }
        return job;
    }

    public List<String> getAllQueues(PasswordAuthentication authToken, int readTimeOut, int connTimeOut) throws IOException, SasPasswordEncodingException, AuthenticationException {
        ArrayList<String> queueList = new ArrayList<String>();
        HashMap<String, String> requestProps = new HashMap<String, String>();
        if (authToken != null) {
            String pw = new String(authToken.getPassword()) != null ? SasPasswordString.decode((String)new String(authToken.getPassword())) : null;
            String pa = authToken.getUserName() + ":" + pw;
            String authPass = BASE64.encode((byte[])pa.getBytes("UTF-8"));
            requestProps.put("Authorization", String.format("Basic %s", authPass));
        }
        requestProps.put("Accept", "application/vnd.sas.sasgrid.queues;version=1;charset=utf-8");
        URL restEndpoint = new URL(this._baseUrl + getQueuesUrl);
        RestCall rc = new RestCall(restEndpoint, "GET", requestProps, null, null, readTimeOut, connTimeOut);
        String gridResponse = rc.response;
        if (gridResponse == null) {
            LOGGER.error("Attempt to retrieve Queues from grid has failed.");
        } else {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Queues queues = (Queues)mapper.readValue(gridResponse, Queues.class);
            for (Queue queue : queues.getQueues()) {
                queueList.add(queue.getName());
            }
        }
        return queueList;
    }

    public ResourceNames getAllResources(PasswordAuthentication authToken, int readTimeOut, int connTimeOut) throws IOException, SasPasswordEncodingException, AuthenticationException {
        ResourceNames resourceNames = null;
        HashMap<String, String> requestProps = new HashMap<String, String>();
        if (authToken != null) {
            String pa = authToken.getUserName() + ":" + new String(authToken.getPassword());
            String authPass = BASE64.encode((byte[])pa.getBytes("UTF-8"));
            requestProps.put("Authorization", String.format("Basic %s", authPass));
        }
        requestProps.put("Accept", "application/vnd.sas.sasgrid.job.request.options;version=1;charset=utf-8");
        URL restEndpoint = new URL(this._baseUrl + getResourcesUrl);
        RestCall rc = new RestCall(restEndpoint, "GET", requestProps, null, null, readTimeOut, connTimeOut);
        String gridResponse = rc.response;
        if (gridResponse == null) {
            System.err.println("Attempt to retrieve Resources from grid has failed.");
        } else {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            resourceNames = (ResourceNames)mapper.readValue(gridResponse, ResourceNames.class);
        }
        return resourceNames;
    }

    public Job killJob(String procStatusUrl, PasswordAuthentication authToken, int readTimeOut, int connTimeOut) throws UnsupportedEncodingException, MalformedURLException, AuthenticationException {
        Job job = null;
        HashMap<String, String> requestProps = new HashMap<String, String>();
        if (authToken != null) {
            String pa = authToken.getUserName() + ":" + new String(authToken.getPassword()).replace("\"", "");
            String authPass = BASE64.encode((byte[])pa.getBytes("UTF-8"));
            requestProps.put("Authorization", String.format("Basic %s", authPass));
        }
        String jsonString = "";
        requestProps.put("Accept", "application/vnd.sas.sasgrid.job;version=1;charset=utf-8");
        URL restEndpoint = new URL(procStatusUrl);
        String contentType = "application/vnd.sas.sasgrid.job.request;version=1;charset=utf-8";
        RestCall rc = new RestCall(restEndpoint, "PUT", requestProps, null, contentType, readTimeOut, connTimeOut);
        jsonString = rc.response;
        if (jsonString == null) {
            LOGGER.error("Attempt to get job on grid resulted in null object being returned.");
        }
        if (jsonString != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                job = (Job)mapper.readValue(jsonString, Job.class);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return job;
    }

    public static String getGridProcessesUrl() {
        return _gridProcessesUrl;
    }

    public static List<String> getStatusCompleteList() {
        return _statusCompleteList;
    }

    public String getGridProcessJsonTemplate(String queue) {
        if (queue != null && !queue.isEmpty()) {
            return _gridJobPostCmdJsonTemplatewithQueue;
        }
        return _gridJobPostCmdJsonTemplate;
    }

    static {
        getQueuesUrl = "/sasgrid/api/queues";
        getResourcesUrl = "/sasgrid/api/jobs/info";
        _statusCompleteList = Arrays.asList("COMPLETED", "FAILED", "LAUNCH-ERROR", "UNKNOWN", "KILLED", "HOST-FAILED", "KILLED-LIMIT");
    }
}

