/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.model.JobEventInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowDepChecker {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    protected JobEventInfo _jobEventInfo;
    protected volatile HashMap<String, SASJFSFlowHistory> _flowHistories;
    protected volatile SASJFSFlowHistory _depHistory;
    protected String _depTargetName;

    public FlowDepChecker() {
    }

    public FlowDepChecker(String depTargetName, JobEventInfo jei, HashMap<String, SASJFSFlowHistory> flowHistories) {
        String depName = jei.getJobInfo().getName();
        int expEval = jei.getEventType();
        this._flowHistories = flowHistories;
        if (this instanceof FlowDepChecker) {
            this._depHistory = this.getFlowHistoryByName(depName, expEval);
        }
        this._depTargetName = depTargetName;
        this._jobEventInfo = jei;
    }

    public boolean evalJobExpression() {
        if (this._depHistory == null) {
            return false;
        }
        boolean retval = false;
        String jeiJobName = this._jobEventInfo.getJobDataBinding().getName();
        boolean jobCompleted = this.jobNameInCompletedItems(jeiJobName);
        int exprOp = this._jobEventInfo.getOperator();
        int exprType = this._jobEventInfo.getEventType();
        int exprValue = this._jobEventInfo.getValue();
        int jhExitCode = this._depHistory.getErrorCode();
        if (exprOp == -1) {
            switch (exprType) {
                case 0: 
                case 10: {
                    return jobCompleted && jhExitCode == 0;
                }
                case 1: 
                case 11: {
                    return jobCompleted;
                }
            }
        }
        boolean depMet = false;
        switch (exprType) {
            case 3: 
            case 13: {
                boolean opCheck = this.opCheck(exprOp, exprValue, jhExitCode);
                return opCheck;
            }
            case 4: 
            case 14: {
                depMet = false;
                if (this._depHistory.getStartTime() != null) {
                    long jobRunTimeInMinutes = FlowDepChecker.getDateDiff(this._depHistory.getStartTime(), new Date(), TimeUnit.MINUTES);
                    depMet = jobRunTimeInMinutes > (long)exprValue;
                }
                return depMet;
            }
            case 5: 
            case 15: {
                depMet = false;
                if (this._depHistory.getStartTime() != null && this._depHistory.getFinishTime() != null) {
                    long jobRunTimeInMinutes = FlowDepChecker.getDateDiff(this._depHistory.getStartTime(), this._depHistory.getFinishTime(), TimeUnit.MINUTES);
                    depMet = jobRunTimeInMinutes < (long)exprValue;
                }
                return depMet;
            }
            case 6: 
            case 16: {
                LOGGER.info("\"Flow misses scheduled time\" is an unsupported event type.");
                break;
            }
            case 8: 
            case 18: {
                LOGGER.info("\"Flow cannot run\" is an unsupported event type.");
            }
        }
        return retval;
    }

    private static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    private boolean opCheck(int exprOp, int exprValue, int valueToCheck) {
        switch (exprOp) {
            case 21: {
                return valueToCheck == exprValue;
            }
            case 23: {
                return valueToCheck > exprValue;
            }
            case 24: {
                return valueToCheck >= exprValue;
            }
            case 25: {
                return valueToCheck < exprValue;
            }
            case 26: {
                return valueToCheck <= exprValue;
            }
            case 22: {
                return valueToCheck != exprValue;
            }
        }
        return false;
    }

    public boolean jobNameInCompletedItems(String jeiJobName) {
        return this._flowHistories.containsKey(jeiJobName);
    }

    protected SASJFSFlowHistory getFlowHistoryByName(String name, int expEval) {
        return this._flowHistories.get(name);
    }
}

