/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs;

import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.apache.logging.log4j.Logger;

public class SASJFSFlowHistory
implements FlowHistory {
    private List<SASJFSFlowHistory> mSubHistories;
    private String mFlowID;
    private String mOwner;
    private String mInvoker;
    private long mExitCode;
    private static Logger mLogger;
    private int m_errorCode;
    private long m_instanceID;
    private int m_state;
    private int m_status;
    private String m_instanceName;
    private String m_flowName;
    private String m_schedulerFlowName;
    private Date m_startTime;
    private Date m_finishTime;
    private boolean mSuspended;
    public static char HistorySeparator;
    static final String TopLevelFlowTerminatorLine = "#";
    private static final String Type_Tag;
    private static final String Count_Tag;
    private static final String InstanceID_Tag;
    private static final String FlowName_Tag;
    private static final String FlowID_Tag;
    private static final String Owner_Tag;
    private static final String ExitCode_Tag;
    private static final String Invoker_Tag;
    private static final String Suspended_Tag;

    public SASJFSFlowHistory(Logger logger) {
        this.mSubHistories = new ArrayList<SASJFSFlowHistory>();
        this.mOwner = "";
        this.mExitCode = 0L;
        this.mInvoker = "";
        this.mSuspended = false;
        mLogger = logger;
    }

    public SASJFSFlowHistory(long id, String flowName, String instanceName, int state, int status, Date startTime, Date finishTime, int errorCode, Logger logger) {
        this.m_instanceID = id;
        this.m_flowName = flowName;
        this.m_instanceName = instanceName;
        this.m_state = state;
        this.m_status = status;
        this.m_startTime = startTime;
        this.m_finishTime = finishTime;
        this.m_errorCode = errorCode;
        mLogger = logger;
    }

    public SASJFSFlowHistory(String flowName, com.sas.scheduler.model.FlowHistory schedulerHistory) {
        this.m_startTime = null;
        if (schedulerHistory.getStartTimeDataBinding() != null) {
            this.m_startTime = schedulerHistory.getStartTimeDataBinding().getTime();
        }
        this.m_finishTime = null;
        if (schedulerHistory.getFinishTimeDataBinding() != null) {
            this.m_finishTime = schedulerHistory.getFinishTimeDataBinding().getTime();
        }
        this.m_status = schedulerHistory.getStatus();
        this.m_state = schedulerHistory.getState();
        this.m_instanceName = schedulerHistory.getInstanceNameDataBinding();
        this.mFlowID = schedulerHistory.getFlowNameDataBinding();
        this.m_flowName = flowName;
        try {
            this.m_instanceID = Long.parseLong(schedulerHistory.getInstanceNameDataBinding());
        }
        catch (NumberFormatException e) {
            this.m_instanceID = -2L;
        }
        this.m_errorCode = schedulerHistory.getErrorCode();
    }

    protected void addHistory(SASJFSFlowHistory history) {
        this.mSubHistories.add(history);
    }

    public String getInvoker() {
        if (this.mInvoker == null) {
            this.mInvoker = "";
        }
        return this.mInvoker;
    }

    public String getOwner() {
        if (this.mOwner == null) {
            this.mOwner = "";
        }
        return this.mOwner;
    }

    public void setOwner(String owner) {
        this.mOwner = owner;
    }

    public String getFlowID() {
        if (this.mFlowID == null) {
            this.mFlowID = "";
        }
        return this.mFlowID;
    }

    public boolean isSuspended() {
        return this.mSuspended;
    }

    public void setSuspended(boolean mSuspended) {
        this.mSuspended = mSuspended;
    }

    public List<SASJFSFlowHistory> getSubHistories() {
        return this.mSubHistories;
    }

    public long getExitCode() {
        return this.mExitCode;
    }

    public void setExitCode(long exitCode) {
        this.mExitCode = exitCode;
    }

    protected int getFullSubItemCount() {
        int count = 0;
        for (SASJFSFlowHistory history : this.mSubHistories) {
            count += history.getFullSubItemCount() + 1;
        }
        return count;
    }

    protected static int getNumberOfLinesAssociatedWithFlow(String flowLine) {
        String numberString = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, Count_Tag);
        int count = Integer.parseInt(numberString);
        return count;
    }

    protected static String getFlowID(String flowLine) {
        String idString = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, FlowID_Tag);
        return idString;
    }

    protected static String getInstanceID(String flowLine) {
        String idString = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, InstanceID_Tag);
        return idString;
    }

    public static SASJFSFlowHistory getHistoryFromString(String data, Logger logger) {
        BufferedReader reader = new BufferedReader(new StringReader(data));
        SASJFSFlowHistory history = new SASJFSFlowHistory(logger);
        try {
            String flowLine = reader.readLine();
            history.createFromData(flowLine, reader);
            reader.close();
            return history;
        }
        catch (NullPointerException e) {
            mLogger.log(null, (Object)Level.WARNING, (Throwable)e);
            return null;
        }
        catch (IOException e) {
            mLogger.log(null, (Object)Level.WARNING, (Throwable)e);
            return null;
        }
    }

    public static List<SASJFSFlowHistory> getHistoriesOfFlow(BufferedReader reader, String flowID, int resultCount, Logger logger) {
        ArrayList<SASJFSFlowHistory> results = new ArrayList<SASJFSFlowHistory>();
        if (resultCount < 0) {
            return results;
        }
        try {
            String flowLine;
            while ((flowLine = reader.readLine()) != null) {
                String line;
                if (flowID == null || SASJFSFlowHistory.getFlowID(flowLine).equals(flowID)) {
                    SASJFSFlowHistory history = new SASJFSFlowHistory(logger);
                    try {
                        history.createFromData(flowLine, reader);
                    }
                    catch (RuntimeException e) {
                        mLogger.log(null, (Object)Level.WARNING, (Throwable)e);
                    }
                    results.add(history);
                    if (resultCount > 0 && results.size() >= resultCount) break;
                }
                while ((line = reader.readLine()) != null && !line.equals(TopLevelFlowTerminatorLine)) {
                }
            }
        }
        catch (IOException e) {
            mLogger.log(null, (Object)Level.WARNING, (Throwable)e);
        }
        return results;
    }

    protected void createFromData(String flowLine, BufferedReader reader) {
        this.m_instanceID = SASJFSFlowHistory.getLongParameterFromHistoryLine(flowLine, InstanceID_Tag);
        this.mFlowID = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, FlowID_Tag);
        this.mOwner = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, Owner_Tag);
        this.mInvoker = SASJFSFlowHistory.getStringParameterFromHistoryLine(flowLine, Invoker_Tag);
        this.mExitCode = SASJFSFlowHistory.getLongParameterFromHistoryLine(flowLine, ExitCode_Tag);
        this.mSuspended = SASJFSFlowHistory.getBooleanParameterFromHistoryLine(flowLine, Suspended_Tag);
    }

    static List<String> getInstanceIDs(BufferedReader reader) throws IOException {
        String data;
        ArrayList<String> results = new ArrayList<String>();
        while ((data = reader.readLine()) != null) {
            String instanceID = SASJFSFlowHistory.getInstanceID(data);
            if (instanceID.length() > 0) {
                results.add(instanceID);
            }
            SASJFSFlowHistory.skipHistoryInstance(reader, null);
        }
        return results;
    }

    static boolean skipHistoryInstance(BufferedReader reader, StringBuffer outputBuffer) throws IOException {
        String data;
        do {
            if ((data = reader.readLine()) == null) {
                return true;
            }
            if (outputBuffer == null) continue;
            outputBuffer.append(data);
            outputBuffer.append('\n');
        } while (!data.equals(TopLevelFlowTerminatorLine));
        return false;
    }

    public void setID(long id) {
        this.m_instanceID = id;
    }

    @Override
    public Date getStartTime() {
        if (this.m_instanceID <= 0L) {
            return null;
        }
        return this.m_startTime;
    }

    public void setStartTime(Date date) {
        this.m_startTime = date;
    }

    @Override
    public Date getFinishTime() {
        if (this.m_instanceID <= 0L) {
            return null;
        }
        return this.m_finishTime;
    }

    public void setFinishTime(Date date) {
        this.m_finishTime = date;
    }

    @Override
    public int getState() {
        if (this.m_instanceID <= 0L) {
            return -1;
        }
        return this.m_state;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    @Override
    public int getStatus() {
        if (this.getState() == -1) {
            return -1;
        }
        return this.m_status;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.m_instanceName = instanceName;
    }

    @Override
    public String getFlowName() {
        return this.m_flowName;
    }

    public void setFlowName(String flowName) {
        this.m_flowName = flowName;
    }

    @Override
    public String getSchedulerFlowName() {
        return this.m_schedulerFlowName;
    }

    public void setSchedulerFlowName(String schedulerFlowName) {
        this.m_schedulerFlowName = schedulerFlowName;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
    }

    public void initFromSerializedForm(String serializedForm) {
        this.m_instanceID = SASJFSFlowHistory.getLongParameterFromHistoryLine(serializedForm, InstanceID_Tag);
        this.mFlowID = SASJFSFlowHistory.getStringParameterFromHistoryLine(serializedForm, FlowID_Tag);
        this.mOwner = SASJFSFlowHistory.getStringParameterFromHistoryLine(serializedForm, Owner_Tag);
        this.mInvoker = SASJFSFlowHistory.getStringParameterFromHistoryLine(serializedForm, Invoker_Tag);
        this.mExitCode = SASJFSFlowHistory.getLongParameterFromHistoryLine(serializedForm, ExitCode_Tag);
        this.mSuspended = SASJFSFlowHistory.getBooleanParameterFromHistoryLine(serializedForm, Suspended_Tag);
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        return this.toSerializedForm(buffer).toString();
    }

    protected StringBuffer toSerializedForm(StringBuffer buffer) {
        buffer.append(Type_Tag);
        buffer.append("Flow");
        if (String.valueOf(this.m_flowName).length() > 0) {
            buffer.append(FlowName_Tag);
            buffer.append(String.valueOf(this.m_flowName));
        }
        if (String.valueOf(this.m_instanceID).length() > 0) {
            buffer.append(InstanceID_Tag);
            buffer.append(String.valueOf(this.m_instanceID));
        }
        if (this.getFlowID().length() > 0) {
            buffer.append(FlowID_Tag);
            buffer.append(this.getFlowID());
        }
        if (this.getOwner().length() > 0) {
            buffer.append(Owner_Tag);
            buffer.append(this.getOwner());
        }
        if (this.getInvoker().length() > 0) {
            buffer.append(Invoker_Tag);
            buffer.append(this.getInvoker());
        }
        if (this.getInvoker().length() > 0) {
            buffer.append(Suspended_Tag);
            buffer.append(this.getInvoker());
        }
        buffer.append(ExitCode_Tag);
        buffer.append(this.getErrorCode());
        return buffer;
    }

    public static boolean getBooleanParameterFromHistoryLine(String historyLine, String parmName) {
        boolean rc = false;
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return rc;
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        try {
            if (dataString.length() > 0) {
                rc = Boolean.parseBoolean(dataString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rc;
    }

    public static long getLongParameterFromHistoryLine(String historyLine, String parmName) {
        long rc = -1L;
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return rc;
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        try {
            if (dataString.length() > 0) {
                rc = Long.parseLong(dataString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rc;
    }

    public static String getStringParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    @Override
    public long getID() {
        return this.m_instanceID;
    }

    public static List<SASJFSFlowHistory> GetHistoriesOfFlow(BufferedReader reader, String flowID, int resultCount, ClientLogger logger) {
        ArrayList<SASJFSFlowHistory> results = new ArrayList<SASJFSFlowHistory>();
        if (resultCount < 0) {
            return results;
        }
        try {
            String flowLine;
            while ((flowLine = reader.readLine()) != null) {
                String line;
                if (flowID == null || SASJFSFlowHistory.getFlowID(flowLine).equals(flowID)) {
                    SASJFSFlowHistory history = new SASJFSFlowHistory(null);
                    try {
                        history.createFromData(flowLine, reader);
                    }
                    catch (RuntimeException e) {
                        logger.logMessage(Level.WARNING, e);
                    }
                    results.add(history);
                    if (resultCount > 0 && results.size() >= resultCount) break;
                }
                while ((line = reader.readLine()) != null) {
                }
            }
        }
        catch (IOException e) {
            logger.logMessage(Level.WARNING, e);
        }
        return results;
    }

    static {
        HistorySeparator = (char)124;
        Type_Tag = HistorySeparator + "Type=";
        Count_Tag = HistorySeparator + "Count=";
        InstanceID_Tag = HistorySeparator + "InstanceID=";
        FlowName_Tag = HistorySeparator + "FlowName=";
        FlowID_Tag = HistorySeparator + "FlowID=";
        Owner_Tag = HistorySeparator + "Owner=";
        ExitCode_Tag = HistorySeparator + "ExitCode=";
        Invoker_Tag = HistorySeparator + "Invoker=";
        Suspended_Tag = HistorySeparator + "Suspended=";
    }
}

