/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.os;

import com.sas.iom.SAS.IWorkspace;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.os.OSCalendar;
import com.sas.scheduler.api.servers.os.OSFlowHistory;
import com.sas.scheduler.api.servers.os.OSJob;
import com.sas.scheduler.api.servers.sasprocs.ProcScheduler;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OSScheduler
extends SchedulerIMPL
implements Scheduler {
    private static final ResourceBundle m_bundle;
    private static final Logger LOGGER;
    private OSCalendar m_cal;
    private IWorkspaceServer m_WorkspaceServer;
    private IWorkspace m_workspace;
    private static int m_maxHistory;
    private static int m_maxHistoryPerFlow;
    private static HashMap<String, String> m_cachedRemovedFlows;
    private static HashMap<String, FlowHistory> m_cachedHistory;
    private static long m_nextID;

    public OSScheduler(SchedulerServerInfo info) {
        super(info);
    }

    public void setMaximumsOnHistory(int allflows, int perflow) {
        m_maxHistory = allflows;
        m_maxHistoryPerFlow = perflow;
    }

    @Override
    public Calendar getCalendar(String schedulerCalenderName) {
        if (this.m_cal == null) {
            this.m_cal = new OSCalendar(schedulerCalenderName, null, null);
        }
        return this.m_cal;
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) {
        try {
            OSCalendar cal = new OSCalendar(info, this);
            cal.setDays(info);
            cal.setDescription(info.toXML());
            return cal;
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    @Override
    public Calendar createCalendar(IRecurrenceInfo info) {
        return this.getCalendar(info);
    }

    @Override
    public String getClassId() {
        return "b379c9c1-89e0-4e72-ba43-6a416899b5dd";
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        ProcScheduler sascode = null;
        boolean rc = false;
        try {
            String outdir = this.m_schedulingServer.getOutDir();
            try {
                flow.checkCircularDependencies();
            }
            catch (InvalidParameterException ex) {
                InvalidParameterException e = new InvalidParameterException(OSScheduler.createCircularDependencyMessage(null, ex.getMessage(), flow));
                throw e;
            }
            String triggerType = flow.getTriggerType();
            if (triggerType == null) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("OSScheduler.MustSetTrigger.txt"), OSScheduler.class, "OSScheduler.MustSetTrigger.txt", null);
                throw ex;
            }
            boolean now = false;
            if (triggerType.compareTo("RunNow") == 0) {
                now = true;
            } else if (triggerType.compareTo("TimeEvent") == 0) {
                triggerType = "Event";
            }
            sascode = new ProcScheduler(this, flow, now, outdir, this.m_workspace);
            if (sascode.processFlow()) {
                flow.setScheduleID(sascode.schedule(flow.getName(), triggerType));
                if (!now) {
                    flow.setFlowSubmitted(true, this.m_schedulingServer.getUsername());
                    flow.setScheduleDefinitionId(this.genFlowName(flow));
                }
                rc = true;
            } else {
                flow.setFlowSubmitted(false, null);
            }
        }
        catch (SchedulerException e) {
            flow.setFlowSubmitted(false, null);
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (InvalidParameterException e) {
            flow.setFlowSubmitted(false, null);
            throw e;
        }
        catch (Exception e) {
            flow.setFlowSubmitted(false, null);
            SchedulerException ex = new SchedulerException(m_bundle.getString("OSScheduler.ErrorProcessingFlow.txt"), OSScheduler.class, "OSScheduler.ErrorProcessingFlow.txt", null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getStackTrace().toString());
            } else if (this.isDebug()) {
                e.printStackTrace();
            }
            throw ex;
        }
        finally {
            if (sascode != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(sascode.getINFile());
                } else if (this.isDebug()) {
                    System.out.println(sascode.getINFile());
                }
                sascode.dispose();
            }
        }
        try {
            if (m_cachedRemovedFlows.containsKey(flow.getName())) {
                m_cachedRemovedFlows.remove(flow.getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        ProcScheduler sascode = null;
        try {
            String outdir = this.m_schedulingServer.getOutDir();
            try {
                flow.checkCircularDependencies();
            }
            catch (InvalidParameterException ex) {
                InvalidParameterException e = new InvalidParameterException(OSScheduler.createCircularDependencyMessage(null, ex.getMessage(), flow));
                throw e;
            }
            sascode = new ProcScheduler(this, flow, true, outdir, this.m_workspace);
            if (sascode.processFlow()) {
                flow.setScheduleID(sascode.schedule(flow.getName(), "RunNow"));
            } else {
                flow.setFlowSubmitted(false, null);
            }
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (Exception e) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("OSScheduler.ErrorProcessingFlow.txt"), OSScheduler.class, "OSScheduler.ErrorProcessingFlow.txt", null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getStackTrace().toString());
            } else if (this.isDebug()) {
                e.printStackTrace();
            }
            throw ex;
        }
        finally {
            if (sascode != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(sascode.getINFile());
                } else if (this.isDebug()) {
                    System.out.println(sascode.getINFile());
                }
                sascode.dispose();
            }
        }
        try {
            if (m_cachedRemovedFlows.containsKey(flow.getName())) {
                m_cachedRemovedFlows.remove(flow.getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws UnsupportedOperationException, SchedulerException {
        try {
            boolean rc = this.removeFlowFromScheduler(flow.getName(), flow.getScheduledUser());
            if (rc) {
                flow.setFlowSubmitted(false);
                flow.setScheduleDefinitionId("");
            } else if (triggerType != null && triggerType.equalsIgnoreCase("RunNow")) {
                return true;
            }
            return rc;
        }
        catch (SchedulerException ex) {
            return triggerType != null && triggerType.equalsIgnoreCase("RunNow");
        }
    }

    @Override
    public boolean removeFlow(String flowName) throws UnsupportedOperationException, SchedulerException {
        return this.removeFlowFromScheduler(flowName, this.m_schedulingServer.getUsername());
    }

    private boolean removeFlowFromScheduler(String flowName, String userid) throws UnsupportedOperationException, SchedulerException {
        try {
            String outdir = this.m_schedulingServer.getOutDir();
            ProcScheduler sascode = new ProcScheduler(userid, this, this.m_workspace, outdir);
            if (sascode.remove(flowName)) {
                m_cachedRemovedFlows.put(flowName, "yes");
                sascode.dispose();
                return true;
            }
            sascode.dispose();
            return false;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("OSScheduler.ErrorProcessingFlow.txt"), OSScheduler.class, "OSScheduler.ErrorProcessingFlow.txt", null);
            throw ex;
        }
    }

    @Override
    public boolean killFlowInstance(FlowHistory flowInstance) {
        return false;
    }

    @Override
    public long getFlowInstance(FlowInfo flow) throws SchedulerException {
        FlowHistory history = this.getFlowHistory(flow);
        long flowID = m_nextID++;
        m_cachedHistory.put(String.valueOf(flowID), history);
        return flowID;
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        return 3;
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) {
        String outdir = null;
        try {
            outdir = this.m_schedulingServer.getOutDir();
        }
        catch (RuntimeException ex) {
            outdir = "./";
        }
        OSFlowHistory flowHistory = null;
        ProcScheduler sascode = new ProcScheduler(this, flow, this.m_workspace, outdir);
        try {
            List<OSFlowHistory> list = sascode.getHistory(flow.toString(), 1);
            if (list.size() > 0) {
                flowHistory = list.get(0);
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        sascode.dispose();
        return flowHistory;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, int count) {
        if (count < 0) {
            return null;
        }
        String outdir = null;
        try {
            outdir = this.m_schedulingServer.getOutDir();
        }
        catch (RuntimeException ex) {
            outdir = "./";
        }
        ProcScheduler sascode = new ProcScheduler(this, this.m_workspace, outdir);
        List<FlowHistory> list = null;
        try {
            list = sascode.getUserHistory(userid, count);
        }
        catch (SchedulerException ex) {
            list = new ArrayList<OSFlowHistory>();
        }
        sascode.dispose();
        return list;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow, int count) {
        if (count < 0) {
            return null;
        }
        String outdir = null;
        try {
            outdir = this.m_schedulingServer.getOutDir();
        }
        catch (RuntimeException ex) {
            outdir = "./";
        }
        ProcScheduler sascode = new ProcScheduler(this, flow, this.m_workspace, outdir);
        List<FlowHistory> list = null;
        try {
            list = sascode.getHistory(flow.toString(), count);
        }
        catch (SchedulerException ex) {
            list = new ArrayList<OSFlowHistory>();
        }
        sascode.dispose();
        return list;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, List<FlowInfo> flowList, int count) {
        if (count < 0) {
            return null;
        }
        ArrayList<FlowHistory> flowInstances = new ArrayList<FlowHistory>();
        HashMap<String, FlowInfo> flowNames = new HashMap<String, FlowInfo>();
        for (FlowInfo flow : flowList) {
            String flowname = flow.toString();
            flowNames.put(flowname, flow);
        }
        List<FlowHistory> flows = this.getFlowHistoryList(userid, count * flowList.size() * 2);
        int numFlows = flows.size();
        int flowCount = 0;
        String lastFlowName = "";
        for (int x = 0; x < numFlows; ++x) {
            FlowHistory history = flows.get(x);
            String thisFlowName = history.getFlowName();
            if (!flowNames.containsKey(thisFlowName)) continue;
            if (lastFlowName.equals(thisFlowName)) {
                ++flowCount;
            } else {
                flowCount = 0;
                lastFlowName = thisFlowName;
            }
            if (flowCount > count) continue;
            flowInstances.add(history);
        }
        return flowInstances;
    }

    @Override
    public List<FlowHistory> getAllFlowHistory() throws SchedulerException {
        String outdir = this.m_schedulingServer.getOutDir();
        ProcScheduler sascode = new ProcScheduler(this, this.m_workspace, outdir);
        List<FlowHistory> list = sascode.getHistory("*", m_maxHistory);
        sascode.dispose();
        return list;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow) {
        String outdir = this.m_schedulingServer.getOutDir();
        ProcScheduler sascode = new ProcScheduler(this, flow, this.m_workspace, outdir);
        List<FlowHistory> list = null;
        try {
            list = sascode.getHistory(flow.toString(), m_maxHistoryPerFlow);
        }
        catch (SchedulerException ex) {
            list = new ArrayList<OSFlowHistory>();
        }
        sascode.dispose();
        return list;
    }

    @Override
    public Date getFinishTime(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getFinishTime() : null;
    }

    @Override
    public Date getStartTime(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getStartTime() : null;
    }

    @Override
    public int getState(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getState() : -1;
    }

    @Override
    public int getStatus(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getStatus() : -2;
    }

    @Override
    public boolean isFlowScheduled(String id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        return this.verifyFlowScheduled(flow);
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) {
        try {
            if (m_cachedRemovedFlows.containsKey(flow.getName())) {
                return false;
            }
            return flow.isFlowSubmitted();
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Override
    public boolean isValidFlowName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (!Character.isUnicodeIdentifierStart(firstChar) && firstChar != SUBCHAR) {
            return false;
        }
        for (int i = 1; i < namelen; ++i) {
            if (Character.isUnicodeIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidJobName(String name) {
        return OSJob.isValidName(name);
    }

    @Override
    public String getInvalidChars(boolean flow) {
        if (flow) {
            return "][:;)(#$/";
        }
        return OSJob.getInValidChars();
    }

    @Override
    public boolean closeConnection() {
        if (this.m_WorkspaceServer != null && this.m_WorkspaceServer.isConnected()) {
            this.m_WorkspaceServer.closeConnection();
        }
        this.m_workspace = null;
        this.m_connected = false;
        return true;
    }

    @Override
    public boolean doesRunNowLeaveDefinition() throws InvalidParameterException {
        return true;
    }

    @Override
    public String runNowName(String flowname) {
        return "RunNow_" + flowname;
    }

    @Override
    public boolean isHistorySupported() throws InvalidParameterException {
        if (this.m_schedulingServer == null) {
            throw new InvalidParameterException();
        }
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return major != 9 || minor != 1;
    }

    @Override
    public boolean isJobDependenciesEnabled() throws InvalidParameterException {
        if (this.m_schedulingServer == null) {
            throw new InvalidParameterException();
        }
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return major != 9 || minor != 1;
    }

    @Override
    public boolean isTimeDependenciesEnabled() {
        return false;
    }

    @Override
    public boolean isFileDependenciesEnabled() {
        return false;
    }

    @Override
    protected boolean __maketheconnection() throws SchedulerException {
        boolean connected = false;
        SchedulerException ex = null;
        InvalidParameterException ipe = null;
        try {
            String classID = this.getClassId();
            String host = this.m_schedulingServer.getHost();
            int port = Integer.parseInt(this.m_schedulingServer.getPort());
            if (this.m_WorkspaceServer != null && this.m_WorkspaceServer.isConnected()) {
                this.m_WorkspaceServer.closeConnection();
            }
            this.m_WorkspaceServer = new IWorkspaceServer(null, classID, host, port);
            if (this.m_WorkspaceServer.makeConnection(this.m_schedulingServer.getUsername(), this.getSchServerInfoPasswordSealedString())) {
                this.m_workspace = this.m_WorkspaceServer.getWorkspace();
                connected = true;
            } else {
                connected = false;
            }
        }
        catch (InvalidCredentialsException e) {
            this.m_schedulingServer.setUsername(null);
            this.m_schedulingServer.setPassword(null);
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("OSScheduler.LogonFailure.message.fmt"), this.getHost()), OSScheduler.class, "OSScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        catch (FatalConnectionFactoryException e) {
            this.m_schedulingServer.setUsername(null);
            this.m_schedulingServer.setPassword(null);
            ipe = new InvalidParameterException(MessageFormat.format(m_bundle.getString("OSScheduler.LaunchServer.message.fmt"), this.getHost(), e.getLocalizedMessage()));
        }
        if (ex != null) {
            throw ex;
        }
        if (ipe != null) {
            throw ipe;
        }
        return connected;
    }

    @Override
    public boolean checkVersion(SchedulerIMPL scheduler) throws SchedulerException {
        return false;
    }

    static {
        LOGGER = LogManager.getLogger(OSScheduler.class);
        String strClassName = OSScheduler.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        m_maxHistory = 9999;
        m_maxHistoryPerFlow = 25;
        m_cachedRemovedFlows = new HashMap();
        m_cachedHistory = new HashMap();
        m_nextID = 0L;
    }
}

