/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie.job;

import com.sas.scheduler.api.servers.oozie.generation.ACTION;
import com.sas.scheduler.api.servers.oozie.generation.ACTIONTRANSITION;
import com.sas.scheduler.api.servers.oozie.generation.CONFIGURATION;
import com.sas.scheduler.api.servers.oozie.generation.CREDENTIAL;
import com.sas.scheduler.api.servers.oozie.generation.END;
import com.sas.scheduler.api.servers.oozie.generation.FORK;
import com.sas.scheduler.api.servers.oozie.generation.FORKTRANSITION;
import com.sas.scheduler.api.servers.oozie.generation.JOIN;
import com.sas.scheduler.api.servers.oozie.generation.KILL;
import com.sas.scheduler.api.servers.oozie.generation.SHELL;
import com.sas.scheduler.api.servers.oozie.generation.START;
import com.sas.scheduler.api.servers.oozie.generation.SUBWORKFLOW;
import com.sas.scheduler.api.servers.oozie.generation.WORKFLOWAPP;
import com.sas.scheduler.api.servers.oozie.job.AbstractOozieJob;
import com.sas.scheduler.api.servers.oozie.job.JobDescriptor;
import com.sas.scheduler.api.servers.oozie.job.OozieAction;
import com.sas.scheduler.api.servers.oozie.job.OozieEnd;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.api.servers.oozie.job.OozieFork;
import com.sas.scheduler.api.servers.oozie.job.OozieJoin;
import com.sas.scheduler.api.servers.oozie.job.OozieKill;
import com.sas.scheduler.api.servers.oozie.job.OozieNode;
import com.sas.scheduler.api.servers.oozie.job.OozieStart;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class OozieWorkflowJob
extends AbstractOozieJob {
    private static final String HDFSPrefix = "hdfs://";
    private static final String MAPRPrefix = "maprfs://";
    private static final String ENDNAME = "end";
    private static final String KILLNAME = "kill";
    Set<Package> packages = new HashSet<Package>();
    WORKFLOWAPP oozieWorkflow = null;
    String flowxml = null;
    Exception exception = null;
    List<String> sourceFiles = new ArrayList<String>();
    Map<String, String> scripts = new HashMap<String, String>();
    int ident = 0;
    int forkJoinId = 1;
    String jobscript = "";
    Properties jobConfig = new Properties();
    Map<String, List<JobDescriptor>> fjMap;
    Map<String, JobDescriptor> mNodes;
    List<OozieNode> unmatchedForkJoins = new ArrayList<OozieNode>();
    OozieStart start = null;
    OozieEnd end = null;
    OozieKill kill = null;
    List<OozieNode> DAG = new ArrayList<OozieNode>();

    public OozieWorkflowJob(FlowInfo flow, SchedulerServerInfo server) {
        super(flow, server);
        this.fjMap = new HashMap<String, List<JobDescriptor>>();
        this.mNodes = new HashMap<String, JobDescriptor>();
        String config = server.getConfigPropertiesDataBinding();
        if (config != null && config != "") {
            String[] props;
            for (String nvpair : props = config.split(";")) {
                String[] nv = nvpair.trim().split("=");
                if (nv.length != 2) {
                    this.Debug(nvpair);
                    this.Debug("Invalid configuration property. Must be name value pairs such as \"name=value\"");
                    continue;
                }
                this.jobConfig.setProperty(nv[0].trim(), nv[1].trim());
            }
        }
        this.create();
        try {
            this.flowxml = this.getXml(this.m_oozieFactory.createWorkflowApp(this.oozieWorkflow), "   ", this.packages, true);
        }
        catch (JAXBException e) {
            this.flowxml = null;
            this.exception = e;
        }
    }

    public String getXML() {
        return this.flowxml;
    }

    public void runFlow() throws OozieException {
        this.uploadFlow();
        this.uploadScript();
        this.submitJob(this.getFlowConfigurationXML(), true);
        if (this.isDebug()) {
            AbstractOozieJob.HttpResponse resp = this.getJobLog();
            this.Debug(resp.body);
        }
    }

    protected void uploadFlow() throws OozieException {
        String path = this.getWebHDFSPathForWorkflow();
        String xml = this.getXML();
        try {
            this.Debug(xml);
            AbstractOozieJob.HttpResponse resp = this.hdfsCreate(path, xml, true);
            this.Debug(resp);
            if (resp.code != 201) {
                throw new OozieException(MessageFormat.format(m_bundle.getString("OozieWorkflowJob.Workflow.UploadFailed.fmt"), path, resp.code));
            }
        }
        catch (IOException e) {
            throw new OozieException(e);
        }
    }

    protected void uploadScript() throws OozieException {
        String path = this.getWebHDFSPathForShellScript();
        try {
            this.Debug(this.jobscript);
            AbstractOozieJob.HttpResponse resp = this.hdfsCreate(path, this.jobscript, "application/octet-stream", true);
            this.Debug(resp);
            if (resp.code != 201) {
                throw new OozieException(MessageFormat.format(m_bundle.getString("OozieWorkflowJob.Script.UploadFailed.fmt"), path, resp.code));
            }
        }
        catch (IOException e) {
            throw new OozieException(e);
        }
    }

    protected OozieJoin hasMatchingJoin(OozieFork fork) {
        OozieJoin join;
        OozieNode node = this.findCommonParent(fork);
        if (node instanceof OozieJoin && this.unmatchedForkJoins.contains((join = (OozieJoin)node).getFork()) && this.findCommonChild(join) == fork) {
            return join;
        }
        return null;
    }

    protected OozieFork hasMatchingFork(OozieJoin join) {
        OozieFork fork;
        OozieNode node = this.findCommonChild(join);
        if (node instanceof OozieFork && this.unmatchedForkJoins.contains((fork = (OozieFork)node).getJoin()) && this.findCommonParent(fork) == join) {
            return fork;
        }
        return null;
    }

    protected void processJob(JobDescriptor job) {
        JobDescriptor jj;
        Object j;
        OozieFork fork;
        int id;
        if (job.isProcessed()) {
            return;
        }
        job.setProcessed(true);
        this.DAG.add(job.myAction);
        if (job.isOkFork()) {
            id = this.forkJoinId++;
            fork = new OozieFork("FORK_" + id, "JOIN_" + id);
            fork.setFromOk(job.myAction);
            job.myAction.setOkTo(fork);
            for (DisplayInfo displayInfo : job.okSuccessors) {
                JobDescriptor j22 = this.mNodes.get(displayInfo.getName());
                fork.addTransition(j22.myAction);
                j22.myAction.setFromOk(fork);
            }
            j = this.hasMatchingJoin(fork);
            if (j != null) {
                --this.forkJoinId;
                fork = ((OozieJoin)j).getFork();
                this.unmatchedForkJoins.remove(fork);
                job.myAction.setOkTo(fork);
                fork.setFromOk(job.myAction);
                for (DisplayInfo d : job.okSuccessors) {
                    jj = this.mNodes.get(d.getName());
                    fork.addTransition(jj.myAction);
                    jj.myAction.setFromOk(fork);
                }
            } else {
                this.unmatchedForkJoins.add(fork.getJoin());
            }
            this.DAG.add(fork);
        } else if (!job.okSuccessors.isEmpty() && job.myAction.getOkTo() == null) {
            JobDescriptor j3 = this.mNodes.get(job.okSuccessors.get(0).getName());
            job.myAction.setOkTo(j3.myAction);
        }
        if (job.isFailFork()) {
            id = this.forkJoinId++;
            fork = new OozieFork("FORK_" + id, "JOIN_" + id);
            fork.setFromFail(job.myAction);
            job.myAction.setErrorTo(fork);
            for (DisplayInfo displayInfo : job.failSuccessors) {
                JobDescriptor j2 = this.mNodes.get(displayInfo.getName());
                fork.addTransition(j2.myAction);
                j2.myAction.setFromOk(fork);
            }
            j = this.hasMatchingJoin(fork);
            if (j != null) {
                --this.forkJoinId;
                fork = ((OozieJoin)j).getFork();
                this.unmatchedForkJoins.remove(fork);
                job.myAction.setErrorTo(fork);
                fork.setFromFail(job.myAction);
                for (DisplayInfo d : job.failSuccessors) {
                    jj = this.mNodes.get(d.getName());
                    fork.addTransition(jj.myAction);
                    jj.myAction.setFromOk(fork);
                }
            } else {
                this.unmatchedForkJoins.add(fork.getJoin());
            }
            this.DAG.add(fork);
        } else if (!job.failSuccessors.isEmpty() && job.myAction.getErrorTo() == null) {
            JobDescriptor j4 = this.mNodes.get(job.failSuccessors.get(0).getName());
            job.myAction.setErrorTo(j4.myAction);
        }
        if (job.isOkJoin()) {
            int id2 = this.forkJoinId++;
            OozieJoin join = new OozieJoin("JOIN_" + id2, "FORK_" + id2);
            join.setTo(job.myAction);
            job.myAction.setFromOk(join);
            for (JobDescriptor jobDescriptor : job.fromok) {
                jobDescriptor.myAction.setOkTo(join);
                join.joinFrom(jobDescriptor.myAction);
            }
            OozieFork f = this.hasMatchingFork(join);
            if (f != null) {
                --this.forkJoinId;
                join = f.getJoin();
                this.unmatchedForkJoins.remove(join);
                join.setTo(job.myAction);
                for (JobDescriptor j2 : job.fromok) {
                    j2.myAction.setOkTo(join);
                    join.joinFrom(j2.myAction);
                }
            } else {
                this.unmatchedForkJoins.add(join.getFork());
            }
            this.DAG.add(join);
        } else if (!job.fromok.isEmpty() && job.myAction.getFromOk() == null) {
            job.myAction.setFromOk(job.fromok.get((int)0).myAction);
        }
        if (!job.fromfail.isEmpty() && job.myAction.getFromFail() == null) {
            job.myAction.setFromFail(job.fromfail.get((int)0).myAction);
        }
        for (DisplayInfo d : job.okSuccessors) {
            j = this.mNodes.get(d.getName());
            if (((JobDescriptor)j).isProcessed()) continue;
            this.processJob((JobDescriptor)j);
        }
        for (DisplayInfo d : job.failSuccessors) {
            j = this.mNodes.get(d.getName());
            if (((JobDescriptor)j).isProcessed()) continue;
            this.processJob((JobDescriptor)j);
        }
    }

    protected void goToEnd(OozieTreeNode tnode, List<OozieTreeNode> path) {
        OozieNode node = tnode.node;
        if (node instanceof OozieAction) {
            OozieTreeNode tn;
            OozieAction a = (OozieAction)node;
            if (a.isEnd()) {
                path.add(new OozieTreeNode(this.end, node));
            }
            OozieNode ok = a.getOkTo();
            OozieNode fail = a.getErrorTo();
            if (ok != null) {
                tn = new OozieTreeNode(ok, node);
                path.add(tn);
                this.goToEnd(tn, path);
            }
            if (fail != null) {
                tn = new OozieTreeNode(fail, node);
                path.add(tn);
                this.goToEnd(tn, path);
            }
        } else if (node instanceof OozieJoin) {
            OozieJoin join = (OozieJoin)node;
            if (join.getTo() == null) {
                path.add(new OozieTreeNode(this.end, node));
                return;
            }
            OozieTreeNode tn = new OozieTreeNode(join.getTo(), node);
            path.add(tn);
            this.goToEnd(tn, path);
        } else if (node instanceof OozieFork) {
            OozieFork fork = (OozieFork)node;
            for (OozieNode n : fork.getPaths()) {
                OozieTreeNode tn = new OozieTreeNode(n, node);
                path.add(tn);
                this.goToEnd(tn, path);
            }
        }
    }

    protected void goToStart(OozieTreeNode tnode, List<OozieTreeNode> path) {
        OozieNode node = tnode.node;
        if (node instanceof OozieAction) {
            OozieTreeNode tn;
            OozieAction a = (OozieAction)node;
            if (a.isRoot()) {
                path.add(new OozieTreeNode(this.start, node));
                return;
            }
            OozieNode ok = a.getFromOk();
            OozieNode fail = a.getFromFail();
            if (ok != null) {
                tn = new OozieTreeNode(ok, node);
                path.add(tn);
                this.goToStart(tn, path);
            }
            if (fail != null) {
                tn = new OozieTreeNode(fail, node);
                path.add(tn);
                this.goToStart(tn, path);
            }
        } else if (node instanceof OozieJoin) {
            OozieJoin join = (OozieJoin)node;
            for (OozieNode n : join.getPaths()) {
                OozieTreeNode tn = new OozieTreeNode(n, node);
                path.add(tn);
                this.goToStart(tn, path);
            }
        } else if (node instanceof OozieFork) {
            OozieTreeNode tn;
            OozieFork fork = (OozieFork)node;
            OozieNode ok = fork.getFromOk();
            OozieNode fail = fork.getFromFail();
            if (ok == null && fail == null) {
                path.add(new OozieTreeNode(this.start, node));
                return;
            }
            if (ok != null) {
                tn = new OozieTreeNode(ok, node);
                path.add(tn);
                this.goToStart(tn, path);
            }
            if (fail != null) {
                tn = new OozieTreeNode(fail, node);
                path.add(tn);
                this.goToStart(tn, path);
            }
        }
    }

    protected OozieNode findCommonParent(OozieFork node) {
        return this.findCommonParentWithPaths(node, null);
    }

    protected OozieNode findCommonParentWithPaths(OozieFork node, List<OozieNode> cpaths) {
        OozieNode commonParent = null;
        ArrayList<ArrayList<OozieTreeNode>> paths = new ArrayList<ArrayList<OozieTreeNode>>();
        for (OozieNode n : node.getPaths()) {
            ArrayList<OozieTreeNode> parents = new ArrayList<OozieTreeNode>();
            OozieTreeNode tn = new OozieTreeNode(n, node);
            parents.add(tn);
            this.goToEnd(tn, parents);
            paths.add(parents);
        }
        List least = (List)paths.get(0);
        for (int i = 1; i < paths.size(); ++i) {
            List l = (List)paths.get(i);
            if (l.size() >= least.size()) continue;
            least = l;
        }
        paths.remove(least);
        for (OozieTreeNode n : least) {
            boolean match = true;
            for (List list : paths) {
                if (list.contains(n)) continue;
                match = false;
            }
            if (!match) continue;
            commonParent = n.node;
            if (cpaths == null) break;
            HashSet<OozieNode> set = new HashSet<OozieNode>();
            OozieTreeNode oozieTreeNode = n;
            while (least.contains(n)) {
                int idx = least.indexOf(n);
                OozieTreeNode oozieTreeNode2 = (OozieTreeNode)least.remove(idx);
                set.add(n.parent);
            }
            for (List list : paths) {
                while (list.contains(n)) {
                    int idx = list.indexOf(n);
                    n = (OozieTreeNode)list.remove(idx);
                    set.add(n.parent);
                }
            }
            cpaths.addAll(set);
            break;
        }
        return commonParent;
    }

    protected OozieNode findCommonParentWithPaths2(OozieFork node, List<OozieNode> cpaths) {
        OozieNode commonParent = null;
        ArrayList<ArrayList<OozieTreeNode>> paths = new ArrayList<ArrayList<OozieTreeNode>>();
        for (OozieNode n : node.getPaths()) {
            ArrayList<OozieTreeNode> parents = new ArrayList<OozieTreeNode>();
            OozieTreeNode tn = new OozieTreeNode(n, node);
            parents.add(tn);
            this.goToEnd(tn, parents);
            paths.add(parents);
        }
        List least = (List)paths.get(0);
        for (int i = 1; i < paths.size(); ++i) {
            List l = (List)paths.get(i);
            if (l.size() >= least.size()) continue;
            least = l;
        }
        paths.remove(least);
        for (OozieTreeNode n : least) {
            boolean match = true;
            for (List list : paths) {
                if (list.contains(n)) continue;
                match = false;
            }
            if (!match) continue;
            commonParent = n.node;
            if (cpaths == null) break;
            HashSet<OozieNode> set = new HashSet<OozieNode>();
            OozieTreeNode oozieTreeNode = n;
            OozieNode temp = oozieTreeNode.parent;
            while (temp != null) {
                set.add(temp);
                OozieTreeNode df = null;
                for (OozieTreeNode nn : least) {
                    if (!nn.equals(temp)) continue;
                    df = nn;
                }
                if (df != null) {
                    temp = df.parent;
                    continue;
                }
                temp = null;
            }
            for (List list : paths) {
                int idx = list.indexOf(oozieTreeNode);
                temp = ((OozieTreeNode)list.get((int)idx)).parent;
                while (temp != null) {
                    set.add(temp);
                    OozieTreeNode df = null;
                    for (OozieTreeNode nn : list) {
                        if (!nn.equals(temp)) continue;
                        df = nn;
                    }
                    if (df != null) {
                        temp = df.parent;
                        continue;
                    }
                    temp = null;
                }
            }
            cpaths.addAll(set);
            break;
        }
        return commonParent;
    }

    protected OozieNode gotToStartOrFork(OozieNode node, List<OozieTreeNode> outside) {
        if (node == null) {
            return this.start;
        }
        if (node instanceof OozieFork) {
            boolean isOutside = false;
            for (OozieTreeNode tn : outside) {
                if (tn.node != ((OozieFork)node).getJoin()) continue;
                isOutside = true;
                break;
            }
            if (!isOutside) {
                if (node.getFromOk() != null) {
                    return this.gotToStartOrFork(node.getFromOk(), outside);
                }
                if (node.getFromFail() != null) {
                    return this.gotToStartOrFork(node.getFromFail(), outside);
                }
                return this.start;
            }
            return node;
        }
        if (node instanceof OozieJoin) {
            Iterator<OozieNode> iterator = ((OozieJoin)node).getPaths().iterator();
            if (iterator.hasNext()) {
                OozieNode n = iterator.next();
                return this.gotToStartOrFork(n, outside);
            }
        } else {
            if (node.getFromOk() != null) {
                return this.gotToStartOrFork(node.getFromOk(), outside);
            }
            if (node.getFromFail() != null) {
                return this.gotToStartOrFork(node.getFromFail(), outside);
            }
            return this.start;
        }
        return null;
    }

    protected OozieNode findCommonChild(OozieJoin node) {
        return this.findCommonChildWithPaths(node, null);
    }

    protected OozieNode findCommonChildWithPaths(OozieJoin node, List<OozieNode> cpaths) {
        OozieNode commonChild = null;
        ArrayList<ArrayList<OozieTreeNode>> paths = new ArrayList<ArrayList<OozieTreeNode>>();
        for (OozieNode n : node.getPaths()) {
            ArrayList<OozieTreeNode> children = new ArrayList<OozieTreeNode>();
            OozieTreeNode tn = new OozieTreeNode(n, node);
            children.add(tn);
            this.goToStart(tn, children);
            paths.add(children);
        }
        List least = (List)paths.get(0);
        for (int i = 1; i < paths.size(); ++i) {
            List l = (List)paths.get(i);
            if (l.size() >= least.size()) continue;
            least = l;
        }
        paths.remove(least);
        for (OozieTreeNode n : least) {
            boolean match = true;
            for (List list : paths) {
                if (list.contains(n)) continue;
                match = false;
            }
            if (!match) continue;
            commonChild = n.node;
            if (cpaths == null) break;
            HashSet<OozieNode> set = new HashSet<OozieNode>();
            OozieTreeNode oozieTreeNode = n;
            while (least.contains(n)) {
                int idx = least.indexOf(n);
                OozieTreeNode oozieTreeNode2 = (OozieTreeNode)least.remove(idx);
                set.add(n.parent);
            }
            for (List list : paths) {
                while (list.contains(n)) {
                    int idx = list.indexOf(n);
                    n = (OozieTreeNode)list.remove(idx);
                    set.add(n.parent);
                }
            }
            cpaths.addAll(set);
            break;
        }
        return commonChild;
    }

    public void insertJoin(OozieJoin join, OozieNode parent, List<OozieNode> children) {
        for (OozieNode child : children) {
            join.joinFrom(child);
            if (child instanceof OozieAction) {
                OozieAction action = (OozieAction)child;
                if (action.isEnd()) {
                    action.setOkTo(join);
                } else {
                    if (parent == action.getErrorTo()) {
                        action.setErrorTo(join);
                    }
                    if (parent == action.getOkTo()) {
                        action.setOkTo(join);
                    }
                }
            } else if (child instanceof OozieJoin) {
                ((OozieJoin)child).setTo(join);
            } else if (child instanceof OozieFork) {
                OozieFork f = (OozieFork)child;
                f.getPaths().remove(parent);
                f.getPaths().add(join);
            }
            if (!(parent instanceof OozieJoin)) continue;
            ((OozieJoin)parent).getPaths().remove(child);
        }
    }

    public boolean isInBetween(OozieNode node, OozieFork fork, OozieJoin join) {
        boolean ret = false;
        ArrayList<OozieNode> cpaths = new ArrayList<OozieNode>();
        this.findCommonParentWithPaths(fork, cpaths);
        if (cpaths.contains(node)) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected void create() {
        OozieTreeNode jointn;
        Object outside;
        void var6_13;
        this.oozieWorkflow = this.m_oozieFactory.createWORKFLOWAPP();
        this.oozieWorkflow.setName(this.flow.getName());
        this.oozieWorkflow.setStart(this.m_oozieFactory.createSTART());
        this.oozieWorkflow.setEnd(this.m_oozieFactory.createEND());
        this.oozieWorkflow.getEnd().setName(ENDNAME);
        this.oozieWorkflow.setCredentials(this.m_oozieFactory.createCREDENTIALS());
        CREDENTIAL credential = this.m_oozieFactory.createCREDENTIAL();
        this.oozieWorkflow.getCredentials().getCredential().add(credential);
        credential.setName(this.user);
        credential.setType("hcat");
        List jobs = this.flow.getJobs();
        int count = jobs.size();
        JobDescriptor[] nodes = new JobDescriptor[count];
        this.start = new OozieStart();
        this.end = new OozieEnd(ENDNAME);
        this.kill = new OozieKill(KILLNAME);
        this.kill.setMessage(m_bundle.getString("OozieWorkflowJob.KillMsg.txt"));
        for (int i = 0; i < count; ++i) {
            Object j;
            DisplayInfo displayInfo = (DisplayInfo)jobs.get(i);
            if (!(displayInfo instanceof JobInfo) || (j = (JobInfo)displayInfo).isSubflow()) continue;
            JobDescriptor n = new JobDescriptor((JobInfo)j, this.flow);
            n.setDependencies((DisplayInfo)this.flow.getEvent(j.getId()));
            nodes[i] = n;
            this.mNodes.put(n.name, n);
        }
        for (JobDescriptor jobDescriptor : this.mNodes.values()) {
            for (DisplayInfo d : jobDescriptor.okSuccessors) {
                this.mNodes.get(d.getName()).addFromOk(jobDescriptor);
                this.mNodes.get(d.getName()).addPrecursor(jobDescriptor);
            }
            for (DisplayInfo d : jobDescriptor.failSuccessors) {
                this.mNodes.get(d.getName()).addFromFail(jobDescriptor);
                this.mNodes.get(d.getName()).addPrecursor(jobDescriptor);
            }
        }
        ArrayList<JobDescriptor> baseNodes = new ArrayList<JobDescriptor>();
        for (JobDescriptor node : nodes) {
            if (node.hasDependencies()) continue;
            baseNodes.add(node);
        }
        for (JobDescriptor j : baseNodes) {
            if (j.isProcessed()) continue;
            this.processJob(j);
        }
        int n = this.unmatchedForkJoins.size() - 1;
        while (var6_13 >= 0) {
            OozieFork f;
            ArrayList<OozieNode> paths;
            OozieNode n2 = this.unmatchedForkJoins.get((int)var6_13);
            if (n2 instanceof OozieJoin) {
                OozieJoin join = (OozieJoin)n2;
                OozieFork fork = join.getFork();
                this.DAG.add(join);
                paths = new ArrayList<OozieNode>();
                OozieNode node = this.findCommonParentWithPaths(fork, paths);
                join.setTo(node);
                for (OozieNode child : paths) {
                    join.joinFrom(child);
                    if (child instanceof OozieAction) {
                        OozieAction action = (OozieAction)child;
                        if (action.isEnd()) {
                            action.setOkTo(join);
                        } else {
                            if (node == action.getErrorTo()) {
                                action.setErrorTo(join);
                            }
                            if (node == action.getOkTo()) {
                                action.setOkTo(join);
                            }
                        }
                    } else if (child instanceof OozieJoin) {
                        ((OozieJoin)child).setTo(join);
                    } else if (child instanceof OozieFork) {
                        f = (OozieFork)child;
                        f.getPaths().remove(node);
                        f.getPaths().add(join);
                    }
                    if (!(node instanceof OozieJoin)) continue;
                    ((OozieJoin)node).getPaths().remove(child);
                }
                if (node instanceof OozieJoin) {
                    ((OozieJoin)node).joinFrom(join);
                }
            } else if (n2 instanceof OozieFork) {
                OozieFork fork = (OozieFork)n2;
                OozieJoin join = fork.getJoin();
                this.DAG.add(fork);
                paths = new ArrayList();
                OozieNode child = this.findCommonChildWithPaths(join, paths);
                if (child != this.start) {
                    fork.setFromOk(child);
                }
                for (OozieNode parent : paths) {
                    fork.addTransition(parent);
                    if (child instanceof OozieFork) {
                        f = (OozieFork)child;
                        f.getPaths().remove(parent);
                        f.addTransition(fork);
                    }
                    if (parent instanceof OozieAction || parent instanceof OozieFork) {
                        if (parent.getFromFail() == null && parent.getFromOk() == null) {
                            parent.setFromOk(fork);
                        }
                        if (child == parent.getFromFail()) {
                            parent.setFromFail(fork);
                        }
                        if (child != parent.getFromOk()) continue;
                        parent.setFromOk(fork);
                        continue;
                    }
                    if (!(parent instanceof OozieJoin)) continue;
                    OozieJoin j = (OozieJoin)parent;
                    j.getPaths().remove(child);
                    j.joinFrom(fork);
                }
            }
            --var6_13;
        }
        for (OozieNode n3 : this.DAG) {
            if (!(n3 instanceof OozieJoin)) continue;
            OozieJoin joinA = (OozieJoin)n3;
            outside = new ArrayList<OozieTreeNode>();
            jointn = new OozieTreeNode(joinA.getTo(), joinA);
            outside.add(jointn);
            this.goToEnd(jointn, (List<OozieTreeNode>)outside);
            ArrayList<OozieNode> children = new ArrayList<OozieNode>();
            for (OozieNode node : joinA.getPaths()) {
                OozieNode c = this.gotToStartOrFork(node, (List<OozieTreeNode>)outside);
                if (children.contains(c)) continue;
                children.add(c);
            }
            if (children.size() <= 1) continue;
            int num = children.size() - 1;
            if (children.contains(this.start)) {
                children.remove(this.start);
            }
            for (int i = 0; i < num; ++i) {
                OozieFork st = (OozieFork)children.get(i);
                OozieJoin joinB = st.getJoin();
                ArrayList<OozieNode> cpaths = new ArrayList<OozieNode>();
                this.findCommonParentWithPaths2(st, cpaths);
                Iterator iterator = outside.iterator();
                while (iterator.hasNext()) {
                    OozieTreeNode r = (OozieTreeNode)iterator.next();
                    cpaths.remove(r.node);
                }
                ArrayList<OozieNode> removeMe = new ArrayList<OozieNode>();
                for (OozieNode ch : joinB.getPaths()) {
                    if (cpaths.contains(ch)) continue;
                    OozieNode otherNode = ch;
                    OozieNode otherEnd = joinB.getTo();
                    if (otherEnd != null && otherEnd == this.end) {
                        otherEnd = null;
                    }
                    if (otherNode instanceof OozieAction) {
                        ((OozieAction)otherNode).setOkTo(otherEnd);
                    } else if (otherNode instanceof OozieJoin) {
                        ((OozieJoin)otherNode).setTo(otherEnd);
                    }
                    removeMe.add(otherNode);
                    if (otherEnd == null) continue;
                    if (otherEnd instanceof OozieFork || otherEnd instanceof OozieAction) {
                        otherEnd.setFromOk(otherNode);
                        continue;
                    }
                    if (!(otherEnd instanceof OozieJoin)) continue;
                    ((OozieJoin)otherEnd).getPaths().remove(joinB);
                    ((OozieJoin)otherEnd).getPaths().add(otherNode);
                }
                joinB.getPaths().removeAll(removeMe);
                removeMe.clear();
                for (OozieNode path : joinA.getPaths()) {
                    if (!cpaths.contains(path)) continue;
                    removeMe.add(path);
                    joinB.joinFrom(path);
                    if (path instanceof OozieAction) {
                        if (((OozieAction)path).getOkTo() == joinA) {
                            ((OozieAction)path).setOkTo(joinB);
                        }
                        if (((OozieAction)path).getErrorTo() != joinA) continue;
                        ((OozieAction)path).setErrorTo(joinB);
                        continue;
                    }
                    if (path instanceof OozieJoin) {
                        ((OozieJoin)path).setTo(joinB);
                        continue;
                    }
                    if (!(path instanceof OozieFork)) continue;
                    ((OozieFork)path).getPaths().remove(joinA);
                    ((OozieFork)path).getPaths().add(joinB);
                }
                joinA.getPaths().removeAll(removeMe);
                joinB.setTo(joinA);
                joinA.joinFrom(joinB);
            }
        }
        ArrayList<OozieNode> arrayList = new ArrayList<OozieNode>();
        for (OozieNode n4 : this.DAG) {
            if (!(n4 instanceof OozieAction) || !((OozieAction)n4).isEnd()) continue;
            arrayList.add(n4);
        }
        for (OozieNode n5 : arrayList) {
            outside = new ArrayList();
            jointn = new OozieTreeNode(n5, null);
            outside.add((OozieTreeNode)jointn);
            this.goToEnd(jointn, (List<OozieTreeNode>)outside);
            OozieNode c = this.gotToStartOrFork(n5, (List<OozieTreeNode>)outside);
            if (c == null || c == this.start) continue;
            OozieFork f = (OozieFork)c;
            ((OozieAction)n5).setOkTo(f.getJoin());
        }
        ArrayList<OozieNode> arrayList2 = new ArrayList<OozieNode>();
        for (OozieNode n6 : this.DAG) {
            if (!(n6 instanceof OozieAction) && !(n6 instanceof OozieFork) || n6.getFromFail() != null || n6.getFromOk() != null) continue;
            arrayList2.add(n6);
        }
        if (arrayList2.size() > 1) {
            OozieFork fork = new OozieFork("FORK_0", "JOIN_0");
            OozieJoin join = fork.getJoin();
            for (OozieNode n7 : arrayList2) {
                fork.addTransition(n7);
                n7.setFromOk(fork);
            }
            this.start.setTo(fork);
            ArrayList<OozieNode> children2 = new ArrayList<OozieNode>();
            OozieNode parent = this.findCommonParentWithPaths(fork, children2);
            this.insertJoin(join, parent, children2);
            this.DAG.add(fork);
            this.DAG.add(join);
        } else {
            this.start.setTo((OozieNode)arrayList2.get(0));
        }
        START oozieStart = this.m_oozieFactory.createSTART();
        oozieStart.setTo(this.start.getTo().getName());
        this.oozieWorkflow.setStart(oozieStart);
        KILL oozieKill = this.m_oozieFactory.createKILL();
        oozieKill.setMessage(this.kill.getMessage());
        oozieKill.setName(this.kill.getName());
        this.oozieWorkflow.getDecisionOrForkOrJoin().add(oozieKill);
        END oozieEnd = this.m_oozieFactory.createEND();
        oozieEnd.setName(this.end.getName());
        this.oozieWorkflow.setEnd(oozieEnd);
        for (OozieNode n8 : this.DAG) {
            if (n8 instanceof OozieFork) {
                FORK fork = this.m_oozieFactory.createFORK();
                fork.setName(n8.getName());
                for (OozieNode t : ((OozieFork)n8).getPaths()) {
                    FORKTRANSITION trans = this.m_oozieFactory.createFORKTRANSITION();
                    trans.setStart(t.getName());
                    fork.getPath().add(trans);
                }
                this.oozieWorkflow.getDecisionOrForkOrJoin().add(fork);
                continue;
            }
            if (n8 instanceof OozieJoin) {
                JOIN join = this.m_oozieFactory.createJOIN();
                OozieJoin j = (OozieJoin)n8;
                if (((OozieJoin)n8).getTo() == null) {
                    join.setTo(this.end.getName());
                } else {
                    join.setTo(j.getTo().getName());
                }
                join.setName(n8.getName());
                this.oozieWorkflow.getDecisionOrForkOrJoin().add(join);
                continue;
            }
            if (!(n8 instanceof OozieAction)) continue;
            OozieAction action = (OozieAction)n8;
            ACTION oozieAction = this.m_oozieFactory.createACTION();
            ACTIONTRANSITION onok = this.m_oozieFactory.createACTIONTRANSITION();
            ACTIONTRANSITION onerr = this.m_oozieFactory.createACTIONTRANSITION();
            if (action.getOkTo() == null) {
                onok.setTo(ENDNAME);
            } else {
                onok.setTo(action.getOkTo().getName());
            }
            if (action.getErrorTo() == null) {
                onerr.setTo(KILLNAME);
            } else {
                onerr.setTo(action.getErrorTo().getName());
            }
            oozieAction.setOk(onok);
            oozieAction.setError(onerr);
            this.oozieWorkflow.getDecisionOrForkOrJoin().add(oozieAction);
            JobDescriptor job = this.mNodes.get(action.getName());
            this.buildCommandline(oozieAction, job, this.flow);
            if (job.packages == null) continue;
            this.packages.addAll(job.packages);
        }
        this.buildJobScript();
        JAXBElement<WORKFLOWAPP> workflowApp = this.m_oozieFactory.createWorkflowApp(this.oozieWorkflow);
        this.packages.add(WORKFLOWAPP.class.getPackage());
    }

    private void buildJobScript() {
        StringBuilder s = new StringBuilder();
        s.append("#!/bin/sh\n");
        s.append("dir=`pwd`\n");
        for (Map.Entry<String, String> entry : this.scripts.entrySet()) {
            s.append(entry.getKey());
            s.append("()\n{\n");
            s.append(entry.getValue());
            s.append("return $status\n");
            s.append("\n}\n");
        }
        s.append("while test $# -gt 0; do\n");
        s.append(" case \"${1}\" in\n");
        for (Map.Entry<String, String> entry : this.scripts.entrySet()) {
            s.append(entry.getKey());
            s.append(")\n");
            s.append("   " + entry.getKey());
            s.append("\n;;\n");
        }
        s.append("esac\n");
        s.append("shift\n");
        s.append("done\n");
        s.append("\n\n");
        this.jobscript = s.toString();
        this.Debug(this.jobscript);
    }

    private String buildSubJobScript(String command, String[] args, String input) {
        String script = "";
        String hdfslogloc = "";
        StringBuilder s = new StringBuilder();
        s.append("executable=\"");
        s.append(command);
        s.append("\"\n");
        boolean hdfslog = false;
        boolean hdfsfile = false;
        String argstring = "";
        boolean logarg = false;
        for (String arg : args) {
            if (arg.trim().equals("")) continue;
            arg = arg.replace("\"", "\\\"");
            if (logarg) {
                logarg = false;
                if (arg.toLowerCase().startsWith(HDFSPrefix) || arg.toLowerCase().startsWith(MAPRPrefix)) {
                    hdfslog = true;
                    hdfslogloc = arg.substring(arg.indexOf("://") + 2, arg.lastIndexOf("/"));
                    s.append("mkdir log\n");
                    String name = arg.substring(arg.lastIndexOf("/") + 1);
                    s.append("logfile=\"$dir/log/");
                    s.append(name);
                    s.append("\"\n");
                    argstring = argstring + "$logfile ";
                    continue;
                }
                argstring = argstring + arg + " ";
                continue;
            }
            if (arg.equals("-log")) {
                logarg = true;
                argstring = argstring + arg + " ";
                continue;
            }
            argstring = arg.equals(input) ? argstring + "$infile " : argstring + arg + " ";
        }
        s.append("infile=\"");
        if (input.toLowerCase().startsWith(HDFSPrefix) || input.toLowerCase().startsWith(MAPRPrefix)) {
            String name = input.substring(input.lastIndexOf("/") + 1);
            s.append("$dir/");
            s.append(name);
            s.append("\"\n");
        } else {
            s.append(input);
            s.append("\"\n");
        }
        s.append("args=\"");
        s.append(argstring);
        s.append("\"\n\n");
        s.append("cmd=\"$executable $args\"\n");
        s.append("$cmd\n\n");
        s.append("status=$?\n\n");
        s.append("if [ \"$(ls -A log)\" ]; then\n");
        s.append("  hdfs dfs -put -f log/* ");
        s.append(hdfslogloc);
        s.append("\n");
        s.append("fi\n");
        s.append("exit $status\n");
        script = s.toString();
        this.Debug(script);
        return script;
    }

    private void buildCommandline(ACTION action, JobDescriptor node, FlowInfo flow) {
        action.setName(node.name);
        switch (node.type) {
            case SHELL: {
                SHELL sh = this.m_oozieFactory.createSHELL();
                String cmdline = node.info.getCommandLine();
                String command = cmdline.split(" ")[0];
                String parms = cmdline.substring(command.length());
                String[] args = parms.split(" ");
                String input = node.info.getSourceDir().getPath();
                if (!input.endsWith("/")) {
                    input = input + "/";
                }
                input = input + node.sourceFile;
                String script = this.buildSubJobScript(command, args, input);
                String scriptname = node.name + "_" + this.ident++;
                this.scripts.put(scriptname, script);
                sh.setExec(this.getScriptFileName());
                sh.getArgument().add(scriptname);
                sh.getFile().add(this.getScriptFileName());
                if (input.toLowerCase().startsWith(HDFSPrefix)) {
                    sh.getFile().add(input.substring(HDFSPrefix.length() - 1));
                } else if (input.toLowerCase().startsWith(MAPRPrefix)) {
                    sh.getFile().add(input.substring(MAPRPrefix.length() - 1));
                }
                if (!this.jobConfig.isEmpty()) {
                    CONFIGURATION configuration = this.m_oozieFactory.createCONFIGURATION();
                    for (String key : this.jobConfig.stringPropertyNames()) {
                        String value = this.jobConfig.getProperty(key);
                        CONFIGURATION.Property prop = this.m_oozieFactory.createCONFIGURATIONProperty();
                        prop.setName(key);
                        prop.setValue(value);
                        configuration.getProperty().add(prop);
                    }
                    sh.setConfiguration(configuration);
                }
                sh.setJobTracker(this.jobTracker);
                sh.setNameNode(this.defaultFS);
                List<String> jobXml = sh.getJobXml();
                String jobEnv = node.info.getSchedulerResources();
                String envVars = flow.getJobDefaultEnvironmentVariables();
                String[] vars = null;
                if (jobEnv != null && jobEnv.length() > 0) {
                    vars = jobEnv.split(";");
                } else if (envVars != null && envVars.length() > 0) {
                    vars = envVars.split(";");
                }
                if (vars != null) {
                    for (int i = 0; i < vars.length; ++i) {
                        if (vars[i].isEmpty()) continue;
                        sh.getEnvVar().add(vars[i]);
                    }
                }
                action.setShell(sh);
                break;
            }
            case SUB_WORKFLOW: {
                SUBWORKFLOW subworkflow = this.m_oozieFactory.createSUBWORKFLOW();
                action.setSubWorkflow(subworkflow);
                break;
            }
            case OTHER: {
                Object other = null;
                action.setOther(other);
                break;
            }
        }
    }

    private class OozieTreeNode {
        OozieNode node = null;
        OozieNode parent = null;

        public OozieTreeNode(OozieNode node, OozieNode parent) {
            this.node = node;
            this.parent = parent;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof OozieTreeNode) {
                return this.node.equals(((OozieTreeNode)obj).node);
            }
            if (obj instanceof OozieNode) {
                return this.node.equals(obj);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

