/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie.job;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.oozie.generation.ObjectFactory;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractOozieJob {
    protected static final ResourceBundle m_bundle;
    protected FlowInfo flow;
    protected SchedulerServerInfo server;
    protected String oozieServer = null;
    protected String nameNode = null;
    protected String jobTracker = null;
    protected String defaultFS = null;
    protected String workflowPath = null;
    protected String coordPath = null;
    protected String user = null;
    protected String username = null;
    protected String flowName = null;
    protected ObjectFactory m_oozieFactory = new ObjectFactory();
    protected String jobid = null;

    public AbstractOozieJob(FlowInfo flow, SchedulerServerInfo server) {
        this.flow = flow;
        this.server = server;
        this.oozieServer = server.getRestAPIPath();
        this.nameNode = server.getWebNameNode();
        this.jobTracker = server.getJobTracker();
        this.defaultFS = server.getNameNode();
        this.workflowPath = server.getWorkflowPath();
        this.coordPath = server.getCoordinatorPath();
        if (flow != null) {
            this.flowName = flow.getName();
        }
        this.user = server.getUsername();
        if (this.user == null) {
            this.user = "";
            this.username = "";
        } else {
            if (this.user.contains("\\")) {
                this.username = this.user.substring(this.user.indexOf(92) + 1);
            } else if (this.user.contains("&5C")) {
                this.username = this.user.substring(this.user.indexOf("&5C") + 3);
            }
            this.username = this.user.contains("@") ? this.user.substring(0, this.user.indexOf(64)) : (this.user.contains("&40") ? this.user.substring(0, this.user.indexOf("&40")) : this.user);
        }
    }

    protected <T> String getXml(JAXBElement<T> element, String indent, Set<Package> packages, boolean stripNamespaces) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        StringWriter packs = new StringWriter();
        String sep = "";
        for (Package package1 : packages) {
            packs.append(sep).append(package1.getName());
            sep = ":";
        }
        String packageNames = packs.toString();
        Marshaller marshaller = JAXBContext.newInstance((String)packageNames).createMarshaller();
        marshaller.setProperty("com.sun.xml.bind.indentString", (Object)indent);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal(element, (Writer)stringWriter);
        String xml = stringWriter.toString();
        if (stripNamespaces) {
            Pattern p = Pattern.compile("xmlns:(ns[\\d])+=\"[^\"]+\"[\\s]*");
            Matcher m = p.matcher(xml);
            boolean found = m.find();
            while (found) {
                int start = m.start();
                int end = m.end();
                String what = xml.substring(start, end);
                int equals = what.indexOf("=");
                String num = what.substring(8, equals);
                xml = m.replaceFirst("");
                xml = xml.replaceAll("<ns" + num + ":", "<");
                xml = xml.replaceAll("</ns" + num + ":", "</");
                m = p.matcher(xml);
                found = m.find();
            }
        }
        return xml;
    }

    public boolean isDebug() {
        return MetaUtilities.isDebug();
    }

    protected HttpResponse hdfsCreate(String path, String data, boolean overwrite) throws IOException {
        return this.hdfsCreate(path, data, "application/octet-stream", overwrite);
    }

    public String getFlowFileName() {
        return this.username + "_w_" + this.flowName + ".xml";
    }

    public String getCoordinatorFileName() {
        return this.username + "_c_" + this.flowName + ".xml";
    }

    public String getScriptFileName() {
        return this.username + "_w_" + this.flowName + ".sh";
    }

    public String getHDFSPathForCoordinator() {
        return this.defaultFS + this.coordPath + "/" + this.getCoordinatorFileName();
    }

    public String getHDFSPathForWorkflow() {
        return this.defaultFS + this.workflowPath + "/" + this.getFlowFileName();
    }

    public String getWEBHdfsPathForCoordinator() {
        return this.nameNode + "/webhdfs/v1" + this.coordPath + "/" + this.getCoordinatorFileName();
    }

    public String getWebHDFSPathForWorkflow() {
        String path = this.nameNode + "/webhdfs/v1";
        path = path + this.workflowPath;
        path = path + "/";
        path = path + this.getFlowFileName();
        return path;
    }

    public String getWebHDFSPathForShellScript() {
        String path = this.nameNode + "/webhdfs/v1";
        path = path + this.workflowPath;
        path = path + "/";
        path = path + this.getScriptFileName();
        return path;
    }

    protected String getFlowConfigurationXML() {
        String flow = this.defaultFS + this.workflowPath + "/" + this.getFlowFileName();
        Configuration c = new Configuration();
        c.addProperty("oozie.wf.application.path", flow);
        c.addProperty("user.name", this.username);
        c.addProperty("oozie.use.system.libpath", "true");
        return c.getXML();
    }

    protected String getCoordinatorConfigurationXML() {
        Configuration c = new Configuration();
        c.addProperty("oozie.coord.application.path", this.getHDFSPathForCoordinator());
        c.addProperty("user.name", this.username);
        c.addProperty("oozie.use.system.libpath", "true");
        return c.getXML();
    }

    protected void submitJob(String configuration, boolean start) throws OozieException {
        String oozieUrl = this.oozieServer + "/oozie/v2/jobs";
        if (start) {
            oozieUrl = oozieUrl + "?action=start";
        }
        try {
            this.Debug(configuration);
            HttpResponse resp = this.doPost(oozieUrl, configuration, "application/xml");
            this.Debug(resp);
            if (resp.code != 201) {
                List<String> header;
                String message = "";
                if (resp.headers != null && (header = resp.headers.get("oozie-error-message")) != null && !header.isEmpty()) {
                    message = header.toString();
                }
                throw new OozieException(MessageFormat.format(m_bundle.getString("AbstractOozieJob.JobSubmissionFailed.fmt"), message));
            }
            try {
                JSONObject json = new JSONObject(resp.body);
                this.jobid = json.getString("id");
                this.Debug("Job created: id = " + this.jobid);
                this.flow.setScheduleDefinitionId(this.jobid);
            }
            catch (JSONException e) {
                this.Debug(e.getStackTrace().toString());
            }
        }
        catch (IOException e) {
            this.Debug(e.getStackTrace().toString());
            throw new OozieException(MessageFormat.format(m_bundle.getString("AbstractOozieJob.JobSubmissionFailed.fmt"), e.getLocalizedMessage()), e);
        }
    }

    protected HttpResponse getJobStatus() throws OozieException {
        String oozieUrl = this.oozieServer + "/oozie/v2/job/" + this.jobid;
        HttpResponse resp = null;
        try {
            resp = this.doGet(oozieUrl);
        }
        catch (IOException e) {
            throw new OozieException(MessageFormat.format(m_bundle.getString("AbstractOozieJob.FailedToGetJob.fmt"), this.jobid), e);
        }
        return resp;
    }

    protected HttpResponse getJobLog() throws OozieException {
        String oozieUrl = this.oozieServer + "/oozie/v2/job/" + this.jobid + "?show=log";
        HttpResponse resp = null;
        try {
            resp = this.doGet(oozieUrl);
        }
        catch (IOException e) {
            throw new OozieException(e);
        }
        return resp;
    }

    protected HttpResponse doPost(String path, String data, String contentType) throws IOException {
        HttpResponse resp = null;
        URL url = new URL(path);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (contentType != null && contentType != "") {
            conn.setRequestProperty("Content-Type", contentType);
        }
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
        out.write(data);
        out.close();
        resp = new HttpResponse(conn);
        return resp;
    }

    protected HttpResponse doGet(String path) throws IOException {
        HttpResponse resp = null;
        URL url = new URL(path);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.connect();
        resp = new HttpResponse(conn);
        return resp;
    }

    protected HttpResponse hdfsCreate(String path, String data, String contentType, boolean overwrite) throws IOException {
        HttpResponse resp = null;
        String fullUrl = path + "?op=CREATE";
        if (this.username != null && this.username != "") {
            fullUrl = fullUrl + "&user.name=" + this.username;
        }
        if (overwrite) {
            fullUrl = fullUrl + "&overwrite=true";
        }
        URL url = new URL(fullUrl);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", contentType);
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
        out.write(data);
        out.close();
        resp = new HttpResponse(conn);
        return resp;
    }

    protected void Debug(String data) {
        if (this.isDebug()) {
            System.out.println(data);
        }
    }

    protected void Debug(HttpResponse resp) {
        if (this.isDebug()) {
            if (resp.headers != null) {
                System.out.println(resp.headers.toString());
            }
            System.out.println(resp.body);
        }
    }

    static {
        String strClassName = AbstractOozieJob.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class HttpResponse {
        int code;
        Map<String, List<String>> headers;
        String body;
        boolean error;
        Exception e;

        public HttpResponse(HttpURLConnection conn) {
            block5: {
                this.code = 0;
                this.headers = null;
                this.body = "";
                this.error = false;
                this.e = null;
                try {
                    this.code = conn.getResponseCode();
                    BufferedReader in = null;
                    try {
                        String line;
                        in = this.code >= 400 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        while ((line = in.readLine()) != null) {
                            this.body = this.body + line;
                        }
                        in.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.headers = conn.getHeaderFields();
                }
                catch (IOException e) {
                    this.error = true;
                    this.e = e;
                    if (!AbstractOozieJob.this.isDebug()) break block5;
                    e.printStackTrace();
                }
            }
        }

        public boolean isError() {
            return this.error;
        }

        public Exception getException() {
            return this.e;
        }
    }

    private class Configuration {
        private StringBuilder sb = new StringBuilder();

        private Configuration() {
        }

        public void addProperty(String name, String value) {
            this.sb.append("    <property>\n        <name>");
            this.sb.append(name);
            this.sb.append("</name>\n        <value>");
            this.sb.append(value);
            this.sb.append("</value>\n    </property>");
        }

        public String getXML() {
            String xml = "<configuration>\n" + this.sb.toString() + "\n</configuration>";
            return xml;
        }
    }
}

