/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.lsf;

import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.api.JFCalendarManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.login.LoginException;

public class LSFCalendar
implements Calendar {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(LSFCalendar.class);
    private static final String DayRecurrence = "day";
    private static final String WeekRecurrence = "week";
    private static final String MonthRecurrence = "month";
    private static final String YearRecurrence = "year";
    private static final String WeeklySystemCalendar = "Weekdays@Sys";
    private static final String DailySystemCalendar = "Daily@Sys";
    private static final String WeekDaysList = "MON,TUE,WED,THU,FRI";
    private static final String[] LSFWeekDays = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
    private static final int[] RecurrenceDailyMasks = new int[]{1, 2, 4, 8, 16, 32, 64};
    private static final String[] LSFMonthlyWeekDays = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "Daily@Sys"};
    private static final int[] RecurrenceMonthlyDayMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final String InvalidCharacters = "\"<>][ #:;/=()";
    private static final char SubstituteCharacter = '_';
    private JFCalendar m_cal;
    private IRecurrenceInfo m_RecurrenceInfo;
    private String m_definition;
    public static final String USER_SYSTEM = "Sys";

    protected LSFCalendar() {
    }

    public LSFCalendar(JFCalendar cal) throws SchedulerException {
        this.m_cal = cal;
        this.m_definition = this.m_cal.getDescription();
        if (this.m_definition != null) {
            this.m_RecurrenceInfo = RecurrenceBaseClass.createFromXML((String)this.m_definition);
        }
    }

    public LSFCalendar(String id, Scheduler scheduler) throws SchedulerException {
        if (scheduler instanceof LSFScheduler) {
            JFCalendarManager calMgr = (JFCalendarManager)((LSFScheduler)scheduler).getCalendarManager();
            try {
                String actualCalName = id.indexOf("(") > 0 ? id.substring(0, id.indexOf("(")).trim() : id;
                this.m_cal = LSFCalendar.setCalendarFromCalMgr(calMgr, actualCalName);
            }
            catch (JFException jfe) {
                SchedulerException ex = new SchedulerException(jfe.toString());
                throw ex;
            }
            catch (IOException ioe) {
                SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
                throw ex;
            }
        } else {
            SchedulerException ex = new SchedulerException(m_bundle.getString("LSFCalendar.InvalidScheduler.txt"), LSFCalendar.class, "LSFCalendar.InvalidScheduler.txt", null);
            throw ex;
        }
        String desc = this.m_cal.getDescription();
        if (desc.indexOf("schedule") >= 0) {
            this.m_RecurrenceInfo = RecurrenceBaseClass.createFromXML((String)desc);
            this.m_definition = desc;
        } else if (id.compareTo(DailySystemCalendar) == 0) {
            this.m_RecurrenceInfo = new DailyRecurrence();
        } else if (id.compareTo(WeeklySystemCalendar) == 0) {
            this.m_RecurrenceInfo = new DailyRecurrence();
            ((DailyRecurrence)this.m_RecurrenceInfo).setWeekDays(true);
        } else if (id.compareTo(WeeklySystemCalendar) == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(31);
        } else if (id.compareTo("Weekends@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(96);
        } else if (id.compareTo("Mondays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(1);
        } else if (id.compareTo("Tuesdays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(2);
        } else if (id.compareTo("Wednesdays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(4);
        } else if (id.compareTo("Thursdays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(8);
        } else if (id.compareTo("Fridays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(16);
        } else if (id.compareTo("Saturdays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(32);
        } else if (id.compareTo("Sundays@Sys") == 0) {
            this.m_RecurrenceInfo = new WeeklyRecurrence();
            ((WeeklyRecurrence)this.m_RecurrenceInfo).setDaysToRun(64);
        } else if (id.compareTo("First_monday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(1, 1);
        } else if (id.compareTo("First_tuesday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(2, 1);
        } else if (id.compareTo("First_wednesday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(4, 1);
        } else if (id.compareTo("First_thursday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(8, 1);
        } else if (id.compareTo("First_friday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(16, 1);
        } else if (id.compareTo("First_saturday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(32, 1);
        } else if (id.compareTo("First_sunday_of_month@Sys") == 0) {
            this.m_RecurrenceInfo = new MonthlyRecurrence();
            ((MonthlyRecurrence)this.m_RecurrenceInfo).setRecurringDay(64, 1);
        } else if (id.startsWith("DL_")) {
            this.m_RecurrenceInfo = new DateList();
            try {
                String[] tokens = id.split("_");
                for (int i = 1; i < tokens.length; ++i) {
                    String date = tokens[i];
                    int year = Integer.valueOf(date.substring(0, 4));
                    int month = Integer.valueOf(date.substring(4, 6));
                    int day = Integer.valueOf(date.substring(6, 8));
                    GregorianCalendar gcal = new GregorianCalendar();
                    gcal.set(1, year);
                    gcal.set(2, month - 1);
                    gcal.set(5, day);
                    ((DateList)this.m_RecurrenceInfo).addDate((java.util.Calendar)gcal);
                }
            }
            catch (NumberFormatException nfe) {
                String data = this.m_cal.getName() + "@" + this.m_cal.getOwner();
                String expression = this.m_cal.getExpression();
                String displayformat = this.m_cal.getName() + "@" + this.m_cal.getOwner() + ":{0}:{1}:{2}";
                this.m_RecurrenceInfo = new OpaqueRecurrence("a1661499-5d7d-4fcc-8fc3-c6509853e116", displayformat, data, expression);
            }
        } else {
            String data = this.m_cal.getName() + "@" + this.m_cal.getOwner();
            String expression = this.m_cal.getExpression();
            String displayformat = this.m_cal.getName() + "@" + this.m_cal.getOwner() + ":{0}:{1}:{2}";
            this.m_RecurrenceInfo = new OpaqueRecurrence("a1661499-5d7d-4fcc-8fc3-c6509853e116", displayformat, data, expression);
        }
    }

    public LSFCalendar(IRecurrenceInfo info, Scheduler scheduler) throws SchedulerException {
        try {
            if (!(scheduler instanceof LSFScheduler)) {
                throw new SchedulerException();
            }
            this.createCalendars(info, (LSFScheduler)scheduler);
            this.setDefinition(info.toXML());
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.toString());
            throw ex;
        }
    }

    public LSFCalendar(String name, String expression, String description) throws SchedulerException {
        try {
            String desc;
            String calname = name;
            if (name.indexOf("@") > 0) {
                calname = name.substring(0, name.indexOf("@"));
            }
            if ((desc = description) == null) {
                desc = "";
            }
            this.m_cal = new JFCalendar(calname, expression, desc);
            this.m_RecurrenceInfo = null;
        }
        catch (IllegalArgumentException iae) {
            SchedulerException ex = new SchedulerException(iae.toString());
            throw ex;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
    }

    public LSFCalendar(String name, String expression, String owner, String description) {
        String desc = description;
        if (desc == null) {
            desc = "";
        }
        this.m_cal = new JFCalendar(name, expression, owner, desc);
        this.m_RecurrenceInfo = null;
    }

    public JFCalendar getJFCalendar() {
        return this.m_cal;
    }

    @Override
    public String getName() {
        if (this.m_cal != null) {
            return this.m_cal.getName();
        }
        return null;
    }

    @Override
    public boolean setName(String name) {
        if (this.m_cal != null) {
            this.m_cal.setName(name);
            return true;
        }
        return false;
    }

    public String getExpression() {
        return this.m_cal.getExpression();
    }

    public boolean setExpression(String exp) {
        if (this.m_cal != null) {
            this.m_cal.setExpression(exp);
            return true;
        }
        return false;
    }

    @Override
    public IRecurrenceInfo getDays() {
        return this.m_RecurrenceInfo;
    }

    @Override
    public boolean setDays(IRecurrenceInfo info) {
        this.m_RecurrenceInfo = info;
        return true;
    }

    @Override
    public boolean isUserDefined() {
        return !this.m_cal.getOwner().equalsIgnoreCase("SYS");
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getXML() {
        String xml = this.getDefinition();
        if (xml != null && xml.indexOf("schedule") >= 0) {
            return xml;
        }
        return null;
    }

    @Override
    public boolean setXML(String xml) {
        return this.setDefinition(xml);
    }

    @Override
    public String getDescription() {
        if (this.m_cal != null) {
            return this.m_cal.getDescription();
        }
        return null;
    }

    @Override
    public boolean setDescription(String description) {
        if (this.m_cal != null) {
            this.m_cal.setDescription(description);
            return true;
        }
        return false;
    }

    @Override
    public String getDefinition() {
        if (this.m_definition == null) {
            String desc = this.m_cal.getDescription();
            this.m_definition = desc != null && desc.indexOf("schedule") >= 0 ? desc : this.m_cal.getExpression();
        }
        return this.m_definition;
    }

    @Override
    public boolean setDefinition(String desc) {
        this.m_definition = desc;
        return this.setDescription(desc);
    }

    @Override
    public String getOwner() {
        if (this.m_cal != null) {
            return this.m_cal.getOwner();
        }
        return null;
    }

    @Override
    public boolean setOwner(String owner) {
        if (this.m_cal != null) {
            this.m_cal.setOwner(owner);
            return true;
        }
        return false;
    }

    public static String makeCalendarExpression(IRecurrenceInfo recurrence) {
        String topCalendarExpression = "";
        GregorianCalendar today = new GregorianCalendar(Locale.getDefault());
        if (recurrence instanceof DailyRecurrence) {
            DailyRecurrence dailySpec = (DailyRecurrence)recurrence;
            if (!(dailySpec.getStartDate() != null && LSFCalendar.futureDay(dailySpec.getStartDate(), today) || dailySpec.getEndDate() != null || dailySpec.getSkipCount() != 1)) {
                topCalendarExpression = dailySpec.isWeekDays() ? WeeklySystemCalendar : DailySystemCalendar;
            } else {
                StringBuffer buffer = new StringBuffer();
                String recurrenceType = DayRecurrence;
                if (dailySpec.isWeekDays()) {
                    recurrenceType = WeekRecurrence;
                }
                LSFCalendar.handleCommonCalendarItems((AbstractRecurrence)dailySpec, dailySpec.getStartDate(), recurrenceType, dailySpec.getSkipCount(), buffer);
                if (dailySpec.isWeekDays()) {
                    buffer.append(':');
                    buffer.append(WeekDaysList);
                    topCalendarExpression = buffer.toString();
                } else {
                    topCalendarExpression = buffer.toString();
                }
            }
        } else if (recurrence instanceof WeeklyRecurrence) {
            WeeklyRecurrence weeklySpec = (WeeklyRecurrence)recurrence;
            String[] calendarNames = new String[]{"Mondays@Sys", "Tuesdays@Sys", "Wednesdays@Sys", "Thursdays@Sys", "Fridays@Sys", "Saturdays@Sys", "Sundays@Sys"};
            int daysToRun = weeklySpec.getDaysToRun();
            boolean buildCustom = false;
            if (!(weeklySpec.getStartDate() != null && LSFCalendar.futureDay(weeklySpec.getStartDate(), today) || weeklySpec.getEndDate() != null || weeklySpec.getSkipCount() != 1)) {
                String calName = "";
                for (int i = 0; i < RecurrenceDailyMasks.length; ++i) {
                    if ((daysToRun & RecurrenceDailyMasks[i]) <= 0) continue;
                    if (calName.length() > 0) {
                        calName = "";
                        break;
                    }
                    calName = calendarNames[i];
                }
                if (calName.length() > 0) {
                    topCalendarExpression = calName;
                } else if (daysToRun == 31) {
                    topCalendarExpression = WeeklySystemCalendar;
                } else if (daysToRun == 96) {
                    topCalendarExpression = "Weekends@Sys";
                } else {
                    buildCustom = true;
                }
            } else {
                buildCustom = true;
            }
            if (buildCustom) {
                StringBuffer buffer = new StringBuffer();
                LSFCalendar.handleCommonCalendarItems((AbstractRecurrence)weeklySpec, weeklySpec.getStartDate(), WeekRecurrence, weeklySpec.getSkipCount(), buffer);
                buffer.append(':');
                boolean seenFirstDay = false;
                for (int i = 0; i < RecurrenceDailyMasks.length; ++i) {
                    if ((daysToRun & RecurrenceDailyMasks[i]) <= 0) continue;
                    if (seenFirstDay) {
                        buffer.append(',');
                    } else {
                        seenFirstDay = true;
                    }
                    buffer.append(LSFWeekDays[i]);
                }
                topCalendarExpression = buffer.toString();
            }
        } else if (recurrence instanceof MonthlyRecurrence) {
            MonthlyRecurrence monthlySpec = (MonthlyRecurrence)recurrence;
            if (!(monthlySpec.getStartDate() != null && LSFCalendar.futureDay(monthlySpec.getStartDate(), today) || monthlySpec.getEndDate() != null || monthlySpec.getSkipCount() != 1 || monthlySpec.getDayOfMonth() != 0 || monthlySpec.getWhichWeek() != 1)) {
                String[] monthlyCalendars = new String[]{"First_monday_of_month@Sys", "First_tuesday_of_month@Sys", "First_wednesday_of_month@Sys", "First_thursday_of_month@Sys", "First_friday_of_month@Sys", "First_saturday_of_month@Sys", "First_sunday_of_month@Sys"};
                for (int i = 0; i < RecurrenceDailyMasks.length; ++i) {
                    if ((monthlySpec.getDayOfWeek() & RecurrenceDailyMasks[i]) <= 0) continue;
                    topCalendarExpression = monthlyCalendars[i];
                    break;
                }
            } else {
                StringBuffer buffer = new StringBuffer();
                LSFCalendar.handleCommonCalendarItems((AbstractRecurrence)monthlySpec, monthlySpec.getStartDate(), MonthRecurrence, monthlySpec.getSkipCount(), buffer);
                buffer.append(':');
                if (monthlySpec.getDayOfMonth() > 0) {
                    buffer.append(monthlySpec.getDayOfMonth());
                } else if (monthlySpec.getDayOfWeek() > 0 && monthlySpec.getWhichWeek() > 0) {
                    boolean seenFirstDay = false;
                    for (int i = 0; i < LSFMonthlyWeekDays.length; ++i) {
                        if ((monthlySpec.getDayOfWeek() & RecurrenceMonthlyDayMasks[i]) <= 0) continue;
                        if (seenFirstDay) {
                            buffer.append(',');
                        } else {
                            seenFirstDay = true;
                        }
                        buffer.append(LSFMonthlyWeekDays[i]);
                        buffer.append('(');
                        switch (monthlySpec.getWhichWeek()) {
                            case 1: {
                                buffer.append(1);
                                break;
                            }
                            case 2: {
                                buffer.append(2);
                                break;
                            }
                            case 3: {
                                buffer.append(3);
                                break;
                            }
                            case 4: {
                                buffer.append(4);
                                break;
                            }
                            case 6: {
                                buffer.append(-1);
                            }
                        }
                        buffer.append(')');
                    }
                }
                topCalendarExpression = buffer.toString();
            }
        } else if (recurrence instanceof YearlyRecurrence) {
            String[] monthNames = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
            YearlyRecurrence yearlySpec = (YearlyRecurrence)recurrence;
            StringBuffer buffer = new StringBuffer();
            String recurrenceType = YearRecurrence;
            int skipCount = 1;
            if (yearlySpec.getSkipCount() > 1 || yearlySpec.getWhichWeek() >= 0) {
                recurrenceType = MonthRecurrence;
                skipCount = yearlySpec.getSkipCount() * 12;
                GregorianCalendar mungedStartDate = new GregorianCalendar(Locale.getDefault());
                java.util.Calendar startCal = yearlySpec.getStartDate();
                if (startCal != null) {
                    mungedStartDate.set(startCal.get(1), startCal.get(2), startCal.get(5));
                }
                mungedStartDate.set(2, yearlySpec.getMonth() - 1);
                mungedStartDate.set(5, 1);
                LSFCalendar.handleCommonCalendarItems((AbstractRecurrence)yearlySpec, mungedStartDate, recurrenceType, skipCount, buffer);
            } else {
                LSFCalendar.handleCommonCalendarItems((AbstractRecurrence)yearlySpec, yearlySpec.getStartDate(), recurrenceType, skipCount, buffer);
            }
            if (recurrenceType.compareTo(YearRecurrence) == 0) {
                buffer.append(":");
                buffer.append(monthNames[yearlySpec.getMonth() - 1]);
                buffer.append(":");
                buffer.append(yearlySpec.getDay());
            } else if (yearlySpec.getMonth() > 0) {
                if (yearlySpec.getDay() > 0) {
                    buffer.append(":");
                    buffer.append(yearlySpec.getDay());
                } else if (yearlySpec.getDayOfWeek() >= 0 && yearlySpec.getWhichWeek() >= 0) {
                    buffer.append(":");
                    for (int i = 0; i < RecurrenceDailyMasks.length; ++i) {
                        if ((yearlySpec.getDayOfWeek() & RecurrenceDailyMasks[i]) <= 0) continue;
                        buffer.append(LSFWeekDays[i]);
                        break;
                    }
                    buffer.append('(');
                    switch (yearlySpec.getWhichWeek()) {
                        case 1: {
                            buffer.append(1);
                            break;
                        }
                        case 2: {
                            buffer.append(2);
                            break;
                        }
                        case 3: {
                            buffer.append(3);
                            break;
                        }
                        case 4: {
                            buffer.append(4);
                            break;
                        }
                        case 6: {
                            buffer.append(-1);
                        }
                    }
                    buffer.append(')');
                }
            }
            topCalendarExpression = buffer.toString();
        } else if (recurrence instanceof DateList) {
            DateList once = (DateList)recurrence;
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            boolean firstTime = true;
            for (java.util.Calendar date : once.getDatesToRun()) {
                if (!firstTime) {
                    buffer.append(',');
                }
                buffer.append(date.get(1));
                buffer.append('/');
                buffer.append(date.get(2) + 1);
                buffer.append('/');
                buffer.append(date.get(5));
                firstTime = false;
            }
            buffer.append(')');
            topCalendarExpression = buffer.toString();
        } else {
            OpaqueRecurrence opaque;
            String schID;
            topCalendarExpression = recurrence instanceof OpaqueRecurrence ? ((schID = (opaque = (OpaqueRecurrence)recurrence).getScheduler()).compareToIgnoreCase("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0 ? opaque.getData() : "") : "";
        }
        return topCalendarExpression;
    }

    @Override
    public String makeValidCalendarName(String nameStr) {
        return LSFCalendar.makeValidName(nameStr);
    }

    public static String makeValidName(String nameStr) {
        return MetaUtilities.makeValidCalendarName(nameStr, InvalidCharacters, '_');
    }

    @Override
    public boolean isValidCalendarName(String nameStr) {
        return LSFCalendar._isValidCalendarName(nameStr);
    }

    public static boolean _isValidCalendarName(String nameStr) {
        boolean isValid = true;
        if (nameStr == null || nameStr.length() == 0) {
            isValid = false;
        } else {
            int slen = InvalidCharacters.length();
            if (!Character.isLetter(nameStr.charAt(0))) {
                isValid = false;
            } else {
                for (int i = 0; i < slen; ++i) {
                    char c = InvalidCharacters.charAt(i);
                    if (nameStr.indexOf(c) < 0) continue;
                    isValid = false;
                    break;
                }
            }
        }
        return isValid;
    }

    private static JFCalendar setCalendarFromCalMgr(JFCalendarManager calMgr, String actualCalName) throws IOException, JFException {
        JFCalendar cal = calMgr.getCalendar(actualCalName);
        if (null == cal) {
            cal = calMgr.getCalendar(actualCalName, USER_SYSTEM);
        }
        return cal;
    }

    private static void handleCommonCalendarItems(AbstractRecurrence recurrence, java.util.Calendar startDate, String calendarTypeString, int skipCount, StringBuffer buffer) {
        buffer.append("RANGE(");
        java.util.Calendar fixedStartDate = startDate;
        if (fixedStartDate == null) {
            fixedStartDate = new GregorianCalendar(Locale.getDefault());
        }
        buffer.append(fixedStartDate.get(1));
        buffer.append('/');
        buffer.append(fixedStartDate.get(2) + 1);
        buffer.append('/');
        buffer.append(fixedStartDate.get(5));
        if (recurrence.getEndDate() != null) {
            java.util.Calendar endDate = recurrence.getEndDate();
            buffer.append(',');
            buffer.append(endDate.get(1));
            buffer.append('/');
            buffer.append(endDate.get(2) + 1);
            buffer.append('/');
            buffer.append(endDate.get(5));
        }
        buffer.append(')');
        if (calendarTypeString.compareTo(YearRecurrence) != 0) {
            buffer.append(":");
            buffer.append(calendarTypeString);
            buffer.append('(');
            buffer.append("1,*,");
            buffer.append(skipCount < 1 ? 1 : skipCount);
            buffer.append(')');
        }
    }

    public static String getCalendarName(IRecurrenceInfo recurrence, LSFScheduler scheduler) throws JFException, IOException, SchedulerException {
        String validName;
        JFCalendar cal = null;
        String calendarExpression = LSFCalendar.makeCalendarExpression(recurrence);
        JFCalendarManager calMgr = (JFCalendarManager)scheduler.getCalendarManager();
        cal = LSFCalendar._isValidCalendarName(calendarExpression) && scheduler.calendarExists(calendarExpression) ? LSFCalendar.setCalendarFromCalMgr(calMgr, calendarExpression) : (LSFCalendar._isValidCalendarName(validName = LSFCalendar.makeValidName(recurrence.toShortUniqueString())) && scheduler.calendarExists(validName) ? LSFCalendar.setCalendarFromCalMgr(calMgr, validName) : new JFCalendar(validName, calendarExpression, recurrence.toXML()));
        if (cal != null) {
            return cal.getName() + "@" + cal.getOwner();
        }
        return "";
    }

    protected final String createCalendars(IRecurrenceInfo recurrence, LSFScheduler scheduler) throws JFException, IOException, SchedulerException {
        String topCalendarExpression = LSFCalendar.makeCalendarExpression(recurrence);
        this.cacheCalendar(topCalendarExpression, recurrence, scheduler);
        this.m_RecurrenceInfo = recurrence;
        return this.m_cal != null ? this.m_cal.getName() : "";
    }

    private void cacheCalendar(String calendarExpression, IRecurrenceInfo recurrence, LSFScheduler scheduler) throws JFException, IOException, SchedulerException {
        if (calendarExpression == null || calendarExpression.length() <= 0) {
            this.m_cal = null;
            return;
        }
        JFCalendarManager calMgr = (JFCalendarManager)scheduler.getCalendarManager();
        if (this.isValidCalendarName(calendarExpression) && calMgr.calendarExists(calendarExpression)) {
            this.m_cal = LSFCalendar.setCalendarFromCalMgr(calMgr, calendarExpression);
            this.m_RecurrenceInfo = recurrence;
        } else {
            boolean found = false;
            if (calendarExpression.contains("@")) {
                String calName;
                String inputCalName = calName = calendarExpression;
                JFCalendar[] cals = calMgr.getAllCalendars();
                if (calName.indexOf("@") >= 0) {
                    inputCalName = calName.substring(0, calName.indexOf("@"));
                }
                for (int i = 0; i < cals.length; ++i) {
                    String desc;
                    String tryCalName = cals[i].getName();
                    if (!inputCalName.equals(tryCalName) || (desc = cals[i].getDescription()) == null || !desc.equals(recurrence.toXML())) continue;
                    this.m_cal = cals[i];
                    this.m_RecurrenceInfo = recurrence;
                    found = true;
                    break;
                }
            }
            if (!found) {
                String validName = this.makeValidCalendarName(recurrence.toShortUniqueString());
                if (this.isValidCalendarName(validName) && calMgr.calendarExists(validName)) {
                    this.m_cal = LSFCalendar.setCalendarFromCalMgr(calMgr, validName);
                    this.m_RecurrenceInfo = recurrence;
                } else {
                    SchedulerServerInfo ssi = scheduler.getServerComponent();
                    if (scheduler.getConnectedUser().contains("guest") && ssi.getUsername() != null && ssi.getPassword() != null) {
                        try {
                            JFLoginManager.login((String)ssi.getUsername(), (String)ssi.getPassword());
                        }
                        catch (LoginException e) {
                            this.m_cal = null;
                            SchedulerException se = new SchedulerException("LSFCalendar.UnableToSaveCalendarToServer.txt");
                            throw se;
                        }
                    }
                    this.m_cal = new JFCalendar(validName, calendarExpression, recurrence.toXML());
                    try {
                        calMgr.addCalendar(this.m_cal);
                        this.m_RecurrenceInfo = recurrence;
                    }
                    catch (JFException jfe) {
                        this.m_cal = null;
                        SchedulerException se = new SchedulerException("LSFCalendar.UnableToSaveCalendarToServer.txt");
                        se.initCause((Throwable)jfe);
                        throw se;
                    }
                    catch (IOException ioe) {
                        this.m_cal = null;
                        SchedulerException se = new SchedulerException("LSFCalendar.UnableToSaveCalendarToServer.txt");
                        se.initCause((Throwable)ioe);
                        throw se;
                    }
                }
            }
        }
    }

    private static boolean sameDay(java.util.Calendar day1, java.util.Calendar day2) {
        if (day1.get(1) != day2.get(1)) {
            return false;
        }
        if (day1.get(2) != day2.get(2)) {
            return false;
        }
        return day1.get(5) == day2.get(5);
    }

    private static boolean futureDay(java.util.Calendar day1, java.util.Calendar day2) {
        if (LSFCalendar.sameDay(day1, day2)) {
            return false;
        }
        return day1.after(day2);
    }
}

