/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.scheduler.api.servers.ip.engine.IJobRoutingNode;
import com.sas.scheduler.api.servers.ip.engine.Job;
import java.util.ArrayList;
import java.util.List;

public class JobRoutingBooleanNode
implements IJobRoutingNode {
    private boolean mAnded;
    private List<IJobRoutingNode> mChildren;

    public JobRoutingBooleanNode(boolean isAnd) {
        this.mAnded = isAnd;
        this.mChildren = new ArrayList<IJobRoutingNode>();
    }

    public void addChild(IJobRoutingNode child) {
        if (child != null) {
            this.mChildren.add(child);
        }
    }

    @Override
    public boolean evaluate(Job j) {
        if (this.mChildren.size() == 0) {
            return true;
        }
        for (IJobRoutingNode node : this.mChildren) {
            boolean eval = node.evaluate(j);
            if (this.mAnded) {
                if (eval) continue;
                return false;
            }
            if (!eval) continue;
            return true;
        }
        return this.mAnded;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        boolean first = true;
        for (IJobRoutingNode child : this.mChildren) {
            if (!first) {
                if (this.mAnded) {
                    buffer.append(" AND ");
                } else {
                    buffer.append(" OR ");
                }
            }
            first = false;
            buffer.append(child.toString());
        }
        return buffer.toString();
    }
}

