/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.entities.GUID;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.MasterServer;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.ScheduleIDInfo;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.mq.OutputHolder;
import com.sas.scheduler.api.servers.ip.engine.mq.Utilities;
import com.sas.scheduler.model.SchedulerException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.springframework.jms.core.MessagePostProcessor;

public class JMSMasterServer
implements MasterServer {
    public static final String Key_JMS_Master_Response_Timeout = "sas.dip.JMSResponseTimeout";
    public static final String Key_JMS_Master_CreateSessionResponse_Timeout = "sas.dip.JMSCreateSessionResponseTimeout";
    protected static final long DefaultResponseTimeout = 35000L;
    protected static final long DefaultCreateSessionTimeout = 25000L;
    protected JMSClusterSupport mCluster;
    protected long mResponseTimeout = 35000L;
    protected long mCreateSessionTimeout = 25000L;

    public JMSMasterServer(JMSClusterSupport cluster) {
        this.mCluster = cluster;
        long timeout = IPUtilities.getLongValue(System.getProperties(), Key_JMS_Master_Response_Timeout, 35000L, this.mCluster.getLogger());
        if (timeout >= 1000L) {
            this.mResponseTimeout = timeout;
        }
        if ((timeout = IPUtilities.getLongValue(System.getProperties(), Key_JMS_Master_CreateSessionResponse_Timeout, 25000L, this.mCluster.getLogger())) >= 1000L) {
            this.mCreateSessionTimeout = timeout;
        }
    }

    public String getNodeID() {
        return this.mCluster.getNodeID();
    }

    @Override
    public String[] addFlows(final String sessionID, TopLevelFlow[] newFlows) {
        final String[] flowDefs = new String[newFlows.length];
        for (int i = 0; i < newFlows.length; ++i) {
            TopLevelFlow flow = newFlows[i];
            flowDefs[i] = flow.toSerializedForm();
        }
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowDefs));
                message.setStringProperty("operation", "AddFlows");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[newFlows.length];
    }

    @Override
    public String[] addPredefinedCalendars(String sessionID, PredefinedCalendar[] calendars) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AbstractUserSession createSession(String userID, String password) {
        return this.createSession(userID, password != null ? new SealedString(password) : null);
    }

    @Override
    public AbstractUserSession createSession(final String userID, final SealedString password) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "CreateSession");
                message.setStringProperty("userID", userID);
                message.setStringProperty("password", String.valueOf(password != null ? password.getCharacters() : null));
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid, this.mCreateSessionTimeout);
        if (result instanceof String) {
            AbstractUserSession userSession = this.mCluster.getManager().getExecutionProvider().constructSession((String)result);
            userSession.setFlowManager(this.mCluster.getManager());
            return userSession;
        }
        return null;
    }

    @Override
    public String[] deleteFlows(final String sessionID, final String[] flowIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                message.setStringProperty("operation", "DeleteFlows");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[0];
    }

    @Override
    public TopLevelFlowIDInfo[] getAllFlowIDs(final String sessionID) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetAllFlowIDs");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] idInfoStrings = Utilities.getArrayFromEncodedString((String)result);
            ArrayList<TopLevelFlowIDInfo> idInfos = new ArrayList<TopLevelFlowIDInfo>();
            for (int i = 0; i < idInfoStrings.length; ++i) {
                String defString = idInfoStrings[i];
                try {
                    TopLevelFlowIDInfo newFlowInfo = TopLevelFlowIDInfo.createFromSeralizedForm(defString, this.mCluster.getManager().getLogger());
                    if (newFlowInfo == null) continue;
                    idInfos.add(newFlowInfo);
                    continue;
                }
                catch (Exception e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return idInfos.toArray(new TopLevelFlowIDInfo[0]);
        }
        return new TopLevelFlowIDInfo[0];
    }

    @Override
    public PredefinedCalendar getCalendarForID(String calendarID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopLevelFlow[] getFlowDefinitions(final String sessionID, final String[] flowIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                message.setStringProperty("operation", "GetFlowDefinitions");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] flowDefs = Utilities.getArrayFromEncodedString((String)result);
            ArrayList<TopLevelFlow> defs = new ArrayList<TopLevelFlow>();
            for (int i = 0; i < flowDefs.length; ++i) {
                String defString = flowDefs[i];
                try {
                    TopLevelFlow newFlow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(defString)), this.mCluster.getManager().getLogger());
                    if (newFlow == null) continue;
                    defs.add(newFlow);
                    continue;
                }
                catch (Exception e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return defs.toArray(new TopLevelFlow[0]);
        }
        return new TopLevelFlow[0];
    }

    @Override
    public FlowHistory[] getFlowHistories(final String sessionID, final String[] flowIDs, final int countPerFlow) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                message.setIntProperty("auxData1", countPerFlow);
                message.setStringProperty("operation", "GetFlowHistories");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] historiesAsString = Utilities.getArrayFromEncodedString((String)result);
            ArrayList<FlowHistory> histories = new ArrayList<FlowHistory>();
            for (int i = 0; i < historiesAsString.length; ++i) {
                String historyString = historiesAsString[i];
                try {
                    FlowHistory history = FlowHistory.GetHistoryFromString(historyString, this.mCluster.getManager().getLogger());
                    if (history == null) continue;
                    histories.add(history);
                    continue;
                }
                catch (Exception e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return histories.toArray(new FlowHistory[0]);
        }
        return new FlowHistory[0];
    }

    @Override
    public FlowHistory[] getFlowHistory(final String sessionID, HistorySearchOptions options) {
        final String optionsString = options.toSerializedForm();
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", optionsString);
                message.setStringProperty("operation", "SearchHistory");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] historiesAsString = Utilities.getArrayFromEncodedString((String)result);
            ArrayList<FlowHistory> histories = new ArrayList<FlowHistory>();
            for (int i = 0; i < historiesAsString.length; ++i) {
                String historyString = historiesAsString[i];
                try {
                    FlowHistory history = FlowHistory.GetHistoryFromString(historyString, this.mCluster.getManager().getLogger());
                    if (history == null) continue;
                    histories.add(history);
                    continue;
                }
                catch (Exception e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return histories.toArray(new FlowHistory[0]);
        }
        return new FlowHistory[0];
    }

    @Override
    public String getFlowID(final String sessionID, final String flowName) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("mainData", flowName);
                message.setStringProperty("operation", "GetFlowByName");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    @Override
    public FlowInstance[] getInstanceDefinitions(final String sessionID, final String[] instanceIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetInstanceDefinitions");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(instanceIDs));
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] instanceDefs = Utilities.getArrayFromEncodedString((String)result);
            ArrayList<FlowInstance> defs = new ArrayList<FlowInstance>();
            for (int i = 0; i < instanceDefs.length; ++i) {
                String defString = instanceDefs[i];
                try {
                    FlowInstance newInstance = FlowInstance.createFromXML(new BufferedReader(new StringReader(defString)), this.mCluster.getManager().getLogger());
                    if (newInstance == null) continue;
                    defs.add(newInstance);
                    continue;
                }
                catch (SchedulerException e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return defs.toArray(new FlowInstance[0]);
        }
        return new FlowInstance[0];
    }

    @Override
    public ScheduleIDInfo[] getPredefinedCalendarIDInfos(String sessionID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PredefinedCalendar[] getPredefinedCalendars(String sessionID, String[] calendarIDs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] holdFlows(final String sessionID, final String[] flowIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "HoldFlows");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[0];
    }

    @Override
    public boolean isAdministrator(final String sessionID) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "IsAdministrator");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public String[][] isPredefinedCalendarInUse(String sessionID, String scheduleID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean killExecutionItem(final String sessionID, final String flowInstanceID, final String subItemID, final boolean force) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "KillExecutionItem");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", flowInstanceID);
                message.setStringProperty("auxData1", subItemID);
                message.setBooleanProperty("auxData2", force);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public String[] killFlowInstances(final String sessionID, final String[] instanceIDs, final boolean force) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "KillFlows");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(instanceIDs));
                message.setBooleanProperty("auxData1", force);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[0];
    }

    @Override
    public String[] releaseFlows(final String sessionID, final String[] flowIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "ReleaseFlows");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[0];
    }

    @Override
    public String[] runFlows(final String sessionID, final String[] flowIDs) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "RunFlows");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return Utilities.getArrayFromEncodedString((String)result);
        }
        return new String[0];
    }

    @Override
    public boolean terminateSession(final String sessionID) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "TerminateSession");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean triggerExecutionItem(final String sessionID, final String flowInstanceID, final String subItemID) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "TriggerExecutionItem");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", flowInstanceID);
                message.setStringProperty("auxData1", subItemID);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean updateFlow(final String sessionID, TopLevelFlow flow) {
        final String flowString = flow.toSerializedForm();
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "UpdateFlow");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", flowString);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean updatePredefinedCalendar(String sessionID, PredefinedCalendar newCalendarDef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markJobFinished(final String rendevousID, final int statusCode, final int exitCode) {
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "MarkJobFinished");
                message.setStringProperty("mainData", rendevousID);
                message.setIntProperty("auxData1", statusCode);
                message.setIntProperty("auxData2", exitCode);
                return message;
            }
        });
    }

    @Override
    public void updateJobStartInfo(final String rendevousID, final long startTime, final String rendererName) {
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "UpdateJobStart");
                message.setStringProperty("mainData", rendevousID);
                message.setLongProperty("auxData1", startTime);
                message.setStringProperty("auxData2", rendererName);
                return message;
            }
        });
    }

    @Override
    public int getErrorStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return this.getStreamData("GetErrorData", sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    @Override
    public int getOutputStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return this.getStreamData("GetOutputData", sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    public int getStreamData(final String opCode, final String sessionID, final String flowID, final String instanceID, final String uniqueSubitemID, final long startPos, final int maxCharacters, StringBuffer buffer) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", opCode);
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", flowID);
                message.setStringProperty("auxData1", instanceID);
                message.setStringProperty("auxData2", uniqueSubitemID);
                message.setLongProperty("auxData3", startPos);
                message.setIntProperty("auxData4", maxCharacters);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        try {
            OutputHolder holder = (OutputHolder)result;
            buffer.append(holder.getData());
            return holder.getCharsRead();
        }
        catch (Exception e) {
            this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
            return -1;
        }
    }

    @Override
    public Collection<JobRendererInfo> getJobRendererSnapshots() {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetRendererSnapshots");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        ArrayList<JobRendererInfo> results = new ArrayList<JobRendererInfo>();
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            String[] infos;
            for (String serializedData : infos = Utilities.getArrayFromEncodedString((String)result)) {
                try {
                    JobRendererInfo object = JobRendererInfo.createFromData(serializedData);
                    if (object == null) continue;
                    results.add(object);
                }
                catch (Exception e) {
                    this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return results;
        }
        return results;
    }

    @Override
    public Properties getMasterServerConfig() {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetMasterServerConfig");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(((String)result).getBytes()));
            }
            catch (IOException e) {
                this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
            }
            return props;
        }
        return new Properties();
    }

    @Override
    public List<Long> getNextTriggerTimes(List<String> flowIDs, Calendar startTime) {
        final String[] flowArray = flowIDs.toArray(new String[0]);
        final String guid = GUID.newGUID();
        long startTimeCode = 0L;
        if (startTime != null) {
            startTimeCode = startTime.getTimeInMillis();
        }
        final long finalStartTime = startTimeCode;
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetNextTriggerTimes");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", Utilities.createStringFromArray(flowArray));
                message.setLongProperty("auxData1", finalStartTime);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            Long[] longArray = Utilities.getLongArrayFromEncodedString((String)result);
            ArrayList<Long> results = new ArrayList<Long>();
            results.addAll(Arrays.asList(longArray));
            for (int i = results.size(); i < flowIDs.size(); ++i) {
                results.add(0L);
            }
            return results;
        }
        ArrayList<Long> results = new ArrayList<Long>();
        for (int i = 0; i < flowIDs.size(); ++i) {
            results.add(0L);
        }
        return results;
    }

    @Override
    public String getJobRoutingRulesXML(final String sessionID) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "GetJobRoutingRules");
                message.setStringProperty("requestID", guid);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return (String)result;
        }
        return "";
    }

    @Override
    public boolean setJobRoutingRulesXML(final String sessionID, final String xml) {
        final String guid = GUID.newGUID();
        this.mCluster.addResponder(Thread.currentThread(), guid);
        this.mCluster.getRequestQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                message.setStringProperty("CallbackServer", JMSMasterServer.this.mCluster.getClusterID());
                message.setStringProperty("sessionID", sessionID);
                message.setStringProperty("clusterNodeID", JMSMasterServer.this.getNodeID());
                message.setStringProperty("operation", "SetJobRoutingRules");
                message.setStringProperty("requestID", guid);
                message.setStringProperty("mainData", xml);
                return message;
            }
        });
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    protected Object waitForResponse(String guid) {
        return this.waitForResponse(guid, 0L);
    }

    protected Object waitForResponse(String guid, long overrideTimeout) {
        long timeout = this.mResponseTimeout;
        if (overrideTimeout > 0L) {
            timeout = overrideTimeout;
        }
        try {
            long startTime = System.currentTimeMillis();
            while (!this.mCluster.isShuttingDown() && !this.mCluster.hasResponse(guid)) {
                if (System.currentTimeMillis() - startTime > timeout) {
                    this.mCluster.getLogger().logMessage(Level.FINE, "Timeout waiting for jms response: " + guid);
                    break;
                }
                Thread.sleep(250L);
            }
            Object result = this.mCluster.getResponse(guid);
            return result;
        }
        catch (Exception e) {
            this.mCluster.getManager().getLogger().logMessage(Level.WARNING, e);
            return null;
        }
    }
}

