/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TopLevelFlow
extends Flow {
    private String mOwner;
    private String mID = "";
    private RunCondition mTriggerConditions;
    private int mInstanceLimit;
    private boolean mHeld;
    private boolean mIsRestoredFlow;
    static final short ACCESS_ALLPRIVATE = 0;
    static final short ACCESS_PUBLIC_EDIT = 1;
    static final short ACCESS_PUBLIC_VIEW = 2;
    static final short ACCESS_PUBLIC_RUN = 4;
    static final short ACCESS_PUBLIC_KILL = 8;
    static final short ACCESS_PUBLIC_DELETE = 16;
    static final short ACCESS_PUBLIC_TRIGGER = 32;
    static final short ACCESS_INVOKER_TRIGGER = 64;
    static final short ACCESS_INVOKER_KILL = 256;
    static final short ACCESS_PUBLIC_HISTORY = 512;
    static final short ACCESS_INVOKER_HISTORY = 1024;
    public static final String XML_Owner_Tag = "Owner";
    public static final String XML_Access_Tag = "UserAccess";
    public static final String XML_FlowFile_Tag = "FlowFile";
    public static final String XML_TriggerConditions_Tag = "TriggerConditions";
    public static final String XML_MaxInstances_Tag = "MaxInstances";
    public static final String XML_ID_Tag = "ID";
    private short mAccessFlags;
    public static final String XML_Held_Tag = "Held";

    public TopLevelFlow(ClientLogger logger) {
        super(logger);
        this.mTriggerConditions = new RunConditions(logger);
        this.mOwner = "";
        this.mAccessFlags = 0;
        this.mHeld = false;
        this.mIsRestoredFlow = false;
    }

    public int getInstanceLimit() {
        return this.mInstanceLimit;
    }

    public void setInstanceLimit(int instanceLimit) {
        if (instanceLimit >= 0) {
            this.mInstanceLimit = instanceLimit;
        }
    }

    public RunCondition getTriggerConditions() {
        return this.mTriggerConditions;
    }

    public void setTriggerConditions(RunCondition triggerConditions) {
        if (triggerConditions != null) {
            this.mTriggerConditions = triggerConditions;
        }
    }

    public String getID() {
        return this.mID;
    }

    public void setID(String id) {
        if (id != null && this.mID.length() == 0) {
            this.mID = id;
        }
    }

    public void clearID() {
        this.mID = "";
    }

    public String getOwner() {
        return this.mOwner;
    }

    boolean needsToTriggerNow(FlowManager manager, Calendar serverTime, Map<String, Long> usedTimes, Calendar nextTriggerTime) {
        if (this.mTriggerConditions instanceof RunConditions && ((RunConditions)this.mTriggerConditions).isEmpty()) {
            return false;
        }
        HashMap<String, Long> usedTimeCodes = new HashMap<String, Long>();
        if (!this.mTriggerConditions.canTriggerNow(manager, serverTime, usedTimes, usedTimeCodes, nextTriggerTime)) {
            return false;
        }
        usedTimes.putAll(usedTimeCodes);
        return true;
    }

    @Override
    public Flow copy(boolean copySubItems) {
        TopLevelFlow tempFlow = new TopLevelFlow(this.mLogger);
        tempFlow.copyFrom(this, copySubItems);
        return tempFlow;
    }

    @Override
    public void copyFrom(Flow flow, boolean copySubItems) {
        if (!(flow instanceof TopLevelFlow)) {
            return;
        }
        super.copyFrom(flow, copySubItems);
        TopLevelFlow source = (TopLevelFlow)flow;
        this.mID = source.mID;
        this.mInstanceLimit = source.mInstanceLimit;
        this.mTriggerConditions = source.mTriggerConditions.copy();
        this.mOwner = source.mOwner;
        this.mAccessFlags = source.mAccessFlags;
        this.mHeld = source.mHeld;
    }

    public boolean isPublicKillable() {
        return (this.mAccessFlags & 8) > 0;
    }

    public boolean isPublicTriggerable() {
        return (this.mAccessFlags & 0x20) > 0;
    }

    public boolean isPublicHistory() {
        return (this.mAccessFlags & 0x200) > 0;
    }

    public boolean isInvokerTriggerable() {
        return (this.mAccessFlags & 0x40) > 0;
    }

    public boolean isInvokerKillable() {
        return (this.mAccessFlags & 0x100) > 0;
    }

    public boolean isInvokerHistory() {
        return (this.mAccessFlags & 0x400) > 0;
    }

    public boolean isPublicDeletable() {
        return (this.mAccessFlags & 0x10) > 0;
    }

    public boolean isPublicViewable() {
        return (this.mAccessFlags & 2) > 0;
    }

    public boolean isPublicRunnable() {
        return (this.mAccessFlags & 4) > 0;
    }

    public boolean isPublicEditable() {
        return (this.mAccessFlags & 1) > 0;
    }

    public void setPublicViewable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFFD);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFFB);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFFE);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFF7);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFEF);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFDFF);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFDF);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFBFF);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFEFF);
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFBF);
        }
    }

    public void setPublicRunnable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 4);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFFB);
        }
    }

    public void setPublicEditable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 1);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFFE);
        }
    }

    public void setPublicKillable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 8);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFF7);
        }
    }

    public void setPublicDeletable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x10);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFEF);
        }
    }

    public void setPublicHistory(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x200);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFDFF);
        }
    }

    public void setPublicTriggerable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x20);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFDF);
        }
    }

    public void setInvokerTriggerable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x40);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFFBF);
        }
    }

    public void setInvokerKillable(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x100);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFEFF);
        }
    }

    public void setInvokerHistory(boolean isPublic) {
        if (isPublic) {
            this.mAccessFlags = (short)(this.mAccessFlags | 0x400);
            this.mAccessFlags = (short)(this.mAccessFlags | 2);
        } else {
            this.mAccessFlags = (short)(this.mAccessFlags & 0xFFFFFBFF);
        }
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element flowTag = doc.createElement("Flow");
        parent.appendChild(flowTag);
        flowTag.setAttribute(XML_ID_Tag, this.mID);
        flowTag.setAttribute(XML_MaxInstances_Tag, Integer.toString(this.mInstanceLimit));
        flowTag.setAttribute(XML_Access_Tag, Short.toString(this.mAccessFlags));
        flowTag.setAttribute(XML_Held_Tag, Boolean.toString(this.mHeld));
        if (this.mOwner != null && this.mOwner.length() > 0) {
            Element ownerTag = doc.createElement(XML_Owner_Tag);
            CDATASection cdata = doc.createCDATASection(this.mOwner);
            flowTag.appendChild(ownerTag);
            ownerTag.appendChild(cdata);
        }
        this.injectXML(doc, flowTag);
        Element triggers = doc.createElement(XML_TriggerConditions_Tag);
        flowTag.appendChild(triggers);
        this.mTriggerConditions.serialize(doc, triggers);
    }

    public void setOwner(String owner) {
        if (owner != null) {
            this.mOwner = owner;
        }
    }

    public static List<TopLevelFlow> createMultipleFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        InputSource source = new InputSource(xmlReader);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = dbf.newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_FlowFile_Tag)) continue;
                List<TopLevelFlow> results = TopLevelFlow.processFlowFileTag(node, logger);
                return results;
            }
        }
        catch (SAXException dbf) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        return new ArrayList<TopLevelFlow>();
    }

    public static TopLevelFlow createFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        List<TopLevelFlow> flows = TopLevelFlow.createMultipleFromXML(xmlReader, logger);
        if (flows.size() > 0) {
            return flows.get(0);
        }
        return null;
    }

    private static List<TopLevelFlow> processFlowFileTag(Node topNode, ClientLogger logger) {
        ArrayList<TopLevelFlow> results = new ArrayList<TopLevelFlow>();
        NodeList children = topNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("Flow")) continue;
            TopLevelFlow flow = TopLevelFlow.processTopFlowTag(child, logger);
            results.add(flow);
        }
        return results;
    }

    static TopLevelFlow processTopFlowTag(Node flowNode, ClientLogger logger) {
        Node heldNode;
        Node publicAccessNode;
        Node maxInstancesNode;
        TopLevelFlow flow = new TopLevelFlow(logger);
        TopLevelFlow.processFlowTag(flow, flowNode, logger);
        NamedNodeMap attributes = flowNode.getAttributes();
        Node idNode = attributes.getNamedItem(XML_ID_Tag);
        if (idNode != null) {
            flow.setID(idNode.getNodeValue());
        }
        if ((maxInstancesNode = attributes.getNamedItem(XML_MaxInstances_Tag)) != null) {
            flow.setInstanceLimit(Integer.parseInt(maxInstancesNode.getNodeValue()));
        }
        if ((publicAccessNode = attributes.getNamedItem(XML_Access_Tag)) != null) {
            try {
                flow.mAccessFlags = Short.valueOf(publicAccessNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
                flow.mAccessFlags = 0;
            }
        }
        if ((heldNode = attributes.getNamedItem(XML_Held_Tag)) != null) {
            boolean isHeld = Boolean.valueOf(heldNode.getNodeValue());
            flow.setHeld(isHeld);
        }
        NodeList children = flowNode.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            RunCondition trigger;
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_Owner_Tag)) {
                String tagValue = ExecutionItem.getCData(child);
                flow.setOwner(tagValue);
                continue;
            }
            if (!tagName.equals(XML_TriggerConditions_Tag) || (trigger = RunCondition.processCondition(child, logger)) == null) continue;
            flow.setTriggerConditions(trigger);
        }
        return flow;
    }

    public boolean isHeld() {
        return this.mHeld;
    }

    public void setHeld(boolean locked) {
        this.mHeld = locked;
    }

    void findRequiredFileTimers(List<FileStatusListener> results) {
        this.mTriggerConditions.findRequiredFileTimers(false, results);
    }

    @Override
    public String toSerializedForm() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(XML_FlowFile_Tag);
            doc.appendChild(root);
            this.serialize(doc, root);
            return FlowInstance.emitXML(doc, this.mLogger);
        }
        catch (ParserConfigurationException e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    short getUserAccessFlags() {
        return this.mAccessFlags;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Held: " + this.mHeld);
        buffer.append('\n');
        buffer.append("ID: " + this.mID);
        buffer.append('\n');
        buffer.append("Max Instances: " + this.mInstanceLimit);
        buffer.append('\n');
        buffer.append("Owning user: " + this.mOwner);
        buffer.append('\n');
        buffer.append("Access Flags: " + this.mAccessFlags);
        buffer.append('\n');
        buffer.append(this.mTriggerConditions.toString());
        return buffer.toString();
    }

    public void markAsRestoredFlow() {
        this.mIsRestoredFlow = true;
    }

    public boolean isRestoredFlow() {
        return this.mIsRestoredFlow;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TopLevelFlow)) {
            return false;
        }
        TopLevelFlow other = (TopLevelFlow)obj;
        if (other.mHeld != this.mHeld) {
            return false;
        }
        if (other.mIsRestoredFlow != this.mIsRestoredFlow) {
            return false;
        }
        if (other.mAccessFlags != this.mAccessFlags) {
            return false;
        }
        if (other.mID != this.mID) {
            return false;
        }
        if (other.mInstanceLimit != this.mInstanceLimit) {
            return false;
        }
        if (!other.mOwner.equals(this.mOwner)) {
            return false;
        }
        if (other.mTriggerConditions != null && this.mTriggerConditions != null ? !other.mTriggerConditions.equals(this.mTriggerConditions) : other.mTriggerConditions != this.mTriggerConditions) {
            return false;
        }
        return super.equals(obj);
    }
}

