/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.TaskEventInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;

public abstract class RunningItem {
    protected Calendar mCreationTime = new GregorianCalendar();
    protected Calendar mStartTime = null;
    protected Calendar mFinishTime = null;
    protected boolean mComplete = false;
    protected int mCompletionCode;
    protected boolean mHeld = false;
    protected Calendar mDeadlineTime;
    protected RunningItem mParent = null;
    protected int mPriorityAddition = 0;
    private FlowManager mFlowManager;
    protected int mRetryAttempts;
    private transient List<TaskEventInterface> mTaskListeners = new ArrayList<TaskEventInterface>();

    public RunningItem(FlowManager manager) {
        this.mFlowManager = manager;
        this.mRetryAttempts = 0;
    }

    public void incrementPriorityAddition(int amount) {
        this.mPriorityAddition += amount;
    }

    public int getPriorityAddition() {
        return this.mPriorityAddition;
    }

    public void addTaskEventListener(TaskEventInterface completionInterface) {
        if (this.mTaskListeners.size() > 0 && completionInterface instanceof FlowManager) {
            this.mTaskListeners.add(0, completionInterface);
        } else {
            this.mTaskListeners.add(completionInterface);
        }
    }

    public int getCompletionCode() {
        return this.mCompletionCode;
    }

    void setCompletionCode(int completionCode) {
        this.mCompletionCode = completionCode;
    }

    public String getCompletionString() {
        return RunHistory.getCompletionAsString(this.getCompletionCode());
    }

    public abstract String getName();

    public abstract int getExitCode();

    public abstract String getUniqueID();

    public Calendar getCreationTime() {
        return this.mCreationTime;
    }

    public void setCreationTime(Calendar creationTime) {
        this.mCreationTime = creationTime;
    }

    public Calendar getFinishTime() {
        return this.mFinishTime;
    }

    public void setFinishTime(Calendar finishTime) {
        this.mFinishTime = finishTime;
    }

    public Calendar getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(Calendar startTime) {
        this.mStartTime = startTime;
    }

    public boolean isComplete() {
        return this.mComplete;
    }

    void setComplete(boolean complete) {
        this.mComplete = complete;
    }

    public abstract String getUserName();

    abstract boolean kill(boolean var1);

    protected void notifyTaskListeners(boolean started) {
        for (TaskEventInterface obj : this.mTaskListeners) {
            try {
                if (started) {
                    obj.started(this);
                    continue;
                }
                obj.completed(this);
            }
            catch (Exception e) {
                this.mFlowManager.getLogger().logMessage(Level.WARNING, e);
            }
        }
    }

    public RunningItem getParent() {
        return this.mParent;
    }

    public RunningFlow getTopParent() {
        RunningItem topParent = this.getParent();
        while (topParent.getParent() != null) {
            topParent = topParent.getParent();
        }
        if (topParent instanceof RunningFlow) {
            return (RunningFlow)topParent;
        }
        return null;
    }

    public void markNotRunnable(boolean notifyListeners) {
        if (this.mCompletionCode != 16) {
            this.getFlowManager().getLogger().logMessage(Level.WARNING, FlowManager.generateLogString("Mark not runnable", "Item not in wait state.  ItemID: " + this.getUniqueID() + " Current status: " + this.getCompletionCode() + "(" + this.getCompletionString() + ")"));
        }
        this.mComplete = true;
        this.mCompletionCode = 32;
        if (notifyListeners) {
            this.notifyTaskListeners(false);
        }
    }

    public void markNotRunnable() {
        this.markNotRunnable(true);
    }

    public FlowManager getFlowManager() {
        return this.mFlowManager;
    }

    protected void copyFrom(RunningItem sourceItem) {
        this.mComplete = sourceItem.mComplete;
        this.mHeld = sourceItem.mHeld;
        this.mCompletionCode = sourceItem.mCompletionCode;
        this.mCreationTime = (Calendar)sourceItem.mCreationTime.clone();
        if (sourceItem.mDeadlineTime != null) {
            this.mDeadlineTime = (Calendar)sourceItem.mDeadlineTime.clone();
        }
        this.mPriorityAddition = sourceItem.mPriorityAddition;
        if (sourceItem.mStartTime != null) {
            this.mStartTime = (Calendar)sourceItem.mStartTime.clone();
        }
        if (sourceItem.mFinishTime != null) {
            this.mFinishTime = (Calendar)sourceItem.mFinishTime.clone();
        }
    }

    protected abstract RunningItem copy();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Complete: " + this.mComplete);
        buffer.append('\n');
        buffer.append("Held: " + this.mHeld);
        buffer.append('\n');
        buffer.append("CompletionCode: " + this.mCompletionCode);
        buffer.append('\n');
        buffer.append("Creation Time: " + SimpleDateFormat.getDateTimeInstance().format(this.mCreationTime.getTime()));
        buffer.append('\n');
        if (this.mDeadlineTime != null) {
            buffer.append("DeadLine: " + SimpleDateFormat.getDateTimeInstance().format(this.mDeadlineTime.getTime()));
            buffer.append('\n');
        }
        if (this.mStartTime != null) {
            buffer.append("StartTime: " + SimpleDateFormat.getDateTimeInstance().format(this.mStartTime.getTime()));
            buffer.append('\n');
        }
        if (this.mFinishTime != null) {
            buffer.append("FinishTime: " + SimpleDateFormat.getDateTimeInstance().format(this.mFinishTime.getTime()));
            buffer.append('\n');
        }
        buffer.append("Priority Addition: " + this.mPriorityAddition);
        buffer.append('\n');
        return buffer.toString();
    }

    public static int adjustPriority(int originalPriority, int extra) {
        if (originalPriority >= 100) {
            return originalPriority + extra;
        }
        if (originalPriority >= 75) {
            return Math.min(originalPriority + extra, 99);
        }
        return Math.min(originalPriority + extra, 74);
    }

    public int getRetryAttempts() {
        return this.mRetryAttempts;
    }

    public void incrementRetryAttempts() {
        ++this.mRetryAttempts;
    }
}

