/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RetryCondition {
    private RunConditions mRetryRule;

    public RetryCondition(RunConditions retryRule) {
        this.mRetryRule = retryRule;
    }

    public boolean isMatchesCondition(RunningJob item, int exitCode) {
        if (this.mRetryRule == null) {
            return false;
        }
        if (this.mRetryRule.isEmpty()) {
            return false;
        }
        RunningJob tempItem = (RunningJob)item.copy();
        tempItem.markExited(exitCode);
        this.setRunningItem(this.mRetryRule, tempItem);
        return this.mRetryRule.canExecute(item.getFlowManager(), Calendar.getInstance(), null, null, Calendar.getInstance(), false) == 56;
    }

    private void setRunningItem(RunCondition condition, RunningItem item) {
        if (condition instanceof JobDependency) {
            ((JobDependency)condition).setDependentItem(item);
        } else if (condition instanceof RunConditions) {
            for (RunCondition subCondition : ((RunConditions)condition).getSubConditions()) {
                this.setRunningItem(subCondition, item);
            }
        }
    }

    public void serialize(Document doc, Node parent) {
        if (this.mRetryRule == null) {
            return;
        }
        this.mRetryRule.serialize(doc, parent);
    }

    public static RetryCondition processXML(Node node, ClientLogger logger) {
        RunCondition dependencies = RunConditions.processCondition(node, logger);
        if (dependencies instanceof RunConditions) {
            return new RetryCondition((RunConditions)dependencies);
        }
        return new RetryCondition(null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RetryCondition)) {
            return false;
        }
        RetryCondition other = (RetryCondition)obj;
        if (this.mRetryRule == null && other.mRetryRule != null || this.mRetryRule != null && other.mRetryRule == null) {
            return false;
        }
        return this.mRetryRule == null || this.mRetryRule.equals(other.mRetryRule);
    }

    public RetryCondition copy() {
        RunCondition retryRule = null;
        if (this.mRetryRule != null) {
            retryRule = this.mRetryRule.copy();
        }
        return new RetryCondition((RunConditions)retryRule);
    }
}

