/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class JobResourceRequirements {
    protected static char TagSeparator = RunHistory.HistorySeparator;
    private static final String JobRunnerIDs_Tag = RunHistory.HistorySeparator + "JobRunnerIDs=";
    private List<String> mJobRunnerIDs = new ArrayList<String>();

    public JobResourceRequirements() {
    }

    public JobResourceRequirements(JobResourceRequirements requirements) {
        this.mJobRunnerIDs.addAll(requirements.mJobRunnerIDs);
    }

    public String getJobRunnerIDString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String id : this.mJobRunnerIDs) {
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(id);
        }
        return buffer.toString();
    }

    public List<String> getJobRunnerIDs() {
        return this.mJobRunnerIDs;
    }

    public void addJobRunner(String jobRunnerID) {
        if (jobRunnerID == null) {
            return;
        }
        if ((jobRunnerID = jobRunnerID.trim()).length() > 0) {
            if (this.mJobRunnerIDs.contains(jobRunnerID)) {
                return;
            }
            this.mJobRunnerIDs.add(jobRunnerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializedForm() {
        StringWriter sw = new StringWriter();
        BufferedWriter writer = new BufferedWriter(sw);
        try {
            this.toSerializedForm(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sw.toString();
    }

    void toSerializedForm(BufferedWriter writer) throws IOException {
        writer.write(JobRunnerIDs_Tag);
        for (String runnerID : this.mJobRunnerIDs) {
            writer.write(RunHistory.getEscapedString(runnerID));
            writer.write(",");
        }
        writer.write(RunHistory.HistorySeparator);
    }

    public static JobResourceRequirements createFromSerializedForm(String data) {
        JobResourceRequirements jrr = new JobResourceRequirements();
        jrr.createFromString(data);
        return jrr;
    }

    protected void createFromString(String data) {
        String runnerString = RunHistory.GetParameterFromHistoryLine(data, JobRunnerIDs_Tag);
        if (runnerString.length() > 0) {
            String[] jobRunnerIDs;
            for (String id : jobRunnerIDs = runnerString.split(",")) {
                this.addJobRunner(RunHistory.getUnescapedString(id));
            }
        }
    }

    public boolean matchesJobRunner(String jobRunnerID) {
        if (jobRunnerID == null) {
            return false;
        }
        if (this.mJobRunnerIDs.size() == 0) {
            return true;
        }
        jobRunnerID = jobRunnerID.trim();
        for (String id : this.mJobRunnerIDs) {
            if (!jobRunnerID.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toSerializedForm();
    }

    public JobResourceRequirements copy() {
        return new JobResourceRequirements(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobResourceRequirements)) {
            return false;
        }
        JobResourceRequirements req = (JobResourceRequirements)obj;
        if (this.mJobRunnerIDs.size() != req.mJobRunnerIDs.size()) {
            return false;
        }
        for (int i = 0; i < this.mJobRunnerIDs.size(); ++i) {
            if (this.mJobRunnerIDs.get(i).equals(req.mJobRunnerIDs.get(i))) continue;
            return false;
        }
        return true;
    }
}

