/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class JobRendererInfo {
    private String mRendererName;
    private List<String> mApplicationIDs;
    private long mLastHeartBeatTime;
    private long mCumulativeJobCount;
    private long mUpTime;
    private int mActiveJobCount;
    protected static final String Tag_Name = "Name=";
    protected static final String Tag_AppIDs = "AppIDs=";
    protected static final String Tag_LastHeartbeat = "LastHeartbeat=";
    protected static final String Tag_TotalJobCount = "TotalJobCount=";
    protected static final String Tag_ActiveJobCount = "ActiveJobCount=";
    protected static final String Tag_UpTime = "UpTime=";
    public static ClientLogger mLogger = FlowManager.getDefaultLogger();

    public JobRendererInfo(String rendererName, List<String> appIDs, long lastHeartBeat, int currentJobCount, long totalJobCount, long upTime) {
        this.mRendererName = rendererName;
        this.mApplicationIDs = appIDs;
        this.mLastHeartBeatTime = lastHeartBeat;
        this.mCumulativeJobCount = totalJobCount;
        this.mActiveJobCount = currentJobCount;
        this.mUpTime = upTime;
    }

    public String getRendererName() {
        return this.mRendererName;
    }

    public List<String> getApplicationIDs() {
        return this.mApplicationIDs;
    }

    public long getLastHeartBeatTime() {
        return this.mLastHeartBeatTime;
    }

    public long getCumulativeJobCount() {
        return this.mCumulativeJobCount;
    }

    public long getUptime() {
        return this.mUpTime;
    }

    public int getActiveJobCount() {
        return this.mActiveJobCount;
    }

    public String serialize() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Tag_Name);
        buffer.append(this.mRendererName);
        buffer.append(RunHistory.HistorySeparator);
        buffer.append(Tag_ActiveJobCount);
        buffer.append(Integer.toString(this.mActiveJobCount));
        buffer.append(RunHistory.HistorySeparator);
        buffer.append(Tag_AppIDs);
        for (String id : this.mApplicationIDs) {
            buffer.append(id);
            buffer.append(",");
        }
        buffer.append(RunHistory.HistorySeparator);
        buffer.append(Tag_LastHeartbeat);
        buffer.append(Long.toString(this.mLastHeartBeatTime));
        buffer.append(RunHistory.HistorySeparator);
        buffer.append(Tag_TotalJobCount);
        buffer.append(Long.toString(this.mCumulativeJobCount));
        buffer.append(RunHistory.HistorySeparator);
        buffer.append(Tag_UpTime);
        buffer.append(Long.toString(this.mUpTime));
        buffer.append(RunHistory.HistorySeparator);
        return buffer.toString();
    }

    public static JobRendererInfo createFromData(String data) {
        String name = FlowHistory.GetParameterFromHistoryLine(data, Tag_Name);
        String idString = FlowHistory.GetParameterFromHistoryLine(data, Tag_AppIDs);
        String[] ids = idString.split(",");
        ArrayList<String> appIDs = new ArrayList<String>();
        for (String id : ids) {
            if (id.length() <= 0) continue;
            appIDs.add(id);
        }
        long totalJobCount = JobRendererInfo.getLongValue(data, Tag_TotalJobCount);
        long upTime = JobRendererInfo.getLongValue(data, Tag_UpTime);
        long lastHeartbeat = JobRendererInfo.getLongValue(data, Tag_LastHeartbeat);
        long activeJobCount = JobRendererInfo.getLongValue(data, Tag_ActiveJobCount);
        return new JobRendererInfo(name, appIDs, lastHeartbeat, (int)activeJobCount, totalJobCount, upTime);
    }

    private static long getLongValue(String data, String tag) {
        String numString = FlowHistory.GetParameterFromHistoryLine(data, tag);
        try {
            return Long.parseLong(numString);
        }
        catch (NumberFormatException e) {
            mLogger.logMessage(Level.WARNING, e);
            return -1L;
        }
    }
}

