/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.JobHistory;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FlowInstance {
    private FlowHistory mFlowHistory;
    private Flow mFlow;
    protected ClientLogger mLogger;
    static final String XML_FlowInstanceFile_Tag = "FlowInstanceFile";
    static final String XML_History_Tag = "RunInfo";
    private static final String CREscape = "[char{13}]";
    private static final String NLEscape = "[char{10}]";

    public FlowInstance(ClientLogger logger) {
        this.mLogger = logger;
    }

    public FlowInstance(Flow flow, FlowHistory fh) {
        this(fh.getLogger());
        this.mFlow = flow;
        this.mFlowHistory = fh;
    }

    public FlowHistory getFlowHistory() {
        return this.mFlowHistory;
    }

    public void setFlowHistory(FlowHistory flowHistory) {
        if (flowHistory != null) {
            this.mFlowHistory = flowHistory;
        }
    }

    public static FlowInstance createFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        InputSource source = new InputSource(xmlReader);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = dbf.newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_FlowInstanceFile_Tag)) continue;
                FlowInstance instance = FlowInstance.processInstanceFileTag(node, logger);
                return instance;
            }
        }
        catch (SAXException dbf) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        return null;
    }

    private static FlowInstance processInstanceFileTag(Node node, ClientLogger logger) {
        FlowInstance instance = new FlowInstance(logger);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_History_Tag)) {
                String tagValue = ExecutionItem.getCData(child);
                if (tagValue == null) continue;
                FlowHistory flowHistory = FlowHistory.GetHistoryFromString(tagValue, logger);
                instance.setFlowHistory(flowHistory);
                continue;
            }
            if (!tagName.equals("Flow")) continue;
            TopLevelFlow flow = TopLevelFlow.processTopFlowTag(child, logger);
            instance.setFlow(flow);
        }
        return instance;
    }

    public Flow getFlow() {
        return this.mFlow;
    }

    public void setFlow(Flow flow) {
        if (flow != null) {
            this.mFlow = flow;
        }
    }

    public String toSerializedForm() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(XML_FlowInstanceFile_Tag);
            doc.appendChild(root);
            this.mFlow.serialize(doc, root);
            Element historyTag = doc.createElement(XML_History_Tag);
            root.appendChild(historyTag);
            CDATASection historySection = doc.createCDATASection(this.mFlowHistory.toSerializedForm());
            historyTag.appendChild(historySection);
            return FlowInstance.emitXML(doc, this.mLogger);
        }
        catch (ParserConfigurationException e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    public static String emitXML(Document doc, ClientLogger logger) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(doc), result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            logger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    public static String getUnescapeData(String instanceData) {
        instanceData = instanceData.replace(NLEscape, "\n");
        instanceData = instanceData.replace(CREscape, "\r");
        return instanceData;
    }

    public static String getEscapedData(String instanceData) {
        instanceData = instanceData.replace("\n", NLEscape);
        instanceData = instanceData.replace("\r", CREscape);
        return instanceData;
    }

    public void restoreFlowState(RunningFlow rFlow) {
        HashMap<String, RunHistory> historyMap = new HashMap<String, RunHistory>();
        this.populateHistoryMap(this.getFlowHistory(), historyMap);
        this.restoreFlowState(rFlow, historyMap);
    }

    private void populateHistoryMap(FlowHistory history, Map<String, RunHistory> historyMap) {
        historyMap.put(history.getUniqueID(), history);
        for (RunHistory subHist : history.getSubHistories()) {
            if (subHist instanceof FlowHistory) {
                this.populateHistoryMap((FlowHistory)subHist, historyMap);
                continue;
            }
            historyMap.put(subHist.getUniqueID(), subHist);
        }
    }

    private void restoreFlowState(RunningFlow rFlow, Map<String, RunHistory> historyMap) {
        RunHistory history = historyMap.get(rFlow.getUniqueID());
        if (history != null && history instanceof FlowHistory) {
            FlowHistory hist = (FlowHistory)history;
            rFlow.initializeFromHistory(hist);
        }
        List<RunningItem> subItems = rFlow.getSubItems();
        for (RunningItem item : subItems) {
            if (item instanceof RunningFlow) {
                this.restoreFlowState((RunningFlow)item, historyMap);
                continue;
            }
            if (!(item instanceof RunningJob)) continue;
            this.restoreJobState((RunningJob)item, historyMap);
        }
    }

    private void restoreJobState(RunningJob rJob, Map<String, RunHistory> historyMap) {
        RunHistory history = historyMap.get(rJob.getUniqueID());
        if (history != null && history instanceof JobHistory) {
            rJob.initializeFromHistory((JobHistory)history);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowInstance)) {
            return false;
        }
        FlowInstance other = (FlowInstance)obj;
        if (!other.mFlow.equals(this.mFlow)) {
            return false;
        }
        if (!other.mFlowHistory.equals(this.mFlowHistory)) {
            return false;
        }
        return super.equals(obj);
    }
}

