/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.JobHistory;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class FlowHistory
extends RunHistory {
    private List<RunHistory> mSubHistories;
    private String mInstanceID;
    private String mFlowID;
    private short mAccessFlags;
    private String mOwner;
    private String mInvoker;
    private long mExitCode;
    static final String TopLevelFlowTerminatorLine = "#";
    private static final String Type_Tag = HistorySeparator + "Type=";
    private static final String Count_Tag = HistorySeparator + "Count=";
    private static final String InstanceID_Tag = HistorySeparator + "InstanceID=";
    private static final String FlowID_Tag = HistorySeparator + "FlowID=";
    private static final String UserAccess_Tag = HistorySeparator + "UserAccess=";
    private static final String Owner_Tag = HistorySeparator + "Owner=";
    private static final String ExitCode_Tag = HistorySeparator + "ExitCode=";
    private static final String Invoker_Tag = HistorySeparator + "Invoker=";

    public FlowHistory(ClientLogger logger) {
        super(logger);
        this.mSubHistories = new ArrayList<RunHistory>();
        this.mCompletionCode = 16;
        this.mInstanceID = "";
        this.mOwner = "";
        this.mAccessFlags = 0;
        this.mExitCode = 0L;
        this.mInvoker = "";
    }

    public FlowHistory(RunningFlow completedFlow, ClientLogger logger) {
        super(completedFlow, logger);
        this.mFlowID = "";
        this.mInstanceID = "";
        this.mOwner = "";
        this.mAccessFlags = 0;
        this.mExitCode = completedFlow.getExitCode();
        this.mInvoker = "";
        if (completedFlow.getFlow() instanceof TopLevelFlow) {
            this.mFlowID = ((TopLevelFlow)completedFlow.getFlow()).getID();
            this.mInstanceID = completedFlow.getID();
            this.mOwner = ((TopLevelFlow)completedFlow.getFlow()).getOwner();
            this.mAccessFlags = ((TopLevelFlow)completedFlow.getFlow()).getUserAccessFlags();
            this.mInvoker = completedFlow.getInvokingUser();
        }
        this.mUniqueItemID = completedFlow.getFlow().getUniqueID();
        this.mSubHistories = new ArrayList<RunHistory>();
        for (RunningItem rItem : completedFlow.getSubItems()) {
            if (rItem instanceof RunningFlow) {
                FlowHistory flowHistory = new FlowHistory((RunningFlow)rItem, this.mLogger);
                this.mSubHistories.add(flowHistory);
                continue;
            }
            if (!(rItem instanceof RunningJob)) continue;
            JobHistory jobHistory = new JobHistory((RunningJob)rItem, this.mLogger);
            this.mSubHistories.add(jobHistory);
        }
    }

    protected void addHistory(RunHistory history) {
        this.mSubHistories.add(history);
    }

    public String getInvoker() {
        return this.mInvoker;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getFlowID() {
        return this.mFlowID;
    }

    public String getID() {
        return this.mInstanceID;
    }

    public List<RunHistory> getSubHistories() {
        return this.mSubHistories;
    }

    boolean isPublicHistory() {
        return (this.mAccessFlags & 0x200) > 0;
    }

    boolean isInvokerHistory() {
        return (this.mAccessFlags & 0x400) > 0;
    }

    public long getExitCode() {
        return this.mExitCode;
    }

    @Override
    protected void toSerializedForm(StringBuffer buffer) {
        buffer.append(Type_Tag);
        buffer.append("Flow");
        buffer.append(Count_Tag);
        buffer.append(this.mSubHistories.size());
        if (this.mInstanceID.length() > 0) {
            buffer.append(InstanceID_Tag);
            buffer.append(this.mInstanceID);
        }
        if (this.mFlowID.length() > 0) {
            buffer.append(FlowID_Tag);
            buffer.append(this.mFlowID);
        }
        buffer.append(UserAccess_Tag);
        buffer.append(this.mAccessFlags);
        if (this.mOwner.length() > 0) {
            buffer.append(Owner_Tag);
            buffer.append(this.mOwner);
        }
        if (this.mInvoker.length() > 0) {
            buffer.append(Invoker_Tag);
            buffer.append(this.mInvoker);
        }
        buffer.append(ExitCode_Tag);
        buffer.append(this.mExitCode);
        super.toSerializedForm(buffer);
        buffer.append(HistorySeparator);
        for (RunHistory history : this.mSubHistories) {
            buffer.append('\n');
            history.toSerializedForm(buffer);
        }
    }

    @Override
    protected int getFullSubItemCount() {
        int count = 0;
        for (RunHistory history : this.mSubHistories) {
            count += history.getFullSubItemCount() + 1;
        }
        return count;
    }

    protected static int GetNumberOfLinesAssociatedWithFlow(String flowLine) {
        String numberString = RunHistory.GetParameterFromHistoryLine(flowLine, Count_Tag);
        int count = Integer.parseInt(numberString);
        return count;
    }

    protected static String GetFlowID(String flowLine) {
        String idString = RunHistory.GetParameterFromHistoryLine(flowLine, FlowID_Tag);
        return idString;
    }

    protected static String GetInstanceID(String flowLine) {
        String idString = RunHistory.GetParameterFromHistoryLine(flowLine, InstanceID_Tag);
        return idString;
    }

    public static FlowHistory GetHistoryFromString(String data, ClientLogger logger) {
        BufferedReader reader = new BufferedReader(new StringReader(data));
        FlowHistory history = new FlowHistory(logger);
        try {
            String flowLine = reader.readLine();
            history.createFromData(flowLine, reader);
            reader.close();
            return history;
        }
        catch (NullPointerException e) {
            logger.logMessage(Level.WARNING, e);
            return null;
        }
        catch (IOException e) {
            logger.logMessage(Level.WARNING, e);
            return null;
        }
    }

    public static List<FlowHistory> GetHistoriesOfFlow(BufferedReader reader, String flowID, int resultCount, ClientLogger logger) {
        ArrayList<FlowHistory> results = new ArrayList<FlowHistory>();
        if (resultCount < 0) {
            return results;
        }
        try {
            String flowLine;
            while ((flowLine = reader.readLine()) != null) {
                String line;
                if (flowID == null || FlowHistory.GetFlowID(flowLine).equals(flowID)) {
                    FlowHistory history = new FlowHistory(logger);
                    try {
                        history.createFromData(flowLine, reader);
                    }
                    catch (RuntimeException e) {
                        logger.logMessage(Level.WARNING, e);
                    }
                    results.add(history);
                    if (resultCount > 0 && results.size() >= resultCount) break;
                }
                while ((line = reader.readLine()) != null && !line.equals(TopLevelFlowTerminatorLine)) {
                }
            }
        }
        catch (IOException e) {
            logger.logMessage(Level.WARNING, e);
        }
        return results;
    }

    protected void createFromData(String flowLine, BufferedReader reader) {
        this.mInstanceID = RunHistory.GetParameterFromHistoryLine(flowLine, InstanceID_Tag);
        this.mFlowID = RunHistory.GetParameterFromHistoryLine(flowLine, FlowID_Tag);
        this.mOwner = RunHistory.GetParameterFromHistoryLine(flowLine, Owner_Tag);
        this.mInvoker = RunHistory.GetParameterFromHistoryLine(flowLine, Invoker_Tag);
        String exitCodeString = RunHistory.GetParameterFromHistoryLine(flowLine, ExitCode_Tag);
        try {
            if (exitCodeString.length() > 0) {
                this.mExitCode = Long.parseLong(exitCodeString);
            }
        }
        catch (NumberFormatException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        String accessString = RunHistory.GetParameterFromHistoryLine(flowLine, UserAccess_Tag);
        try {
            if (accessString.length() > 0) {
                this.mAccessFlags = Short.valueOf(accessString);
            }
        }
        catch (NumberFormatException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        super.createFromData(flowLine);
        int count = FlowHistory.GetNumberOfLinesAssociatedWithFlow(flowLine);
        for (int i = 0; i < count; ++i) {
            try {
                RunHistory history;
                String line = reader.readLine();
                String historyType = RunHistory.GetParameterFromHistoryLine(line, Type_Tag);
                if (historyType.equals("Flow")) {
                    history = new FlowHistory(this.mLogger);
                    ((FlowHistory)history).createFromData(line, reader);
                    this.addHistory(history);
                    continue;
                }
                history = new JobHistory(this.mLogger);
                ((JobHistory)history).createFromData(line);
                this.addHistory(history);
                continue;
            }
            catch (NullPointerException e) {
                this.mLogger.logMessage(Level.WARNING, e);
                continue;
            }
            catch (IOException e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
        }
    }

    static List<String> GetInstanceIDs(BufferedReader reader) throws IOException {
        String data;
        ArrayList<String> results = new ArrayList<String>();
        while ((data = reader.readLine()) != null) {
            String instanceID = FlowHistory.GetInstanceID(data);
            if (instanceID.length() > 0) {
                results.add(instanceID);
            }
            FlowHistory.SkipHistoryInstance(reader, null);
        }
        return results;
    }

    static boolean SkipHistoryInstance(BufferedReader reader, StringBuffer outputBuffer) throws IOException {
        String data;
        do {
            if ((data = reader.readLine()) == null) {
                return true;
            }
            if (outputBuffer == null) continue;
            outputBuffer.append(data);
            outputBuffer.append('\n');
        } while (!data.equals(TopLevelFlowTerminatorLine));
        return false;
    }
}

