/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FileDependency;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileAgeDependency
extends FileDependency
implements FileStatusListener {
    static final String XML_FileAgeDependency_Tag = "FileAgeDependency";
    private static final String XML_Age_Tag = "Age";
    private int mComparisonCode;
    private long mComparisonAge;
    private transient long mPreviousCheckTimestamp;
    private transient boolean mPreviousStatus;
    private transient boolean mManualTrigger;
    private transient long mManualTimestamp;

    public FileAgeDependency(String filePath, int comparisonCode, long age, ClientLogger logger) {
        super(filePath, logger);
        this.mComparisonCode = comparisonCode;
        this.mComparisonAge = age;
        this.mPreviousStatus = false;
        this.mPreviousCheckTimestamp = -2L;
        this.mManualTrigger = false;
        this.mManualTimestamp = -2L;
    }

    public FileAgeDependency(ClientLogger logger) {
        super(logger);
        this.mComparisonCode = 10;
        this.mComparisonAge = 0L;
        this.mPreviousStatus = false;
        this.mPreviousCheckTimestamp = -2L;
        this.mManualTrigger = false;
        this.mManualTimestamp = -2L;
    }

    public int getComparisonCode() {
        return this.mComparisonCode;
    }

    public void setComparisonCode(int comparisonCode) {
        if (comparisonCode == 12 || comparisonCode == 15 || comparisonCode == 10 || comparisonCode == 13 || comparisonCode == 11 || comparisonCode == 14) {
            this.mComparisonCode = comparisonCode;
        }
    }

    public long getAge() {
        return this.mComparisonAge;
    }

    public void setAge(long age) {
        if (age >= 0L) {
            this.mComparisonAge = age;
        }
    }

    @Override
    public void manuallyMakeConditionValid(boolean isTrigger) {
        this.mManualTrigger = true;
        this.mManualTimestamp = System.currentTimeMillis();
        if (isTrigger) {
            this.setTriggerRestriction(true);
        }
    }

    private long getLastModified(File f) {
        if (this.mManualTrigger) {
            return this.mManualTimestamp;
        }
        return this.fileLastModified(f);
    }

    @Override
    protected boolean isConditionSatisfied(boolean[] outputDataChanged) {
        long oldStamp = this.mPreviousCheckTimestamp;
        File f = new File(this.getFilePath());
        if (!this.mManualTrigger && !this.fileExists(f)) {
            this.mPreviousCheckTimestamp = -1L;
            outputDataChanged[0] = this.mPreviousCheckTimestamp != oldStamp;
            return false;
        }
        this.mPreviousCheckTimestamp = this.getLastModified(f);
        long fileAge = (System.currentTimeMillis() - this.mPreviousCheckTimestamp) / 1000L;
        boolean oldStatus = this.mPreviousStatus;
        this.mPreviousStatus = this.checkCondition(fileAge);
        outputDataChanged[0] = this.mPreviousCheckTimestamp != oldStamp || this.mPreviousStatus != oldStatus;
        return this.mPreviousStatus;
    }

    private boolean checkCondition(long fileAge) {
        switch (this.mComparisonCode) {
            case 10: {
                if (fileAge <= this.mComparisonAge) break;
                return true;
            }
            case 11: {
                if (fileAge >= this.mComparisonAge) break;
                return true;
            }
            case 12: {
                if (fileAge != this.mComparisonAge) break;
                return true;
            }
            case 15: {
                if (fileAge == this.mComparisonAge) break;
                return true;
            }
            case 13: {
                if (fileAge < this.mComparisonAge) break;
                return true;
            }
            case 14: {
                if (fileAge > this.mComparisonAge) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_FileAgeDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Age_Tag, Long.toString(this.mComparisonAge));
        tag.setAttribute("ComparisonCode", Integer.toString(this.mComparisonCode));
    }

    @Override
    public RunCondition copy() {
        FileAgeDependency dep = new FileAgeDependency(this.getFilePath(), this.getComparisonCode(), this.getAge(), this.mLogger);
        dep.setTriggerRestriction(this.getTriggerRestriction());
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Runs if file: " + this.getFilePath() + " ");
        switch (this.mComparisonCode) {
            case 12: {
                printString.append("=");
                break;
            }
            case 15: {
                printString.append("!=");
                break;
            }
            case 10: {
                printString.append(">");
                break;
            }
            case 13: {
                printString.append(">=");
                break;
            }
            case 11: {
                printString.append("<");
                break;
            }
            case 14: {
                printString.append("<=");
            }
        }
        printString.append(this.mComparisonAge);
        printString.append(" bytes.");
        if (!this.getTriggerRestriction()) {
            printString.append("Trigger valid whenever the condition is true.");
        } else {
            printString.append("Trigger valid only when condition becomes true.");
        }
        return printString.toString();
    }

    public static RunCondition processAgeCondition(Node node, ClientLogger logger) {
        Node triggerRestrictionNode;
        Node comparisonNode;
        FileAgeDependency dependency = new FileAgeDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node ageNode = attributes.getNamedItem(XML_Age_Tag);
        if (ageNode != null) {
            dependency.setAge(Long.valueOf(ageNode.getNodeValue()));
        }
        if ((comparisonNode = attributes.getNamedItem("ComparisonCode")) != null) {
            dependency.setComparisonCode(Integer.valueOf(comparisonNode.getNodeValue()));
        }
        if ((triggerRestrictionNode = attributes.getNamedItem("RestrictTrigger")) != null) {
            dependency.setTriggerRestriction(Boolean.valueOf(triggerRestrictionNode.getNodeValue()));
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!tagName.equals("FilePath")) continue;
            String filePath = ExecutionItem.getCData(child);
            dependency.setFilePath(filePath);
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileAgeDependency)) {
            return false;
        }
        FileAgeDependency other = (FileAgeDependency)obj;
        if (other.mComparisonAge != this.mComparisonAge) {
            return false;
        }
        if (other.mComparisonCode != this.mComparisonCode) {
            return false;
        }
        return super.equals(obj);
    }
}

