/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.ip.ExtraJobOptions;
import com.sas.scheduler.api.servers.ip.IPCalendar;
import com.sas.scheduler.api.servers.ip.IPFlowHistory;
import com.sas.scheduler.api.servers.ip.IPJob;
import com.sas.scheduler.api.servers.ip.IPJobEvent;
import com.sas.scheduler.api.servers.ip.SchedulerInitializationCallback;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.AssociatedAction;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.EmailItemStatusAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.FileAgeDependency;
import com.sas.scheduler.api.servers.ip.engine.FileExistsDependency;
import com.sas.scheduler.api.servers.ip.engine.FileSizeDependency;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunItemStatusDependency;
import com.sas.scheduler.api.servers.ip.engine.SimpleProcessProvider;
import com.sas.scheduler.api.servers.ip.engine.TimeDependency;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.Timezone;
import com.sas.scheduler.model.TriggerEventInfo;
import java.io.BufferedReader;
import java.io.StringReader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPScheduler
extends SchedulerIMPL
implements Scheduler {
    private static final Logger LOGGER = LogManager.getLogger(IPScheduler.class);
    private static ClientLogger mLogger;
    private static Level mDefaultLogLevel;
    private static final ResourceBundle m_bundle;
    protected AbstractUserSession mSession = null;
    protected static Map<String, FlowManager> mFlowManagerMap;
    private Map<Long, com.sas.scheduler.api.servers.FlowHistory> mInstanceMap = new HashMap<Long, com.sas.scheduler.api.servers.FlowHistory>();

    public IPScheduler(SchedulerServerInfo info) {
        super(info);
        if (mFlowManagerMap == null) {
            mFlowManagerMap = new HashMap<String, FlowManager>();
        }
    }

    public void redeployAllFlows(final SchedulerInitializationCallback initCallback) {
        Thread schedulerInitializer = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<FlowInfo> flows = IPScheduler.this.getDeployedFlowsForServerComponent(initCallback.getJomaStore());
                    for (FlowInfo flow : flows) {
                        try {
                            String[] credentials = initCallback.getSchedulerCredentials(flow);
                            try {
                                int rc = IPScheduler.this.makeConnection(credentials[0], credentials[1]);
                                if (rc != 1) continue;
                                try {
                                    AbstractUserSession abstractUserSession = IPScheduler.this.getUserSession();
                                    synchronized (abstractUserSession) {
                                        boolean executeIfRunNow = false;
                                        IPScheduler.this.scheduleFlowInternal(flow, false, executeIfRunNow, true);
                                    }
                                }
                                finally {
                                    IPScheduler.this.closeConnection();
                                }
                            }
                            catch (SchedulerException e) {
                                if (!IPScheduler.this.isDebug()) continue;
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            if (!IPScheduler.this.isDebug()) continue;
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    if (IPScheduler.this.isDebug()) {
                        e.printStackTrace();
                    }
                }
                finally {
                    initCallback.schedulerInitializationCompleted();
                }
            }
        });
        schedulerInitializer.start();
    }

    public void initializeScheduler(ExecutionProvider serviceProvider, ClientLogger logger, SchedulerInitializationCallback initCallback) throws SecurityException {
        if (mFlowManagerMap.containsKey(this.m_schedulingServer.getName())) {
            return;
        }
        if (this.isDebug()) {
            FlowManager.setDefaultLogLevel(Level.FINEST);
        }
        FlowManager f = FlowManager.createFlowManager(serviceProvider, logger);
        mFlowManagerMap.put(this.m_schedulingServer.getName(), f);
        if (initCallback != null) {
            this.redeployAllFlows(initCallback);
        }
    }

    @Override
    public Calendar getCalendar(String schedulerCalenderName) {
        IPCalendar cal = new IPCalendar();
        return cal;
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) {
        IPCalendar cal = new IPCalendar(info);
        cal.setDays(info);
        cal.setDescription(info.toXML());
        return cal;
    }

    @Override
    public Calendar createCalendar(IRecurrenceInfo info) {
        return this.getCalendar(info);
    }

    @Override
    public String getClassId() {
        return "c8b4baf0-5f9f-471e-ba76-1201e1e81aef";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        AbstractUserSession abstractUserSession = this.getUserSession();
        synchronized (abstractUserSession) {
            return this.scheduleFlowInternal(flow, false, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        AbstractUserSession abstractUserSession = this.getUserSession();
        synchronized (abstractUserSession) {
            return this.scheduleFlowInternal(flow, true, true, false);
        }
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException, UnsupportedOperationException {
        return this.scheduleFlow(flow) ? 0 : 2;
    }

    protected boolean scheduleFlowInternal(FlowInfo flow, boolean runNowOverride, boolean executeIfRunNow, boolean redeployment) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        boolean success = true;
        try {
            flow.setScheduleID(-2L);
            TopLevelFlow topFlow = (TopLevelFlow)this.processFlow(flow, true);
            TriggerEventInfo trigger = flow.getTriggerEvent();
            String triggerType = flow.getTriggerType();
            if (triggerType == null || triggerType.equals("RunNow") || triggerType.equals("Manual")) {
                trigger = null;
            }
            String flowID = null;
            if (runNowOverride) {
                flowID = flow.getScheduleDefinitionId();
            } else {
                flowID = this.genFlowName(flow);
                flow.setScheduleDefinitionId(flowID);
            }
            TopLevelFlow[] existingFlows = new TopLevelFlow[]{};
            existingFlows = this.getUserSession().getFlowDefinitions(new String[]{flowID});
            if (existingFlows.length > 0) {
                if (redeployment) {
                    return true;
                }
                topFlow.setID(flowID);
            } else if (redeployment) {
                topFlow.setID(flowID);
            } else {
                flowID = "";
                flow.setScheduleDefinitionId(flowID);
            }
            topFlow.setPublicHistory(true);
            if (!runNowOverride && trigger != null && trigger.getEvent() != null) {
                RunCondition condition = this.getTriggeringEvent(trigger);
                if (condition != null) {
                    topFlow.setTriggerConditions(condition);
                } else {
                    success = false;
                }
            }
            if (success) {
                boolean pushedToScheduler = false;
                if (flowID.length() > 0 && existingFlows.length > 0) {
                    if (runNowOverride) {
                        topFlow.setTriggerConditions(existingFlows[0].getTriggerConditions().copy());
                        pushedToScheduler = this.getUserSession().updateFlow(topFlow);
                    } else {
                        pushedToScheduler = this.getUserSession().updateFlow(topFlow);
                    }
                } else {
                    topFlow.clearID();
                    String[] ids = this.getUserSession().addFlows(new TopLevelFlow[]{topFlow});
                    boolean bl = pushedToScheduler = ids[0] != null;
                    if (pushedToScheduler) {
                        flowID = ids[0];
                        flow.setScheduleDefinitionId(flowID);
                    }
                }
                if (pushedToScheduler) {
                    String[] createdInstanceIDs;
                    flow.setFlowSubmitted(true, this.getCurrentUserID());
                    if ((runNowOverride || executeIfRunNow && (triggerType == null || triggerType.equals("RunNow"))) && (createdInstanceIDs = this.getUserSession().runFlows(new String[]{flowID}))[0] == null) {
                        success = false;
                    }
                } else {
                    success = false;
                }
            }
            return success;
        }
        catch (RuntimeException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            ex.initCause((Throwable)ioe);
            throw ex;
        }
    }

    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws UnsupportedOperationException, SchedulerException {
        boolean rc;
        if (this.getUserSession() == null) {
            return false;
        }
        String flowID = flow.getScheduleDefinitionId();
        if (flowID == null || flowID.length() == 0) {
            String flowName = this.genFlowName(flow);
            flowID = this.getUserSession().getFlowID(flowName);
        }
        if (rc = this.removeFlowByID(flowID)) {
            flow.setFlowSubmitted(false);
            flow.setScheduleDefinitionId("");
        }
        return rc;
    }

    @Override
    public boolean removeFlow(String flowName) throws UnsupportedOperationException {
        if (this.getUserSession() == null) {
            return false;
        }
        String flowID = this.getUserSession().getFlowID(flowName);
        if (flowID == null) {
            return false;
        }
        return this.removeFlowByID(flowID);
    }

    private boolean removeFlowByID(String flowID) {
        if (this.getUserSession() == null) {
            return false;
        }
        String[] failedItems = this.getUserSession().deleteFlows(new String[]{flowID});
        return failedItems.length == 0;
    }

    @Override
    public long getFlowInstance(FlowInfo flow) {
        com.sas.scheduler.api.servers.FlowHistory history = this.getFlowHistory(flow);
        if (history != null) {
            long instanceID = history.getID();
            if (instanceID >= 0L) {
                this.mInstanceMap.put(new Long(instanceID), history);
            }
            return instanceID;
        }
        return -2L;
    }

    private com.sas.scheduler.api.servers.FlowHistory getHistoryFromInstanceID(long instanceID) {
        com.sas.scheduler.api.servers.FlowHistory history = this.mInstanceMap.get(new Long(instanceID));
        if (history != null) {
            return history;
        }
        return null;
    }

    @Override
    public Date getFinishTime(long id) {
        com.sas.scheduler.api.servers.FlowHistory history = this.getHistoryFromInstanceID(id);
        if (history == null) {
            return null;
        }
        return history.getFinishTime();
    }

    @Override
    public Date getStartTime(long id) {
        com.sas.scheduler.api.servers.FlowHistory history = this.getHistoryFromInstanceID(id);
        if (history == null) {
            return null;
        }
        return history.getStartTime();
    }

    @Override
    public int getState(long id) {
        com.sas.scheduler.api.servers.FlowHistory history = this.getHistoryFromInstanceID(id);
        if (history == null) {
            return -1;
        }
        return history.getState();
    }

    @Override
    public int getStatus(long id) {
        com.sas.scheduler.api.servers.FlowHistory history = this.getHistoryFromInstanceID(id);
        if (history == null) {
            return -1;
        }
        return history.getStatus();
    }

    @Override
    public String genFlowName(FlowInfo info) {
        return MetaUtilities.makeValidFlowName(info.getName());
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        FlowManager manager = mFlowManagerMap.get(this.m_schedulingServer.getName());
        if (manager != null) {
            return manager.getMaxHistoryRecordsPerFlow();
        }
        SimpleProcessProvider epb = new SimpleProcessProvider(IPScheduler.getLogger(), null, 1);
        return epb.getMaxHistoryRecordsPerFlow();
    }

    @Override
    public com.sas.scheduler.api.servers.FlowHistory getFlowHistory(FlowInfo flow) {
        List flowHistories = this.getFlowHistoryList(flow, 1);
        if (flowHistories.size() == 0) {
            return null;
        }
        return (com.sas.scheduler.api.servers.FlowHistory)flowHistories.get(0);
    }

    public List getFlowHistoryList(String userid, int count) {
        ArrayList<IPFlowHistory> flowHistories = new ArrayList<IPFlowHistory>();
        if (this.getUserSession() == null) {
            return flowHistories;
        }
        if (count < 0) {
            return flowHistories;
        }
        HistorySearchOptions searchOptions = new HistorySearchOptions();
        searchOptions.setCountPerFlow(count);
        searchOptions.setOwner(userid);
        FlowHistory[] histories = this.getUserSession().getFlowHistory(searchOptions);
        for (int i = 0; i < histories.length; ++i) {
            IPFlowHistory history = new IPFlowHistory(histories[i].getItemName(), histories[i]);
            flowHistories.add(history);
        }
        return flowHistories;
    }

    public List getFlowHistoryList(FlowInfo flow, int count) {
        ArrayList<IPFlowHistory> flowHistories = new ArrayList<IPFlowHistory>();
        if (this.getUserSession() == null) {
            return flowHistories;
        }
        if (count < 0) {
            return flowHistories;
        }
        String flowID = flow.getScheduleDefinitionId();
        if (flowID.length() == 0) {
            String flowGenName = this.genFlowName(flow);
            flowID = this.getUserSession().getFlowID(flowGenName);
        }
        if (flowID != null) {
            FlowHistory[] histories = this.getUserSession().getFlowHistory(new String[]{flowID}, count);
            for (int i = 0; i < histories.length; ++i) {
                IPFlowHistory history = new IPFlowHistory(flow.getName(), histories[i]);
                flowHistories.add(history);
            }
        }
        return flowHistories;
    }

    public List getAllFlowHistory() {
        ArrayList<IPFlowHistory> flowHistories = new ArrayList<IPFlowHistory>();
        if (this.getUserSession() == null) {
            return flowHistories;
        }
        HistorySearchOptions searchOptions = new HistorySearchOptions();
        FlowHistory[] histories = this.getUserSession().getFlowHistory(searchOptions);
        for (int i = 0; i < histories.length; ++i) {
            IPFlowHistory history = new IPFlowHistory(histories[i].getItemName(), histories[i]);
            flowHistories.add(history);
        }
        return flowHistories;
    }

    public List getFlowHistoryList(String userid, List flowList, int count) {
        String flowName;
        ArrayList<IPFlowHistory> flowHistories = new ArrayList<IPFlowHistory>();
        if (count < 0) {
            return flowHistories;
        }
        if (this.getUserSession() == null) {
            return flowHistories;
        }
        ArrayList<String> flowIDs = new ArrayList<String>();
        for (FlowInfo flow : flowList) {
            String flowID = flow.getScheduleDefinitionId();
            if (flowID.length() == 0) {
                flowName = this.genFlowName(flow);
                flowID = this.getUserSession().getFlowID(flowName);
            }
            flowIDs.add(flowID);
        }
        FlowHistory[] histories = this.getUserSession().getFlowHistory(flowIDs.toArray(new String[0]), count);
        for (int i = 0; i < histories.length; ++i) {
            flowName = histories[i].getItemName();
            int firstColon = flowName.indexOf(58);
            if (firstColon >= 0) {
                flowName = flowName.substring(firstColon + 1);
            }
            IPFlowHistory history = new IPFlowHistory(flowName, histories[i]);
            flowHistories.add(history);
        }
        return flowHistories;
    }

    public List getFlowHistoryList(FlowInfo flow) {
        return this.getFlowHistoryList(flow, 0);
    }

    @Override
    public boolean isFlowScheduled(String flowName) {
        if (this.getUserSession() == null) {
            return false;
        }
        String flowID = this.getUserSession().getFlowID(flowName);
        return flowID != null;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        if (this.getUserSession() == null) {
            return flow.isFlowSubmitted();
        }
        String flowID = flow.getScheduleDefinitionId();
        if (flowID != null && flowID.length() > 0) {
            return this.getUserSession().getFlowDefinitions(new String[]{flowID}).length > 0;
        }
        String flowName = this.genFlowName(flow);
        return this.isFlowScheduled(flowName);
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) throws SchedulerException {
        if (this.getUserSession() == null) {
            throw new SchedulerException();
        }
        return this.isFlowScheduled(flow);
    }

    @Override
    public boolean isValidFlowName(String name) {
        int namelen = name.length();
        return namelen != 0;
    }

    @Override
    public boolean isValidJobName(String name) {
        return IPJob.isValidName(name);
    }

    @Override
    public String getInvalidChars(boolean flow) {
        return "";
    }

    @Override
    public boolean closeConnection() {
        if (this.getUserSession() == null) {
            return false;
        }
        super.closeConnection();
        this.getUserSession().terminateSession();
        return true;
    }

    @Override
    public boolean isHistorySupported() throws InvalidParameterException {
        if (this.m_schedulingServer == null) {
            throw new InvalidParameterException();
        }
        return true;
    }

    @Override
    public boolean isJobDependenciesEnabled() throws InvalidParameterException {
        return true;
    }

    protected Flow processFlow(FlowInfo flow, boolean topLevel) throws InvalidParameterException, SchedulerException {
        Flow newFlow = null;
        String flowname = this.genFlowName(flow);
        if (topLevel) {
            newFlow = new TopLevelFlow(IPScheduler.getLogger());
            ((TopLevelFlow)newFlow).setInstanceLimit(flow.hasExclusive() ? 1 : 0);
            newFlow.setUserName(this.getCurrentUserID());
            ((TopLevelFlow)newFlow).setOwner(this.getCurrentUserID());
        } else {
            newFlow = new Flow(IPScheduler.getLogger());
        }
        try {
            flow.checkCircularDependencies();
        }
        catch (InvalidParameterException ex) {
            InvalidParameterException e = new InvalidParameterException(IPScheduler.createCircularDependencyMessage(null, ex.getMessage(), flow));
            throw e;
        }
        newFlow.setDescription(flow.getDescription());
        newFlow.setName(flowname);
        List<AssociatedAction> associatedActions = this.getEmailActions(flow.emailNotificationLevel(), flow.emailAddress(), "", "");
        newFlow.setAssociatedTasks(associatedActions);
        associatedActions = this.getEmailActions(flow.jobDefaultEmailNotificationLevel(), flow.jobDefaultEmailAddress(), "", "");
        List jobs = flow.getJobs();
        ArrayList<ExecutionItem> jfjobs = new ArrayList<ExecutionItem>();
        HashMap<String, ExecutionItem> jobMap = new HashMap<String, ExecutionItem>();
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            if (job instanceof JobInfo) {
                Job j = this.processJob((JobInfo)job);
                j.setAssociatedTasks(associatedActions);
                jfjobs.add(j);
                jobMap.put(job.getId(), j);
                continue;
            }
            if (!(job instanceof FlowInfo)) continue;
            Flow f = this.processSubflow((FlowInfo)job);
            jfjobs.add(f);
            jobMap.put(job.getId(), f);
        }
        int ipPriority = 50;
        int defaultPriority = flow.getJobDefaultPriority();
        switch (defaultPriority) {
            case 0: {
                ipPriority = 100;
                break;
            }
            case 1: {
                ipPriority = 75;
                break;
            }
            case 2: {
                ipPriority = 50;
                break;
            }
            case 3: {
                ipPriority = 25;
                break;
            }
            case 4: {
                ipPriority = 0;
            }
        }
        newFlow.setPriority(ipPriority, true);
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            ExecutionItem obj = (ExecutionItem)jfjobs.get(i);
            if (obj instanceof Job) {
                this.processJobEvents(newFlow, flow, (Job)obj, job, jobMap);
                JobInfo jinfo = (JobInfo)job;
                if (jinfo.getJobPriority() == -1) continue;
                int priority = 50;
                switch (jinfo.getJobPriority()) {
                    case 0: {
                        priority = 100;
                        break;
                    }
                    case 1: {
                        priority = 75;
                        break;
                    }
                    case 2: {
                        priority = 50;
                        break;
                    }
                    case 3: {
                        priority = 25;
                        break;
                    }
                    case 4: {
                        priority = 0;
                    }
                }
                ((Job)obj).setPriority(priority);
                continue;
            }
            if (!(obj instanceof Flow)) continue;
            this.processSubflowEvents(newFlow, flow, (Flow)obj, job, jobMap);
        }
        Integer completionType = flow.getCompletionLevelDataBinding();
        switch (completionType) {
            case 2: {
                newFlow.setCompletionCondition(this.getJobIDList(newFlow, flow.getCompletionSelectedJobNamesDataBinding()), true);
                break;
            }
            case 3: {
                newFlow.setCompletionCondition(this.getJobIDList(newFlow, flow.getCompletionSelectedJobNamesDataBinding()), false);
                break;
            }
            case 1: {
                newFlow.setCompletionCondition(null, true);
                break;
            }
            default: {
                newFlow.setCompletionCondition(new ArrayList<String>(), true);
            }
        }
        newFlow.setKillRunningItemsWhenComplete(false);
        return newFlow;
    }

    protected List<AssociatedAction> getEmailActions(int emailNotificationCode, String emailAddresses, String timeZoneID, String fromAddress) {
        ArrayList<AssociatedAction> associatedActions = new ArrayList<AssociatedAction>();
        ArrayList<String> addresses = new ArrayList<String>();
        if (emailAddresses != null) {
            String[] addressStrings;
            for (String address : addressStrings = emailAddresses.split(";")) {
                if (address.trim().length() <= 0) continue;
                addresses.add(address.trim());
            }
        }
        if (fromAddress == null || fromAddress.length() == 0) {
            fromAddress = System.getProperty("sas.dip.emailFromAddress", "no-reply@DIPScheduler");
        }
        if (timeZoneID == null || timeZoneID.length() == 0) {
            timeZoneID = System.getProperty("sas.dip.emailTimeZoneID", new Timezone().getID());
        }
        Locale locale = Locale.getDefault();
        String overrideLocale = System.getProperty("sas.dip.emailLocaleInfo", null);
        if (overrideLocale != null) {
            try {
                String[] pieces = overrideLocale.trim().split(";");
                if (pieces.length == 1) {
                    locale = new Locale(pieces[0]);
                } else if (pieces.length == 2) {
                    locale = new Locale(pieces[0], pieces[1]);
                } else if (pieces.length == 3) {
                    locale = new Locale(pieces[0], pieces[1], pieces[2]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (emailNotificationCode == 0 || emailNotificationCode == 1 || emailNotificationCode == 2) {
            EmailItemStatusAction emailAction = new EmailItemStatusAction(true);
            emailAction.addToAddresses(addresses);
            emailAction.setTimeZoneID(timeZoneID);
            emailAction.setFromAddress(fromAddress);
            emailAction.setLocale(locale);
            associatedActions.add(emailAction);
        }
        if (emailNotificationCode == 4 || emailNotificationCode == 1) {
            EmailItemStatusAction emailAction = new EmailItemStatusAction(false);
            emailAction.addToAddresses(addresses);
            emailAction.setTimeZoneID(timeZoneID);
            emailAction.setFromAddress(fromAddress);
            emailAction.setLocale(locale);
            associatedActions.add(emailAction);
        }
        if (emailNotificationCode == 3 || emailNotificationCode == 2) {
            RunItemStatusDependency exitDep = new RunItemStatusDependency(IPScheduler.getLogger());
            exitDep.setStatusMask(2);
            EmailItemStatusAction emailAction = new EmailItemStatusAction(exitDep);
            emailAction.addToAddresses(addresses);
            emailAction.setTimeZoneID(timeZoneID);
            emailAction.setFromAddress(fromAddress);
            emailAction.setLocale(locale);
            associatedActions.add(emailAction);
        }
        return associatedActions;
    }

    private List<String> getJobIDList(Flow flow, List<String> jobNames) {
        HashMap<String, String> nameToID = new HashMap<String, String>();
        for (ExecutionItem item : flow.getSubItems()) {
            nameToID.put(item.getName(), item.getUniqueID());
        }
        ArrayList<String> completionList = new ArrayList<String>();
        for (String name : jobNames) {
            String id = (String)nameToID.get(name);
            if (id == null) continue;
            completionList.add(id);
        }
        return completionList;
    }

    private Job processJob(JobInfo info) throws InvalidParameterException, SchedulerException {
        ExtraJobOptions options;
        String appID;
        Job job = new Job(IPScheduler.getLogger());
        job.setName(info.getName());
        job.setDescription(info.getDescription());
        String cmdline = info.getRawCommandLine();
        if (cmdline == null) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("IPScheduler.SchedulingDetailsError.fmt"), info.getName()));
        }
        job.setCommand(cmdline);
        String machineCommandLine = info.getJCL();
        if (machineCommandLine == null || machineCommandLine.trim().length() == 0) {
            machineCommandLine = cmdline;
        }
        job.setOSCommand(machineCommandLine);
        if (!System.getProperty("com.sas.scheduler.dip.captureStreamData", "true").equals("false")) {
            job.setCaptureErrorStream(true);
            job.setCaptureOutputStream(true);
        }
        if ((appID = IPScheduler.getApplicationID(info.getBatchServer())) == null || appID.length() == 0) {
            appID = "DIP.CommandLine";
        }
        job.setExecutionQueue(appID);
        if (info.getSchedulerProperties() != null && (options = ExtraJobOptions.createFromXML(new BufferedReader(new StringReader(info.getSchedulerProperties())), IPScheduler.getLogger())) != null) {
            job.setMaximumRunTime(options.getMaxRunTime());
            job.setMaxRetryCount(options.getRetryCount());
            job.setRetryCondition(options.getRetryCondition());
            job.setJobResourceRequirements(options.getJobResourceRequirements());
        }
        return job;
    }

    public static String getApplicationID(BatchServerInfo batchServer) {
        if (batchServer == null) {
            return null;
        }
        return IPScheduler.getApplicationID(batchServer.getType(), batchServer.getSubType());
    }

    public static String getApplicationID(int batchServerType, int batchServerSubtype) {
        if (batchServerSubtype == 0) {
            return null;
        }
        String batchServerTypeIDString = BatchServerInfo.getSubTypeId((int)batchServerType, (int)batchServerSubtype);
        return batchServerTypeIDString;
    }

    private Flow processSubflow(FlowInfo subflow) throws InvalidParameterException, SchedulerException {
        return this.processFlow(subflow, false);
    }

    private void processJobEvents(Flow schFlow, FlowInfo flow, Job schJob, DisplayInfo job, Map<String, ExecutionItem> listOfJobs) throws SchedulerException {
        DisplayInfo info = null;
        if (job instanceof JobInfo) {
            info = flow.getEvent((JobInfo)job);
        } else if (job instanceof FlowInfo) {
            info = flow.getEvent((FlowInfo)job);
        }
        RunCondition event = this.processFlowEventInfo(info, listOfJobs);
        if (event != null) {
            schJob.setRunConditions(event);
        }
        schFlow.addSubItem(schJob);
    }

    private void processSubflowEvents(Flow schFlow, FlowInfo flow, Flow schSubflow, DisplayInfo job, Map<String, ExecutionItem> listOfJobs) throws SchedulerException {
        DisplayInfo info = null;
        if (job instanceof JobInfo) {
            info = flow.getEvent((JobInfo)job);
        } else if (job instanceof FlowInfo) {
            info = flow.getEvent((FlowInfo)job);
        }
        RunCondition event = this.processFlowEventInfo(info, listOfJobs);
        if (event != null) {
            schSubflow.setRunConditions(event);
        }
        schFlow.addSubItem(schSubflow);
    }

    private RunCondition processFlowEventInfo(DisplayInfo info, Map<String, ExecutionItem> listOfJobs) throws SchedulerException {
        if (info == null) {
            return null;
        }
        if (info instanceof GroupingEventInfo) {
            GroupingEventInfo ginfo = (GroupingEventInfo)info;
            boolean condition = true;
            switch (ginfo.getEventType()) {
                case 0: {
                    condition = true;
                    break;
                }
                default: {
                    condition = false;
                }
            }
            List list = ginfo.getDependencies2();
            int numEvents = list.size();
            RunConditions conditions = new RunConditions(IPScheduler.getLogger());
            conditions.setCombinationType(condition);
            for (int x = 0; x < numEvents; ++x) {
                DisplayInfo ai = (DisplayInfo)list.get(x);
                if (ai instanceof GroupingEventInfo) {
                    conditions.addCondition(this.processFlowEventInfo(ai, listOfJobs));
                    continue;
                }
                if (ai instanceof JobEventInfo) {
                    JobEventInfo jei = (JobEventInfo)ai;
                    conditions.addCondition(this.processJobWaitEvent(jei, listOfJobs));
                    continue;
                }
                if (ai instanceof TimeEventInfo) {
                    TimeEventInfo tei = (TimeEventInfo)ai;
                    conditions.addCondition(this.processWaitEvent((AbstractEventInterface)tei));
                    continue;
                }
                if (!(ai instanceof FileEventInfo)) continue;
                FileEventInfo fei = (FileEventInfo)ai;
                conditions.addCondition(this.processWaitEvent((AbstractEventInterface)fei));
            }
            return conditions;
        }
        if (info instanceof JobEventInfo) {
            JobEventInfo jei = (JobEventInfo)info;
            return this.processJobWaitEvent(jei, listOfJobs);
        }
        if (info instanceof TimeEventInfo) {
            TimeEventInfo tei = (TimeEventInfo)info;
            return this.processWaitEvent((AbstractEventInterface)tei);
        }
        if (info instanceof FileEventInfo) {
            FileEventInfo fei = (FileEventInfo)info;
            return this.processWaitEvent((AbstractEventInterface)fei);
        }
        return null;
    }

    protected RunCondition getTriggeringEvent(TriggerEventInfo event) throws SchedulerException {
        AbstractEventInfo eventInfo;
        if (null != event && (eventInfo = event.getEvent()) != null) {
            return this.processFlowEventInfo((DisplayInfo)eventInfo, new HashMap<String, ExecutionItem>());
        }
        return null;
    }

    private RunCondition processJobWaitEvent(JobEventInfo event, Map<String, ExecutionItem> jobMap) {
        int type = event.getEventType();
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ExecutionItem dependJob = jobMap.get(event.getJobInfo().getId());
                IPJobEvent jobEvent = new IPJobEvent(dependJob, type, event.getOperator(), event.getValue());
                return jobEvent.getEvent();
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                ExecutionItem dependFlow = jobMap.get(event.getJobInfo().getId());
                IPJobEvent flowEvent = new IPJobEvent(dependFlow, type, event.getOperator(), event.getValue());
                return flowEvent.getEvent();
            }
        }
        return null;
    }

    private RunCondition processWaitEvent(AbstractEventInterface event) {
        if (event instanceof TimeEventInfo) {
            TimeEventInfo timeEvent = (TimeEventInfo)event;
            String timeZoneID = timeEvent.getTimezone();
            if (timeZoneID == null) {
                timeZoneID = new Timezone().getID();
            }
            TimeDependency timeDep = new TimeDependency(timeEvent.getHours(), timeEvent.getMinutes(), timeEvent.getDuration(), timeZoneID, IPScheduler.getLogger());
            timeDep.setRecurrence(timeEvent.getRecurrence());
            return timeDep;
        }
        if (event instanceof FileEventInfo) {
            FileEventInfo fileEvent = (FileEventInfo)event;
            if (fileEvent.getEventType() == 0) {
                FileExistsDependency dep = new FileExistsDependency(fileEvent.getFileName(), fileEvent.getValue() == 1L, IPScheduler.getLogger());
                return dep;
            }
            if (fileEvent.getEventType() == 1) {
                FileSizeDependency dep = new FileSizeDependency(IPScheduler.getLogger());
                dep.setFilePath(fileEvent.getFileName());
                dep.setSize(fileEvent.getValue());
                switch (fileEvent.getOperator()) {
                    case 21: {
                        dep.setComparisonCode(12);
                        break;
                    }
                    case 23: {
                        dep.setComparisonCode(10);
                        break;
                    }
                    case 24: {
                        dep.setComparisonCode(13);
                        break;
                    }
                    case 25: {
                        dep.setComparisonCode(11);
                        break;
                    }
                    case 26: {
                        dep.setComparisonCode(14);
                        break;
                    }
                    case 22: {
                        dep.setComparisonCode(15);
                        break;
                    }
                }
                return dep;
            }
            if (fileEvent.getEventType() == 3) {
                FileAgeDependency dep = new FileAgeDependency(IPScheduler.getLogger());
                dep.setFilePath(fileEvent.getFileName());
                dep.setAge(fileEvent.getValue());
                switch (fileEvent.getOperator()) {
                    case 21: {
                        dep.setComparisonCode(12);
                        break;
                    }
                    case 23: {
                        dep.setComparisonCode(10);
                        break;
                    }
                    case 24: {
                        dep.setComparisonCode(13);
                        break;
                    }
                    case 25: {
                        dep.setComparisonCode(11);
                        break;
                    }
                    case 26: {
                        dep.setComparisonCode(14);
                        break;
                    }
                    case 22: {
                        dep.setComparisonCode(15);
                        break;
                    }
                }
                return dep;
            }
            if (fileEvent.getEventType() == 2) {
                FileExistsDependency dep = new FileExistsDependency(fileEvent.getFileName(), true, FlowManager.getDefaultLogger());
                dep.setTriggerRestriction(true);
                return dep;
            }
        }
        return null;
    }

    public FlowManager getFlowEngine() {
        return this.getUserSession().getFlowManager();
    }

    public AbstractUserSession getUserSession() {
        return this.mSession;
    }

    @Override
    public boolean isTimeDependenciesEnabled() {
        return true;
    }

    @Override
    public boolean isFileDependenciesEnabled() {
        return true;
    }

    @Override
    @Deprecated
    protected boolean maketheConnection(String user, String pass) {
        return this.maketheConnection(user, pass != null ? new SealedString(pass) : null);
    }

    @Override
    protected boolean maketheConnection(String user, SealedString pass) {
        AbstractUserSession session;
        if (this.m_schedulingServer == null) {
            return false;
        }
        boolean connected = false;
        FlowManager manager = mFlowManagerMap.get(this.m_schedulingServer.getName());
        if (manager == null) {
            return false;
        }
        if (user == null) {
            user = "TempUserID";
        }
        connected = (session = manager.createSession(user, pass)) != null;
        this.mSession = session;
        return connected;
    }

    @Override
    public String getCurrentUserID() {
        if (this.getUserSession() != null) {
            return this.getUserSession().getUserID();
        }
        return "";
    }

    public static ClientLogger getLogger() {
        if (mLogger != null) {
            return mLogger;
        }
        mLogger = new ClientLogger(){

            @Override
            public void logMessage(Level l, Throwable t) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    LOGGER.warn("Exception occurred.", t);
                }
            }

            @Override
            public void logMessage(Level l, String message) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    LOGGER.warn(message);
                }
            }
        };
        return mLogger;
    }

    @Override
    public boolean killFlowInstance(com.sas.scheduler.api.servers.FlowHistory flowInstance) throws SchedulerException {
        String flowID = flowInstance.getSchedulerFlowName();
        if (flowID.length() > 0) {
            String[] failedKillIDs = this.getUserSession().killFlowInstances(new String[]{flowID}, true);
            return failedKillIDs.length == 0;
        }
        return false;
    }

    @Override
    public String makeValidFlowname(String nameStr) {
        return nameStr;
    }

    @Override
    public String makeValidJobName(String nameStr) {
        return nameStr;
    }

    @Override
    public boolean checkVersion(SchedulerIMPL scheduler) throws SchedulerException {
        return false;
    }

    static {
        mDefaultLogLevel = Level.WARNING;
        String strClassName = IPScheduler.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        mFlowManagerMap = null;
    }
}

