/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JobEvent
implements AbstractEventInterface {
    private DeployedJob m_job = null;
    private static final String JobEventTag = "PlatformIndependentJobEventV1:";
    protected String m_jobName = "";
    protected String m_command;
    protected int m_type = -1;
    protected int m_operator = -1;
    protected String m_sOperator = null;
    private String m_xmlOperator = null;
    protected int m_value = 0;
    private String m_description;

    public JobEvent() {
    }

    public JobEvent(DeployedJob oJob, int nType, int nOperator, int nValue) {
        this.m_job = oJob;
        this.m_type = nType;
        this.setOperator(nOperator);
        this.m_value = nValue;
    }

    public JobEvent(JobInfo oJob, int nType, int nOperator, int nValue, MdObjectStore store, String repos) throws RemoteException, MdException {
        this.m_job = new DeployedJob(oJob, store, repos);
        this.m_type = nType;
        this.setOperator(nOperator);
        this.m_value = nValue;
    }

    public JobEvent(DeployedJob oJob, StepPrecedence oSP) throws MdException, RemoteException {
        this.m_job = oJob;
        this.initializeFromSP(oSP);
    }

    public JobEvent(String name, String command, StepPrecedence sp) throws MdException, RemoteException {
        this.initializeFromSP(sp);
        this.m_jobName = name;
        this.m_command = command;
    }

    public JobEvent(StepPrecedence oSP) throws MdException, RemoteException {
        this.initializeFromSP(oSP);
    }

    public JobEvent(int nType) {
        this.m_type = nType;
    }

    public JobEvent(DeployedJob oJob) {
        this.m_job = oJob;
    }

    private void initializeFromSP(StepPrecedence sp) throws MdException, RemoteException {
        Property property = null;
        AssociationList spProperties = sp.getProperties();
        for (int propertyCounter = 0; propertyCounter < spProperties.size(); ++propertyCounter) {
            String sValue;
            property = (Property)spProperties.get(propertyCounter);
            String propName = property.getPropertyName();
            if (propName.equalsIgnoreCase("VALUE")) {
                sValue = property.getDefaultValue();
                Integer oValue = Integer.valueOf(sValue);
                this.setValue(oValue);
                continue;
            }
            if (propName.equalsIgnoreCase("OPERATOR")) {
                sValue = property.getDefaultValue();
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_Equal_Symbol) == 0) {
                    this.setOperator(21);
                    continue;
                }
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThan_Symbol) == 0) {
                    this.setOperator(23);
                    continue;
                }
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol) == 0) {
                    this.setOperator(24);
                    continue;
                }
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_LessThan_Symbol) == 0) {
                    this.setOperator(25);
                    continue;
                }
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_LessThanEqual_Symbol) == 0) {
                    this.setOperator(26);
                    continue;
                }
                if (sValue.compareToIgnoreCase(FlowInfo.ArithmeticOperator_NotEqual_Symbol) == 0) {
                    this.setOperator(22);
                    continue;
                }
                this.setOperator(-1);
                continue;
            }
            if (!propName.equalsIgnoreCase("DEPENDENCYTYPE")) continue;
            this.setType(Integer.valueOf(property.getDefaultValue()));
        }
    }

    public String getName() throws RemoteException {
        if (this.m_job == null) {
            return this.m_jobName;
        }
        return JobEvent.getName(this.m_job.getDeployedJobObject());
    }

    public static String getName(JFJob jfjob) throws RemoteException {
        return jfjob.getName();
    }

    public JFJob getMDJob() {
        return this.m_job.getDeployedJobObject();
    }

    public JobEventInfo getInfo(JobInfo job) {
        JobEventInfo info = new JobEventInfo(job, this.m_type, this.m_operator, this.m_value);
        info.setId(job.getId());
        return info;
    }

    public DeployedJob getDeployedJob() {
        return this.m_job;
    }

    public int getType() {
        return this.m_type;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public int getValue() {
        return this.m_value;
    }

    public void setDeployedJob(DeployedJob job) {
        this.m_job = job;
    }

    public void setType(int nType) {
        this.m_type = nType;
    }

    public void setOperator(int nOperator) {
        this.m_operator = nOperator;
        switch (nOperator) {
            case 21: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_Equal_Symbol;
                this.m_xmlOperator = "EQ";
                break;
            }
            case 23: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_GreaterThan_Symbol;
                this.m_xmlOperator = "GT";
                break;
            }
            case 24: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol;
                this.m_xmlOperator = "GTE";
                break;
            }
            case 25: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_LessThan_Symbol;
                this.m_xmlOperator = "LT";
                break;
            }
            case 26: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_LessThanEqual_Symbol;
                this.m_xmlOperator = "LTE";
                break;
            }
            case 22: {
                this.m_sOperator = FlowInfo.ArithmeticOperator_NotEqual_Symbol;
                this.m_xmlOperator = "NE";
                break;
            }
            default: {
                this.m_sOperator = null;
                this.m_xmlOperator = null;
            }
        }
    }

    private void setOperatorBasedOnXMLOperator() {
        if (this.m_xmlOperator.compareTo("EQ") == 0) {
            this.m_operator = 21;
            this.m_sOperator = FlowInfo.ArithmeticOperator_Equal_Symbol;
        } else if (this.m_xmlOperator.compareTo("GT") == 0) {
            this.m_operator = 23;
            this.m_sOperator = FlowInfo.ArithmeticOperator_GreaterThan_Symbol;
        } else if (this.m_xmlOperator.compareTo("GTE") == 0) {
            this.m_operator = 24;
            this.m_sOperator = FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol;
        } else if (this.m_xmlOperator.compareTo("LT") == 0) {
            this.m_operator = 25;
            this.m_sOperator = FlowInfo.ArithmeticOperator_LessThan_Symbol;
        } else if (this.m_xmlOperator.compareTo("LTE") == 0) {
            this.m_operator = 26;
            this.m_sOperator = FlowInfo.ArithmeticOperator_LessThanEqual_Symbol;
        } else if (this.m_xmlOperator.compareTo("NE") == 0) {
            this.m_operator = 22;
            this.m_sOperator = FlowInfo.ArithmeticOperator_NotEqual_Symbol;
        } else {
            this.m_operator = -1;
            this.m_sOperator = null;
        }
    }

    public void setValue(int nValue) {
        this.m_value = nValue;
    }

    public String generateDefinition() {
        StringBuffer jobDefinition = new StringBuffer(JobEventTag);
        jobDefinition.append(this.generateXML(true, false));
        return jobDefinition.toString();
    }

    public String generateXML() {
        return this.generateXML(false, true);
    }

    public boolean initFromDefinition(Scheduler scheduler, String content) throws SchedulerException {
        if (content == null) {
            return false;
        }
        boolean isJobEvent = content.startsWith(JobEventTag);
        if (!isJobEvent) {
            return false;
        }
        String xml = content.substring(JobEventTag.length());
        this.initFromXML(xml);
        return true;
    }

    public boolean initFromCondition(String conditionString, boolean subFlow) throws SchedulerException {
        if (conditionString == null) {
            return false;
        }
        String jobName = JobEventInfo.getJobEventNameFromConditionString((String)conditionString);
        int type = JobEventInfo.getJobEventTypeFromConditionString((String)conditionString, (boolean)subFlow);
        String operatorString = JobEventInfo.getJobEventOperatorFromConditionString((String)conditionString);
        int value = JobEventInfo.getJobEventValueFromConditionString((String)conditionString);
        if (jobName == null || jobName.trim().length() <= 0) {
            return false;
        }
        this.m_jobName = jobName;
        if (type == -1) {
            return false;
        }
        switch (type) {
            case 4: 
            case 14: {
                this.m_type = type;
                this.m_value = value;
                break;
            }
            case 5: 
            case 15: {
                this.m_type = type;
                this.m_value = value;
                break;
            }
            case 3: 
            case 13: {
                this.m_type = type;
                this.m_xmlOperator = operatorString;
                this.m_value = value;
                break;
            }
            default: {
                this.m_type = type;
            }
        }
        return true;
    }

    public void initFromXML(String xml) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node node = doc.getElementsByTagName("Event").item(0);
        this.initFromNode(node);
    }

    public void initFromNode(Node node) throws SchedulerException {
        try {
            NamedNodeMap map = node.getAttributes();
            String type = map.getNamedItem("Type").getNodeValue();
            boolean subFlow = false;
            if (type.compareTo("Job") == 0) {
                subFlow = false;
            } else if (type.compareTo("subFlow") == 0) {
                subFlow = true;
            } else {
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            for (int x = 0; x < numCNodes; ++x) {
                NamedNodeMap attrs;
                Node cnode = cnodes.item(x);
                String tagname = cnode.getNodeName();
                if (tagname.compareTo("done") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        this.m_type = 10;
                        continue;
                    }
                    this.m_type = 0;
                    continue;
                }
                if (tagname.compareTo("end") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        this.m_type = 11;
                        continue;
                    }
                    this.m_type = 1;
                    continue;
                }
                if (tagname.compareTo("start") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        SchedulerException se = new SchedulerException("Invalid Type");
                        throw se;
                    }
                    this.m_type = 2;
                    continue;
                }
                if (tagname.compareTo("miss") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        this.m_type = 16;
                        continue;
                    }
                    this.m_type = 6;
                    continue;
                }
                if (tagname.compareTo("fails") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        SchedulerException se = new SchedulerException("Invalid Type");
                        throw se;
                    }
                    this.m_type = 7;
                    continue;
                }
                if (tagname.compareTo("cannot") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    if (subFlow) {
                        this.m_type = 18;
                        continue;
                    }
                    this.m_type = 8;
                    continue;
                }
                if (tagname.compareTo("over") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    this.m_type = subFlow ? 14 : 4;
                    this.m_value = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
                    continue;
                }
                if (tagname.compareTo("under") == 0) {
                    attrs = cnode.getAttributes();
                    this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                    this.m_type = subFlow ? 15 : 5;
                    this.m_value = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
                    continue;
                }
                if (tagname.compareTo("exit") != 0) continue;
                attrs = cnode.getAttributes();
                this.m_jobName = attrs.getNamedItem("Depend").getNodeValue();
                this.m_type = subFlow ? 13 : 3;
                this.m_xmlOperator = attrs.getNamedItem("Operator").getNodeValue();
                this.setOperatorBasedOnXMLOperator();
                this.m_value = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)rte);
            throw se;
        }
    }

    public String generateXML(boolean exportFormat) {
        return this.generateXML(exportFormat, true);
    }

    private String generateXML(boolean exportFormat, boolean newlines) {
        try {
            StringBuffer jobXML = new StringBuffer();
            String jobname = null;
            jobname = this.m_job != null ? (exportFormat ? this.m_job.getName() : JobEvent.getName(this.m_job.getDeployedJobObject())) : this.m_jobName;
            String newline = "";
            if (newlines) {
                newline = "\n";
            }
            switch (this.m_type) {
                case 0: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<done Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 1: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<end Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 2: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<start Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 6: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<miss Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 7: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<fails Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 8: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<cannot Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 4: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<over Depend=\"" + jobname + "\" Value=\"" + this.m_value + "\"/>" + newline);
                    break;
                }
                case 5: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<under Depend=\"" + jobname + "\" Value=\"" + this.m_value + "\"/>" + newline);
                    break;
                }
                case 3: {
                    jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<exit Depend=\"" + jobname + "\" Operator=\"" + this.m_xmlOperator + "\" Value=\"" + this.m_value + "\"/>" + newline);
                    break;
                }
                case 10: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<done Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 11: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<end Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 16: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<miss Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 18: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<cannot Depend=\"" + jobname + "\"/>" + newline);
                    break;
                }
                case 14: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<over Depend=\"" + jobname + "\" Value=\"" + this.m_value + "\"/>" + newline);
                    break;
                }
                case 15: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<under Depend=\"" + jobname + "\" Value=\"" + this.m_value + "\"/>" + newline);
                    break;
                }
                case 13: {
                    jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                    jobXML.append("<exit Depend=\"" + jobname + "\" Operator=\"" + this.m_xmlOperator + "\" Value=\"" + this.m_value + "\"/>" + newline);
                }
            }
            jobXML.append("</Event>" + newline);
            return jobXML.toString();
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public String getDisplayDefinition() throws RemoteException {
        if (null == this.m_job) {
            return "";
        }
        return JobEventInfo.toString((String)this.m_job.getName(), (int)this.m_type, (int)this.m_operator, (int)this.m_value, (Locale)Locale.getDefault());
    }

    public String toString() {
        return JobEventInfo.getEventTypeDescription((int)this.m_type);
    }

    public static List<JobEvent> getAllEvents() {
        ArrayList<JobEvent> oJobEvents = new ArrayList<JobEvent>();
        oJobEvents.add(new JobEvent(0));
        oJobEvents.add(new JobEvent(1));
        oJobEvents.add(new JobEvent(2));
        oJobEvents.add(new JobEvent(3));
        return oJobEvents;
    }

    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    public String getDescription() {
        return this.m_description;
    }
}

