/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.deployjob;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.deployjob.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.api.deployjob.DirectoryPanel;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.DeployJobPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class DeployedJobDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobDialog.class);
    protected UserContextInterface m_userContext;
    protected String m_name;
    protected int m_batchtype;
    protected int m_batchsubtype;
    protected DeployJobPanel m_jobpanel;
    protected ArrayList<BatchServerInfo> m_batchservers = new ArrayList();
    protected ServerComponent m_sc = null;
    protected IWorkspaceServer m_WorkspaceServer;
    protected IWorkspace m_iworkspace = null;
    protected String m_initpath = null;
    protected String m_initfolder = null;
    protected String m_srcpath = null;
    protected String m_srcname = null;
    protected String m_targetname = null;
    protected String m_basename = null;
    protected String m_fullname = null;
    protected String m_repos;
    protected String m_reposId;
    protected MdFactory m_factory;
    protected MdObjectStore m_store;
    protected DeployedJob m_djob;
    protected Directory m_dir;
    protected Tree m_folder;
    protected String m_title;
    protected String m_fileContent = null;
    protected List<Job> m_jobObjects = new Vector<Job>();
    protected DeployedJobCodeGenerationInterface m_codegen = null;
    protected boolean m_preserve = false;
    protected boolean m_multiselect = true;

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, String name, MdObjectStore store, String repos) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, name, m_bundle.getString("DeployedJobDialog.Title.txt"), 1, 0, null, false, store, repos, null, null);
    }

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, String name, int batchtype, int batchsubtype, MdObjectStore store, String repos) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, name, m_bundle.getString("DeployedJobDialog.Title.txt"), batchtype, batchsubtype, null, false, store, repos, null, null);
    }

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, String name, MdObjectStore store, String repos, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, name, m_bundle.getString("DeployedJobDialog.Title.txt"), 1, 0, null, false, store, repos, null, jobFileContent);
    }

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, List<?> jobs, DeployedJobCodeGenerationInterface callback, MdObjectStore store, String repos, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, jobs, callback, m_bundle.getString("DeployedJobDialog.Title.txt"), store, repos, null, jobFileContent);
    }

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, List<?> jobs, DeployedJobCodeGenerationInterface callback, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, jobs, callback, m_bundle.getString("DeployedJobDialog.Title.txt"), store, repos, folder, jobFileContent);
    }

    public DeployedJobDialog(Frame owner, UserContextInterface userContext, List<?> jobs, DeployedJobCodeGenerationInterface callback, String title, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, userContext, DeployedJobDialog.convertJobListToFilename(jobs), title, 1, 0, callback, false, store, repos, folder, jobFileContent);
        int numJobs = jobs.size();
        if (numJobs > 0) {
            Job job = (Job)jobs.get(0);
            this.m_store = (MdObjectStore)job.getObjectStore();
            this.m_repos = folder.getFQID().substring(0, 8);
            this.m_jobObjects.add(0, job);
            for (int i = 1; i < numJobs; ++i) {
                job = (Job)jobs.get(i);
                this.m_jobObjects.add(i, job);
            }
        }
    }

    private static String convertJobListToFilename(List<?> jobs) throws RemoteException {
        StringBuffer name = new StringBuffer();
        int numJobs = jobs.size();
        if (numJobs <= 0) {
            return null;
        }
        name.append(((Job)jobs.get(0)).getName());
        for (int i = 1; i < numJobs; ++i) {
            name.append(";");
            name.append(((Job)jobs.get(i)).getName());
        }
        return name.toString();
    }

    protected DeployedJobDialog(Frame owner, UserContextInterface userContext, String name, String title, int type, int subtype, DeployedJobCodeGenerationInterface callback, boolean preservation, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        super(owner, title, true);
        this.m_fileContent = jobFileContent;
        this.m_title = title;
        this.m_userContext = userContext;
        this.m_name = name;
        this.m_batchtype = type;
        this.m_batchsubtype = subtype;
        this.m_codegen = callback;
        this.m_preserve = preservation;
        this.m_store = store;
        this.m_repos = repos.length() > 8 ? repos.substring(9) : repos;
        this.m_reposId = repos;
        this.m_factory = store.getFactory();
        this.m_folder = folder;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_deploy_ds_program");
        this.initialize();
    }

    public void dispose() {
        if (this.m_WorkspaceServer != null) {
            this.m_WorkspaceServer.closeConnection();
            this.m_WorkspaceServer = null;
            this.m_iworkspace = null;
        }
        super.dispose();
    }

    private void initialize() throws RemoteException, MdException, SchedulerException {
        List<ServerComponent> servers;
        if (MetaUtilities.getMdFactory(false) == null && this.m_userContext != null) {
            try {
                OMIServer server = (OMIServer)this.m_userContext.getAuthServer();
                MdFactory factory = server.getMdFactory();
                if (factory.getInstance() != null) {
                    MetaUtilities.setMdFactory(factory);
                }
            }
            catch (ServiceException e) {
                MdException ex = new MdException();
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        if ((servers = MetaUtilities.getBatchServers(this.m_batchtype, this.m_batchsubtype, (MdStore)this.m_store, this.m_reposId)).size() > 0) {
            boolean hideSourceFile;
            for (ServerComponent server : servers) {
                BatchServerInfo serverinfo = new BatchServerInfo(server.getName(), server.getClassIdentifier(), CommandUtilities.getTargetOSForBatchServer(server));
                MetaUtilities.setBatchServerProperties(serverinfo, server);
                List<DirectoryInfo> dirlist = MetaUtilities.getDirectoryPathsFromServer(server);
                serverinfo.setDirectories(dirlist);
                this.m_batchservers.add(serverinfo);
            }
            boolean bl = hideSourceFile = this.m_codegen != null;
            if (this.m_batchtype != 1 || this.m_preserve) {
                hideSourceFile = true;
            }
            this.m_jobpanel = new DeployJobPanel(this.m_batchservers, this.m_title, hideSourceFile, this.m_preserve);
            ActionListener deploydirListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BatchServerInfo bsinfo = DeployedJobDialog.this.m_jobpanel.getSelectedServer();
                    DirectoryInfo dirInfo = DeployedJobDialog.this.m_jobpanel.getSelectedDirectory();
                    if (dirInfo != null) {
                        DeployedJobDialog.this.m_jobpanel.setSelectedJCLDirectory(dirInfo);
                        try {
                            DeployedJobDialog.this.m_dir = MetaUtilities.getDirectory(bsinfo, dirInfo, (MdStore)DeployedJobDialog.this.m_store, DeployedJobDialog.this.m_reposId);
                        }
                        catch (RemoteException ex) {
                            String message = ex.getLocalizedMessage();
                            if (message == null || message.length() == 0) {
                                message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                            }
                            MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                        }
                        catch (MdException ex) {
                            String message = ex.getLocalizedMessage();
                            if (message == null || message.length() == 0) {
                                message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                            }
                            MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                        }
                    }
                    try {
                        if (bsinfo.getOperatingSystem() == 2) {
                            ServerComponent server = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)DeployedJobDialog.this.m_store, DeployedJobDialog.this.m_reposId);
                            if (DeployedJobDialog.this.checkConnectionToServer(server) == 1) {
                                DeployedJobDialog.this.updateJCL(server, bsinfo);
                            } else {
                                MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)m_bundle.getString("DeployedJobDialog.Warning.UnableToConnectToAppServer.NoJCL.txt"), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                            }
                        }
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt"), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                    }
                    catch (RemoteException ex) {
                        MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt"), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                    }
                }
            };
            this.m_jobpanel.addBatchServerListener(deploydirListener);
            this.m_jobpanel.addDirListener(deploydirListener);
            BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
            if (bsinfo.getOperatingSystem() == 2) {
                String msg = m_bundle.getString("DeployedJobDialog.BuildJCLProgressIndicator.Message.txt");
                ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
                request.setDelayBeforeProgressCancelDialog(200);
                ServerComponent server = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)this.m_store, this.m_reposId);
                if (this.checkConnectionToServer(server) == 1) {
                    cRunnable_UpdateJCL jclinit = new cRunnable_UpdateJCL(server, bsinfo);
                    request.execute((Runnable)jclinit);
                } else {
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("DeployedJobDialog.Warning.UnableToConnectToAppServer.NoJCL.txt"), (String)this.m_title, (int)2, (int)-1);
                }
            }
            ActionListener newdirListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (!DeployedJobDialog.this.btnNewDirOnclicked()) {
                            MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt"), (String)DeployedJobDialog.this.m_title, (int)2, (int)-1);
                        }
                    }
                    catch (MdException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                        }
                        MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                    }
                    catch (RemoteException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                        }
                        MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                    }
                    catch (RuntimeException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                        }
                        MessageUtil.displayMessage((Frame)DeployedJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)DeployedJobDialog.this.m_title, (int)0, (int)-1);
                    }
                }
            };
            this.m_jobpanel.addNewDirListener(newdirListener);
            ActionListener browseListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = DeployedJobDialog.this.browseFileSystem();
                    DeployedJobDialog.this.m_jobpanel.setFilename(filename);
                }
            };
            this.m_jobpanel.addBrowseListener(browseListener);
            PropertyChangeListener filenameListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String filename = DeployedJobDialog.this.m_jobpanel.getFilename();
                    String[] files = filename.split(";");
                    String names = null;
                    for (int y = 0; y < files.length; ++y) {
                        filename = files[y];
                        if (filename.length() <= 0) continue;
                        try {
                            int index;
                            String name = null;
                            if (DeployedJobDialog.this.m_codegen != null && !filename.endsWith(".sas")) {
                                filename = filename + ".sas";
                            }
                            if ((index = filename.lastIndexOf("\\")) == -1) {
                                index = filename.lastIndexOf("/");
                            }
                            if ((index = (name = index >= 0 ? filename.substring(index + 1) : filename).lastIndexOf(46)) > 0) {
                                name = name.substring(0, index);
                            }
                            name = DeployedJobDialog.this.uniqueName(MetaUtilities.makeValidJobName(name), names);
                            names = names == null ? name : names + ";" + name;
                        }
                        catch (RemoteException ex) {
                            ex.printStackTrace();
                            DeployedJobDialog.this.m_jobpanel.setJobName("");
                        }
                        catch (MdException ex) {
                            ex.printStackTrace();
                            DeployedJobDialog.this.m_jobpanel.setJobName("");
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                            DeployedJobDialog.this.m_jobpanel.setJobName("");
                        }
                        DeployedJobDialog.this.m_jobpanel.setJobName(names);
                    }
                }
            };
            this.m_jobpanel.addFilenameListener(filenameListener);
            ActionListener selectFolderListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tree folder = DeployedJobDialog.this.selectFolders();
                    if (folder != null) {
                        DeployedJobDialog.this.m_folder = folder;
                        String name = null;
                        try {
                            name = MetaUtilities.getFolderLocation(DeployedJobDialog.this.m_folder);
                        }
                        catch (RemoteException re) {
                            name = "";
                        }
                        catch (MdException mde) {
                            name = "";
                        }
                        DeployedJobDialog.this.m_jobpanel.setFolder(name);
                    }
                }
            };
            this.m_jobpanel.addSelectFolderListener(selectFolderListener);
            this.m_jobpanel.setFilename(this.m_name);
            if (this.m_folder == null) {
                try {
                    this.m_folder = this.m_initfolder != null ? MetaUtilities.getFolder(this.m_initfolder, this.m_store, this.m_reposId) : MetaUtilities.getDefaultFolder(this.m_store, this.m_reposId);
                }
                catch (NoContext noContext) {
                }
                catch (NotFound notFound) {
                }
                catch (RemoteException remoteException) {
                }
                catch (MdException mdException) {
                    // empty catch block
                }
            }
            if (!this.m_preserve && this.m_folder != null) {
                String name = null;
                try {
                    name = MetaUtilities.getFolderLocation(this.m_folder);
                }
                catch (RemoteException re) {
                    name = "";
                }
                this.m_jobpanel.setFolder(name);
            }
        } else {
            SchedulerException ex = new SchedulerException(m_bundle.getString("DeployedJobDialog.ErrorMsg.ApplicationServerError.txt"), DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.ApplicationServerError.txt", null);
            throw ex;
        }
        StandardPanel mainpanel = new StandardPanel();
        mainpanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints jobpanel_gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0);
        mainpanel.add((Component)this.m_jobpanel, (Object)jobpanel_gbc);
        this.setMainPanel(mainpanel);
    }

    public String getDirectoryName() throws RemoteException {
        if (this.m_dir != null) {
            return this.m_dir.getName();
        }
        return null;
    }

    public boolean setDefaultDirectory(String dirname) {
        return this.m_jobpanel.setSelectedDirectory(dirname);
    }

    public String getBatchServer() throws RemoteException {
        if (this.m_sc != null) {
            return this.m_sc.getId();
        }
        return null;
    }

    public boolean setDefaultBatchServer(String batchserver) {
        return this.m_jobpanel.setSelectedServer(batchserver);
    }

    public String getSourcePath() {
        return this.m_srcpath;
    }

    public boolean setDefaultSourcePath(String initpath) {
        this.m_initpath = initpath;
        return true;
    }

    public String getFolder() {
        return this.m_jobpanel.getFolder();
    }

    public boolean setDefaultFolder(String initfolder) {
        this.m_initfolder = initfolder;
        this.m_jobpanel.setFolder(initfolder);
        try {
            this.m_folder = MetaUtilities.getFolder(this.m_initfolder, this.m_store, this.m_reposId);
        }
        catch (RemoteException e) {
            this.m_folder = null;
        }
        catch (NotFound e) {
            this.m_folder = null;
        }
        catch (NoContext e) {
            this.m_folder = null;
        }
        catch (MdException e) {
            this.m_folder = null;
        }
        return true;
    }

    public String getJobName() throws RemoteException {
        if (this.m_djob != null) {
            return this.m_djob.getName();
        }
        return null;
    }

    protected boolean validateData() {
        try {
            return !MetaUtilities.doesJobExist(this.m_basename, this.m_folder, (MdStore)this.m_store, this.m_reposId);
        }
        catch (RemoteException e) {
            return false;
        }
        catch (MdException e) {
            return false;
        }
    }

    protected boolean onOK() throws SchedulerException {
        this.m_eReturnValue = 64;
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean rc = this.m_jobpanel.validateData();
        if (rc) {
            try {
                BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
                switch (bsinfo.getType()) {
                    case 1: {
                        rc = this.processDataStepBatchJobs(bsinfo);
                        break;
                    }
                    case 2: {
                        rc = this.processJavaBatchJobs(bsinfo);
                        break;
                    }
                    default: {
                        rc = false;
                    }
                }
                this.m_eReturnValue = 1;
            }
            catch (MdException e) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
                rc = false;
            }
            catch (RemoteException e) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
                rc = false;
            }
            catch (RuntimeException e) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
                rc = false;
            }
        } else {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)this.m_jobpanel.getErrorMessage(), (String)this.m_title, (int)0, (int)-1);
            rc = false;
        }
        this.setCursor(Cursor.getDefaultCursor());
        return rc;
    }

    private boolean processJavaBatchJobs(BatchServerInfo bsinfo) {
        boolean rc = true;
        StringBuffer okMessage = new StringBuffer();
        StringBuffer failedMessage = new StringBuffer();
        int success = 0;
        int failed = 0;
        String spacer = "   ";
        String[] names = this.m_jobpanel.getJobName().split(";");
        int total = names.length;
        if (total == 1) {
            spacer = "";
        }
        for (int z = 0; z < total; ++z) {
            try {
                String message;
                cRunnable_CreateMetadataJava createMetadata;
                this.m_name = names[z];
                Job job = this.m_jobObjects.get(z);
                if (!DeployedJob.isValidName(this.m_name)) {
                    String newname = MetaUtilities.makeValidJobName(this.m_name);
                    int response = MessageUtil.displayMessage((Frame)this.m_frame, (String)MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Warning.InvalidJobName.fmt"), this.m_name, newname), (String)this.m_title, (int)2, (int)2);
                    if (response == 2) {
                        this.m_name = newname;
                    } else {
                        String message2 = m_bundle.getString("DeployedJobDialog.ErrorMsg.InvalidJobName.txt");
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message2));
                        failedMessage.append("\n");
                        continue;
                    }
                }
                String msg = null;
                msg = total == 1 ? m_bundle.getString("DeployedJobDialog.BuildMetadataProgressIndicator.Message.txt") : MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.BuildMetadataProgressIndicator.Message.fmt"), this.m_name, String.valueOf(z + 1), String.valueOf(total));
                if (this.validateData()) {
                    ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
                    request.setDelayBeforeProgressCancelDialog(200);
                    createMetadata = new cRunnable_CreateMetadataJava(job);
                    request.execute((Runnable)createMetadata);
                    if (!createMetadata.isSuccessful()) {
                        SchedulerException ex = createMetadata.getSchedulerException();
                        if (ex != null) {
                            ex.printStackTrace();
                        }
                        String message3 = createMetadata.getErrorMessage();
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message3));
                        failedMessage.append("\n");
                        continue;
                    }
                } else {
                    String message4 = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.DeployedJobExists.fmt"), this.m_basename, this.m_folder.getName());
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message4));
                    failedMessage.append("\n");
                    continue;
                }
                this.m_djob = createMetadata.getDeployedJob();
                if (this.m_folder != null) {
                    if (this.m_djob != null) {
                        Job temp;
                        this.m_djob.setFolder(this.m_folder);
                        if (job == null && (temp = this.m_djob.getJobObject()) != null) {
                            AssociationList trees = temp.getTrees();
                            trees.clear();
                            trees.add(this.m_folder);
                        }
                        this.m_djob.commitChangesWithNoValidation();
                    }
                } else {
                    message = m_bundle.getString("DeployedJobDialog.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message));
                    failedMessage.append("\n");
                    continue;
                }
                message = null;
                String jobName = "";
                String djobName = "";
                if (this.m_djob != null) {
                    djobName = this.m_djob.getName();
                    Job temp = this.m_djob.getJobObject();
                    if (temp != null) {
                        jobName = temp.getName();
                    }
                }
                message = total == 1 ? MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Single.DeploySucc.fmt"), jobName, djobName, this.m_folder.toString()) : MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Multiple.DeploySucc.fmt"), spacer, jobName, djobName);
                ++success;
                okMessage.append(message);
                okMessage.append("\n");
                continue;
            }
            catch (MdException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RemoteException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RuntimeException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
            }
        }
        StringBuffer summary = new StringBuffer();
        if (failed > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Failed.Header.fmt"), String.valueOf(failed), String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        if (success > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Success.Header.fmt"), String.valueOf(success), String.valueOf(total), ""));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        if (total == 1) {
            if (success == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)okMessage.toString(), (String)this.m_title, (int)1, (int)-1);
            } else if (failed == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)failedMessage.toString(), (String)this.m_title, (int)0, (int)-1);
            } else {
                MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)1, (int)-1);
            }
        } else {
            MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)(failed == 0 ? 1 : 0), (int)-1);
        }
        return rc;
    }

    private boolean processDataStepBatchJobs(BatchServerInfo bsinfo) throws RemoteException, MdException {
        int connectRC;
        boolean rc = true;
        ServerComponent mdSC = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)this.m_store, this.m_reposId);
        if (this.m_codegen != null) {
            this.m_codegen.setAppServer(IWorkspaceServer.getServerContext(mdSC));
        }
        if ((connectRC = this.checkConnectionToServer(mdSC)) != 1) {
            String message = null;
            message = connectRC == 2 ? m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.UserAbort.txt") : m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            return false;
        }
        IFileService rio = this.m_iworkspace.FileService();
        StringBuffer okMessage = new StringBuffer();
        StringBuffer failedMessage = new StringBuffer();
        int success = 0;
        int failed = 0;
        boolean overwriteall = false;
        boolean skipall = false;
        String spacer = "   ";
        String file = this.m_jobpanel.getFilename();
        String[] files = file.split(";");
        String[] names = this.m_jobpanel.getJobName().split(";");
        int total = files.length;
        if (total == 1) {
            spacer = "";
        }
        block19: for (int z = 0; z < total; ++z) {
            try {
                cRunnable_CreateMetadataDATAStep createMetadata;
                String message;
                boolean copyfile;
                String jcl;
                block58: {
                    file = files[z];
                    this.m_name = names[z];
                    if (!DeployedJob.isValidName(this.m_name)) {
                        String newname = MetaUtilities.makeValidJobName(this.m_name);
                        int response = MessageUtil.displayMessage((Frame)this.m_frame, (String)MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Warning.InvalidJobName.fmt"), this.m_name, newname), (String)this.m_title, (int)2, (int)2);
                        if (response == 2) {
                            this.m_name = newname;
                        } else if (this.m_codegen == null) {
                            String message2 = m_bundle.getString("DeployedJobDialog.ErrorMsg.InvalidJobName.txt");
                            rc = false;
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message2));
                            failedMessage.append("\n");
                            continue;
                        }
                    }
                    jcl = this.m_jobpanel.getJCL();
                    this.m_dir = MetaUtilities.getDirectory(bsinfo, this.m_jobpanel.getSelectedDirectory(), (MdStore)this.m_store, this.m_reposId);
                    if (this.m_dir == null) {
                        String message3 = null;
                        message3 = this.m_jobpanel.getNumDirectories() == 0 ? m_bundle.getString("DeployedJobDialog.ErrorMsg.NoDeploymentDirs.txt") : m_bundle.getString("DeployedJobDialog.ErrorMsg.MissingDeploymentDir.txt");
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message3));
                        failedMessage.append("\n");
                        continue;
                    }
                    copyfile = false;
                    try {
                        if (this.m_codegen == null) {
                            if (this.setFilePaths(file, bsinfo)) {
                                copyfile = true;
                            } else if (this.m_srcpath == null || this.m_srcpath.compareTo(CommandUtilities.normalizePath(this.m_dir.getDirectoryName(), bsinfo.getOperatingSystem())) != 0) {
                                copyfile = true;
                            }
                        } else {
                            this.setFilePaths(file, bsinfo);
                        }
                        if (this.m_fileContent != null) {
                            CommandUtilities.saveToRemoteFile(rio, file, bsinfo.getOperatingSystem(), this.m_fileContent);
                        }
                        if (!copyfile && this.m_codegen == null || overwriteall) break block58;
                        try {
                            int response1;
                            Object[] options;
                            String prompt;
                            CommandUtilities.readFromRemoteFile(rio, this.m_fullname, bsinfo.getOperatingSystem());
                            String skipmessage = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.UserAbortDeployedJobExists.fmt"), this.m_fullname));
                            if (skipall) {
                                rc = false;
                                ++failed;
                                failedMessage.append(skipmessage);
                                failedMessage.append("\n");
                                continue;
                            }
                            String title = m_bundle.getString("DeployedJobDialog.FileExists.Title.txt");
                            if (total - z < 2) {
                                prompt = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.TargetFileExists.Single.Message.fmt"), this.m_fullname);
                                options = new Object[]{m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.Overwrite.txt"), m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.Skip.txt")};
                                response1 = JOptionPane.showOptionDialog(this.m_frame, prompt, title, -1, 3, null, options, options[0]);
                                switch (response1) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        rc = false;
                                        ++failed;
                                        failedMessage.append(skipmessage);
                                        failedMessage.append("\n");
                                        continue block19;
                                    }
                                }
                                break block58;
                            }
                            prompt = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.TargetFileExists.Message.fmt"), this.m_fullname);
                            options = new Object[]{m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.Overwrite.txt"), m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.OverwriteAll.txt"), m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.Skip.txt"), m_bundle.getString("DeployedJobDialog.TargetFileExists.Option.SkipAll.txt")};
                            response1 = JOptionPane.showOptionDialog(this.m_frame, prompt, title, -1, 3, null, options, options[0]);
                            switch (response1) {
                                case 1: {
                                    overwriteall = true;
                                }
                                case 0: {
                                    break;
                                }
                                case 3: {
                                    skipall = true;
                                }
                                case 2: {
                                    rc = false;
                                    ++failed;
                                    failedMessage.append(skipmessage);
                                    failedMessage.append("\n");
                                    continue block19;
                                }
                            }
                        }
                        catch (GenericError skipmessage) {}
                    }
                    catch (GenericError ex) {
                        message = ex.getLocalizedMessage();
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message));
                        failedMessage.append("\n");
                        continue;
                    }
                    catch (RuntimeException ex) {
                        message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = ex.toString();
                        }
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message));
                        failedMessage.append("\n");
                        continue;
                    }
                }
                String msg = null;
                msg = total == 1 ? m_bundle.getString("DeployedJobDialog.BuildMetadataProgressIndicator.Message.txt") : MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.BuildMetadataProgressIndicator.Message.fmt"), this.m_name, String.valueOf(z + 1), String.valueOf(total));
                if (this.validateData()) {
                    ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
                    request.setDelayBeforeProgressCancelDialog(200);
                    createMetadata = new cRunnable_CreateMetadataDATAStep(copyfile, jcl, this.m_codegen != null ? this.m_jobObjects.get(z) : null);
                    request.execute((Runnable)createMetadata);
                    if (!createMetadata.isSuccessful()) {
                        String message4;
                        SchedulerException ex = createMetadata.getSchedulerException();
                        if (ex != null && MetaUtilities.isDebug()) {
                            ex.printStackTrace();
                        }
                        if ((message4 = createMetadata.getErrorMessage()) == null) {
                            message4 = request.getErrors();
                        }
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message4));
                        failedMessage.append("\n");
                        continue;
                    }
                } else {
                    message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.DeployedJobExists.fmt"), this.m_basename, this.m_folder.getName());
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message));
                    failedMessage.append("\n");
                    continue;
                }
                this.m_djob = createMetadata.getDeployedJob();
                this.m_dir = createMetadata.getDeployedDirectory();
                if (this.m_folder != null) {
                    if (this.m_djob != null) {
                        Job job;
                        this.m_djob.setFolder(this.m_folder);
                        if (this.m_codegen == null && (job = this.m_djob.getJobObject()) != null) {
                            AssociationList trees = job.getTrees();
                            trees.clear();
                            trees.add(this.m_folder);
                        }
                        this.m_djob.commitChangesWithNoValidation();
                    }
                } else {
                    message = m_bundle.getString("DeployedJobDialog.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, message));
                    failedMessage.append("\n");
                    continue;
                }
                message = null;
                String jobName = "";
                String djobName = "";
                String dirName = "";
                if (this.m_djob != null) {
                    djobName = this.m_djob.getName();
                    Job job = this.m_djob.getJobObject();
                    if (job != null) {
                        jobName = job.getName();
                    }
                }
                if (this.m_dir != null) {
                    dirName = this.m_dir.getDirectoryName();
                }
                message = total == 1 ? MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Single.DeploySucc.fmt"), jobName, djobName, dirName) : MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Multiple.DeploySucc.fmt"), spacer, jobName, djobName);
                ++success;
                okMessage.append(message);
                okMessage.append("\n");
                continue;
            }
            catch (MdException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RemoteException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RuntimeException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.toString()));
                failedMessage.append("\n");
            }
        }
        StringBuffer summary = new StringBuffer();
        if (failed > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Failed.Header.fmt"), String.valueOf(failed), String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        if (success > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.Success.Header.fmt"), String.valueOf(success), String.valueOf(total), this.m_dir != null ? this.m_dir.getDirectoryName() : ""));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        if (total == 1) {
            if (success == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)okMessage.toString(), (String)this.m_title, (int)1, (int)-1);
            } else if (failed == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)failedMessage.toString(), (String)this.m_title, (int)0, (int)-1);
            } else {
                MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)1, (int)-1);
            }
        } else {
            MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)(failed == 0 ? 1 : 0), (int)-1);
        }
        return rc;
    }

    /*
     * Exception decompiling
     */
    protected Tree selectFolders() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateJCL(ServerComponent server, BatchServerInfo bsinfo) {
        if (bsinfo.getOperatingSystem() == 2) {
            try {
                Directory dir;
                String dirString = "./";
                DirectoryInfo dinfo = this.m_jobpanel.getSelectedDirectory();
                if (dinfo != null && (dir = MetaUtilities.getDirectory(bsinfo, dinfo, (MdStore)this.m_store, this.m_reposId)) != null) {
                    dirString = dir.getDirectoryName();
                }
                String template = CommandUtilities.getCommandLineFromBatchServer(server);
                String jcl = DataStepProgramDeployer.GenerateJCLFromBatchServer(dirString, template, this.m_iworkspace);
                this.m_jobpanel.setJCL(jcl);
            }
            catch (GenericError ex) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            }
            catch (RemoteException ex) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            }
            catch (MdException ex) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            }
            catch (RuntimeException ex) {
                String message = ex.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = ex.toString();
                }
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uniqueName(String name, String currentlist) throws MdException, RemoteException {
        int MAXAUTONUMBER = 1000;
        int MAXDIGITS = 3;
        String unique = name;
        int count = 0;
        MdObjectStore tempStore = null;
        try {
            tempStore = this.m_factory.createObjectStore();
            boolean jobexists = MetaUtilities.doesJobExist(unique, (MdStore)tempStore, this.m_reposId);
            block7: while (jobexists && count < 1000) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumIntegerDigits(3);
                nf.setMinimumIntegerDigits(3);
                unique = name + nf.format(count++);
                jobexists = MetaUtilities.doesJobExist(unique, (MdStore)tempStore, this.m_reposId);
                if (jobexists || currentlist == null) continue;
                String[] files = currentlist.split(";");
                for (int x = 0; x < files.length; ++x) {
                    if (files[x].compareTo(unique) != 0) continue;
                    jobexists = true;
                    continue block7;
                }
            }
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RemoteException remoteException) {}
                tempStore = null;
            }
        }
        if (count < 1000) {
            return unique;
        }
        return null;
    }

    protected String browseFileSystem() {
        String file;
        BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
        try {
            if (this.checkConnectionToServer(bsinfo) == 2) {
                return null;
            }
        }
        catch (MdException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        catch (RemoteException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        String msg = m_bundle.getString("DeployedJobDialog.BuildFileSelectorProgressIndicator.Message.txt");
        ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
        request.setDelayBeforeProgressCancelDialog(200);
        cRunnable_Files fileselector = new cRunnable_Files(this.m_iworkspace, bsinfo, this.m_initpath);
        request.execute((Runnable)fileselector);
        if (request.hasErrors()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)request.getErrors(), (String)this.m_title, (int)0, (int)-1);
        }
        IFileServiceSelectorPanel pnlSelector = fileselector.getSelector();
        if (this.m_multiselect) {
            pnlSelector.setMultiSelectionEnabled(true);
        } else {
            pnlSelector.setMultiSelectionEnabled(false);
        }
        while (true) {
            ArrayList alFileList = null;
            try {
                alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)this.m_frame, (String)m_bundle.getString("DeployedJobDialog.FileSelection.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)this.m_iworkspace, (boolean)true, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
            }
            catch (Exception ex) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
                return null;
            }
            if (pnlSelector.isCancelled()) {
                return this.m_jobpanel.getFilename();
            }
            if (alFileList == null || alFileList.size() <= 0) continue;
            file = (String)alFileList.get(0);
            for (int x = 1; x < alFileList.size(); ++x) {
                file = file + ";" + alFileList.get(x);
            }
            if (file != null && file.length() > 0) break;
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("DeployedJobDialog.ErrorMsg.MissingProgram.txt"), (String)this.m_title, (int)0, (int)-1);
        }
        return file;
    }

    protected boolean setFilePaths(String infile, BatchServerInfo bsinfo) throws GenericError, RemoteException {
        int firstindex;
        String file = CommandUtilities.normalizePath(infile, bsinfo.getOperatingSystem());
        this.m_basename = !MetaUtilities.isValidFilename(this.m_name) ? MetaUtilities.replaceInvalidCharacters(this.m_name) : this.m_name;
        this.m_targetname = this.m_basename != null && this.m_basename.length() > 0 ? this.m_basename + ".sas" : "";
        char pathseparator = CommandUtilities.getPathSeparator(bsinfo.getOperatingSystem());
        this.m_srcname = file.substring(file.lastIndexOf(pathseparator) + 1);
        int lastindex = file.lastIndexOf(pathseparator);
        this.m_srcpath = lastindex > 0 ? ((firstindex = file.indexOf(pathseparator)) == lastindex ? file.substring(0, lastindex + 1) : file.substring(0, lastindex)) : null;
        boolean rc = false;
        this.m_fullname = CommandUtilities.createFullPath(this.m_dir.getDirectoryName(), this.m_targetname, bsinfo.getOperatingSystem());
        if (this.m_targetname.compareTo(this.m_srcname) != 0) {
            rc = true;
        }
        return rc;
    }

    protected int checkConnectionToServer(BatchServerInfo bsinfo) throws RemoteException, MdException {
        ServerComponent mdSC = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)this.m_store, this.m_reposId);
        return this.checkConnectionToServer(mdSC);
    }

    protected int checkConnectionToServer(ServerComponent mdSC) throws RemoteException, MdException {
        if (this.m_WorkspaceServer == null) {
            ServerContext appServer = null;
            try {
                LogicalServer lc = (LogicalServer)mdSC.getUsedByComponents().get(0);
                appServer = (ServerContext)lc.getUsedByComponents().get(0);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.NoWorkspaceServer.fmt"), mdSC.getName()));
            }
            TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection(mdSC, "440196D4-90F0-11D0-9F41-00A024BB830C");
            if (tcpip == null) {
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.NoWorkspaceServer.fmt"), appServer.getName()));
            }
            String host = tcpip.getHostName();
            int port = tcpip.getPort();
            this.m_WorkspaceServer = new IWorkspaceServer(appServer, "440196D4-90F0-11D0-9F41-00A024BB830C", host, port);
        }
        int rc = 0;
        rc = this.m_userContext != null ? this.m_WorkspaceServer.checkConnectionToServer(this.m_frame, this.m_userContext, CommandUtilities.getWorkspaceServerComponentFromBatchServer(mdSC), "440196D4-90F0-11D0-9F41-00A024BB830C") : this.m_WorkspaceServer.checkConnectionToServer(this.m_frame, CommandUtilities.getWorkspaceServerComponentFromBatchServer(mdSC), "440196D4-90F0-11D0-9F41-00A024BB830C");
        if (rc == 1) {
            this.m_iworkspace = this.m_WorkspaceServer.getWorkspace();
        }
        return rc;
    }

    protected boolean btnNewDirOnclicked() throws RemoteException, MdException {
        StandardDialog dlg = new StandardDialog((Dialog)((Object)this), m_bundle.getString("DeployedJobDialog.NewDirectory.txt"), true);
        DirectoryPanel panel = new DirectoryPanel(this.m_frame, this.m_store, this.m_reposId);
        panel.addBrowseListener(new cBrowseAction(panel));
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_newdeploymentdir");
        dlg.makeVisible();
        Directory dir = panel.getDirectory();
        if (1 == dlg.getReturnValue()) {
            DirectoryInfo dirinfo = new DirectoryInfo(dir.getName(), dir.getDirectoryName());
            this.m_jobpanel.addDirectory(dirinfo);
            if (this.m_sc == null) {
                BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
                this.m_sc = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)this.m_store, this.m_reposId);
            }
            MetaUtilities.addDirectory(dir, this.m_sc);
        } else {
            dir.delete();
        }
        return true;
    }

    protected String launchDirChooser() {
        BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
        try {
            if (this.checkConnectionToServer(bsinfo) == 2) {
                return null;
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            return null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(m_bundle.getString("DeployedJobDialog.RemoteFileSelectorFileTypeText.txt"), "*");
            IFileServiceSelectorPanel pnlSelector = null;
            pnlSelector = bsinfo.getOperatingSystem() == 2 ? new IFileServiceSelectorPanel(null, this.m_iworkspace, fileTypes, 2) : new IFileServiceSelectorPanel(null, this.m_iworkspace, fileTypes, true);
            pnlSelector.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
            pnlSelector.setMultiSelectionEnabled(false);
            ArrayList alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)this.m_frame, (String)m_bundle.getString("DeployedJobDialog.RemoteFileSelectorTitle.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)this.m_iworkspace, (boolean)true, (boolean)true, (IFileServiceSelectorPanel)pnlSelector);
            if (alFileList != null && alFileList.size() > 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return (String)alFileList.get(0);
            }
        }
        catch (RuntimeException e) {
            this.setCursor(Cursor.getDefaultCursor());
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
        }
        this.setCursor(Cursor.getDefaultCursor());
        return null;
    }

    private class cRunnable_UpdateJCL
    implements Runnable {
        private ServerComponent mc_server;
        private BatchServerInfo mc_bsinfo;

        public cRunnable_UpdateJCL(ServerComponent server, BatchServerInfo bsinfo) {
            this.mc_server = server;
            this.mc_bsinfo = bsinfo;
        }

        @Override
        public void run() {
            DeployedJobDialog.this.updateJCL(this.mc_server, this.mc_bsinfo);
        }
    }

    private class cRunnable_CreateMetadataJava
    implements Runnable {
        private DeployedJob mc_djob = null;
        private Job mc_job = null;
        private boolean mc_rc = false;
        private String mc_message = null;
        private SchedulerException mc_schexc = null;

        public cRunnable_CreateMetadataJava(Job job) {
            this.mc_job = job;
        }

        public DeployedJob getDeployedJob() {
            return this.mc_djob;
        }

        public boolean isSuccessful() {
            return this.mc_rc;
        }

        public String getErrorMessage() {
            if (this.mc_rc) {
                return null;
            }
            return this.mc_message;
        }

        public SchedulerException getSchedulerException() {
            return this.mc_schexc;
        }

        @Override
        public void run() {
            BatchServerInfo bsinfo = DeployedJobDialog.this.m_jobpanel.getSelectedServer();
            String repos = DeployedJobDialog.this.m_repos;
            String reposId = DeployedJobDialog.this.m_reposId;
            try {
                if (DeployedJobDialog.this.m_folder != null) {
                    repos = DeployedJobDialog.this.m_folder.getId().substring(0, 8);
                    reposId = "A0000001." + repos;
                }
            }
            catch (Exception e) {
                repos = DeployedJobDialog.this.m_repos;
                reposId = DeployedJobDialog.this.m_reposId;
            }
            try {
                if (DeployedJobDialog.this.m_sc == null) {
                    DeployedJobDialog.this.m_sc = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)DeployedJobDialog.this.m_store, reposId);
                }
                this.mc_djob = DataStepProgramDeployer.BuildMetaObjects(DeployedJobDialog.this.m_name, this.mc_job, DeployedJobDialog.this.m_sc, DeployedJobDialog.this.m_userContext, DeployedJobDialog.this.m_factory, DeployedJobDialog.this.m_store, repos);
                if (!this.mc_djob.commitChangesWithNoValidation()) {
                    this.mc_rc = false;
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    return;
                }
            }
            catch (SchedulerException ex) {
                this.mc_rc = false;
                this.mc_message = ex.getLocalizedMessage();
                this.mc_schexc = ex;
                return;
            }
            catch (MdException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RemoteException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            this.mc_rc = true;
        }
    }

    private class cRunnable_CreateMetadataDATAStep
    implements Runnable {
        private boolean mc_copy = true;
        private String mc_jcl = null;
        private DeployedJob mc_djob = null;
        private Job mc_job = null;
        private boolean mc_rc = false;
        private String mc_message = null;
        private SchedulerException mc_schexc = null;

        public cRunnable_CreateMetadataDATAStep(boolean copy, String jcl, Job job) {
            this.mc_copy = copy;
            this.mc_jcl = jcl;
            this.mc_job = job;
        }

        public DeployedJob getDeployedJob() {
            return this.mc_djob;
        }

        public boolean isSuccessful() {
            return this.mc_rc;
        }

        public String getErrorMessage() {
            if (this.mc_rc) {
                return null;
            }
            return this.mc_message;
        }

        public Directory getDeployedDirectory() {
            return DeployedJobDialog.this.m_dir;
        }

        public SchedulerException getSchedulerException() {
            return this.mc_schexc;
        }

        @Override
        public void run() {
            IFileService rio;
            String reposId;
            String repos;
            BatchServerInfo bsinfo;
            String jclExt;
            block56: {
                String filename = null;
                jclExt = null;
                if (this.mc_jcl != null) {
                    jclExt = "jcl";
                }
                bsinfo = DeployedJobDialog.this.m_jobpanel.getSelectedServer();
                repos = DeployedJobDialog.this.m_repos;
                reposId = DeployedJobDialog.this.m_reposId;
                try {
                    if (DeployedJobDialog.this.m_folder != null) {
                        repos = DeployedJobDialog.this.m_folder.getId().substring(0, 8);
                        reposId = "A0000001." + repos;
                    }
                }
                catch (Exception e) {
                    repos = DeployedJobDialog.this.m_repos;
                    reposId = DeployedJobDialog.this.m_reposId;
                }
                try {
                    if (!this.mc_copy) break block56;
                    rio = DeployedJobDialog.this.m_iworkspace.FileService();
                    filename = DeployedJobDialog.this.m_srcname;
                    if (DeployedJobDialog.this.m_srcpath != null) {
                        filename = CommandUtilities.createFullPath(DeployedJobDialog.this.m_srcpath, DeployedJobDialog.this.m_srcname, bsinfo.getOperatingSystem());
                    }
                    StringBuffer contents = CommandUtilities.readFromRemoteFile(rio, filename, bsinfo.getOperatingSystem());
                    try {
                        if (!CommandUtilities.saveToRemoteFile(DeployedJobDialog.this.m_iworkspace, DeployedJobDialog.this.m_fullname, bsinfo.getOperatingSystem(), contents.toString())) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.fmt"), DeployedJobDialog.this.m_fullname);
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{DeployedJobDialog.this.m_fullname});
                            return;
                        }
                    }
                    catch (SchedulerException se) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile2.fmt"), DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, se.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, se.getLocalizedMessage()});
                        return;
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        if (bsinfo.getOperatingSystem() == 2 && DeployedJobDialog.this.m_fullname.indexOf("/") < 0) {
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingJCLFile2.fmt"), DeployedJobDialog.this.m_fullname, ge.getLocalizedMessage());
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingJCLFile2.fmt", new Object[]{DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, ge.getLocalizedMessage()});
                        } else {
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile2.fmt"), DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, ge.getLocalizedMessage());
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, ge.getLocalizedMessage()});
                        }
                        return;
                    }
                }
                catch (GenericError e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    this.mc_schexc = new SchedulerException(e.getMessage());
                    return;
                }
                catch (RuntimeException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null || this.mc_message.length() == 0) {
                        this.mc_message = e.toString();
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message);
                    return;
                }
            }
            if (this.mc_jcl != null) {
                try {
                    rio = DeployedJobDialog.this.m_iworkspace.FileService();
                    String jclName = DeployedJobDialog.this.m_basename + "." + jclExt;
                    String strFullName = null;
                    try {
                        String dirString = "./";
                        Directory dir = MetaUtilities.getDirectory(bsinfo, DeployedJobDialog.this.m_jobpanel.getSelectedJCLDirectory(), (MdStore)DeployedJobDialog.this.m_store, reposId);
                        if (dir != null) {
                            dirString = dir.getDirectoryName();
                        }
                        strFullName = CommandUtilities.createFullPath(dirString, jclName, bsinfo.getOperatingSystem());
                        String runas = this.mc_djob != null ? this.mc_djob.getRunAs() : null;
                        this.mc_jcl = DataStepProgramDeployer.GenerateJCLFromTemplate(DeployedJobDialog.this.m_fullname, runas, this.mc_jcl);
                        if (!CommandUtilities.saveToRemoteFile(rio, strFullName, bsinfo.getOperatingSystem(), this.mc_jcl)) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.fmt"), strFullName);
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{strFullName});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile2.fmt"), strFullName, ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{strFullName, ge.getLocalizedMessage()});
                        return;
                    }
                }
                catch (MdException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null) {
                        this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    this.mc_schexc.initCause((Throwable)e);
                    return;
                }
                catch (RemoteException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    this.mc_schexc = new SchedulerException(e.getMessage());
                    return;
                }
                catch (RuntimeException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null || this.mc_message.length() == 0) {
                        this.mc_message = e.toString();
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message);
                    return;
                }
            }
            try {
                File fileObj;
                if (DeployedJobDialog.this.m_sc == null) {
                    DeployedJobDialog.this.m_sc = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)DeployedJobDialog.this.m_store, reposId);
                }
                if (DeployedJobDialog.this.m_codegen != null) {
                    rio = DeployedJobDialog.this.m_iworkspace.FileService();
                    try {
                        if (!CommandUtilities.saveToRemoteFile(rio, DeployedJobDialog.this.m_fullname, bsinfo.getOperatingSystem(), "VERIFYING WRITE TO FILE")) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.fmt"), DeployedJobDialog.this.m_fullname);
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{DeployedJobDialog.this.m_fullname});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile2.fmt"), DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{DeployedJobDialog.this.m_fullname != null ? DeployedJobDialog.this.m_fullname : DeployedJobDialog.this.m_srcname, ge.getLocalizedMessage()});
                        return;
                    }
                    try {
                        DeployedJob.deletePhysicalFile(DeployedJobDialog.this.m_iworkspace, DeployedJobDialog.this.m_fullname);
                    }
                    catch (SchedulerException ex) {
                        ex.printStackTrace();
                    }
                    DeployedJobDialog.this.m_codegen.setAppServer(IWorkspaceServer.getServerContext(DeployedJobDialog.this.m_sc));
                    DeployedJobDialog.this.m_codegen.setJob(this.mc_job);
                    String fileContent = DeployedJobDialog.this.m_codegen.generateSource();
                    try {
                        if (!CommandUtilities.saveToRemoteFile(rio, DeployedJobDialog.this.m_fullname, bsinfo.getOperatingSystem(), fileContent)) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.fmt"), DeployedJobDialog.this.m_fullname);
                            this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{DeployedJobDialog.this.m_fullname});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt"), DeployedJobDialog.this.m_dir.getDirectoryName(), ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt", new Object[]{DeployedJobDialog.this.m_dir.getDirectoryName(), ge.getLocalizedMessage()});
                        return;
                    }
                    catch (RuntimeException e) {
                        this.mc_rc = false;
                        String message = e.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = e.toString();
                        }
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("DeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt"), DeployedJobDialog.this.m_dir.getDirectoryName(), message);
                        this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt", new Object[]{DeployedJobDialog.this.m_dir.getDirectoryName(), message});
                        return;
                    }
                    fileObj = MetaUtilities.createSourceCodeObject(DeployedJobDialog.this.m_basename, DeployedJobDialog.this.m_dir, DeployedJobDialog.this.m_store, repos);
                    fileObj.setFileName(DeployedJobDialog.this.m_targetname);
                    this.mc_djob = DataStepProgramDeployer.BuildMetaObjects(this.mc_job, fileObj, DeployedJobDialog.this.m_basename, jclExt, DeployedJobDialog.this.m_dir, DeployedJobDialog.this.m_sc, DeployedJobDialog.this.m_userContext, DeployedJobDialog.this.m_factory, DeployedJobDialog.this.m_store, repos);
                    this.mc_djob.getDeployedJobObject().setName(DeployedJobDialog.this.m_name);
                } else {
                    this.mc_djob = DataStepProgramDeployer.BuildMetaObjects(DeployedJobDialog.this.m_name, DeployedJobDialog.this.m_targetname, DeployedJobDialog.this.m_basename, jclExt, DeployedJobDialog.this.m_dir, DeployedJobDialog.this.m_sc, DeployedJobDialog.this.m_userContext, DeployedJobDialog.this.m_factory, DeployedJobDialog.this.m_store, repos);
                    Job job = this.mc_djob.getJobObject();
                    if (job != null && DeployedJobDialog.this.m_srcname != null) {
                        Directory dir = null;
                        if (DeployedJobDialog.this.m_srcpath != null && (dir = MetaUtilities.getDirectoryFromPath(DeployedJobDialog.this.m_srcpath, (MdStore)DeployedJobDialog.this.m_store, reposId)) == null) {
                            String dirname = DeployedJobDialog.this.m_srcpath.substring(DeployedJobDialog.this.m_srcpath.lastIndexOf("/") + 1);
                            dir = MetaUtilities.createDirectoryObject(dirname, DeployedJobDialog.this.m_store, repos);
                            dir.setDirectoryName(DeployedJobDialog.this.m_srcpath);
                        }
                        fileObj = MetaUtilities.createSourceCodeObject(DeployedJobDialog.this.m_srcname, dir, DeployedJobDialog.this.m_store, repos);
                        if (DeployedJobDialog.this.m_srcname.indexOf(".") >= 0) {
                            fileObj.setFileName(DeployedJobDialog.this.m_srcname.substring(0, DeployedJobDialog.this.m_srcname.lastIndexOf(46)));
                            fileObj.setFileExtension(DeployedJobDialog.this.m_srcname.substring(DeployedJobDialog.this.m_srcname.lastIndexOf(46) + 1));
                        } else {
                            fileObj.setFileName(DeployedJobDialog.this.m_srcname);
                        }
                        fileObj.getDirectories().add((Object)dir);
                        MetaUtilities.setSourceForUserWrittenJob(job, fileObj, CommandUtilities.getWorkspaceServerComponentFromBatchServer(DeployedJobDialog.this.m_sc), "SCHEDULER_JOB");
                    }
                }
                if (!this.mc_djob.commitChangesWithNoValidation()) {
                    this.mc_rc = false;
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    return;
                }
            }
            catch (SchedulerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                this.mc_rc = false;
                this.mc_message = ex.getLocalizedMessage();
                this.mc_schexc = ex;
                return;
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("DeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, DeployedJobDialog.class, "DeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            this.mc_rc = true;
        }
    }

    protected static class cRunnable_Files
    implements Runnable {
        IWorkspace mc_workspace = null;
        BatchServerInfo mc_bsinfo = null;
        String mc_initialpath = null;
        IFileServiceSelectorPanel mc_fileList = null;

        cRunnable_Files(IWorkspace iworkspace, BatchServerInfo bsinfo, String initpath) {
            this.mc_workspace = iworkspace;
            this.mc_bsinfo = bsinfo;
            this.mc_initialpath = initpath;
        }

        public IFileServiceSelectorPanel getSelector() {
            return this.mc_fileList;
        }

        @Override
        public void run() {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(m_bundle.getString("DeployedJobDialog.FileTypeDesc.txt"), m_bundle.getString("DeployedJobDialog.FileTypePattern.lcl"));
            try {
                this.mc_fileList = this.mc_bsinfo.getOperatingSystem() == 2 ? new IFileServiceSelectorPanel(this.mc_initialpath, this.mc_workspace, fileTypes, 2) : new IFileServiceSelectorPanel(this.mc_initialpath, this.mc_workspace, fileTypes, false);
                this.mc_fileList.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_ONLY);
            }
            catch (Exception ex) {
                this.mc_fileList = null;
            }
        }
    }

    protected class cBrowseAction
    implements ActionListener {
        DirectoryPanel mc_panel;

        public cBrowseAction(DirectoryPanel panel) {
            this.mc_panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = DeployedJobDialog.this.launchDirChooser();
            if (text != null) {
                this.mc_panel.setDirectoryText(text);
            }
        }
    }
}

