/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.RB;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class RangeColorMapper {
    private double dataMin = Double.NaN;
    private double dataMax = Double.NaN;
    private Style style = null;
    private Vector<AttributeMapRange> ranges = null;
    public static final int MERGED_RANGE = 1;
    public static final int DATA_RANGE = 2;
    public static final int ATTR_MAP_RANGE = 3;
    private Color missingColor = null;
    private Color otherColor = null;
    private Color underflowColor = null;
    private Color overflowColor = null;
    private RangeAttrBundle attrMapMissingAttrs = null;
    private RangeAttrBundle attrMapOtherAttrs = null;
    private RangeAttrBundle attrMapUnderflowAttrs = null;
    private RangeAttrBundle attrMapOverflowAttrs = null;
    private MarkerAttrs missingMarkerAttrs;
    private MarkerAttrs otherMarkerAttrs;
    private MarkerAttrs underflowMarkerAttrs;
    private MarkerAttrs overflowMarkerAttrs;
    private String missingLabel = null;
    private String otherLabel = null;
    private String underflowLabel = null;
    private String overflowLabel = null;
    private boolean contrastColors = true;
    private static final String MISSING_LABEL = "MISSING";
    private static final String OTHER_LABEL = "OTHER";
    private static final String UNDERFLOW_LABEL = "UNDERFLOW";
    private static final String OVERFLOW_LABEL = "OVERFLOW";
    private Hashtable<String, MarkerAttrs> markerAttrsTable = null;
    private Hashtable<String, String> rangeLabelTable = null;
    private SASFormat format = null;
    private boolean missingDefined = false;
    private boolean otherDefined = false;
    private boolean underflowDefined = false;
    private boolean overflowDefined = false;

    RangeColorMapper(Vector<AttributeMapRange> ranges, double min, double max, Style style, boolean missingDefined, RangeAttrBundle missingAttrs, boolean otherDefined, RangeAttrBundle otherAttrs, boolean underflowDefined, RangeAttrBundle underflowAttrs, boolean overflowDefined, RangeAttrBundle overflowAttrs, boolean contrastColors, SASFormat format) {
        this.ranges = ranges;
        this.dataMin = min;
        this.dataMax = max;
        this.attrMapMissingAttrs = missingAttrs != null ? new RangeAttrBundle(missingAttrs) : new RangeAttrBundle();
        this.attrMapOtherAttrs = otherAttrs != null ? new RangeAttrBundle(otherAttrs) : new RangeAttrBundle();
        this.attrMapUnderflowAttrs = underflowAttrs != null ? new RangeAttrBundle(underflowAttrs) : new RangeAttrBundle();
        this.attrMapOverflowAttrs = overflowAttrs != null ? new RangeAttrBundle(overflowAttrs) : new RangeAttrBundle();
        this.contrastColors = contrastColors;
        this.format = format;
        this.missingDefined = missingDefined;
        this.otherDefined = otherDefined;
        this.underflowDefined = underflowDefined;
        this.overflowDefined = overflowDefined;
        this.orderRanges();
        this.applyStyle(style);
    }

    private void orderRanges() {
        for (int i = 0; i < this.ranges.size() - 1; ++i) {
            for (int j = i + 1; j < this.ranges.size(); ++j) {
                AttributeMapRange r1 = this.ranges.get(i);
                AttributeMapRange r2 = this.ranges.get(j);
                if (!(r1.getMin().getValue() > r2.getMin().getValue())) continue;
                this.ranges.remove(j);
                this.ranges.remove(i);
                this.ranges.insertElementAt(r2, i);
                this.ranges.insertElementAt(r1, j);
            }
        }
    }

    public void applyStyle(Style style) {
        if (this.ranges == null || style == null) {
            return;
        }
        this.style = style;
        for (int i = 0; i < this.ranges.size(); ++i) {
            this.ranges.get(i).applyStyle(style);
        }
        this.attrMapMissingAttrs.applyStyle(style);
        this.attrMapOtherAttrs.applyStyle(style);
        this.attrMapUnderflowAttrs.applyStyle(style);
        this.attrMapOverflowAttrs.applyStyle(style);
        this.missingColor = this.resolveColor(this.attrMapMissingAttrs, "Missing");
        this.otherColor = this.resolveColor(this.attrMapOtherAttrs, "Other");
        this.underflowColor = this.resolveColor(this.attrMapUnderflowAttrs, "Underflow");
        this.overflowColor = this.resolveColor(this.attrMapOverflowAttrs, "Overflow");
        this.missingMarkerAttrs = this.resolveMarkerSymbol(this.attrMapMissingAttrs, "Missing");
        this.otherMarkerAttrs = this.resolveMarkerSymbol(this.attrMapOtherAttrs, "Other");
        this.underflowMarkerAttrs = this.resolveMarkerSymbol(this.attrMapUnderflowAttrs, "Underflow");
        this.overflowMarkerAttrs = this.resolveMarkerSymbol(this.attrMapOverflowAttrs, "Overflow");
        this.missingLabel = this.attrMapMissingAttrs != null && this.attrMapMissingAttrs.getLabel() != null ? this.attrMapMissingAttrs.getLabel() : RB.getStringResource("RangeAttributeMap.", "Missing.txt");
        this.otherLabel = this.attrMapOtherAttrs != null && this.attrMapOtherAttrs.getLabel() != null ? this.attrMapOtherAttrs.getLabel() : RB.getStringResource("RangeAttributeMap.", "Other.txt");
        this.underflowLabel = this.attrMapUnderflowAttrs != null && this.attrMapUnderflowAttrs.getLabel() != null ? this.attrMapUnderflowAttrs.getLabel() : RB.getStringResource("RangeAttributeMap.", "Underflow.txt");
        this.overflowLabel = this.attrMapOverflowAttrs != null && this.attrMapOverflowAttrs.getLabel() != null ? this.attrMapOverflowAttrs.getLabel() : RB.getStringResource("RangeAttributeMap.", "Overflow.txt");
    }

    private Color resolveColor(RangeAttrBundle attrBundle, String styleElementName) {
        if (attrBundle != null) {
            ColorModel cm;
            ColorModel colorModel = cm = this.contrastColors ? attrBundle.getRangeAltColorModel() : attrBundle.getRangeColorModel();
            if (cm != null && cm.getColors() != null) {
                return cm.getColors()[0];
            }
        }
        DataStyleElement dse = this.style.getDataStyleElement(styleElementName);
        return this.contrastColors ? dse.getContrastColor() : dse.getFillColor();
    }

    private MarkerAttrs resolveMarkerSymbol(RangeAttrBundle attrBundle, String styleElementName) {
        if (attrBundle != null && attrBundle.getMarkerAttrs() != null) {
            return attrBundle.getMarkerAttrs();
        }
        MarkerStyleElement mse = this.style.getDataStyleElement(styleElementName).getAsMarkerStyle();
        MarkerAttrs ma = new MarkerAttrs(mse.getMarkerColor(), mse.getMarkerSymbol(), mse.getMarkerSize().getSizeValue());
        return ma;
    }

    public String getRangeLabel(double value) {
        if (Double.isNaN(value)) {
            return MISSING_LABEL;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            AttributeMapRange r = this.ranges.get(i);
            if (i == 0 && value < r.getMin().getValue()) {
                return UNDERFLOW_LABEL;
            }
            if (i == this.ranges.size() - 1 && value > r.getMax().getValue()) {
                return OVERFLOW_LABEL;
            }
            if (!r.contains(value)) continue;
            return r.getMathematicalRepresentation(this.format);
        }
        return OTHER_LABEL;
    }

    public MarkerAttrs getMappedMarkerAttrs(String rangeLabel) {
        if (this.markerAttrsTable == null) {
            this.buildMarkerSymbolTable();
        }
        if (this.markerAttrsTable.containsKey(rangeLabel)) {
            return this.markerAttrsTable.get(rangeLabel);
        }
        return this.otherMarkerAttrs;
    }

    private void buildMarkerSymbolTable() {
        if (this.markerAttrsTable == null) {
            this.markerAttrsTable = new Hashtable();
        } else {
            this.markerAttrsTable.clear();
        }
        this.markerAttrsTable.put(MISSING_LABEL, this.missingMarkerAttrs);
        this.markerAttrsTable.put(OTHER_LABEL, this.otherMarkerAttrs);
        this.markerAttrsTable.put(UNDERFLOW_LABEL, this.underflowMarkerAttrs);
        this.markerAttrsTable.put(OVERFLOW_LABEL, this.overflowMarkerAttrs);
        for (int i = 0; i < this.ranges.size(); ++i) {
            AttributeMapRange r = this.ranges.get(i);
            this.markerAttrsTable.put(r.getMathematicalRepresentation(this.format), r.getRangeAttrBundle().getMarkerAttrs());
        }
    }

    public String getLabel(String rangeLabel) {
        if (this.rangeLabelTable == null) {
            this.buildRangeLabelTable();
        }
        if (this.rangeLabelTable.containsKey(rangeLabel)) {
            return this.rangeLabelTable.get(rangeLabel);
        }
        return rangeLabel;
    }

    private void buildRangeLabelTable() {
        if (this.rangeLabelTable == null) {
            this.rangeLabelTable = new Hashtable();
        } else {
            this.rangeLabelTable.clear();
        }
        this.rangeLabelTable.put(MISSING_LABEL, this.missingLabel);
        this.rangeLabelTable.put(OTHER_LABEL, this.otherLabel);
        this.rangeLabelTable.put(UNDERFLOW_LABEL, this.underflowLabel);
        this.rangeLabelTable.put(OVERFLOW_LABEL, this.overflowLabel);
        for (int i = 0; i < this.ranges.size(); ++i) {
            AttributeMapRange r = this.ranges.get(i);
            this.rangeLabelTable.put(r.getMathematicalRepresentation(this.format), r.getLabel(this.format));
        }
    }

    public Color getMappedColor(double value) {
        if ((this.missingDefined || !this.otherDefined) && Double.isNaN(value)) {
            return this.missingColor;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            AttributeMapRange r = this.ranges.get(i);
            if (i == 0 && (value < r.getMin().getValue() || value == r.getMin().getValue() && !r.getMin().isInclusive()) && (this.underflowDefined || !this.otherDefined)) {
                return this.underflowColor;
            }
            if (i == this.ranges.size() - 1 && (value > r.getMax().getValue() || value == r.getMax().getValue() && !r.getMax().isInclusive()) && (this.overflowDefined || !this.otherDefined)) {
                return this.overflowColor;
            }
            if (!r.contains(value)) continue;
            return RangeColorMapper.getMappedColor(this.getColorModel(r).getColors(), r.getMin().getValue(), r.getMax().getValue(), value);
        }
        return this.otherColor;
    }

    private ColorModel getColorModel(AttributeMapRange range) {
        if (range == null) {
            return null;
        }
        RangeAttrBundle rangeAttrs = range.getRangeAttrBundle();
        return this.contrastColors ? rangeAttrs.getRangeAltColorModel() : rangeAttrs.getRangeColorModel();
    }

    public static Color getMappedColor(Color[] colorList, double min, double max, double value) {
        if (colorList == null || colorList.length < 1) {
            return null;
        }
        if (min > max) {
            return null;
        }
        if (value < min || value > max) {
            return null;
        }
        if (colorList.length == 1) {
            return colorList[0];
        }
        if (value == min) {
            return colorList[0];
        }
        if (value == max) {
            return colorList[colorList.length - 1];
        }
        double normalizedValue = (value - min) / (max - min);
        int numSegments = colorList.length - 1;
        int segment = (int)(normalizedValue * (double)numSegments);
        if (segment == numSegments) {
            --segment;
        }
        double segmentMin = 1.0 * (double)segment / (double)numSegments;
        double segmentNormalizedValue = (normalizedValue - segmentMin) * (double)numSegments;
        return RangeColorMapper.interpolateColor(segmentNormalizedValue, colorList[segment], colorList[segment + 1]);
    }

    public static Color interpolateColor(double value, Color c1, Color c2) {
        value = Math.min(1.0, Math.max(0.0, value));
        int r = c1.getRed() + (int)(value * (double)(c2.getRed() - c1.getRed()));
        int g = c1.getGreen() + (int)(value * (double)(c2.getGreen() - c1.getGreen()));
        int b = c1.getBlue() + (int)(value * (double)(c2.getBlue() - c1.getBlue()));
        int alpha = c1.getAlpha() + (int)(value * (double)(c2.getAlpha() - c1.getAlpha()));
        return new Color(r, g, b, alpha);
    }

    public Range[] getFullRanges(double transparency) {
        Vector<Range> dr = new Vector<Range>();
        AttributeMapRange first = this.ranges.get(0);
        AttributeMapRange last = this.ranges.get(this.ranges.size() - 1);
        int cmp1 = first.getMin().compareTo(this.dataMin);
        int cmp2 = last.getMax().compareTo(this.dataMax);
        ColorModel otherCM = new ColorModel(new Color[]{this.otherColor}, transparency);
        if (cmp1 > 0) {
            Range r = null;
            if (this.underflowDefined || !this.otherDefined) {
                r = new Range(new RangeBound(this.dataMin, true), new RangeBound(first.getMin().getValue(), !first.getMin().isInclusive()), new ColorModel(new Color[]{this.underflowColor}, transparency));
                r.setLabel(this.underflowLabel);
                r.setMarkerAttrs(this.underflowMarkerAttrs);
            } else {
                r = new Range(new RangeBound(this.dataMin, true), new RangeBound(first.getMin().getValue(), !first.getMin().isInclusive()), new ColorModel(new Color[]{this.otherColor}, transparency));
                r.setLabel(this.otherLabel);
                r.setMarkerAttrs(this.otherMarkerAttrs);
            }
            dr.add(r);
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            AttributeMapRange r = this.ranges.get(i);
            ColorModel cm = new ColorModel(this.getColorModel(r).getColors(), transparency);
            Range newRange = new Range(r.getMin(), r.getMax(), cm);
            newRange.setLabel(r.getRangeAttrBundle().getLabel());
            newRange.setMarkerAttrs(r.getRangeAttrBundle().getMarkerAttrs());
            dr.add(newRange);
            if (i >= this.ranges.size() - 1) continue;
            AttributeMapRange r2 = this.ranges.get(i + 1);
            if (r.getMax().getValue() == r2.getMin().getValue()) continue;
            Range newR = new Range(new RangeBound(r.getMax().getValue(), !r.getMax().isInclusive()), new RangeBound(r2.getMin().getValue(), !r2.getMin().isInclusive()), otherCM);
            newR.setLabel(this.otherLabel);
            newR.setMarkerAttrs(this.otherMarkerAttrs);
            dr.add(newR);
        }
        if (cmp2 < 0) {
            Range newR = null;
            if (this.overflowDefined || !this.otherDefined) {
                newR = new Range(new RangeBound(last.getMax().getValue(), !last.getMax().isInclusive()), new RangeBound(this.dataMax, true), new ColorModel(new Color[]{this.overflowColor}, transparency));
                newR.setLabel(this.overflowLabel);
                newR.setMarkerAttrs(this.overflowMarkerAttrs);
            } else {
                newR = new Range(new RangeBound(last.getMax().getValue(), !last.getMax().isInclusive()), new RangeBound(this.dataMax, true), new ColorModel(new Color[]{this.otherColor}, transparency));
                newR.setLabel(this.otherLabel);
                newR.setMarkerAttrs(this.otherMarkerAttrs);
            }
            dr.add(newR);
        }
        return dr.toArray(new Range[dr.size()]);
    }

    public static void main(String[] args) {
    }
}

