/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

public class RangeBound {
    public static final String MIN = "MIN";
    public static final String MIN_ABS = "MINABS";
    public static final String NEG_MIN = "NEGMIN";
    public static final String NEG_MIN_ABS = "NEGMINABS";
    public static final String MAX = "MAX";
    public static final String MAX_ABS = "MAXABS";
    public static final String NEG_MAX = "NEGMAX";
    public static final String NEG_MAX_ABS = "NEGMAXABS";
    private String keyword = null;
    private double value = Double.NaN;
    private boolean inclusive = false;
    private boolean dataBound = false;

    public RangeBound(double value, boolean inclusive) {
        this.init(null, value, inclusive);
    }

    public RangeBound(String keyword, boolean inclusive) {
        this.init(keyword, Double.NaN, inclusive);
    }

    private void init(String keyword, double value, boolean inclusive) {
        this.keyword = keyword;
        this.value = value;
        this.inclusive = inclusive;
    }

    public RangeBound(RangeBound rb) {
        if (rb == null) {
            return;
        }
        this.init(rb.getKeyword(), rb.getValue(), rb.isInclusive());
    }

    public boolean isKeyword() {
        return this.keyword != null;
    }

    public static boolean isKeyword(String value) {
        return MIN.equalsIgnoreCase(value) || MIN_ABS.equalsIgnoreCase(value) || NEG_MIN.equalsIgnoreCase(value) || NEG_MIN_ABS.equalsIgnoreCase(value) || MAX.equalsIgnoreCase(value) || MAX_ABS.equalsIgnoreCase(value) || NEG_MAX.equalsIgnoreCase(value) || NEG_MAX_ABS.equalsIgnoreCase(value);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        if (this.keyword == null) {
            this.value = val;
        }
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void bindToDataMinMax(double min, double max) {
        if (!this.isKeyword()) {
            return;
        }
        if (MIN.equalsIgnoreCase(this.keyword)) {
            this.value = min;
        } else if (MIN_ABS.equalsIgnoreCase(this.keyword)) {
            this.value = Math.min(Math.abs(min), Math.abs(max));
        } else if (NEG_MIN.equalsIgnoreCase(this.keyword)) {
            this.value = -min;
        } else if (NEG_MIN_ABS.equalsIgnoreCase(this.keyword)) {
            this.value = -Math.min(Math.abs(min), Math.abs(max));
        } else if (MAX.equalsIgnoreCase(this.keyword)) {
            this.value = max;
        } else if (MAX_ABS.equalsIgnoreCase(this.keyword)) {
            this.value = Math.max(Math.abs(min), Math.abs(max));
        } else if (NEG_MAX.equalsIgnoreCase(this.keyword)) {
            this.value = -max;
        } else if (NEG_MAX_ABS.equalsIgnoreCase(this.keyword)) {
            this.value = -Math.max(Math.abs(min), Math.abs(max));
        }
        this.dataBound = true;
    }

    public boolean isDataBound() {
        return this.dataBound;
    }

    public boolean equalTo(RangeBound rb) {
        if (rb == null) {
            return false;
        }
        if (rb.isKeyword() != this.isKeyword()) {
            return false;
        }
        if (rb.isInclusive() != this.isInclusive()) {
            return false;
        }
        return rb.getValue() == this.value;
    }

    public int compareTo(double d) {
        if (this.isKeyword() && !this.isDataBound()) {
            return -1;
        }
        if (this.isInclusive() && this.value == d) {
            return 0;
        }
        if (this.value > d) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Value = " + this.getValue() + " inclusive = " + this.isInclusive());
        sb.append("\n");
        return sb.toString();
    }
}

