/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.ParserUtils;
import com.sas.graphics.util.attrmap.RB;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RangeAttributeMapParser {
    public static final String RB_KEY = "RangeAttributeMapParser.";

    public static Object load(Element elem, Style graphStyle) {
        RangeAttributeMap rangeAttrMap = null;
        if (elem != null && "RangeAttrMap".equals(elem.getTagName())) {
            String name = elem.getAttribute("name");
            rangeAttrMap = new RangeAttributeMap(name);
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                RangeBound max;
                RangeBound min;
                Object o;
                Element e;
                if (!(node instanceof Element) || !"AttrRange".equals((e = (Element)node).getTagName())) continue;
                boolean inclusive = true;
                String minValue = e.getAttribute("minValue");
                if ("true".equalsIgnoreCase(e.getAttribute("minExclude"))) {
                    inclusive = false;
                }
                if ("Missing".equalsIgnoreCase(minValue)) {
                    rangeAttrMap.setMissingDefined(true);
                    o = RangeAttributeMapParser.parseRangeAttrs(e, graphStyle, null, RB.getStringResource("RangeAttributeMap.", "Missing.txt"), false);
                    if (o instanceof String) {
                        return o.toString();
                    }
                    if (!(o instanceof RangeAttrBundle)) continue;
                    rangeAttrMap.setMissingAttrs((RangeAttrBundle)o);
                    continue;
                }
                if ("Other".equalsIgnoreCase(minValue)) {
                    rangeAttrMap.setOtherDefined(true);
                    o = RangeAttributeMapParser.parseRangeAttrs(e, graphStyle, null, RB.getStringResource("RangeAttributeMap.", "Other.txt"), false);
                    if (o instanceof String) {
                        return o.toString();
                    }
                    if (!(o instanceof RangeAttrBundle)) continue;
                    RangeAttrBundle rab = (RangeAttrBundle)o;
                    if (rab.getKPIColor() == null) {
                        rab.setKPIColor(ParserUtils.parseColor("Other:color", graphStyle));
                    }
                    rangeAttrMap.setOtherAttrs(rab);
                    continue;
                }
                if ("Under".equalsIgnoreCase(minValue)) {
                    rangeAttrMap.setUnderflowDefined(true);
                    o = RangeAttributeMapParser.parseRangeAttrs(e, graphStyle, null, RB.getStringResource("RangeAttributeMap.", "Underflow.txt"), false);
                    if (o instanceof String) {
                        return o.toString();
                    }
                    if (!(o instanceof RangeAttrBundle)) continue;
                    rangeAttrMap.setUnderflowAttrs((RangeAttrBundle)o);
                    continue;
                }
                if ("Over".equalsIgnoreCase(minValue)) {
                    rangeAttrMap.setOverflowDefined(true);
                    o = RangeAttributeMapParser.parseRangeAttrs(e, graphStyle, null, RB.getStringResource("RangeAttributeMap.", "Overflow.txt"), false);
                    if (o instanceof String) {
                        return o.toString();
                    }
                    if (!(o instanceof RangeAttrBundle)) continue;
                    rangeAttrMap.setOverflowAttrs((RangeAttrBundle)o);
                    continue;
                }
                if (RangeBound.isKeyword(minValue)) {
                    min = new RangeBound(minValue, inclusive);
                } else {
                    try {
                        double d = Double.parseDouble(minValue);
                        min = new RangeBound(d, inclusive);
                    }
                    catch (NumberFormatException nfe) {
                        String s = RB.getStringResource(RB_KEY, "InvalidRangeBound.fmt.txt");
                        return MessageFormat.format(s, minValue);
                    }
                }
                inclusive = true;
                String maxValue = e.getAttribute("maxValue");
                if ("true".equalsIgnoreCase(e.getAttribute("maxExclude"))) {
                    inclusive = false;
                }
                if (RangeBound.isKeyword(maxValue)) {
                    max = new RangeBound(maxValue, inclusive);
                } else {
                    try {
                        double d = Double.parseDouble(maxValue);
                        max = new RangeBound(d, inclusive);
                    }
                    catch (NumberFormatException nfe) {
                        String s = RB.getStringResource(RB_KEY, "InvalidRangeBound.fmt.txt");
                        return MessageFormat.format(s, maxValue);
                    }
                }
                RangeAttrBundle rangeAttrs = null;
                Object o2 = RangeAttributeMapParser.parseRangeAttrs(e, graphStyle, "GraphDataStyleDefault", null, false);
                if (o2 instanceof String) {
                    return o2.toString();
                }
                if (o2 instanceof RangeAttrBundle) {
                    rangeAttrs = (RangeAttrBundle)o2;
                }
                if (rangeAttrs.getKPIColor() == null) {
                    rangeAttrs.setKPIColor(ParserUtils.parseColor("KPIRangeDefault:color", graphStyle));
                }
                if (min == null || max == null) {
                    return null;
                }
                rangeAttrMap.addRange(new AttributeMapRange(min, max, rangeAttrs));
            }
            String err = RangeAttributeMap.validateRanges(rangeAttrMap.getRanges());
            if (err != null) {
                return err;
            }
        }
        return rangeAttrMap;
    }

    private static Object parseRangeAttrs(Element elem, Style graphStyle, String styleElementName, String defaultLabel, boolean setDefaultKPIColor) {
        ColorModel cm = RangeAttributeMapParser.parseColorModel(elem, "rangeColorModel", "Colors", graphStyle);
        Object o = RangeAttributeMapParser.parseColor(elem, "RangeColor", elem.getAttribute("rangeColor"), graphStyle);
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof Color) {
            cm = new ColorModel(new Color[]{(Color)o});
        }
        if (cm == null && styleElementName != null) {
            cm = new ColorModel(new Color[]{ParserUtils.parseColor(styleElementName + ":" + "color", graphStyle)});
        }
        ColorModel acm = RangeAttributeMapParser.parseColorModel(elem, "rangeAltColorModel", "AltColors", graphStyle);
        o = RangeAttributeMapParser.parseColor(elem, "RangeAltColor", elem.getAttribute("rangeAltColor"), graphStyle);
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof Color) {
            acm = new ColorModel(new Color[]{(Color)o});
        }
        if (acm == null && styleElementName != null) {
            acm = new ColorModel(new Color[]{ParserUtils.parseColor(styleElementName + ":" + "altColor", graphStyle)});
        }
        Color kc = null;
        Color kac = null;
        o = RangeAttributeMapParser.parseColorAttribute(elem.getAttribute("kpiColor"), graphStyle);
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof Color) {
            kc = (Color)o;
        } else if (setDefaultKPIColor) {
            kc = ParserUtils.parseColor(styleElementName + ":" + "color", graphStyle);
        }
        o = RangeAttributeMapParser.parseColorAttribute(elem.getAttribute("kpiActiveColor"), graphStyle);
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof Color) {
            kac = (Color)o;
        }
        MarkerAttrs ms = new MarkerAttrs();
        Element markerElem = null;
        NodeList markerAttrsList = elem.getElementsByTagName("MarkerAttrs");
        if (markerAttrsList != null && markerAttrsList.getLength() > 0) {
            markerElem = (Element)markerAttrsList.item(0);
        }
        String mrkAttr = elem.getAttribute("markerAttrs");
        RangeAttributeMapParser.setDefaultMarkerStyle(graphStyle, mrkAttr, ms, "GraphDataStyleDefault");
        if (markerElem != null) {
            RangeAttributeMapParser.parseMarkerAttrs(graphStyle, markerElem, ms);
        }
        String label = defaultLabel;
        if (elem.hasAttribute("label")) {
            label = elem.getAttribute("label");
        }
        return new RangeAttrBundle(cm, acm, kc, kac, ms, label);
    }

    public static void parseMarkerAttrs(Style style, Element elem, MarkerAttrs markerStyle) {
        int symbol;
        String str;
        if (elem == null) {
            return;
        }
        Color c = ParserUtils.parseColor(elem.getAttribute("color"), style);
        if (c != null) {
            markerStyle.setColor(c);
        }
        if ((str = ParserUtils.parseAttrString("symbol", style, elem)) != null && str.length() > 0 && (symbol = Markers.getShape((String)str)) >= 0) {
            markerStyle.setShape(symbol);
        }
    }

    private static void setDefaultMarkerStyle(Style style, String styleElem, MarkerAttrs markerStyle, String defaultStyleElem) {
        MarkerStyleElement markerElem = style.getMarkerStyleElement("GraphDataStyleDefault");
        if (defaultStyleElem != null) {
            markerElem = markerElem.mergeWith((StyleElement)style.getMarkerStyleElement(defaultStyleElem)).getAsMarkerStyle();
        }
        if (styleElem != null && styleElem.length() > 0) {
            markerElem = markerElem.mergeWith((StyleElement)style.getMarkerStyleElement(styleElem)).getAsMarkerStyle();
        }
        markerStyle.setColor(markerElem.getMarkerColor());
        markerStyle.setShape(markerElem.getMarkerSymbol());
    }

    private static ColorModel parseColorModel(Element elem, String colorModelName, String childElemName, Style graphStyle) {
        Element colorsElem;
        NodeList colValues;
        if (elem.hasAttribute(colorModelName)) {
            return new ColorModel(elem.getAttribute(colorModelName));
        }
        NodeList colorsList = elem.getElementsByTagName(childElemName);
        if (colorsList != null && colorsList.getLength() > 0 && (colValues = (colorsElem = (Element)colorsList.item(0)).getElementsByTagName("Value")) != null && colValues.getLength() > 0) {
            Vector<Color> cols = new Vector<Color>();
            for (int i = 0; i < colValues.getLength(); ++i) {
                Element colValue = (Element)colValues.item(i);
                Color c = ParserUtils.parseColor(colValue.getTextContent(), graphStyle);
                if (c == null) continue;
                cols.add(c);
            }
            if (cols.size() > 0) {
                return new ColorModel(cols.toArray(new Color[cols.size()]));
            }
        }
        return null;
    }

    private static Object parseColor(Element elem, String colorElemName, String colorAttribute, Style graphStyle) {
        NodeList colorElemList = elem.getElementsByTagName(colorElemName);
        if (colorElemList != null && colorElemList.getLength() > 0) {
            Element colorElem = (Element)colorElemList.item(0);
            Vector<String> params = new Vector<String>();
            params.add(colorElem.getAttribute("startColor"));
            params.add(colorElem.getAttribute("endColor"));
            params.add(colorElem.getAttribute("stepCount"));
            params.add(colorElem.getAttribute("stepIndex"));
            return RangeAttributeMapParser.parseGradientStepper(params, colorAttribute, graphStyle);
        }
        return RangeAttributeMapParser.parseColorAttribute(colorAttribute, graphStyle);
    }

    private static Object parseColorAttribute(String colorAttribute, Style graphStyle) {
        Color color = null;
        if (colorAttribute != null && colorAttribute.length() > 0) {
            if (colorAttribute.toUpperCase().startsWith("GRADIENTSTEPPER")) {
                String gsParams = colorAttribute.substring("GradientStepper".length()).replace("(", "").replace(")", "").trim();
                StringTokenizer st = new StringTokenizer(gsParams, ",");
                Vector<String> params = new Vector<String>();
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    params.add(s);
                }
                return RangeAttributeMapParser.parseGradientStepper(params, colorAttribute, graphStyle);
            }
            color = ParserUtils.parseColor(colorAttribute, graphStyle);
            if (color == null) {
                String s = RB.getStringResource(RB_KEY, "InvalidColorSpecified.fmt.txt");
                return MessageFormat.format(s, colorAttribute);
            }
        }
        return color;
    }

    private static Object parseGradientStepper(Vector<String> params, String colorAttribute, Style graphStyle) {
        if (params.size() != 4) {
            String s = RB.getStringResource(RB_KEY, "InvalidArgumentList.fmt.txt");
            return MessageFormat.format(s, colorAttribute, "GradientStepper");
        }
        Color color1 = ParserUtils.parseColor(params.get(0), graphStyle);
        Color color2 = ParserUtils.parseColor(params.get(1), graphStyle);
        if (color1 == null) {
            String s = RB.getStringResource(RB_KEY, "InvalidColorSpecified.fmt.txt");
            return MessageFormat.format(s, params.get(0), "GradientStepper");
        }
        if (color2 == null) {
            String s = RB.getStringResource(RB_KEY, "InvalidColorSpecified.fmt.txt");
            return MessageFormat.format(s, params.get(1), "GradientStepper");
        }
        if (!ParserUtils.isInteger(params.get(2))) {
            String s = RB.getStringResource(RB_KEY, "InvalidNumberSteps.fmt.txt");
            return MessageFormat.format(s, params.get(2), "GradientStepper");
        }
        int numSteps = Integer.parseInt(params.get(2));
        if (!ParserUtils.isInteger(params.get(3))) {
            String s = RB.getStringResource(RB_KEY, "InvalidStep.fmt.txt");
            return MessageFormat.format(s, params.get(3), "GradientStepper");
        }
        int step = Integer.parseInt(params.get(3));
        if (step <= 0 || step > numSteps) {
            String s = RB.getStringResource(RB_KEY, "InvalidStep.fmt.txt");
            return MessageFormat.format(s, params.get(3), "GradientStepper");
        }
        return RangeColorMapper.getMappedColor(new Color[]{color1, color2}, 1.0, numSteps, step);
    }
}

