/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.SASColors;
import java.awt.Color;
import org.w3c.dom.Element;

public class ParserUtils {
    private static final SASColors sasColor = SASColors.getInstance();
    private static final String styleRefSeparator = ":";

    private static String getStyleAttribute(Style graphStyle, String context, String attr) {
        if (context == null) {
            return null;
        }
        StyleElement elem = graphStyle.getStyleElement(context);
        return elem.getAttribute(attr);
    }

    public static Color parseColor(String str, Style graphStyle) {
        Color color = null;
        if (str.length() > 0) {
            if (str.indexOf(styleRefSeparator) >= 0) {
                String en = ParserUtils.parseStyleElementName(str);
                String an = ParserUtils.parseStyleAttributeName(str);
                if ((en = graphStyle.remapDataElement(en, an)) != null) {
                    color = sasColor.getColor(ParserUtils.getStyleAttribute(graphStyle, en, an));
                }
            } else {
                color = sasColor.getColor(str.toUpperCase());
            }
        }
        return color;
    }

    private static String parseStyleElementName(String str) {
        int index = str.indexOf(styleRefSeparator);
        String en = str.substring(0, index);
        return en;
    }

    private static String parseStyleAttributeName(String str) {
        int index = str.indexOf(styleRefSeparator);
        String an = str.substring(index + 1);
        return an;
    }

    public static int scale(int size, double dpiScaleFactor, double sizeScaleFactor) {
        return (int)Math.round((double)size * dpiScaleFactor * sizeScaleFactor);
    }

    public static boolean isInteger(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String parseAttrString(String attr, Style graphStyle, Element elem) {
        String str = elem.getAttribute(attr);
        String name = null;
        if (str.length() > 0) {
            if (str.indexOf(styleRefSeparator) >= 0) {
                String en = ParserUtils.parseStyleElementName(str);
                String an = ParserUtils.parseStyleAttributeName(str);
                if ((en = graphStyle.remapDataElement(en, an)) != null) {
                    name = ParserUtils.getStyleAttribute(graphStyle, en, an);
                }
            } else {
                name = str;
            }
        }
        return name;
    }

    private static int unitToPixels(String unit, int containerHeight, int DPI, double dpiScaleFactor, double sizeScaleFactor) {
        if (unit == null) {
            return -1;
        }
        return ParserUtils.scale(new Size(unit).toPixels(DPI, containerHeight), dpiScaleFactor, sizeScaleFactor);
    }

    public static Color parseAttrColor(String attr, Style graphStyle, Element elem) {
        if (elem == null) {
            return null;
        }
        String str = elem.getAttribute(attr);
        return ParserUtils.parseColor(str, graphStyle);
    }

    public static int parseAttrNumber(String attr, Style graphStyle, Element elem, int containerHeight, int DPI, double dpiScaleFactor, double sizeScaleFactor) {
        if (elem == null) {
            return -1;
        }
        String str = elem.getAttribute(attr);
        return ParserUtils.parseNumber(str, graphStyle, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor);
    }

    public static int parseNumber(String str, Style graphStyle, int containerHeight, int DPI, double dpiScaleFactor, double sizeScaleFactor) {
        int size = -1;
        if (str.length() > 0) {
            if (str.indexOf(styleRefSeparator) >= 0) {
                String en = ParserUtils.parseStyleElementName(str);
                String an = ParserUtils.parseStyleAttributeName(str);
                if ((en = graphStyle.remapDataElement(en, an)) != null) {
                    size = ParserUtils.unitToPixels(ParserUtils.getStyleAttribute(graphStyle, en, an), containerHeight, DPI, dpiScaleFactor, sizeScaleFactor);
                }
            } else {
                size = ParserUtils.unitToPixels(str, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor);
            }
        }
        return size;
    }

    public static int parseAttrFontSize(String attr, Style graphStyle, Element elem, int DPI, int containerHeight, double dpiScaleFactor, double sizeScaleFactor, double fontScaleFactor, double shrinkageScale, int minimumFontSize) {
        String str = elem.getAttribute(attr);
        int size = -1;
        if (str.length() > 0) {
            if (str.indexOf(styleRefSeparator) >= 0) {
                String en = ParserUtils.parseStyleElementName(str);
                String an = ParserUtils.parseStyleAttributeName(str);
                if ((en = graphStyle.remapDataElement(en, an)) != null) {
                    size = ParserUtils.unit2FontSize(ParserUtils.getStyleAttribute(graphStyle, en, an), DPI, containerHeight, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
                }
            } else {
                size = ParserUtils.unit2FontSize(str, DPI, containerHeight, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
            }
        }
        return size;
    }

    public static int unit2FontSize(String unit, int DPI, int containerHeight, double dpiScaleFactor, double sizeScaleFactor, double fontScaleFactor, double shrinkageScale, int minimumFontSize) {
        if (unit == null) {
            return -1;
        }
        if (ParserUtils.isNumber(unit)) {
            return ParserUtils.scaleFontSize(Integer.parseInt(unit), dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
        }
        try {
            return ParserUtils.scaleFontSize(new Size(unit).toPoints(DPI, containerHeight), dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static int scaleFontSize(int fs, double dpiScaleFactor, double sizeScaleFactor, double fontScaleFactor, double shrinkageScale, int minimumFontSize) {
        fs = (fs = (int)Math.round((double)fs * dpiScaleFactor * sizeScaleFactor)) <= 12 ? (int)Math.ceil((double)fs * fontScaleFactor * shrinkageScale * 1.3) : (int)Math.ceil((double)fs * fontScaleFactor * shrinkageScale * 100.0 / 72.0);
        return Math.max(fs, minimumFontSize);
    }
}

