/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.attrmap.AttributeBundle;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.attrmap.ParserUtils;
import com.sas.graphics.util.attrmap.RB;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscreteAttributeMapParser {
    public static final String RB_KEY = "DiscreteAttributeMapParser.";

    public static Object load(Element elem, Style graphStyle, int containerWidth, int containerHeight, int DPI, double dpiScaleFactor, double sizeScaleFactor, double fontScaleFactor, double shrinkageScale, int minimumFontSize, boolean useFontManager) {
        DiscreteAttributeMap attrMap = null;
        if (elem != null && "DiscreteAttrMap".equals(elem.getTagName())) {
            String policy;
            String name = elem.getAttribute("name");
            boolean ignoreCase = false;
            if (elem.hasAttribute("ignoreCase")) {
                ignoreCase = "true".equalsIgnoreCase(elem.getAttribute("ignoreCase"));
            }
            attrMap = new DiscreteAttributeMap(name, ignoreCase);
            if (elem.hasAttribute("trimLeading")) {
                attrMap.setTrimLeadingWhitespace(!"false".equalsIgnoreCase(elem.getAttribute("trimLeading")));
            }
            if (elem.hasAttribute("discreteLegendEntryPolicy") && (policy = elem.getAttribute("discreteLegendEntryPolicy")).equalsIgnoreCase("ATTRMAP")) {
                attrMap.setLegendEntryPolicy(1);
            }
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element e;
                if (!(node instanceof Element) || !"AttrValue".equals((e = (Element)node).getTagName())) continue;
                String type = e.getAttribute("valueType");
                String value = e.getAttribute("value");
                if ("keyword".equalsIgnoreCase(type) && "other".equalsIgnoreCase(value)) {
                    AttributeBundle attrBundle = DiscreteAttributeMapParser.parseAttrs(e, graphStyle, "Other", true, containerWidth, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize, useFontManager);
                    attrMap.setOtherAttributeBundle(attrBundle);
                    continue;
                }
                Vector<String> values = DiscreteAttributeMapParser.parseValuesList(e);
                if (values == null) {
                    String s = RB.getStringResource(RB_KEY, "ValueUndefined.fmt.txt");
                    return MessageFormat.format(s, "DiscreteAttrMap");
                }
                Vector<String> vl = new Vector<String>();
                for (int i = 0; i < values.size(); ++i) {
                    String v = values.get(i);
                    if (attrMap.contains(v)) {
                        String s = RB.getStringResource(RB_KEY, "Message.DuplicateValue.fmt.txt");
                        return MessageFormat.format(s, v, "DiscreteAttrMap");
                    }
                    if (vl.contains(v)) {
                        String s = RB.getStringResource(RB_KEY, "Message.DuplicateValue.fmt.txt");
                        return MessageFormat.format(s, v, "DiscreteAttrMap");
                    }
                    vl.add(v);
                }
                AttributeBundle attrBundle = DiscreteAttributeMapParser.parseAttrs(e, graphStyle, "GraphDataStyleDefault", false, containerWidth, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize, useFontManager);
                attrMap.add(vl.toArray(new String[vl.size()]), attrBundle);
            }
        }
        AttributeBundle defaultAttributeBundle = DiscreteAttributeMapParser.createDefaultAttributeBundle(graphStyle, DPI, containerHeight, useFontManager);
        attrMap.setDefaultAttributeBundle(defaultAttributeBundle);
        return attrMap;
    }

    private static Vector<String> parseValuesList(Element elem) {
        Node nv;
        NodeList nl = elem.getElementsByTagName("Values");
        Vector<String> values = new Vector<String>();
        if (nl != null && nl.getLength() > 0 && (nv = nl.item(0)) instanceof Element) {
            Element e = (Element)nv;
            for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element ne;
                if (!(n instanceof Element) || !"Value".equals((ne = (Element)n).getTagName())) continue;
                values.add(ne.getTextContent());
            }
        }
        if (values.size() == 0) {
            return null;
        }
        return values;
    }

    private static AttributeBundle parseAttrs(Element elem, Style graphStyle, String defaultElement, boolean populateWithDefaultStyleElement, int containerWidth, int containerHeight, int DPI, double dpiScaleFactor, double sizeScaleFactor, double fontScaleFactor, double shrinkageScale, int minimumFontSize, boolean useFontManager) {
        Element textElem;
        Element markerElement;
        Element lineElement;
        Element fillElement;
        FillAttrs fillAttrs = null;
        ColorAttr lineAttrs = null;
        MarkerAttrs markerAttrs = null;
        ColorAttr textAttrs = null;
        AttributeBundle attrBundle = new AttributeBundle();
        if (elem.hasAttribute("fillAttrs") || populateWithDefaultStyleElement) {
            DataStyleElement fillElem = graphStyle.getDataStyleElement(defaultElement);
            String styleElem = elem.getAttribute("fillAttrs");
            if (styleElem != null && styleElem.length() > 0) {
                DataStyleElement ds = graphStyle.getDataStyleElement(styleElem);
                ds = graphStyle.getRemappedGraphDataElement(ds, "fill", styleElem);
                fillElem = fillElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            if (fillAttrs == null) {
                fillAttrs = new FillAttrs(null, -1.0);
            }
            fillAttrs.setColor(fillElem.getFillColor());
        }
        if ((fillElement = DiscreteAttributeMapParser.getChildNode(elem, "FillAttrs")) != null) {
            String str;
            Color c;
            if (fillAttrs == null) {
                fillAttrs = new FillAttrs(null, -1.0);
            }
            if ((c = ParserUtils.parseAttrColor("color", graphStyle, fillElement)) != null) {
                fillAttrs.setColor(c);
            }
            if (ParserUtils.isNumber(str = fillElement.getAttribute("transparency"))) {
                fillAttrs.setTransparency(Double.parseDouble(str));
            }
        }
        if (elem.hasAttribute("lineAttrs") || populateWithDefaultStyleElement) {
            DataStyleElement lineElem = graphStyle.getDataStyleElement(defaultElement);
            String styleElem = elem.getAttribute("lineAttrs");
            boolean hasThickness = false;
            if (styleElem != null && styleElem.length() > 0) {
                DataStyleElement ds = graphStyle.getDataStyleElement(styleElem);
                hasThickness = ds.hasAttribute("lineThickness");
                ds = graphStyle.getRemappedGraphDataElement(ds, "line", styleElem);
                lineElem = lineElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            if (lineAttrs == null) {
                lineAttrs = new LineAttrs(null, -1.0, -1, -1, -1, -1, -1.0);
            }
            lineAttrs.setColor(lineElem.getLineColor());
            ((LineAttrs)lineAttrs).setLinePattern(lineElem.getLineStyle());
            if (hasThickness) {
                int lt = lineElem.getLineThickness().toPixels(DPI, containerHeight);
                ((LineAttrs)lineAttrs).setWidth(ParserUtils.scale(lt, dpiScaleFactor, sizeScaleFactor));
            }
        }
        if ((lineElement = DiscreteAttributeMapParser.getChildNode(elem, "LineAttrs")) != null) {
            int thickness;
            int pt;
            String str;
            Color c;
            if (lineAttrs == null) {
                lineAttrs = new LineAttrs(null, -1.0, -1, -1, -1, -1, -1.0);
            }
            if ((c = ParserUtils.parseAttrColor("color", graphStyle, lineElement)) != null) {
                lineAttrs.setColor(c);
            }
            if ((str = ParserUtils.parseAttrString("pattern", graphStyle, lineElement)) != null && str.length() > 0 && ParserUtils.isInteger(str) && (pt = Integer.parseInt(str)) > 0 && pt < 47) {
                ((LineAttrs)lineAttrs).setLinePattern(pt);
            }
            if ((thickness = ParserUtils.parseAttrNumber("thickness", graphStyle, lineElement, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor)) >= 0) {
                ((LineAttrs)lineAttrs).setWidth(thickness);
            }
        }
        if (elem.hasAttribute("markerAttrs") || populateWithDefaultStyleElement) {
            MarkerStyleElement markerElem = graphStyle.getMarkerStyleElement(defaultElement);
            String styleElem = elem.getAttribute("markerAttrs");
            boolean hasSize = false;
            if (styleElem != null && styleElem.length() > 0) {
                DataStyleElement ds = graphStyle.getDataStyleElement(styleElem);
                hasSize = ds.hasAttribute("markerSize");
                ds = graphStyle.getRemappedGraphDataElement(ds, "marker", styleElem);
                markerElem = markerElem.mergeWith((StyleElement)ds).getAsMarkerStyle();
            }
            if (markerAttrs == null) {
                markerAttrs = new MarkerAttrs(null, -1, -1, -1);
            }
            markerAttrs.setColor(markerElem.getMarkerColor());
            if (hasSize) {
                int ms = markerElem.getMarkerSize().toPixels(DPI, containerHeight);
                markerAttrs.setSize(ParserUtils.scale(ms, dpiScaleFactor, sizeScaleFactor));
            }
            markerAttrs.setShape(markerElem.getMarkerSymbol());
        }
        if ((markerElement = DiscreteAttributeMapParser.getChildNode(elem, "MarkerAttrs")) != null) {
            int size;
            int symbol;
            String str;
            Color c;
            if (markerAttrs == null) {
                markerAttrs = new MarkerAttrs(null, -1, -1, -1);
            }
            if ((c = ParserUtils.parseAttrColor("color", graphStyle, markerElement)) != null) {
                markerAttrs.setColor(c);
            }
            if ((str = ParserUtils.parseAttrString("symbol", graphStyle, markerElement)) != null && str.length() > 0 && (symbol = Markers.getShape((String)str)) >= 0) {
                markerAttrs.setShape(symbol);
            }
            if ((size = ParserUtils.parseAttrNumber("size", graphStyle, markerElement, containerHeight, DPI, dpiScaleFactor, sizeScaleFactor)) >= 0) {
                int maxSize = (int)(0.75 * (double)Math.min(containerWidth, containerHeight));
                if (size > maxSize) {
                    size = maxSize;
                }
                markerAttrs.setSize(size);
            }
            if ((str = markerElement.getAttribute("weight")).length() > 0) {
                if (str.equalsIgnoreCase("normal")) {
                    markerAttrs.setWeight(0);
                } else if (str.equalsIgnoreCase("bold")) {
                    markerAttrs.setWeight(2);
                }
            }
            if (ParserUtils.isNumber(str = markerElement.getAttribute("transparency"))) {
                markerAttrs.setTransparency(Double.parseDouble(str));
            }
        }
        if (elem.hasAttribute("textAttrs")) {
            TextStyleElement textElem2 = graphStyle.getTextStyleElement("DataText");
            String styleElem = elem.getAttribute("textAttrs");
            if (styleElem != null && styleElem.length() > 0) {
                TextStyleElement ds = graphStyle.getTextStyleElement(styleElem);
                textElem2 = textElem2.mergeWith((StyleElement)ds).getAsTextStyle();
            }
            if (textAttrs == null) {
                textAttrs = new TextAttrs(null, null, null, -1.0);
            }
            textAttrs.setColor(textElem2.getTextColor());
            ((TextAttrs)textAttrs).setAltColor(textElem2.getAltTextColor());
            String family = textElem2.getFontFamily();
            int weight = textElem2.getFontWeight();
            int style = textElem2.getFontStyle();
            int size = textElem2.getFontSize().toPoints(DPI, containerHeight);
            size = ParserUtils.scaleFontSize(size, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
            int fontStyle = 0;
            if (style == 2) {
                fontStyle |= 2;
            }
            if (weight == 1) {
                fontStyle |= 1;
            }
            if (useFontManager) {
                ((TextAttrs)textAttrs).setFont(FontManager.getFont((String)family, (int)fontStyle, (int)size));
            } else {
                ((TextAttrs)textAttrs).setFont(new Font(family, fontStyle, size));
            }
        }
        if ((textElem = DiscreteAttributeMapParser.getChildNode(elem, "TextAttrs")) != null) {
            Color c;
            if (textAttrs == null) {
                textAttrs = new TextAttrs(null, null, null, -1.0);
            }
            if ((c = ParserUtils.parseAttrColor("color", graphStyle, textElem)) != null) {
                textAttrs.setColor(c);
            }
            String family = ParserUtils.parseAttrString("family", graphStyle, textElem);
            String weight = ParserUtils.parseAttrString("weight", graphStyle, textElem);
            String style = ParserUtils.parseAttrString("style", graphStyle, textElem);
            int fontSize = ParserUtils.parseAttrFontSize("size", graphStyle, textElem, DPI, containerHeight, dpiScaleFactor, sizeScaleFactor, fontScaleFactor, shrinkageScale, minimumFontSize);
            TextStyleElement te = graphStyle.getTextStyleElement("ValueText");
            if (family != null || weight != null || style != null || fontSize > 0) {
                boolean bold;
                boolean italic;
                Font oldFont = ((TextAttrs)textAttrs).getFont();
                if (family == null) {
                    family = oldFont != null ? oldFont.getFamily() : te.getFontFamily();
                }
                boolean bl = oldFont != null ? oldFont.isItalic() : (italic = (te.getFontStyle() & 2) > 0);
                if (style != null) {
                    if (style.equalsIgnoreCase("italic")) {
                        italic = true;
                    } else if (style.equalsIgnoreCase("normal")) {
                        italic = false;
                    }
                }
                boolean bl2 = oldFont != null ? oldFont.isBold() : (bold = (te.getFontStyle() & 1) > 0);
                if (weight != null) {
                    if (weight.equalsIgnoreCase("bold")) {
                        bold = true;
                    } else if (weight.equalsIgnoreCase("normal")) {
                        bold = false;
                    }
                }
                int fontStyle = 0;
                if (bold) {
                    fontStyle |= 1;
                }
                if (italic) {
                    fontStyle |= 2;
                }
                if (fontSize < 0) {
                    int n = fontSize = oldFont != null ? oldFont.getSize() : te.getFontSize().getSizeValue();
                }
                if (useFontManager) {
                    ((TextAttrs)textAttrs).setFont(FontManager.getFont((String)family, (int)fontStyle, (int)fontSize));
                } else {
                    ((TextAttrs)textAttrs).setFont(new Font(family, fontStyle, fontSize));
                }
            }
        }
        if (fillAttrs != null || lineAttrs != null || markerAttrs != null || textAttrs != null) {
            attrBundle.setFillAttrs(fillAttrs);
            attrBundle.setLineAttrs((LineAttrs)lineAttrs);
            attrBundle.setMarkerAttrs(markerAttrs);
            attrBundle.setTextAttrs((TextAttrs)textAttrs);
            return attrBundle;
        }
        return null;
    }

    private static Element getChildNode(Element elem, String childTagName) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(childTagName)) continue;
            return (Element)node;
        }
        return null;
    }

    private static AttributeBundle createDefaultAttributeBundle(Style graphStyle, int DPI, int containerHeight, boolean useFontManager) {
        FillAttrs fillAttrs = new FillAttrs();
        LineAttrs lineAttrs = new LineAttrs();
        MarkerAttrs markerAttrs = new MarkerAttrs();
        TextAttrs textAttrs = new TextAttrs();
        AttributeBundle attrBundle = new AttributeBundle();
        DataStyleElement defaultElem = graphStyle.getDataStyleElement("GraphDataStyleDefault");
        fillAttrs.setColor(defaultElem.getFillColor());
        lineAttrs.setColor(defaultElem.getLineColor());
        lineAttrs.setLinePattern(defaultElem.getLineStyle());
        markerAttrs.setColor(defaultElem.getAsMarkerStyle().getMarkerColor());
        markerAttrs.setShape(defaultElem.getMarkerSymbol());
        TextStyleElement defaultTextElem = graphStyle.getTextStyleElement("ValueText");
        textAttrs.setColor(defaultTextElem.getTextColor());
        textAttrs.setAltColor(defaultTextElem.getAltTextColor());
        String family = defaultTextElem.getFontFamily();
        int weight = defaultTextElem.getFontWeight();
        int style = defaultTextElem.getFontStyle();
        int size = defaultTextElem.getFontSize().toPoints(DPI, containerHeight);
        int fontStyle = 0;
        if (style == 2) {
            fontStyle |= 2;
        }
        if (weight == 1) {
            fontStyle |= 1;
        }
        if (useFontManager) {
            textAttrs.setFont(FontManager.getFont((String)family, (int)fontStyle, (int)size));
        } else {
            textAttrs.setFont(new Font(family, fontStyle, size));
        }
        attrBundle.setFillAttrs(fillAttrs);
        attrBundle.setLineAttrs(lineAttrs);
        attrBundle.setMarkerAttrs(markerAttrs);
        attrBundle.setTextAttrs(textAttrs);
        return attrBundle;
    }
}

