/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.attrmap.AttributeBundle;
import com.sas.graphics.util.attrmap.RB;
import com.sas.graphics.util.attrmap.ValueList;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class DiscreteAttributeMap
implements DiscreteLegendInterface {
    private String name;
    private LinkedHashMap<String, AttributeBundle> attrMap = new LinkedHashMap();
    private LinkedHashMap<ValueList, AttributeBundle> valuesMap = new LinkedHashMap();
    private boolean ignoreCase = false;
    private boolean trimLeadingWhitespace = true;
    private AttributeBundle otherAttributeBundle;
    private AttributeBundle defaultAttributeBundle;
    public static final int LEGEND_ENTRY_POLICY_DATA = 0;
    public static final int LEGEND_ENTRY_POLICY_ATTRMAP = 1;
    private int legendEntryPolicy = 0;
    public static final String RB_KEY = "DiscreteAttributeMap.";

    public DiscreteAttributeMap(String name, boolean ignoreCase) {
        this.name = name;
        this.ignoreCase = ignoreCase;
    }

    public String getName() {
        return this.name;
    }

    public void add(String[] values, AttributeBundle attrBundle) {
        if (values == null || attrBundle == null) {
            return;
        }
        ValueList vl = new ValueList();
        for (int i = 0; i < values.length; ++i) {
            String v = this.clean(values[i]);
            vl.add(v);
            this.add(v, attrBundle);
        }
        this.valuesMap.put(vl, attrBundle);
    }

    private void add(String value, AttributeBundle attrBundle) {
        if (value == null || attrBundle == null) {
            return;
        }
        this.attrMap.put(this.clean(value), attrBundle);
    }

    private String clean(String value) {
        if (value == null) {
            return value;
        }
        if (this.ignoreCase) {
            value = value.toUpperCase();
        }
        value = this.trimLeadingWhitespace ? value.trim() : value.replaceAll("\\s+$", "");
        return value;
    }

    public AttributeBundle get(ValueList valueList) {
        if (valueList == null || valueList.size() == 0) {
            return null;
        }
        if (!this.valuesMap.containsKey(valueList)) {
            return this.getOtherAttributeBundle();
        }
        return this.valuesMap.get(valueList);
    }

    public AttributeBundle get(String value) {
        if (value == null) {
            return null;
        }
        if (!this.attrMap.containsKey(value = this.clean(value))) {
            return this.getOtherAttributeBundle();
        }
        return this.attrMap.get(value);
    }

    public String[] getValues() {
        if (this.size() == 0) {
            return null;
        }
        Set<String> keys = this.attrMap.keySet();
        String[] values = new String[keys.size()];
        values = keys.toArray(values);
        return values;
    }

    public String[] getAllValues() {
        String[] values = this.getValues();
        if (this.getOtherAttributeBundle() == null) {
            return values;
        }
        String[] newValues = values == null ? new String[1] : new String[values.length + 1];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = i == newValues.length - 1 ? RB.getStringResource(RB_KEY, "Other.txt") : values[i];
        }
        return newValues;
    }

    public int getAllSize() {
        int s = this.size();
        if (this.getOtherAttributeBundle() == null) {
            return s;
        }
        return s + 1;
    }

    public String[] getExtraValues(String[] dataValues) {
        if (this.size() == 0) {
            return null;
        }
        if (dataValues == null || dataValues.length == 0) {
            return this.getValues();
        }
        Vector<String> extraValues = new Vector<String>();
        Set<String> values = this.attrMap.keySet();
        for (String value : values) {
            boolean extra = true;
            for (int i = 0; i < dataValues.length; ++i) {
                String dv = this.clean(dataValues[i]);
                if (!value.equals(dv)) continue;
                extra = false;
                break;
            }
            if (!extra) continue;
            extraValues.add(value);
        }
        if (extraValues.size() == 0) {
            return null;
        }
        String[] ev = new String[extraValues.size()];
        extraValues.toArray(ev);
        return ev;
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        return this.attrMap.containsKey(this.clean(value));
    }

    public int size() {
        return this.attrMap.size();
    }

    public void clear() {
        this.attrMap.clear();
        this.setOtherAttributeBundle(null);
        this.setDefaultAttributeBundle(null);
    }

    public AttributeBundle getOtherAttributeBundle() {
        return this.otherAttributeBundle;
    }

    public void setOtherAttributeBundle(AttributeBundle otherAttributeBundle) {
        this.otherAttributeBundle = otherAttributeBundle;
    }

    public AttributeBundle getDefaultAttributeBundle() {
        return this.defaultAttributeBundle;
    }

    public void setDefaultAttributeBundle(AttributeBundle defaultAttributeBundle) {
        this.defaultAttributeBundle = defaultAttributeBundle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DiscreteAttributeMap ");
        sb.append("name=" + this.name + " ");
        sb.append("ignoreCase=" + this.ignoreCase + " ");
        sb.append("size=" + this.size() + " ");
        sb.append("\n\n");
        sb.append("other attribute bundle=");
        sb.append("\n");
        sb.append(this.getOtherAttributeBundle());
        sb.append("\n\n");
        if (this.size() > 0) {
            Set<String> values = this.attrMap.keySet();
            for (String value : values) {
                AttributeBundle ab = this.get(value);
                sb.append("value=" + value);
                sb.append("\n");
                sb.append(ab);
                sb.append("\n\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        return this.getLegendItems(attrType, false);
    }

    public LegendItem[] getLegendItems(int attrType, boolean fillInAttrs) {
        ArrayList<LegendItem> list = new ArrayList<LegendItem>();
        String[] values = this.getValues();
        AttributeBundle otherBunder = this.getOtherAttributeBundle();
        boolean hasOther = otherBunder != null;
        int n = hasOther ? values.length + 1 : values.length;
        ColorAttr attr = null;
        LineAttrs markerOutlineAttr = null;
        block10: for (int i = 0; i < n; ++i) {
            AttributeBundle bundle;
            String value;
            if (hasOther && i == n - 1) {
                value = RB.getStringResource(RB_KEY, "Other.txt");
                bundle = otherBunder;
            } else {
                value = values[i];
                bundle = this.get(values[i]);
            }
            ColorAttr attr2 = null;
            switch (attrType) {
                case 11: {
                    attr2 = bundle.getLineAttrs();
                    if (fillInAttrs) {
                        attr2 = this.completeAttrs(10, attr2);
                    }
                }
                case 7: 
                case 8: {
                    attr = bundle.getFillAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(attrType, attr);
                    }
                    if (attr == null || ((FillAttrs)attr).getColor() == null) continue block10;
                    if (!(attr.getTransparency() > 0.0)) break;
                    attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    attr = bundle.getLineAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(attrType, attr);
                    }
                    if (attr == null) continue block10;
                    LineAttrs lattrs = (LineAttrs)attr;
                    if (!(attrType == 4 && lattrs.getColor() == null || attrType == 5 && lattrs.getLinePattern() < 0) && (attrType != 6 || lattrs.getWidth() >= 0)) break;
                    continue block10;
                }
                case 1: 
                case 2: 
                case 3: 
                case 9: {
                    attr = bundle.getMarkerAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(attrType, attr);
                    }
                    if (attr == null) continue block10;
                    MarkerAttrs mattrs = (MarkerAttrs)attr;
                    if (attrType == 3 && mattrs.getColor() == null || attrType == 1 && mattrs.getShape() < 0 || attrType == 2 && mattrs.getSize() < 0) continue block10;
                    if (!(attr.getTransparency() > 0.0) || attrType != 9 && attrType != 3) break;
                    attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    break;
                }
                case 13: {
                    attr = bundle.getMarkerAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(9, attr);
                    }
                    if (attr == null) continue block10;
                    if (attr.getTransparency() > 0.0) {
                        attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    }
                    attr2 = bundle.getLineAttrs();
                    if (!fillInAttrs) break;
                    attr2 = this.completeAttrs(10, attr2);
                    break;
                }
                case 12: {
                    attr = bundle.getTextAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(attrType, attr);
                    }
                    if (attr == null || ((TextAttrs)attr).getColor() == null) continue block10;
                    if (attr.getTransparency() > 0.0) {
                        attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    }
                    FillAttrs fa = new FillAttrs();
                    fa.setColor(attr.getColor());
                    attr = fa;
                    break;
                }
                case 14: {
                    attr = bundle.getMarkerAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(attrType, attr, bundle.getFillAttrs());
                    }
                    if (attr.getTransparency() > 0.0) {
                        attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    }
                    markerOutlineAttr = bundle.getLineAttrs();
                    if (!fillInAttrs) break;
                    markerOutlineAttr = (LineAttrs)this.completeAttrs(10, markerOutlineAttr);
                    break;
                }
                case 15: {
                    attr = bundle.getMarkerAttrs();
                    if (fillInAttrs) {
                        attr = this.completeAttrs(14, attr, bundle.getFillAttrs());
                    }
                    if (attr.getTransparency() > 0.0) {
                        attr.setColor(DiscreteAttributeMap.applyTransparency(attr.getColor(), attr.getTransparency()));
                    }
                    attr2 = bundle.getLineAttrs();
                    if (fillInAttrs) {
                        attr2 = this.completeAttrs(10, attr2);
                    }
                    markerOutlineAttr = bundle.getLineAttrs();
                    if (!fillInAttrs) break;
                    markerOutlineAttr = (LineAttrs)this.completeAttrs(10, markerOutlineAttr);
                    break;
                }
                default: {
                    continue block10;
                }
            }
            LegendItem li = new LegendItem(attr, attr2, value, null);
            if (markerOutlineAttr != null) {
                li.setMarkerOutlineAttrs(markerOutlineAttr);
            }
            list.add(li);
        }
        if (list.size() == 0) {
            return null;
        }
        LegendItem[] entries = new LegendItem[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            entries[i] = (LegendItem)list.get(i);
        }
        return entries;
    }

    public boolean isLeadingWhitespaceTrimmed() {
        return this.trimLeadingWhitespace;
    }

    public void setTrimLeadingWhitespace(boolean trimLeadingWhitespace) {
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    public static Color applyTransparency(Color c, double transparency) {
        if (c == null || transparency <= 0.0) {
            return c;
        }
        int a = (int)(255.0 * (1.0 - transparency));
        Color nc = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        return nc;
    }

    public int getLegendEntryPolicy() {
        return this.legendEntryPolicy;
    }

    public void setLegendEntryPolicy(int legendEntryPolicy) {
        this.legendEntryPolicy = legendEntryPolicy;
    }

    private ColorAttr completeAttrs(int attrType, ColorAttr attr) {
        return this.completeAttrs(attrType, attr, null);
    }

    private ColorAttr completeAttrs(int attrType, ColorAttr attr, ColorAttr attr2) {
        switch (attrType) {
            default: {
                return attr;
            }
            case 7: 
            case 8: 
            case 11: {
                FillAttrs theFillAttr = this.defaultAttributeBundle.getFillAttrs();
                if (attr == null) {
                    return theFillAttr;
                }
                FillAttrs fillAttr = (FillAttrs)attr;
                FillAttrs newFillAttr = new FillAttrs();
                newFillAttr.setColor(fillAttr.getColor() != null ? fillAttr.getColor() : theFillAttr.getColor());
                return newFillAttr;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                LineAttrs theLineAttr = this.defaultAttributeBundle.getLineAttrs();
                if (attr == null) {
                    return theLineAttr;
                }
                LineAttrs lineAttr = (LineAttrs)attr;
                LineAttrs newLineAttr = new LineAttrs();
                newLineAttr.setColor(lineAttr.getColor() != null ? lineAttr.getColor() : theLineAttr.getColor());
                newLineAttr.setLinePattern(lineAttr.getLinePattern() >= 0 ? lineAttr.getLinePattern() : theLineAttr.getLinePattern());
                newLineAttr.setWidth(lineAttr.getWidth() > 0 ? lineAttr.getWidth() : theLineAttr.getWidth());
                return newLineAttr;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                MarkerAttrs theMarkerAttr = this.defaultAttributeBundle.getMarkerAttrs();
                if (attr == null) {
                    return theMarkerAttr;
                }
                MarkerAttrs markerAttr = (MarkerAttrs)attr;
                MarkerAttrs newMarkerAttr = new MarkerAttrs();
                newMarkerAttr.setColor(markerAttr.getColor() != null ? markerAttr.getColor() : theMarkerAttr.getColor());
                newMarkerAttr.setShape(markerAttr.getShape() >= 0 ? markerAttr.getShape() : theMarkerAttr.getShape());
                newMarkerAttr.setSize(markerAttr.getSize() > 0 ? markerAttr.getSize() : theMarkerAttr.getSize());
                newMarkerAttr.setWeight(markerAttr.getWeight() >= 0 ? markerAttr.getWeight() : theMarkerAttr.getWeight());
                return newMarkerAttr;
            }
            case 12: {
                TextAttrs theTextAttr = this.defaultAttributeBundle.getTextAttrs();
                if (attr == null) {
                    return theTextAttr;
                }
                TextAttrs textAttr = (TextAttrs)attr;
                TextAttrs newTextAttr = new TextAttrs();
                newTextAttr.setColor(textAttr.getColor() != null ? textAttr.getColor() : theTextAttr.getColor());
                return newTextAttr;
            }
            case 14: 
        }
        MarkerAttrs theMarkerAttr = this.defaultAttributeBundle.getMarkerAttrs();
        FillAttrs theFillAttr = this.defaultAttributeBundle.getFillAttrs();
        if (attr == null) {
            return theMarkerAttr;
        }
        MarkerAttrs markerAttr = (MarkerAttrs)attr;
        boolean filled = Markers.isFilled((int)markerAttr.getShape());
        MarkerAttrs newMarkerAttr = new MarkerAttrs();
        if (filled) {
            newMarkerAttr.setColor(attr2.getColor() != null ? attr2.getColor() : theFillAttr.getColor());
        } else {
            newMarkerAttr.setColor(markerAttr.getColor() != null ? markerAttr.getColor() : theMarkerAttr.getColor());
        }
        newMarkerAttr.setShape(markerAttr.getShape() >= 0 ? markerAttr.getShape() : theMarkerAttr.getShape());
        newMarkerAttr.setSize(markerAttr.getSize() > 0 ? markerAttr.getSize() : theMarkerAttr.getSize());
        newMarkerAttr.setWeight(markerAttr.getWeight() >= 0 ? markerAttr.getWeight() : theMarkerAttr.getWeight());
        return newMarkerAttr;
    }
}

