/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.util.attrmap.Level;
import java.util.Vector;

public class CategorizationAttributeMap {
    private String name = null;
    private Vector<Level> levels = null;
    public static final String RB_KEY = "CategorizationAttributeMap.";
    private int numLevels = 3;
    private int numDev = 2;
    private int interval = -1;
    private String type = "NATURAL_BREAKS";
    private String palette = "RAMP";
    public static final String NATURALBREAKS = "NATURAL_BREAKS";
    public static final String QUANTILE = "QUANTILE";
    public static final String EQUALINTERVAL = "EQUAL_INTERVAL";
    public static final String STDDEV = "STANDARD_DEVIATION";
    public static final String UNIQUE = "UNIQUE";
    public static final String RAMP = "RAMP";
    public static final String DISCRETE = "DISCRETE";

    public CategorizationAttributeMap(String name) {
        this.name = name;
        this.levels = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void addLevel(Level r) {
        if (!this.contains(r)) {
            this.levels.add(r);
        }
    }

    public Level getLevel(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.levels.get(index);
    }

    public boolean contains(Level r) {
        if (r == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (r.getIndex() != this.getLevel(i).getIndex()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.levels.size();
    }

    public void clear() {
        this.levels.clear();
    }

    public boolean isValid() {
        return CategorizationAttributeMap.isValid(this.levels);
    }

    public static boolean isValid(Vector<Level> levels) {
        return true;
    }

    public static String validateLevels(Vector<Level> levels) {
        return null;
    }

    public Vector<Level> getLevels() {
        return this.levels;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CategorizationAttributeMap ");
        sb.append("name=" + this.name + " ");
        sb.append("size=" + this.size() + " ");
        sb.append("\n\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append("Level " + (i + 1) + " " + this.getLevel(i));
        }
        return sb.toString();
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public void setNumLevels(int numLevels) {
        this.numLevels = numLevels;
    }

    public int getNumDev() {
        return this.numDev;
    }

    public void setNumDev(int numDev) {
        this.numDev = numDev;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(NATURALBREAKS) || type.equals(QUANTILE) || type.equals(EQUALINTERVAL) || type.equals(STDDEV) || type.equals(UNIQUE)) {
            this.type = type;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPalette() {
        return this.palette;
    }

    public void setPalette(String palette) {
        if (palette.equals(RAMP) || palette.equals(DISCRETE)) {
            this.palette = palette;
        }
    }
}

