/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.attrs;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.Color;

public final class LineAttrs
extends ColorAttr {
    public int width = 1;
    public int stipplePattern = 65535;
    public int stippleFactor = 0;
    public int linePattern = 0;
    public double patternMultiplier = 1.0;
    public static String[] stipNames = new String[]{"Default", "Solid", "Dash1", "Dash2", "Dash3", "Dash4", "Dash5", "Dash6", "Dash3Dash1", "Dash4Dash1", "Dash5Dash1", "Dash6Dash1", "Dash5Dash3", "Dash6Dash3", "Dash3Dash1Dash1", "Dash4Dash1Dash1", "Dash5Dash1Dash1", "Dash6Dash1Dash1", "Dash5Dash3Dash3", "Dash6Dash3Dash3", "Dash2Space", "Dash3Space", "Dash4Space", "Dash5Space", "Dash6Space", "Dash3Dash2", "Dash4Dash2", "Dash5Dash2", "Dash6Dash2", "Dash3Dash2Dash2", "Dash4Dash2Dash2", "Dash5Dash2Dash2", "Dash6Dash2Dash2", "Dot1", "Dot1Space", "Dot1Space2", "Dot2", "Dot3", "Dot2Dot1", "Dot3Dot1", "Dot3Dot2", "Dash3Dot1", "Dash3Dot2", "Dash3Dot3", "Dash3Dot2Dash3Dot1", "Dash3Dot3Dash3Dot1", "Dash3Dot3Dash3Dot2"};

    public LineAttrs() {
        this(1);
    }

    public LineAttrs(LineAttrs ls) {
        this.color = ls.color;
        this.width = ls.width;
        this.linePattern = ls.linePattern;
        this.stippleFactor = ls.stippleFactor;
        this.stipplePattern = ls.stipplePattern;
        this.patternMultiplier = ls.patternMultiplier;
    }

    public LineAttrs(int lineStyle) {
        this.linePattern = lineStyle;
        this.stipplePattern = SASLinePatterns.getStipplePattern((int)lineStyle);
        this.stippleFactor = SASLinePatterns.getStippleFactor((int)lineStyle);
    }

    public LineAttrs(Color color, double transparency, int width, int linePattern, int stippleFactor, int stipplePattern, double patternMultiplier) {
        super(color, transparency);
        this.width = width;
        this.linePattern = linePattern;
        this.stippleFactor = SASLinePatterns.getStippleFactor((int)linePattern);
        this.stipplePattern = SASLinePatterns.getStipplePattern((int)linePattern);
        this.patternMultiplier = patternMultiplier;
    }

    public int getLinePattern() {
        return this.linePattern;
    }

    public void setLinePattern(int lineStyle) {
        this.linePattern = lineStyle;
        this.stipplePattern = SASLinePatterns.getStipplePattern((int)lineStyle);
        this.stippleFactor = SASLinePatterns.getStippleFactor((int)lineStyle);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int aWidth) {
        this.width = aWidth;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public void setStipplePattern(int aPattern) {
        this.stipplePattern = aPattern;
    }

    public int getStippleFactor() {
        return (int)Math.round(this.patternMultiplier * (double)this.stippleFactor);
    }

    public void setStippleFactor(int aFactor) {
        this.stippleFactor = aFactor;
    }

    public String getPatternName() {
        return stipNames[this.linePattern];
    }

    public void setPatternName(String patternName) {
        this.setLinePattern(LineAttrs.getEnum(patternName));
    }

    public static int getEnum(String name) {
        for (int i = 0; i < stipNames.length; ++i) {
            if (!stipNames[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return 0;
    }
}

