/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.attrs;

import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Color;

public class ColorModel {
    private String styleReference;
    private Color[] colors;

    public ColorModel(String styleRef) {
        this(null, styleRef);
    }

    public ColorModel(Color[] colors) {
        this(colors, null);
    }

    public ColorModel(Color[] colors, double transparency) {
        this(colors, null);
        this.colors = this.applyTransparency(colors, transparency);
    }

    private Color[] applyTransparency(Color[] cols, double transparency) {
        double alpha = 1.0;
        if (transparency >= 0.0 && transparency <= 1.0) {
            alpha = 1.0 - transparency;
        }
        Color[] newColors = new Color[cols.length];
        for (int i = 0; i < newColors.length; ++i) {
            newColors[i] = new Color(cols[i].getColorSpace(), cols[i].getRGBColorComponents(null), (float)alpha);
        }
        return newColors;
    }

    private ColorModel(Color[] clrs, String styleRef) {
        this.styleReference = styleRef;
        this.colors = clrs;
    }

    public ColorModel(ColorModel cm) {
        if (cm != null) {
            this.styleReference = cm.getStyleReference();
            if (cm.getColors() != null) {
                Color[] cols = cm.getColors();
                this.colors = new Color[cols.length];
                for (int i = 0; i < this.colors.length; ++i) {
                    this.colors[i] = cols[i];
                }
            }
        }
    }

    public String getStyleReference() {
        return this.styleReference;
    }

    public void setStyleReference(String styleReference) {
        this.styleReference = styleReference;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void applyStyle(Style style) {
        if (style == null || this.styleReference == null) {
            return;
        }
        RampStyleElement rse = style.getRampStyleElement(this.styleReference);
        this.colors = rse.getColors();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Color Model = ");
        if (this.getStyleReference() != null) {
            sb.append("type=StyleRef, value=" + this.getStyleReference());
        } else {
            sb.append("type=color list, colors=");
            for (int i = 0; i < this.colors.length; ++i) {
                if (i == 0) {
                    sb.append("[");
                }
                sb.append(this.colors[i]);
                if (i == this.colors.length) {
                    sb.append("]");
                    continue;
                }
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

