/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

final class Viewport {
    int xo;
    int yo;
    int width;
    int height;
    double wby2;
    double hby2;
    double maxR;
    double invR;
    double logR;
    double aspect;

    Viewport(int x, int y, int xs, int ys) {
        this.xo = x;
        this.yo = y;
        this.width = xs;
        this.height = ys;
        this.wby2 = (double)this.width * 0.5;
        this.hby2 = (double)this.height * 0.5;
        this.aspect = this.hby2 / this.wby2;
        this.maxR = this.wby2;
        this.invR = 1.0 / this.maxR;
    }

    void reset(int x, int y, int xs, int ys) {
        this.xo = x;
        this.yo = y;
        this.width = xs;
        this.height = ys;
        this.wby2 = (double)this.width * 0.5;
        this.hby2 = (double)this.height * 0.5;
        this.maxR = this.wby2;
        this.aspect = this.hby2 / this.wby2;
        this.invR = 1.0 / this.maxR;
    }

    void computeLogR(double fac) {
        this.logR = Math.log(fac * this.maxR + 1.0);
    }
}

