/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Matrix3;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.Transformation;
import com.sas.graphics.util.j2d.Viewport;
import java.util.Stack;
import java.util.Vector;

final class TransInfo {
    ChannelLite ch;
    Matrix3 invert;
    boolean inverted;
    Stack model;
    Matrix3 proj;
    Matrix3 w2s;
    Matrix3 w2m;
    Matrix3 m2s;
    Matrix3 view;
    Viewport viewport;
    boolean moved = false;
    boolean radComputed = false;
    double movingDir;
    double movingRad;
    double centerx;
    double centery;
    double worldWidth;
    Point3 worldOrigin = new Point3();
    Point3 lensLoc = new Point3(0.0, 0.0, 1.0);
    Point3 lensLocScr = new Point3();
    Point3 lensOrgLocScr = null;
    double oldLens;
    double[] lensLocs;
    double[] lensRange;
    double[] lensValues;
    double[] cutoffs;

    TransInfo(ChannelLite ch) {
        this.ch = ch;
        this.proj = new Matrix3();
        this.proj.setIdentity();
        this.view = new Matrix3();
        this.view.setIdentity();
        this.w2s = new Matrix3();
        this.w2s.setIdentity();
        this.w2m = new Matrix3();
        this.w2m.setIdentity();
        this.m2s = new Matrix3();
        this.m2s.setIdentity();
        this.model = new Stack();
        this.model.push(this.w2m);
        this.viewport = new Viewport(0, 0, 640, 480);
        this.LookAt(0.0, 0.0, 0.0);
        this.Ortho(0.0, 100.0, 0.0, 100.0);
    }

    double getLeft() {
        return this.viewport.xo;
    }

    double getRight() {
        return this.viewport.xo + this.viewport.width;
    }

    double getUp() {
        return this.viewport.yo;
    }

    double getDown() {
        return this.viewport.yo + this.viewport.height;
    }

    void GetMatrix(double[] matrix) {
        if (matrix.length < 9) {
            System.out.println("Matrix should have 9 elements.");
            return;
        }
        for (int i = 0; i < 9; ++i) {
            matrix[i] = this.w2m.e[i % 3][i / 3];
        }
    }

    double[] GetScreenX() {
        Point3 X = new Point3(1.0, 0.0, 0.0);
        if (!this.inverted) {
            this.invert = this.view.inverse();
            this.inverted = true;
        }
        X.postMultiply(this.invert);
        X.normalize();
        double[] wx = new double[]{X.x, X.y};
        return wx;
    }

    double[] GetScreenY() {
        Point3 Y = new Point3(0.0, 1.0, 0.0);
        if (!this.inverted) {
            this.invert = this.view.inverse();
            this.inverted = true;
        }
        Y.postMultiply(this.invert);
        Y.normalize();
        double[] wy = new double[]{Y.x, Y.y};
        return wy;
    }

    void LoadIdentity(int render_mode, Vector list) {
        this.w2m.setIdentity();
        this.make_w2s();
        if (render_mode == 4) {
            Transformation t1 = new Transformation(1, null);
            list.addElement(t1);
        }
    }

    void LoadMatrix(double[] matrix, int render_mode, Vector list) {
        if (matrix.length < 9) {
            System.out.println("Matrix should have 9 elements.");
            return;
        }
        this.w2m.set(matrix);
        this.make_w2s();
        if (render_mode == 4) {
            Transformation t1 = new Transformation(8, matrix);
            list.addElement(t1);
        }
    }

    public double[] getViewport() {
        double[] r = new double[]{this.viewport.xo, this.viewport.yo, this.viewport.width, this.viewport.height};
        return r;
    }

    Viewport GetViewport() {
        return this.viewport;
    }

    void LookAt(double centerx, double centery) {
        this.view.setIdentity();
        this.view.translate(-centerx, -centery);
        this.make_w2s();
        if (centerx != 0.0 || centery != 0.0) {
            this.moved = true;
            this.centerx = centerx;
            this.centery = centery;
            this.movingDir = Math.atan2(centery, centerx);
            this.radComputed = false;
        } else {
            this.moved = false;
        }
    }

    void LookAt(double centerx, double centery, double twist) {
        this.view.setIdentity();
        this.view.rotate(-twist);
        this.view.translate(-centerx, -centery);
        this.make_w2s();
        if (centerx != 0.0 || centery != 0.0) {
            this.moved = true;
            this.movingDir = Math.atan2(centery, centerx);
            this.centerx = centerx;
            this.centery = centery;
            this.radComputed = false;
        } else {
            this.moved = false;
        }
    }

    double getRadialFactor(double lens) {
        if (!this.radComputed || lens != this.oldLens) {
            this.computeRadialFactor(lens);
        }
        return this.movingRad;
    }

    Point3 getWorldOrigin(double lens) {
        if (!this.radComputed || lens != this.oldLens) {
            this.computeRadialFactor(lens);
        }
        return this.worldOrigin;
    }

    Point3 getLensLocation(double lens) {
        if (!this.radComputed || lens != this.oldLens) {
            this.computeRadialFactor(lens);
        }
        return this.lensLocScr;
    }

    Point3 getLensOriginalLocation(double lens) {
        if (!this.radComputed || lens != this.oldLens) {
            this.computeRadialFactor(lens);
        }
        return this.lensOrgLocScr;
    }

    Point3 getLensOriginalLocation() {
        if (!this.radComputed) {
            this.computeRadialFactor(this.oldLens);
        }
        return this.lensOrgLocScr;
    }

    void setLensWorldLocation(double x, double y) {
        Point3 p1 = new Point3(x, y, 1.0);
        this.lensOrgLocScr = null;
        this.lensLoc = p1;
        this.radComputed = false;
    }

    void setLensScreenLocation(double x, double y) {
        this.lensLocScr.x = x;
        this.lensLocScr.y = y;
        this.lensOrgLocScr = new Point3(x, y, 1.0);
        this.lensLoc = null;
    }

    void computeRadialFactor(double lens) {
        Matrix3 temp;
        double cy = this.centery / this.viewport.aspect;
        this.movingRad = 2.0 * lens * Math.sqrt(cy * cy + this.centerx * this.centerx) / this.worldWidth;
        this.worldOrigin.set(0.0, 0.0, 1.0);
        this.w2m = new Matrix3();
        this.w2m.setIdentity();
        this.model.push(this.w2m);
        boolean savedmoved = this.moved;
        double savedMovingDir = this.movingDir;
        this.make_w2s();
        this.World2Screen(this.worldOrigin);
        if (this.lensLoc == null) {
            temp = new Matrix3(this.view);
            this.LookAt(0.0, 0.0);
            this.make_w2s();
            this.lensLoc = new Point3(this.lensOrgLocScr);
            this.Screen2World(this.lensLoc);
        }
        this.lensLocScr.copy(this.lensLoc);
        this.World2Screen(this.lensLocScr);
        if (this.lensOrgLocScr == null) {
            temp = new Matrix3(this.view);
            this.LookAt(0.0, 0.0);
            this.make_w2s();
            this.lensOrgLocScr = new Point3(this.lensLoc);
            this.World2Screen(this.lensOrgLocScr);
            this.view = temp;
        }
        this.model.pop();
        this.moved = savedmoved;
        this.movingDir = savedMovingDir;
        this.make_w2s();
        this.radComputed = true;
        this.oldLens = lens;
    }

    Point3 Model2Screen(Point3 obj) {
        obj.t = 1.0;
        obj.postMultiply(this.m2s);
        double t = obj.t;
        double tinv = Math.abs(t) <= (double)1.4E-45f ? (t >= 0.0 ? 2.147483647E9 : -2.147483647E9) : 1.0 / t;
        obj.scale(tinv);
        obj.x = (double)this.viewport.xo + (1.0 + obj.x) * this.viewport.wby2;
        obj.y = (double)this.viewport.yo + (1.0 - obj.y) * this.viewport.hby2;
        return obj;
    }

    void Ortho(double left, double right, double bottom, double top) {
        double div1 = right - left;
        double div2 = top - bottom;
        Matrix3 temp = new Matrix3(this.proj);
        this.proj.setIdentity();
        try {
            this.proj.set(0, 0, 2.0 / div1);
            this.proj.set(1, 1, 2.0 / div2);
            this.proj.set(2, 0, -(right + left) / div1);
            this.proj.set(2, 1, -(top + bottom) / div2);
            this.make_w2s();
        }
        catch (ArithmeticException e) {
            System.out.println("Bad parameter passed to glortho.");
            System.out.println("Projection matrix not modified");
            this.proj.copy(temp);
        }
        this.worldWidth = div2;
    }

    public void PopMatrix(int render_mode, Vector list) {
        this.model.pop();
        this.w2m = (Matrix3)this.model.peek();
        this.make_w2s();
        if (render_mode == 4) {
            Transformation t1 = new Transformation(7, null);
            list.addElement(t1);
        }
    }

    public void PushMatrix(int render_mode, Vector list) {
        this.w2m = new Matrix3(this.w2m);
        this.model.push(this.w2m);
        if (render_mode == 4) {
            Transformation t1 = new Transformation(6, null);
            list.addElement(t1);
        }
    }

    public void Rotate(double angle, int render_mode, Vector list) {
        this.w2m.rotate(angle);
        this.make_w2s();
        if (render_mode == 4) {
            double[] darr = new double[]{angle};
            Transformation t1 = new Transformation(3, darr);
            list.addElement(t1);
        }
    }

    public void Rotate(double centerx, double centery, double angle, int render_mode, Vector list) {
        this.w2m.translate(centerx, centery);
        this.Rotate(angle, render_mode, list);
        this.w2m.translate(-centerx, -centery);
        this.make_w2s();
        if (render_mode == 4) {
            double[] darr = new double[]{centerx, centery, angle};
            Transformation t1 = new Transformation(4, darr);
            list.addElement(t1);
        }
    }

    public void Scale(double x, double y, int render_mode, Vector list) {
        if (x == 0.0 || y == 0.0) {
            System.out.println("glScale(): Invalid scaling parameters.");
            return;
        }
        this.w2m.scale(x, y);
        this.make_w2s();
        if (render_mode == 4) {
            double[] darr = new double[]{x, y};
            Transformation t1 = new Transformation(2, darr);
            list.addElement(t1);
        }
    }

    void Screen2World(Point3 win) {
        if (!this.inverted) {
            this.invert = this.w2s.inverse();
            this.inverted = true;
        }
        double xa = win.x - (double)this.viewport.xo;
        double ya = (double)this.viewport.height - (win.y - (double)this.viewport.yo);
        xa = xa / this.viewport.wby2 - 1.0;
        ya = ya / this.viewport.hby2 - 1.0;
        win.set(xa, ya, 1.0);
        win.postMultiply(this.invert);
        if (Math.abs(win.t) <= (double)1.4E-45f) {
            System.out.println("Bad t value in Screen2World");
        } else {
            win.scale(1.0 / win.t);
        }
    }

    void UnProject(Point3 win) {
        StateLite state = this.ch.state;
        if (state.capabilities[2]) {
            if (state.lensDirection == 6) {
                int index = 0;
                if (win.y > this.lensRange[this.lensRange.length - 1]) {
                    index = this.lensRange.length - 1;
                } else {
                    while (win.y > this.lensRange[index]) {
                        ++index;
                    }
                }
                double lens = this.lensValues[index];
                double totWidth = Math.sqrt(lens);
                double wbyX = this.viewport.width / 10;
                double delta = wbyX / totWidth;
                if (!(lens <= 1.0) && this.lensLocs[index] != win.x) {
                    if (win.x > this.lensLocs[index]) {
                        if (win.x > this.lensLocs[index] + 0.1) {
                            double fac = (win.x - this.lensLocs[index] - wbyX) / ((double)this.viewport.width - this.lensLocs[index] - wbyX);
                            double dist = (Math.exp(Math.log(lens + 1.0) * fac) - 1.0) / lens;
                            win.x = Math.max((double)this.viewport.xo, Math.min((double)(this.viewport.xo + this.viewport.width), dist * ((double)this.viewport.width - this.lensLocs[index] - delta) + this.lensLocs[index] + delta));
                        } else {
                            win.x = (win.x - this.lensLocs[index]) * delta / wbyX + this.lensLocs[index];
                        }
                    } else if (win.x < this.lensLocs[index] - 0.1) {
                        double fac = (this.lensLocs[index] - win.x - wbyX) / (this.lensLocs[index] - wbyX);
                        double dist = (Math.exp(fac * Math.log(lens + 1.0)) - 1.0) / lens;
                        win.x = Math.max((double)this.viewport.xo, Math.min((double)(this.viewport.xo + this.viewport.width), this.lensLocs[index] - delta - dist * (this.lensLocs[index] - delta)));
                    } else {
                        win.x = this.lensLocs[index] - (this.lensLocs[index] - win.x) * delta / wbyX;
                    }
                }
            } else {
                double dist;
                double fac;
                double lens = state.lensFactor;
                if (state.dirtyLensFlag) {
                    this.viewport.computeLogR(lens);
                    this.computeRadialFactor(state.thetaLensFac);
                    state.dirtyLensFlag = false;
                }
                double tempx = win.x - this.viewport.wby2;
                double tempy = (win.y - this.viewport.hby2) / this.viewport.aspect;
                double theta = Math.atan2(tempy, tempx);
                double maxR = this.viewport.maxR;
                double logR = this.viewport.logR;
                double rad = Math.sqrt(tempx * tempx + tempy * tempy);
                if (rad < maxR) {
                    fac = rad / maxR;
                    dist = (Math.exp(fac * logR) - 1.0) / lens;
                } else {
                    dist = maxR;
                }
                win.x = dist * Math.cos(theta) + this.viewport.wby2;
                win.y = (dist * Math.sin(theta) + this.viewport.wby2) * this.viewport.aspect;
                if (state.capabilities[3] && this.moved) {
                    double thetaLens = this.movingRad;
                    double PI = Math.PI;
                    tempx = win.x - this.worldOrigin.x;
                    tempy = (win.y - this.worldOrigin.y) / this.viewport.aspect;
                    theta = Math.atan2(tempy, tempx);
                    dist = Math.sqrt(tempx * tempx + tempy * tempy);
                    fac = (theta + this.movingDir) / PI;
                    if (fac < -1.0) {
                        fac += 2.0;
                    } else if (fac > 1.0) {
                        fac -= 2.0;
                    }
                    double relTheta = fac < 0.0 ? fac / (thetaLens * (fac + 1.0) + 1.0) : fac / (thetaLens * (1.0 - fac) + 1.0);
                    double oldTheta = relTheta * PI - this.movingDir;
                    double cost = Math.cos(oldTheta);
                    double sint = Math.sin(oldTheta);
                    win.x = dist * cost + this.worldOrigin.x;
                    win.y = dist * sint * this.viewport.aspect + this.worldOrigin.y;
                }
            }
        }
        if (!this.inverted) {
            this.invert = this.w2s.inverse();
            this.inverted = true;
        }
        double xa = win.x - (double)this.viewport.xo;
        double ya = (double)this.viewport.height - (win.y - (double)this.viewport.yo);
        xa = xa / this.viewport.wby2 - 1.0;
        ya = ya / this.viewport.hby2 - 1.0;
        win.set(xa, ya, 1.0);
        win.postMultiply(this.invert);
        if (Math.abs(win.t) <= (double)1.4E-45f) {
            System.out.println("Bad t value in Screen2World");
        } else {
            win.scale(1.0 / win.t);
        }
    }

    public void Translate(double x, double y, int render_mode, Vector list) {
        this.w2m = this.w2m.translate(x, y);
        this.make_w2s();
        if (render_mode == 4) {
            double[] darr = new double[]{x, y};
            Transformation t1 = new Transformation(5, darr);
            list.addElement(t1);
        }
    }

    public void Viewport(int x, int y, int width, int height) {
        this.viewport.reset(x, y, width, height);
    }

    void Project(Point3 obj) {
        this.World2Screen(obj);
        StateLite state = this.ch.state;
        if (state.capabilities[2]) {
            if (state.lensDirection == 6) {
                int index = 0;
                if (obj.y > this.lensRange[this.lensRange.length - 1]) {
                    index = this.lensRange.length - 1;
                } else {
                    while (obj.y > this.lensRange[index]) {
                        ++index;
                    }
                }
                if (Math.abs(obj.x - this.lensLocs[index]) < 2.0) {
                    return;
                }
                double lens = this.lensValues[index];
                if (lens <= 1.0) {
                    return;
                }
                double totWidth = Math.sqrt(lens);
                double wbyX = this.viewport.width / 10;
                double delta = wbyX / totWidth;
                if (obj.x > this.lensLocs[index]) {
                    if (obj.x > this.lensLocs[index] + delta) {
                        double dist = Math.max(0.0, Math.min(0.95, (obj.x - this.lensLocs[index] - delta) / ((double)this.viewport.width - this.lensLocs[index] - delta)));
                        double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
                        obj.x = this.lensLocs[index] + wbyX + ((double)this.viewport.width - this.lensLocs[index] - wbyX) * fac;
                    } else {
                        obj.x = this.lensLocs[index] + wbyX * (obj.x - this.lensLocs[index]) / delta;
                    }
                } else if (obj.x < this.lensLocs[index] - delta) {
                    double dist = Math.max(0.0, Math.min(0.95, (this.lensLocs[index] - delta - obj.x) / (this.lensLocs[index] - delta)));
                    double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
                    obj.x = this.lensLocs[index] - wbyX - (this.lensLocs[index] - wbyX) * fac;
                } else {
                    obj.x = this.lensLocs[index] - wbyX * (this.lensLocs[index] - obj.x) / delta;
                }
            } else {
                double lens = state.lensFactor;
                double thetaLens = this.getRadialFactor(state.thetaLensFac);
                if (state.dirtyLensFlag) {
                    this.viewport.computeLogR(lens);
                    this.computeRadialFactor(thetaLens);
                    state.dirtyLensFlag = false;
                }
                if (state.capabilities[3] && this.moved && this.movingDir > state.minAngle && this.movingDir < state.maxAngle) {
                    JPolygon.angularDistortion(obj, this.movingDir, thetaLens, state.minAngle, state.maxAngle);
                }
                JPolygon.radialDistortion(obj, this.lensOrgLocScr, this.viewport, this.movingDir, state.lensFactor);
            }
        }
    }

    void World2Screen(Point3 obj) {
        obj.t = 1.0;
        obj.postMultiply(this.w2s);
        double t = obj.t;
        double tinv = Math.abs(t) <= (double)1.4E-45f ? (t >= 0.0 ? 2.147483647E9 : -2.147483647E9) : 1.0 / t;
        obj.scale(tinv);
        obj.x = (double)this.viewport.xo + (1.0 + obj.x) * this.viewport.wby2;
        obj.y = (double)this.viewport.yo + (1.0 - obj.y) * this.viewport.hby2;
    }

    private void make_w2s() {
        this.m2s.copy(this.proj);
        this.m2s.preMultiply(this.view);
        this.w2s.copy(this.m2s);
        this.w2s.preMultiply(this.w2m);
        this.inverted = false;
    }

    public void setVerticalLensLocations(double[] locs, double[] range, double[] values, double[] textCutoffs) {
        this.lensLocs = locs;
        this.lensRange = range;
        this.lensValues = values;
        this.cutoffs = textCutoffs;
    }
}

