/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.StateLite;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

class DisplayList
implements Drawable {
    long id;
    Vector list;
    Drawable pickObj;

    DisplayList(long lid) {
        this.id = lid;
        this.list = new Vector();
        this.pickObj = null;
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        int num = this.list.size();
        boolean visible = true;
        for (int i = 0; i < num; ++i) {
            Drawable prim = (Drawable)this.list.elementAt(i);
            if (prim instanceof DisplayList && !visible) continue;
            visible = prim.computeScreen(ch);
        }
        return true;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        int num = this.list.size();
        boolean visible = true;
        for (int i = 0; i < num; ++i) {
            Drawable prim = (Drawable)this.list.elementAt(i);
            if (prim instanceof DisplayList && !visible) continue;
            visible = prim.render(state, bgc);
        }
        return true;
    }

    @Override
    public boolean isClipped() {
        boolean clip = true;
        int num = this.list.size();
        for (int i = 0; i < num; ++i) {
            Drawable prim = (Drawable)this.list.elementAt(i);
            clip &= prim.isClipped();
        }
        return clip;
    }

    @Override
    public Stack getNameList() {
        if (this.pickObj == null) {
            return null;
        }
        return this.pickObj.getNameList();
    }

    @Override
    public boolean pick(Graphics gc, Rectangle pickmatrix) {
        this.pickObj = null;
        int num = this.list.size();
        for (int i = 0; i < num; ++i) {
            Drawable prim = (Drawable)this.list.elementAt(i);
            if (!prim.pick(gc, pickmatrix)) continue;
            this.pickObj = prim;
            return true;
        }
        return false;
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        this.pickObj = null;
        int num = this.list.size();
        for (int i = num - 1; i >= 0; --i) {
            Drawable prim = (Drawable)this.list.elementAt(i);
            if (!prim.pick(gc, pickmatrix)) continue;
            this.pickObj = prim;
            return true;
        }
        return false;
    }
}

