/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Stack;
import java.util.Vector;

public class CompoundedText
implements Drawable {
    Color color;
    Font font;
    Point3 loc;
    Point3 dscr;
    boolean clip;
    Stack namelist;
    boolean pickable;
    boolean optimized;
    boolean handle;
    static Point3 p1 = new Point3(0.0, 0.0, 1.0);
    static Point3 p2 = new Point3(0.0, 0.0, 1.0);
    boolean border;
    int borderType;
    Color borderColor;
    Color lineColor;
    Color handleColor;
    protected double bkgdHeight = 1.0;
    protected double bkgdWidth = 1.0;
    protected Color bkgdColor;
    Color textColor;
    int borderWidth;
    Rectangle bbox;
    private static char newline = (char)10;
    private static final int multiLineOffsetIndex = 7;
    private Vector string;
    private int[] textWidth;
    private int maxTextWidth;
    private int textLines;
    private StateLite state;
    private Point3 uc;
    private Point3 lc;
    private Point3 cl;
    private Point3 cr;
    private Point3 wloc;
    private Point3 ucscr;
    private Point3 lcscr;
    private Point3 clscr;
    private Point3 crscr;
    private static final int X = 0;
    private static final int Y = 1;

    CompoundedText(StateLite state, String str, double x, double y, double width, double height) {
        this.state = state;
        ChannelLite ch = state.ch;
        TransInfo tr = ch.trans;
        this.font = state.font;
        this.clip = false;
        this.pickable = false;
        this.handleColor = state.textHandleColor;
        this.wloc = new Point3(x, y, 1.0);
        this.loc = new Point3(x, y, 1.0);
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.loc.postMultiply(tr.w2m);
        }
        this.string = CompoundedText.makeMultiLine(str);
        this.textLines = this.string.size();
        this.textWidth = null;
        this.color = state.color;
        this.border = state.border;
        this.borderType = state.textBorderType;
        this.borderColor = state.textBorderColor;
        this.lineColor = state.textLineColor;
        this.textColor = state.textColor;
        this.dscr = new Point3(0.0, 0.0, 1.0);
        this.bbox = new Rectangle();
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
            ch.glRefresh();
        }
        this.ucscr = new Point3();
        this.lcscr = new Point3();
        this.clscr = new Point3();
        this.crscr = new Point3();
        this.bkgdWidth = width;
        this.bkgdHeight = height;
        this._setBackgroundWidth(width);
        this._setBackgroundHeight(height);
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        String label = this.string.elementAt(0).toString();
        StateLite state = ch.getState();
        if (state.render_mode == 1) {
            return !this.clip;
        }
        this.clip = false;
        TransInfo tr = ch.trans;
        this.dscr.copy(this.loc);
        boolean fixedHeight = false;
        boolean fixedWidth = false;
        if (this.bkgdHeight != -1.0) {
            this.ucscr.copy(this.uc);
            this.lcscr.copy(this.lc);
            fixedHeight = true;
        }
        if (this.bkgdWidth != -1.0 && this.bkgdWidth < 1.0) {
            this.clscr.copy(this.cl);
            this.crscr.copy(this.cr);
            fixedWidth = true;
        }
        if (state.capabilities[2]) {
            int fnHeight;
            Viewport view = tr.GetViewport();
            double lens = state.lensFactor;
            double thetaLens = tr.getRadialFactor(state.thetaLensFac);
            if (state.dirtyLensFlag) {
                view.computeLogR(lens);
                state.dirtyLensFlag = false;
            }
            Point3 lensOrgLoc = tr.getLensOriginalLocation(state.thetaLensFac);
            double tfac = 0.0;
            if (state.capabilities[3] && tr.moved) {
                tfac = JPolygon.angularDistortion(this.dscr, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
            }
            if (this.optimized) {
                tr.Model2Screen(this.dscr);
                if (fixedHeight) {
                    tr.Model2Screen(this.ucscr);
                    tr.Model2Screen(this.lcscr);
                }
                if (fixedWidth) {
                    tr.Model2Screen(this.clscr);
                    tr.Model2Screen(this.crscr);
                }
            } else {
                tr.World2Screen(this.dscr);
                if (fixedHeight) {
                    tr.World2Screen(this.ucscr);
                    tr.World2Screen(this.lcscr);
                }
                if (fixedWidth) {
                    tr.World2Screen(this.clscr);
                    tr.World2Screen(this.crscr);
                }
            }
            double rfac = 0.5;
            if (state.lensDirection == 6) {
                rfac = JPolygon.verticalDistortion(this.dscr, view, tr, state.lensFactor);
                if (fixedWidth) {
                    JPolygon.verticalDistortion(this.clscr, view, tr, state.lensFactor);
                    JPolygon.verticalDistortion(this.crscr, view, tr, state.lensFactor);
                }
                if (fixedHeight) {
                    JPolygon.verticalDistortion(this.ucscr, view, tr, state.lensFactor);
                    JPolygon.verticalDistortion(this.lcscr, view, tr, state.lensFactor);
                }
                double[] cutoffs = tr.cutoffs;
                double[] range = tr.lensRange;
                int index = 0;
                while (this.dscr.y > range[index]) {
                    ++index;
                }
            }
            int n = fnHeight = this.font == null ? 12 : Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
            if (fixedWidth) {
                this.bbox.x = (int)this.clscr.x;
                this.bbox.width = (int)(this.crscr.x - this.clscr.x);
            } else if (this.bkgdWidth > 1.0) {
                this.bbox.x = (int)(this.dscr.x - this.bkgdWidth / 2.0);
                this.bbox.width = (int)this.bkgdWidth;
            }
            if (fixedHeight) {
                this.bbox.y = (int)this.lcscr.y;
                this.bbox.height = (int)(this.ucscr.y - this.lcscr.y);
            }
        } else if (this.optimized) {
            tr.Model2Screen(this.dscr);
            if (fixedHeight) {
                tr.Model2Screen(this.ucscr);
                tr.Model2Screen(this.lcscr);
            }
            if (fixedWidth) {
                tr.Model2Screen(this.clscr);
                tr.Model2Screen(this.crscr);
            }
        } else {
            tr.World2Screen(this.dscr);
            if (fixedHeight) {
                tr.World2Screen(this.ucscr);
                tr.World2Screen(this.lcscr);
            }
            if (fixedWidth) {
                tr.World2Screen(this.clscr);
                tr.World2Screen(this.crscr);
            }
        }
        if (fixedWidth) {
            this.dscr.x = (this.clscr.x + this.crscr.x) / 2.0;
        }
        if (fixedHeight) {
            this.dscr.y = (this.ucscr.y + this.lcscr.y) / 2.0;
        }
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        double epsilon;
        if (this.clip) {
            return false;
        }
        if (this.font != null) {
            bgc.setFont(this.font);
        }
        Font fn = bgc.getFont();
        FontMetrics fm = bgc.getFontMetrics();
        int[] info = this.computeAlignmentInfo(state, bgc, (int)this.dscr.x, (int)this.dscr.y, this.handle);
        int yPad = state.lensDirection == 6 ? (int)Math.max(1.0, (this.bkgdHeight - 1.0) * (double)fm.getHeight() / 2.0) : 1;
        int xoff = 0;
        if (this.bkgdWidth == -1.0) {
            this.bbox.x = info[0] - 2;
            this.bbox.width = info[2] + 4;
            if (fn.isItalic() && fn.getName().startsWith("Dialog")) {
                xoff = fm.getDescent() / 2;
                this.bbox.width += fm.getAscent() / 2;
            }
        }
        if (this.bkgdHeight == -1.0) {
            this.bbox.y = info[4] - yPad;
            this.bbox.height = info[3] + 2 * yPad;
        }
        if (state.capabilities[6]) {
            bgc.setColor(Color.gray);
            bgc.fillRoundRect(this.bbox.x + 2, this.bbox.y + 2, this.bbox.width, this.bbox.height, 10, 10);
        }
        bgc.setColor(this.color);
        bgc.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, 10, 10);
        switch (this.borderType) {
            case 1: 
            case 3: {
                bgc.setColor(this.borderColor);
                bgc.drawRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, 10, 10);
                if (this.borderWidth <= 1) break;
                double xo = this.bbox.x;
                double x1 = this.bbox.x + this.bbox.width;
                double yo = this.bbox.y;
                double y1 = this.bbox.y + this.bbox.height;
                JPolygon.drawSegment(state, bgc, xo, yo, xo, y1, this.borderWidth);
                JPolygon.drawSegment(state, bgc, xo, y1, x1, y1, this.borderWidth);
                JPolygon.drawSegment(state, bgc, x1, y1, x1, yo, this.borderWidth);
                JPolygon.drawSegment(state, bgc, x1, yo, xo, yo, this.borderWidth);
                break;
            }
        }
        int textWidth = info[2];
        if (fn.isItalic() && fn.getName().startsWith("Dialog")) {
            textWidth += (fm.getAscent() + fm.getDescent()) / 2;
        }
        int handleWidth = 0;
        if (this.handle) {
            handleWidth = (int)bgc.getFontMetrics().getStringBounds(" + ", bgc).getWidth();
            textWidth += handleWidth;
        }
        double d = epsilon = this.bbox.width > textWidth ? 0.0 : bgc.getFontMetrics().getStringBounds("..", bgc).getWidth();
        if ((double)this.bbox.width > 2.0 * epsilon) {
            if (this.handle) {
                if (this.bbox.width < textWidth) {
                    bgc.setColor(Color.LIGHT_GRAY);
                    bgc.fillRect(this.bbox.x + 2, this.bbox.y + this.bbox.height / 2 - handleWidth / 2, handleWidth / 2, handleWidth);
                    bgc.setColor(this.handleColor);
                    bgc.drawString("+", this.bbox.x + 2, info[1] + (this.textLines - 1) * info[5] / 2);
                    epsilon += (double)(handleWidth / 2);
                } else {
                    bgc.setColor(Color.LIGHT_GRAY);
                    bgc.fillRect(info[0] - xoff, this.bbox.y + this.bbox.height / 2 - handleWidth / 2, handleWidth + 2, handleWidth + 2);
                    bgc.setColor(this.handleColor);
                    bgc.drawString(" + ", info[0] - xoff, info[1] + (this.textLines - 1) * info[5] / 2);
                    info[0] = info[0] + handleWidth;
                }
            }
            bgc.setColor(this.textColor);
            String thisLine = null;
            for (int i = 0; i < this.textLines; ++i) {
                thisLine = (String)this.string.elementAt(i);
                if (this.bbox.width < textWidth) {
                    String string;
                    do {
                        thisLine = thisLine.substring(0, thisLine.length() - 1);
                    } while (bgc.getFontMetrics().getStringBounds(string, bgc).getWidth() + epsilon > (double)this.bbox.width);
                    bgc.drawString(thisLine + "..", this.bbox.x + 2 + handleWidth / 2, info[1]);
                } else {
                    bgc.drawString(thisLine, info[0] + info[7 + i] - xoff, info[1]);
                }
                info[1] = info[1] + info[5];
            }
        }
        return true;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics bgc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    void setBorderFlag(boolean flag) {
        this.border = flag;
    }

    void setBorderType(int type) {
        this.borderType = type;
    }

    public void setBorderColor(Color clr) {
        this.borderColor = clr;
    }

    public void setLineColor(Color clr) {
        this.lineColor = clr;
    }

    Color getLineColor() {
        return this.lineColor;
    }

    Point3 getLocation() {
        return this.dscr;
    }

    static void getWorldPixelCorners(TransInfo trans, Point3 ll, Point3 ur, int direction) {
        ll.set(0.0, 0.0, 1.0);
        trans.World2Screen(ll);
        if (direction == 0) {
            ur.set(ll.x + 1.0, ll.y, 1.0);
        } else {
            ur.set(ll.x, ll.y - 1.0, 1.0);
        }
        trans.Screen2World(ll);
        trans.Screen2World(ur);
    }

    static double getWorldPixelWidth(StateLite state) {
        Point3 ll = state.pt1;
        Point3 ur = state.pt2;
        CompoundedText.getWorldPixelCorners(state.ch.trans, ll, ur, 0);
        ur.sub(ll);
        return ur.length();
    }

    static double getWorldPixelHeight(StateLite state) {
        Point3 ll = state.pt1;
        Point3 ur = state.pt2;
        CompoundedText.getWorldPixelCorners(state.ch.trans, ll, ur, 1);
        ur.sub(ll);
        return ur.length();
    }

    static double getWidth(StateLite state, Graphics gc, Font font, String string) {
        int w = 0;
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        Vector list = CompoundedText.makeMultiLine(string);
        for (int i = 0; i < list.size(); ++i) {
            w = Math.max(w, fm.stringWidth((String)list.elementAt(i)));
        }
        return (double)w * CompoundedText.getWorldPixelWidth(state);
    }

    static double getAscent(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double ascent = fm.getAscent();
        double pixel = CompoundedText.getWorldPixelHeight(state);
        return ascent * pixel;
    }

    static double getDescent(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double descent = fm.getDescent();
        double pixel = CompoundedText.getWorldPixelHeight(state);
        return descent * pixel;
    }

    static double getHeight(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double h = fm.getHeight();
        double pixel = CompoundedText.getWorldPixelHeight(state);
        return h * pixel;
    }

    static double getSize(StateLite state, Graphics gc, Font font) {
        FontMetrics fm = null;
        if (gc == null) {
            fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        } else {
            gc.setFont(font);
            fm = gc.getFontMetrics();
        }
        double h = fm.getHeight();
        double pixel = CompoundedText.getWorldPixelHeight(state);
        return h * pixel;
    }

    static double getHeight(StateLite state, Graphics gc, Font font, String string) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        Vector list = CompoundedText.makeMultiLine(string);
        int h = fm.getHeight() * list.size();
        return (double)h * CompoundedText.getWorldPixelHeight(state);
    }

    private static Vector makeMultiLine(String text) {
        int nlIndex = 0;
        Vector<String> multiLine = new Vector<String>();
        if (text != null && text.length() > 0) {
            int i = 0;
            while (nlIndex >= 0) {
                nlIndex = text.indexOf(newline, i);
                String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                multiLine.addElement(line);
                i = 1 + nlIndex;
            }
        }
        return multiLine;
    }

    private static int[] getInfoBuffer(StateLite state, int lineCount) {
        int infoLength = 7 + lineCount;
        if (state.tempRasterInfo == null || state.tempRasterInfo.length < infoLength) {
            state.tempRasterInfo = new int[infoLength];
        }
        return state.tempRasterInfo;
    }

    private static int computeWidths(Vector string, int[] widths, FontMetrics fm) {
        int max = Integer.MIN_VALUE;
        int lineCount = string.size();
        if (widths == null) {
            widths = new int[lineCount];
        }
        for (int i = 0; i < lineCount; ++i) {
            widths[i] = fm.stringWidth((String)string.elementAt(i));
            max = Math.max(max, widths[i]);
        }
        return max;
    }

    protected int[] computeAlignmentInfo(StateLite state, Graphics gc, int x, int y, boolean handle) {
        gc.setFont(this.font);
        FontMetrics fm = gc.getFontMetrics();
        if (this.textWidth == null || state.capabilities[2]) {
            this.textWidth = new int[this.textLines];
            this.maxTextWidth = CompoundedText.computeWidths(this.string, this.textWidth, fm);
        }
        int[] alignInfo = CompoundedText.getInfoBuffer(state, this.textLines);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        this.maxTextWidth += hnwidth;
        CompoundedText.computeAlignmentInfo(alignInfo, this.textWidth, this.maxTextWidth, this.string.size(), fm, 1, 1, hnwidth, x, y);
        return alignInfo;
    }

    static int[] computeAlignmentInfo(StateLite state, Graphics gc, Vector string, Font font, int halign, int valign, boolean handle, int x, int y) {
        int lineCount = string.size();
        int[] textWidth = state.tempTextWidth;
        if (textWidth == null || textWidth.length < lineCount) {
            textWidth = state.tempTextWidth = new int[lineCount];
        }
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        int maxTextWidth = CompoundedText.computeWidths(string, textWidth, fm);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        int[] info = CompoundedText.getInfoBuffer(state, lineCount);
        CompoundedText.computeAlignmentInfo(info, textWidth, maxTextWidth += hnwidth, string.size(), fm, halign, valign, hnwidth, x, y);
        return info;
    }

    private static void computeAlignmentInfo(int[] info, int[] widths, int w, int lineCount, FontMetrics fm, int halign, int valign, int hnwidth, int x, int y) {
        int descent;
        info[0] = 0;
        info[1] = 0;
        int ascent = fm.getAscent();
        info[6] = descent = fm.getDescent();
        int lineHeight = fm.getHeight();
        int h = lineHeight * lineCount;
        switch (valign) {
            case 0: {
                info[1] = info[1] + ascent;
                break;
            }
            case 1: {
                info[1] = info[1] + (ascent - h / 2);
                break;
            }
            case 3: {
                info[1] = info[1] - (h - ascent);
                break;
            }
        }
        info[0] = -w;
        info[2] = w;
        info[3] = h;
        info[4] = y + info[1] - ascent;
        switch (halign) {
            default: {
                info[0] = 0;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth;
                }
                break;
            }
            case 1: {
                info[0] = info[0] / 2;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth + (w - hnwidth - widths[i - 7]) / 2;
                }
                break;
            }
            case 2: {
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = w - widths[i - 7] - hnwidth;
                }
            }
        }
        info[0] = info[0] + x;
        info[1] = info[1] + y;
        info[5] = lineHeight;
    }

    private void _setBackgroundHeight(double ht) {
        if (ht != -1.0) {
            this.uc = new Point3(this.wloc.x, this.wloc.y - ht / 2.0, 1.0);
            this.lc = new Point3(this.wloc.x, this.wloc.y + ht / 2.0, 1.0);
            if (this.optimized) {
                this.uc.postMultiply(this.state.ch.trans.w2m);
                this.lc.postMultiply(this.state.ch.trans.w2m);
            }
        }
    }

    private void _setBackgroundWidth(double w) {
        if (w != -1.0) {
            this.cl = new Point3(this.wloc.x - w / 2.0, this.wloc.y, 1.0);
            this.cr = new Point3(this.wloc.x + w / 2.0, this.wloc.y, 1.0);
            if (this.optimized) {
                this.cl.postMultiply(this.state.ch.trans.w2m);
                this.cr.postMultiply(this.state.ch.trans.w2m);
            }
        }
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    void setPickable(StateLite state, boolean flag) {
        this.pickable = flag;
        this.namelist = flag ? state.namelist : null;
    }

    public void setHandleVisible(boolean flag) {
        this.handle = flag;
    }

    public void setHandleColor(Color c) {
        this.handleColor = c;
    }
}

